/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.options.MercurialOptionsPanelController;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class MercurialPanel
extends JPanel {
    private final MercurialOptionsPanelController controller;
    private final DocumentListener listener;
    private String initialUserName;
    final JButton addButton = new JButton();
    final JTextField annotationTextField = new JTextField();
    private JCheckBox backupOnRevertModifications;
    final JButton execPathBrowseButton = new JButton();
    final JTextField executablePathTextField = new JTextField();
    private JLabel exportFilename;
    final JButton exportFilenameBrowseButton = new JButton();
    final JTextField exportFilenameTextField = new JTextField();
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    final JButton manageButton = new JButton();
    final JTextField userNameTextField = new JTextField();

    MercurialPanel(MercurialOptionsPanelController mercurialOptionsPanelController) {
        this.controller = mercurialOptionsPanelController;
        this.listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MercurialPanel.this.nameChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MercurialPanel.this.nameChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                MercurialPanel.this.nameChange();
            }
        };
        this.initComponents();
    }

    public void addNotify() {
        super.addNotify();
        this.userNameTextField.getDocument().addDocumentListener(this.listener);
    }

    public void removeNotify() {
        this.userNameTextField.getDocument().removeDocumentListener(this.listener);
        super.removeNotify();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.exportFilename = new JLabel();
        this.backupOnRevertModifications = new JCheckBox();
        this.jLabel1.setLabelFor(this.userNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel1.text"));
        this.jLabel2.setLabelFor(this.executablePathTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.execPathBrowseButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.browseButton.text"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jPanel1.border.title")));
        this.jLabel3.setLabelFor(this.annotationTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel3.text"));
        this.annotationTextField.setText(NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.annotationTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.addButton.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3).addPreferredGap(1).add((Component)this.annotationTextField, -2, 405, -2).addPreferredGap(0, 115, Short.MAX_VALUE).add((Component)this.addButton).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.addButton).add((Component)this.annotationTextField, -2, -1, -2)).addContainerGap(20, Short.MAX_VALUE)));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_addButton"));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(MercurialPanel.class, (String)"MecurialPanel.jPanel2.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jLabel4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.manageButton.text"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jLabel4).addPreferredGap(0, 175, Short.MAX_VALUE).add((Component)this.manageButton).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.manageButton)).addContainerGap(24, Short.MAX_VALUE)));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_manageButton"));
        this.exportFilename.setLabelFor(this.exportFilenameTextField);
        Mnemonics.setLocalizedText((JLabel)this.exportFilename, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.ExportFilename.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.exportFilenameBrowseButton, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.browseButton2.text"));
        this.backupOnRevertModifications.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.backupOnRevertModifications, (String)NbBundle.getMessage(MercurialPanel.class, (String)"MercurialPanel.jCheckBox1.text"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.backupOnRevertModifications).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1, false).add((Component)this.jLabel1, -1, 160, Short.MAX_VALUE).add((Component)this.jLabel2, -1, -1, Short.MAX_VALUE).add((Component)this.exportFilename, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.userNameTextField, -1, 558, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.exportFilenameTextField, -1, 427, Short.MAX_VALUE).add(2, (Component)this.executablePathTextField, -1, 427, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add((Component)this.execPathBrowseButton).add((Component)this.exportFilenameBrowseButton, -1, 125, Short.MAX_VALUE)))))).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.userNameTextField, -2, -1, -2).add((Component)this.jLabel1)).add(18, 18, 18).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.execPathBrowseButton).add((Component)this.jLabel2).add((Component)this.executablePathTextField, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.exportFilename).add((Component)this.exportFilenameTextField, -2, -1, -2).add((Component)this.exportFilenameBrowseButton)).add(10, 10, 10).add((Component)this.jPanel1, -2, -1, -2).add(18, 18, 18).add((Component)this.jPanel2, -2, -1, -2).add(18, 18, 18).add((Component)this.backupOnRevertModifications).addContainerGap(25, Short.MAX_VALUE)));
        this.userNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_userNameTextField"));
        this.executablePathTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_executablePathTextField"));
        this.execPathBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_execPathBrowseButton"));
        this.exportFilenameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_exportFileNameTextField"));
        this.exportFilenameBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_exportFilenameBrowseButton"));
        this.backupOnRevertModifications.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MercurialPanel.class, (String)"ACSD_backupOnRevertModifications"));
    }

    private void nameChange() {
        this.controller.changed();
    }

    void load() {
        this.initialUserName = HgModuleConfig.getDefault().getUserName();
        this.userNameTextField.setText(this.initialUserName);
        this.executablePathTextField.setText(HgModuleConfig.getDefault().getExecutableBinaryPath());
        this.exportFilenameTextField.setText(HgModuleConfig.getDefault().getExportFilename());
        this.annotationTextField.setText(HgModuleConfig.getDefault().getAnnotationFormat());
        this.backupOnRevertModifications.setSelected(HgModuleConfig.getDefault().getBackupOnRevertModifications());
    }

    void store() {
        if (!this.initialUserName.equals(this.userNameTextField.getText())) {
            HgModuleConfig.getDefault().setUserName(this.userNameTextField.getText());
        }
        HgModuleConfig.getDefault().setExecutableBinaryPath(this.executablePathTextField.getText());
        HgModuleConfig.getDefault().setExportFilename(this.exportFilenameTextField.getText());
        HgModuleConfig.getDefault().setAnnotationFormat(this.annotationTextField.getText());
        HgModuleConfig.getDefault().setBackupOnRevertModifications(this.backupOnRevertModifications.isSelected());
        if (MercurialAnnotator.isRevisionInAnnotationFormat(this.annotationTextField.getText())) {
            HgUtils.warningDialog(MercurialPanel.class, "MSG_STATUS_LABEL_WITH_REVSION_TITLE", "MSG_STATUS_LABEL_WITH_REVSION_MSG");
        }
    }

    boolean valid() {
        String string = this.userNameTextField.getText();
        Boolean bl = HgModuleConfig.getDefault().isUserNameValid(string);
        if (!bl.booleanValue()) {
            return false;
        }
        String string2 = this.executablePathTextField.getText();
        bl = HgModuleConfig.getDefault().isExecPathValid(string2);
        return bl;
    }
}

