/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MercurialInterceptor
extends VCSInterceptor {
    private final FileStatusCache cache;
    private ConcurrentHashMap<File, File> dirsToDelete = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<File> filesToRefresh = new ConcurrentLinkedQueue();
    private RequestProcessor.Task refreshTask;
    private static final RequestProcessor rp = new RequestProcessor("MercurialRefresh", 1, true);

    public MercurialInterceptor() {
        this.cache = Mercurial.getInstance().getFileStatusCache();
        this.refreshTask = rp.create((Runnable)new RefreshTask());
    }

    public boolean beforeDelete(File file) {
        if (file == null) {
            return true;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        if (file.isDirectory()) {
            for (File file2 : this.dirsToDelete.keySet()) {
                if (!file.equals(file2.getParentFile())) continue;
                this.dirsToDelete.remove(file2);
            }
            if (SharabilityQuery.getSharability((File)file) != 2) {
                this.dirsToDelete.put(file, file);
            }
        }
        return true;
    }

    public void doDelete(File file) throws IOException {
    }

    public void afterDelete(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                MercurialInterceptor.this.fileDeletedImpl(file);
            }
        });
    }

    private void fileDeletedImpl(final File file) {
        if (file == null) {
            return;
        }
        Mercurial mercurial = Mercurial.getInstance();
        final File file2 = mercurial.getTopmostManagedParent(file);
        RequestProcessor requestProcessor = null;
        if (file2 != null) {
            requestProcessor = mercurial.getRequestProcessor(file2.getAbsolutePath());
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                file.delete();
                if (!this.dirsToDelete.remove(file, file)) {
                    return;
                }
                if (file2 == null) {
                    return;
                }
                HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                    public void perform() {
                        try {
                            HgCommand.doRemove(file2, file, this.getLogger());
                            Map<File, FileInformation> map = HgCommand.getInterestingStatus(file2, file);
                            if (!map.isEmpty()) {
                                Set<File> set = map.keySet();
                                Map<File, Map<File, FileInformation>> map2 = HgUtils.getInterestingDirs(map, set);
                                Calendar calendar = Calendar.getInstance();
                                for (File file3 : set) {
                                    if (this.isCanceled()) {
                                        return;
                                    }
                                    FileInformation fileInformation = map.get(file3);
                                    MercurialInterceptor.this.cache.refreshFileStatus(file3, fileInformation, map2.get(file3.isDirectory() ? file3 : file3.getParentFile()), true);
                                }
                                Calendar calendar2 = Calendar.getInstance();
                            }
                        }
                        catch (HgException hgException) {
                            Mercurial.LOG.log(Level.FINE, "fileDeletedImpl(): File: {0} {1}", new Object[]{file.getAbsolutePath(), hgException.toString()});
                        }
                    }
                };
                hgProgressSupport.start(requestProcessor, file2.getAbsolutePath(), NbBundle.getMessage(MercurialInterceptor.class, (String)"MSG_Remove_Progress"));
            } else {
                Boolean bl = HgUtils.isIgnored(file, false);
                Mercurial.LOG.log(Level.FINE, "fileDeletedImpl(): File: {0} isIgnored {1}", new Object[]{file.getAbsolutePath(), bl});
                file.delete();
                if (file2 == null || bl.booleanValue()) {
                    return;
                }
                for (File file3 : this.dirsToDelete.keySet()) {
                    for (File file4 = file.getParentFile(); file4 != null; file4 = file4.getParentFile()) {
                        if (!file4.equals(file3)) continue;
                        return;
                    }
                }
                HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                    public void perform() {
                        try {
                            HgCommand.doRemove(file2, file, this.getLogger());
                            MercurialInterceptor.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                        }
                        catch (HgException hgException) {
                            Mercurial.LOG.log(Level.FINE, "fileDeletedImpl(): File: {0} {1}", new Object[]{file.getAbsolutePath(), hgException.toString()});
                        }
                    }
                };
                hgProgressSupport.start(requestProcessor, file2.getAbsolutePath(), NbBundle.getMessage(MercurialInterceptor.class, (String)"MSG_Remove_Progress"));
            }
        }
    }

    public boolean beforeMove(File file, File file2) {
        if (file == null || file2 == null || file2.exists()) {
            return true;
        }
        Mercurial mercurial = Mercurial.getInstance();
        if (mercurial.isManaged(file)) {
            return mercurial.isManaged(file2);
        }
        return super.beforeMove(file, file2);
    }

    public void doMove(final File file, final File file2) throws IOException {
        if (file == null || file2 == null || file2.exists()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Mercurial.LOG.log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
            final Throwable[] throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        MercurialInterceptor.this.hgMoveImplementation(file, file2);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            Mercurial.getInstance().getRequestProcessor().post(runnable).waitFinished();
            if (throwableArray[0] != null) {
                if (throwableArray[0] instanceof IOException) {
                    throw (IOException)throwableArray[0];
                }
                if (throwableArray[0] instanceof RuntimeException) {
                    throw (RuntimeException)throwableArray[0];
                }
                if (throwableArray[0] instanceof Error) {
                    throw (Error)throwableArray[0];
                }
                throw new IllegalStateException("Unexpected exception class: " + throwableArray[0]);
            }
        } else {
            this.hgMoveImplementation(file, file2);
        }
    }

    private void hgMoveImplementation(final File file, final File file2) throws IOException {
        Mercurial mercurial = Mercurial.getInstance();
        final File file3 = mercurial.getTopmostManagedParent(file);
        final File file4 = mercurial.getTopmostManagedParent(file2);
        if (file3 == null) {
            return;
        }
        RequestProcessor requestProcessor = mercurial.getRequestProcessor(file3.getAbsolutePath());
        Mercurial.LOG.log(Level.FINE, "hgMoveImplementation(): File: {0} {1}", new Object[]{file, file2});
        file.renameTo(file2);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                OutputLogger outputLogger = OutputLogger.getLogger(file3.getAbsolutePath());
                try {
                    if (file3.equals(file4)) {
                        HgCommand.doRenameAfter(file3, file, file2, outputLogger);
                    }
                }
                catch (HgException hgException) {
                    Mercurial.LOG.log(Level.FINE, "Mercurial failed to rename: File: {0} {1}", new Object[]{file.getAbsolutePath(), file2.getAbsolutePath()});
                }
                finally {
                    outputLogger.closeLog();
                }
            }
        };
        requestProcessor.post(runnable);
    }

    public void afterMove(final File file, final File file2) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                MercurialInterceptor.this.fileMovedImpl(file, file2);
            }
        });
    }

    private void fileMovedImpl(File file, File file2) {
        if (file == null || file2 == null || !file2.exists()) {
            return;
        }
        if (file2.isDirectory()) {
            return;
        }
        this.reScheduleRefresh(1000, file.getParentFile());
    }

    public boolean beforeCreate(final File file, boolean bl) {
        FileInformation fileInformation;
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        if (!bl && !file.exists() && (fileInformation = this.cache.getCachedStatus(file, false)) != null && fileInformation.getStatus() == 256) {
            Mercurial.LOG.log(Level.FINE, "beforeCreate(): LocallyDeleted: {0}", file);
            Mercurial mercurial = Mercurial.getInstance();
            final File file2 = mercurial.getTopmostManagedParent(file);
            if (file2 == null) {
                return false;
            }
            final OutputLogger outputLogger = Mercurial.getInstance().getLogger(file2.getAbsolutePath());
            final Throwable[] throwableArray = new Throwable[1];
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        ArrayList<File> arrayList = new ArrayList<File>();
                        arrayList.add(file);
                        HgCommand.doRevert(file2, arrayList, null, false, outputLogger);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                    }
                }
            };
            Mercurial.getInstance().getRequestProcessor().post(runnable).waitFinished();
            if (throwableArray[0] != null) {
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): File: {0} {1}", new Object[]{file.getAbsolutePath(), throwableArray[0].toString()});
            }
            Mercurial.LOG.log(Level.FINE, "beforeCreate(): afterWaitFinished: {0}", file);
            outputLogger.closeLog();
            file.delete();
        }
        return false;
    }

    public void doCreate(File file, boolean bl) throws IOException {
        super.doCreate(file, bl);
    }

    public void afterCreate(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                MercurialInterceptor.this.fileCreatedImpl(file);
            }
        });
    }

    private void fileCreatedImpl(File file) {
        if (file.isDirectory()) {
            return;
        }
        Mercurial.LOG.log(Level.FINE, "fileCreatedImpl {0}", file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(1000, file.getParentFile());
        }
    }

    public void afterChange(final File file) {
        Utils.post((Runnable)new Runnable(){

            public void run() {
                MercurialInterceptor.this.fileChangedImpl(file);
            }
        });
    }

    private void fileChangedImpl(File file) {
        if (file.isDirectory()) {
            return;
        }
        Mercurial.LOG.log(Level.FINE, "fileChangedImpl(): File: {0}", file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(1000, file.getParentFile());
        }
    }

    private void reScheduleRefresh(int n, File file) {
        if (!this.filesToRefresh.contains(file) && !this.filesToRefresh.offer(file)) {
            Mercurial.LOG.log(Level.FINE, "reScheduleRefresh failed to add to filesToRefresh queue {0}", file);
        }
        this.refreshTask.schedule(n);
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        public void run() {
            Thread.interrupted();
            File file = (File)MercurialInterceptor.this.filesToRefresh.poll();
            if (file != null) {
                Mercurial.LOG.log(Level.FINE, "RefreshTask called refreshAll {0}", file);
                MercurialInterceptor.this.cache.refreshAll(file);
                file = (File)MercurialInterceptor.this.filesToRefresh.peek();
                if (file != null) {
                    MercurialInterceptor.this.refreshTask.schedule(0);
                }
            }
        }
    }
}

