/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileLocation;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBean;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFileSpringBeanSource
implements SpringBeanSource {
    private static final Logger LOGGER = Logger.getLogger(ConfigFileSpringBeanSource.class.getName());
    private final Map<String, ConfigFileSpringBean> id2Bean = new HashMap<String, ConfigFileSpringBean>();
    private final Map<String, ConfigFileSpringBean> name2Bean = new HashMap<String, ConfigFileSpringBean>();
    private final List<ConfigFileSpringBean> beans = new ArrayList<ConfigFileSpringBean>();

    public void parse(BaseDocument baseDocument) throws IOException {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)baseDocument);
        if (fileObject == null) {
            LOGGER.log(Level.WARNING, "Could not get a FileObject for document {0}", baseDocument);
            return;
        }
        LOGGER.log(Level.FINE, "Parsing {0}", fileObject);
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            LOGGER.log(Level.WARNING, "{0} resolves to a null File, aborting", fileObject);
            return;
        }
        new DocumentParser(file, (Document)baseDocument).run();
        LOGGER.log(Level.FINE, "Parsed {0}", fileObject);
    }

    @Override
    public List<SpringBean> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    @Override
    public SpringBean findBeanByID(String string) {
        return this.id2Bean.get(string);
    }

    @Override
    public SpringBean findBeanByIDOrName(String string) {
        SpringBean springBean = this.findBeanByID(string);
        if (springBean == null) {
            springBean = this.name2Bean.get(string);
        }
        return springBean;
    }

    private final class DocumentParser
    implements Runnable {
        private final File file;
        private final Document document;

        public DocumentParser(File file, Document document) {
            this.file = file;
            this.document = document;
        }

        public void run() {
            ConfigFileSpringBeanSource.this.id2Bean.clear();
            ConfigFileSpringBeanSource.this.name2Bean.clear();
            ConfigFileSpringBeanSource.this.beans.clear();
            Tag tag = SpringXMLConfigEditorUtils.getDocumentRoot(this.document);
            if (tag == null) {
                return;
            }
            NodeList nodeList = tag.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!"bean".equals(node.getNodeName())) continue;
                this.parseBean(node);
            }
        }

        private void parseBean(Node node) {
            String string = this.getTrimmedAttr(node, "id");
            String string2 = this.getTrimmedAttr(node, "name");
            List<String> list = string2 != null ? Collections.unmodifiableList(StringUtils.tokenize(string2, ",; ")) : Collections.emptyList();
            String string3 = this.getTrimmedAttr(node, "class");
            String string4 = this.getTrimmedAttr(node, "parent");
            String string5 = this.getTrimmedAttr(node, "factory-bean");
            String string6 = this.getTrimmedAttr(node, "factory-method");
            Tag tag = (Tag)node;
            ConfigFileLocation configFileLocation = new ConfigFileLocation(this.file, tag.getElementOffset());
            ConfigFileSpringBean configFileSpringBean = new ConfigFileSpringBean(string, list, string3, string4, string5, string6, configFileLocation);
            if (string != null) {
                this.addBeanID(string, configFileSpringBean);
            }
            for (String string7 : list) {
                this.addBeanName(string7, configFileSpringBean);
            }
            ConfigFileSpringBeanSource.this.beans.add(configFileSpringBean);
        }

        private void addBeanID(String string, ConfigFileSpringBean configFileSpringBean) {
            if (ConfigFileSpringBeanSource.this.id2Bean.get(string) == null) {
                ConfigFileSpringBeanSource.this.id2Bean.put(string, configFileSpringBean);
            }
        }

        private void addBeanName(String string, ConfigFileSpringBean configFileSpringBean) {
            if (ConfigFileSpringBeanSource.this.name2Bean.get(string) == null) {
                ConfigFileSpringBeanSource.this.name2Bean.put(string, configFileSpringBean);
            }
        }

        private String getTrimmedAttr(Node node, String string) {
            String string2 = SpringXMLConfigEditorUtils.getAttribute(node, string);
            if (string2 != null) {
                string2 = string2.trim();
            }
            return string2;
        }
    }
}

