/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.model.ConfigModelSpringBeans;
import org.netbeans.modules.spring.beans.model.EditorListener;
import org.netbeans.modules.spring.beans.model.ExclusiveAccess;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelController;
import org.netbeans.modules.spring.beans.model.impl.ConfigFileSpringBeanSource;
import org.netbeans.modules.spring.util.fcs.FileChangeSupport;
import org.netbeans.modules.spring.util.fcs.FileChangeSupportEvent;
import org.netbeans.modules.spring.util.fcs.FileChangeSupportListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringConfigModelController {
    private final ConfigFileGroup configFileGroup;
    private final Map<File, SpringConfigFileModelController> file2Controller = Collections.synchronizedMap(new HashMap());
    private FileListener fileListener;
    private ConfigModelSpringBeans readAccess;
    private boolean writeAccess;

    public static SpringConfigModelController create(ConfigFileGroup configFileGroup) {
        SpringConfigModelController springConfigModelController = new SpringConfigModelController(configFileGroup);
        springConfigModelController.initialize();
        return springConfigModelController;
    }

    private SpringConfigModelController(ConfigFileGroup configFileGroup) {
        this.configFileGroup = configFileGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        this.fileListener = new FileListener();
        Map<File, SpringConfigFileModelController> map = this.file2Controller;
        synchronized (map) {
            for (File file : this.configFileGroup.getFiles()) {
                this.file2Controller.put(file, new SpringConfigFileModelController(file, new ConfigFileSpringBeanSource()));
                FileChangeSupport.DEFAULT.addListener(this.fileListener, file);
            }
        }
        EditorListener.getInstance().register(this);
    }

    ConfigFileGroup getConfigFileGroup() {
        return this.configFileGroup;
    }

    private void notifyFileChanged(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return;
        }
        this.notifyFileChanged(fileObject, file);
    }

    private void notifyFileDeleted(File file) {
    }

    void notifyFileChanged(FileObject fileObject, File file) {
        SpringConfigFileModelController springConfigFileModelController = this.file2Controller.get(file);
        if (springConfigFileModelController != null) {
            springConfigFileModelController.notifyChange(fileObject);
        }
    }

    public void runReadAction(Action<SpringBeans> action) throws IOException {
        try {
            this.runReadAction0(action);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            throw (IOException)iOException.initCause(exception);
        }
    }

    private void runReadAction0(final Action<SpringBeans> action) throws Exception {
        ExclusiveAccess.getInstance().runSyncTask(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws IOException {
                if (SpringConfigModelController.this.writeAccess) {
                    throw new IllegalStateException("Already in write access.");
                }
                boolean bl = SpringConfigModelController.this.readAccess == null;
                try {
                    if (bl) {
                        SpringConfigModelController.this.readAccess = new ConfigModelSpringBeans(SpringConfigModelController.this.computeSpringBeanSources(null));
                    }
                    action.run(SpringConfigModelController.this.readAccess);
                }
                finally {
                    if (bl) {
                        SpringConfigModelController.this.readAccess = null;
                    }
                }
                return null;
            }
        });
    }

    public void runDocumentAction(Action<SpringConfigModel.DocumentAccess> action) throws IOException {
        try {
            this.runDocumentAction0(action);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            throw (IOException)iOException.initCause(exception);
        }
    }

    private void runDocumentAction0(final Action<SpringConfigModel.DocumentAccess> action) throws Exception {
        ExclusiveAccess.getInstance().runSyncTask(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws IOException {
                if (SpringConfigModelController.this.readAccess != null) {
                    throw new IllegalStateException("Already in read access.");
                }
                if (SpringConfigModelController.this.writeAccess) {
                    throw new IllegalStateException("Reentrant write access not supported");
                }
                SpringConfigModelController.this.writeAccess = true;
                try {
                    Map map = SpringConfigModelController.this.file2Controller;
                    synchronized (map) {
                        for (File file : SpringConfigModelController.this.file2Controller.keySet()) {
                            Map map2 = SpringConfigModelController.this.computeSpringBeanSources(file);
                            SpringConfigFileModelController springConfigFileModelController = (SpringConfigFileModelController)SpringConfigModelController.this.file2Controller.get(file);
                            SpringConfigFileModelController.LockedDocument lockedDocument = springConfigFileModelController.getLockedDocument();
                            if (lockedDocument == null) continue;
                            lockedDocument.lock();
                            try {
                                map2.put(file, lockedDocument.getBeanSource());
                                ConfigModelSpringBeans configModelSpringBeans = new ConfigModelSpringBeans(map2);
                                SpringConfigModel.DocumentAccess documentAccess = new SpringConfigModel.DocumentAccess(configModelSpringBeans, file, lockedDocument);
                                action.run(documentAccess);
                            }
                            finally {
                                lockedDocument.unlock();
                            }
                        }
                    }
                }
                finally {
                    SpringConfigModelController.this.writeAccess = false;
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, SpringBeanSource> computeSpringBeanSources(File file) throws IOException {
        HashMap<File, SpringBeanSource> hashMap = new HashMap<File, SpringBeanSource>();
        Map<File, SpringConfigFileModelController> map = this.file2Controller;
        synchronized (map) {
            for (Map.Entry<File, SpringConfigFileModelController> entry : this.file2Controller.entrySet()) {
                File file2 = entry.getKey();
                if (file2.equals(file)) continue;
                hashMap.put(entry.getKey(), entry.getValue().getUpToDateBeanSource());
            }
        }
        return hashMap;
    }

    private final class FileListener
    implements FileChangeSupportListener {
        private FileListener() {
        }

        public void fileCreated(FileChangeSupportEvent fileChangeSupportEvent) {
            SpringConfigModelController.this.notifyFileChanged(fileChangeSupportEvent.getPath());
        }

        public void fileModified(FileChangeSupportEvent fileChangeSupportEvent) {
            SpringConfigModelController.this.notifyFileChanged(fileChangeSupportEvent.getPath());
        }

        public void fileDeleted(FileChangeSupportEvent fileChangeSupportEvent) {
            SpringConfigModelController.this.notifyFileDeleted(fileChangeSupportEvent.getPath());
        }
    }
}

