/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.hyperlink.BeansRefHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.FactoryMethodHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.JavaClassHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.JavaMethodHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.PHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.PropertyHyperlinkProcessor;
import org.netbeans.modules.spring.beans.hyperlink.ResourceHyperlinkProcessor;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringXMLConfigHyperlinkProvider
implements HyperlinkProvider {
    private static final String P_NAMESPACE = "http://www.springframework.org/schema/p";
    private static final String BEAN_TAG = "bean";
    private static final String IMPORT_TAG = "import";
    private static final String LOOKUP_METHOD_TAG = "lookup-method";
    private static final String REPLACED_METHOD_TAG = "replaced-method";
    private static final String PROPERTY_TAG = "property";
    private static final String ALIAS_TAG = "alias";
    private static final String CONSTRUCTOR_ARG_TAG = "constructor-arg";
    private static final String REF_TAG = "ref";
    private static final String IDREF_TAG = "idref";
    private static final String CLASS_ATTRIB = "class";
    private static final String RESOURCE_ATTRIB = "resource";
    private static final String INIT_METHOD_ATTRIB = "init-method";
    private static final String DESTROY_METHOD_ATTRIB = "destroy-method";
    private static final String NAME_ATTRIB = "name";
    private static final String FACTORY_METHOD_ATTRIB = "factory-method";
    private static final String FACTORY_BEAN_ATTRIB = "factory-bean";
    private static final String DEPENDS_ON_ATTRIB = "depends-on";
    private static final String PARENT_ATTRIB = "parent";
    private static final String REPLACER_ATTRIB = "replacer";
    private static final String REF_ATTRIB = "ref";
    private static final String BEAN_ATTRIB = "bean";
    private static final String LOCAL_ATTRIB = "local";
    private BaseDocument lastDocument = null;
    private HyperlinkProcessor currentProcessor;
    private Map<String, HyperlinkProcessor> attribValueProcessors = new HashMap<String, HyperlinkProcessor>();
    private PHyperlinkProcessor pHyperlinkProcessor = new PHyperlinkProcessor();

    public SpringXMLConfigHyperlinkProvider() {
        JavaClassHyperlinkProcessor javaClassHyperlinkProcessor = new JavaClassHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("bean", CLASS_ATTRIB, javaClassHyperlinkProcessor);
        JavaMethodHyperlinkProcessor javaMethodHyperlinkProcessor = new JavaMethodHyperlinkProcessor(SpringXMLConfigEditorUtils.Public.DONT_CARE, SpringXMLConfigEditorUtils.Static.NO, 0);
        this.registerAttribValueHyperlinkPoint("bean", INIT_METHOD_ATTRIB, javaMethodHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("bean", DESTROY_METHOD_ATTRIB, javaMethodHyperlinkProcessor);
        FactoryMethodHyperlinkProcessor factoryMethodHyperlinkProcessor = new FactoryMethodHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("bean", FACTORY_METHOD_ATTRIB, factoryMethodHyperlinkProcessor);
        javaMethodHyperlinkProcessor = new JavaMethodHyperlinkProcessor(SpringXMLConfigEditorUtils.Public.DONT_CARE, SpringXMLConfigEditorUtils.Static.NO, 0);
        this.registerAttribValueHyperlinkPoint(LOOKUP_METHOD_TAG, NAME_ATTRIB, javaMethodHyperlinkProcessor);
        javaMethodHyperlinkProcessor = new JavaMethodHyperlinkProcessor(SpringXMLConfigEditorUtils.Public.DONT_CARE, SpringXMLConfigEditorUtils.Static.NO, -1);
        this.registerAttribValueHyperlinkPoint(REPLACED_METHOD_TAG, NAME_ATTRIB, javaMethodHyperlinkProcessor);
        ResourceHyperlinkProcessor resourceHyperlinkProcessor = new ResourceHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint(IMPORT_TAG, RESOURCE_ATTRIB, resourceHyperlinkProcessor);
        PropertyHyperlinkProcessor propertyHyperlinkProcessor = new PropertyHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint(PROPERTY_TAG, NAME_ATTRIB, propertyHyperlinkProcessor);
        BeansRefHyperlinkProcessor beansRefHyperlinkProcessor = new BeansRefHyperlinkProcessor(true);
        this.registerAttribValueHyperlinkPoint("bean", FACTORY_BEAN_ATTRIB, beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("bean", DEPENDS_ON_ATTRIB, beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("bean", PARENT_ATTRIB, beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint(LOOKUP_METHOD_TAG, "bean", beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint(REPLACED_METHOD_TAG, REPLACER_ATTRIB, beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint(PROPERTY_TAG, "ref", beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint(ALIAS_TAG, NAME_ATTRIB, beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint(CONSTRUCTOR_ARG_TAG, "ref", beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("ref", "bean", beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint(IDREF_TAG, "bean", beansRefHyperlinkProcessor);
        beansRefHyperlinkProcessor = new BeansRefHyperlinkProcessor(false);
        this.registerAttribValueHyperlinkPoint(IDREF_TAG, LOCAL_ATTRIB, beansRefHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("ref", LOCAL_ATTRIB, beansRefHyperlinkProcessor);
    }

    private void registerAttribValueHyperlinkPoint(String string, String string2, HyperlinkProcessor hyperlinkProcessor) {
        this.attribValueProcessors.put(this.createRegisteredName(string, string2), hyperlinkProcessor);
    }

    public boolean isHyperlinkPoint(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        if (!(baseDocument.getSyntaxSupport() instanceof XMLSyntaxSupport)) {
            return false;
        }
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        if (hyperlinkEnv.getType().isValueHyperlink()) {
            this.currentProcessor = this.locateHyperlinkProcessor(hyperlinkEnv.getTagName(), hyperlinkEnv.getAttribName(), this.attribValueProcessors);
            if (this.currentProcessor == null && this.isPNamespaceName(hyperlinkEnv, hyperlinkEnv.getAttribName())) {
                this.currentProcessor = this.pHyperlinkProcessor;
            }
        } else {
            this.currentProcessor = hyperlinkEnv.getType().isAttributeHyperlink() ? (this.isPNamespaceName(hyperlinkEnv, hyperlinkEnv.getAttribName()) ? this.pHyperlinkProcessor : null) : null;
        }
        return this.currentProcessor != null;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        if (this.currentProcessor == null) {
            return null;
        }
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        return this.currentProcessor.getSpan(hyperlinkEnv);
    }

    public void performClickAction(Document document, int n) {
        HyperlinkEnv hyperlinkEnv = new HyperlinkEnv(document, n);
        if (this.currentProcessor != null) {
            this.currentProcessor.process(hyperlinkEnv);
        }
    }

    protected String createRegisteredName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.hasText(string)) {
            stringBuilder.append("/nodeName=");
            stringBuilder.append(string);
        } else {
            stringBuilder.append("/nodeName=");
            stringBuilder.append("*");
        }
        if (StringUtils.hasText(string2)) {
            stringBuilder.append("/attribute=");
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private HyperlinkProcessor locateHyperlinkProcessor(String string, String string2, Map<String, HyperlinkProcessor> map) {
        String string3 = this.createRegisteredName(string, string2);
        if (map.containsKey(string3)) {
            return map.get(string3);
        }
        string3 = this.createRegisteredName("*", string2);
        if (map.containsKey(string3)) {
            return map.get(string3);
        }
        return null;
    }

    private boolean isPNamespaceName(HyperlinkEnv hyperlinkEnv, String string) {
        String string2;
        String string3 = ContextUtilities.getPrefixFromNodeName(string);
        return string3 != null && P_NAMESPACE.equals(string2 = hyperlinkEnv.lookupNamespacePrefix(string3));
    }
}

