/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.Location;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringXMLConfigEditorUtils {
    public static final String BEAN_NAME_DELIMITERS = ",; ";

    private SpringXMLConfigEditorUtils() {
    }

    public static Map<String, String> getTagAttributes(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            hashMap.put(node2.getNodeName(), node2.getNodeValue());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    public static String getBeanPropertySetterName(String string) {
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        return "set" + String.valueOf(cArray);
    }

    public static String getBeanFactoryMethod(Tag tag) {
        NamedNodeMap namedNodeMap;
        Node node = SpringXMLConfigEditorUtils.getBean((Node)tag);
        if (node != null && (namedNodeMap = node.getAttributes()) != null && namedNodeMap.getNamedItem("factory-method") != null) {
            return namedNodeMap.getNamedItem("factory-method").getNodeValue();
        }
        return null;
    }

    public static TypeElement findClassElementByBinaryName(String string, CompilationController compilationController) {
        PackageElement packageElement;
        if (!string.contains("$")) {
            return compilationController.getElements().getTypeElement(string);
        }
        String string2 = "";
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        if ((packageElement = compilationController.getElements().getPackageElement(string2)) == null) {
            return null;
        }
        return (TypeElement)new BinaryNameTypeScanner().visit(packageElement, string);
    }

    public static Node getBean(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeName().equals("bean")) {
            return node;
        }
        if (node.getNodeName().equals("lookup-method") || node.getNodeName().equals("replaced-method") || node.getNodeName().equals("property")) {
            Node node2 = node.getParentNode();
            if (node2.getNodeName().equals("bean")) {
                return node2;
            }
            return null;
        }
        return null;
    }

    public static String getBeanClassName(Node node) {
        NamedNodeMap namedNodeMap;
        Node node2 = SpringXMLConfigEditorUtils.getBean(node);
        if (node2 != null && (namedNodeMap = node2.getAttributes()) != null && namedNodeMap.getNamedItem("class") != null) {
            return namedNodeMap.getNamedItem("class").getNodeValue();
        }
        return null;
    }

    public static JavaSource getJavaSource(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        int n = 0;
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        SourceGroup[] sourceGroupArray2 = sourceGroupArray;
        int n2 = sourceGroupArray2.length;
        if (n < n2) {
            SourceGroup sourceGroup = sourceGroupArray2[n];
            return JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)sourceGroup.getRootFolder()), (FileObject[])new FileObject[0]);
        }
        return null;
    }

    public static JavaSource getJavaSource(Document document) {
        return SpringXMLConfigEditorUtils.getJavaSource(NbEditorUtilities.getFileObject((Document)document));
    }

    public static void findAndOpenJavaClass(final String string, FileObject fileObject) {
        final JavaSource javaSource = SpringXMLConfigEditorUtils.getJavaSource(fileObject);
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        boolean bl = false;
                        TypeElement typeElement = SpringXMLConfigEditorUtils.findClassElementByBinaryName(string, compilationController);
                        if (typeElement != null) {
                            bl = ElementOpen.open((ClasspathInfo)javaSource.getClasspathInfo(), (Element)typeElement);
                        }
                        if (!bl) {
                            String string2 = NbBundle.getMessage(SpringXMLConfigEditorUtils.class, (String)"LBL_SourceNotFound", (Object)string);
                            StatusDisplayer.getDefault().setStatusText(string2);
                        }
                    }
                }, false);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    public static ElementHandle<ExecutableElement> findMethod(FileObject fileObject, String string, String string2, int n, Public public_, Static static_) {
        JavaSource javaSource = SpringXMLConfigEditorUtils.getJavaSource(fileObject);
        if (javaSource != null) {
            try {
                MethodFinder methodFinder = new MethodFinder(string, string2, n, public_, static_);
                javaSource.runUserActionTask((Task)methodFinder, false);
                return methodFinder.getMethodHandle();
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
        return null;
    }

    public static void openMethodInEditor(FileObject fileObject, String string, String string2, int n, Public public_, Static static_) {
        if (string == null || string2 == null || fileObject == null) {
            return;
        }
        final JavaSource javaSource = SpringXMLConfigEditorUtils.getJavaSource(fileObject);
        if (javaSource == null) {
            return;
        }
        final ElementHandle<ExecutableElement> elementHandle = SpringXMLConfigEditorUtils.findMethod(fileObject, string, string2, n, public_, static_);
        if (elementHandle != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)compilationController);
                        ElementOpen.open((ClasspathInfo)javaSource.getClasspathInfo(), (Element)executableElement);
                    }
                }, false);
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    public static final Tag getDocumentRoot(Document document) {
        Tag tag = null;
        try {
            XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)((BaseDocument)document).getSyntaxSupport();
            TokenItem tokenItem = xMLSyntaxSupport.getTokenChain(0, 1);
            if (tokenItem != null) {
                Tag tag2;
                while (!ContextUtilities.isTagToken(tokenItem)) {
                    tokenItem = tokenItem.getNext();
                }
                SyntaxElement syntaxElement = xMLSyntaxSupport.getElementChain(tokenItem.getOffset() + tokenItem.getImage().length());
                if ((syntaxElement instanceof StartTag || syntaxElement instanceof EmptyTag) && (tag2 = (Tag)syntaxElement).getParentNode() instanceof org.w3c.dom.Document) {
                    return tag2;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return tag;
    }

    public static final boolean hasAttribute(Node node, String string) {
        return node != null && node.getAttributes() != null && node.getAttributes().getNamedItem(string) != null;
    }

    public static final String getAttribute(Node node, String string) {
        if (SpringXMLConfigEditorUtils.hasAttribute(node, string)) {
            return node.getAttributes().getNamedItem(string).getNodeValue();
        }
        return null;
    }

    public static boolean openFile(File file, int n) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            return SpringXMLConfigEditorUtils.openFile(fileObject, n);
        }
        return false;
    }

    public static boolean openFile(FileObject fileObject, int n) {
        DataObject dataObject;
        boolean bl = false;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
            if (n > 0) {
                bl = SpringXMLConfigEditorUtils.openFileAtOffset(dataObject, n);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
        if (bl) {
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }

    private static boolean openFileAtOffset(DataObject dataObject, int n) throws IOException {
        Line line;
        int n2;
        StyledDocument styledDocument;
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (editorCookie != null && lineCookie != null && (styledDocument = editorCookie.openDocument()) != null && (n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n)) != -1 && (line = lineCookie.getLineSet().getCurrent(n2)) != null) {
            int n3 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2);
            int n4 = n - n3;
            line.show(2, n4);
            return true;
        }
        return false;
    }

    public static SpringBean getMergedBean(SpringBean springBean, FileObject fileObject) {
        if (springBean == null) {
            return null;
        }
        if (springBean.getParent() == null) {
            return springBean;
        }
        ModelBasedSpringBean modelBasedSpringBean = new ModelBasedSpringBean(springBean, fileObject);
        return SpringXMLConfigEditorUtils.getMergedBean(modelBasedSpringBean, fileObject);
    }

    public static SpringBean getMergedBean(Map<String, String> map, FileObject fileObject) {
        NodeBasedSpringBean nodeBasedSpringBean = new NodeBasedSpringBean(map);
        if (!StringUtils.hasText(nodeBasedSpringBean.getParent())) {
            return nodeBasedSpringBean;
        }
        return SpringXMLConfigEditorUtils.getMergedBean(nodeBasedSpringBean, fileObject);
    }

    private static SpringBean getMergedBean(MutableSpringBean mutableSpringBean, FileObject fileObject) {
        final MutableSpringBean[] mutableSpringBeanArray = new MutableSpringBean[]{mutableSpringBean};
        SpringConfigModel springConfigModel = SpringConfigModel.forFileObject(fileObject);
        if (springConfigModel == null) {
            return null;
        }
        try {
            springConfigModel.runReadAction(new Action<SpringBeans>(){

                @Override
                public void run(SpringBeans springBeans) {
                    String string = mutableSpringBeanArray[0].getParent();
                    HashSet<SpringBean> hashSet = new HashSet<SpringBean>();
                    while (string != null && (mutableSpringBeanArray[0].getClassName() == null || mutableSpringBeanArray[0].getFactoryBean() == null || mutableSpringBeanArray[0].getFactoryMethod() == null)) {
                        SpringBean springBean = springBeans.findBean(string);
                        if (hashSet.contains(springBean)) {
                            mutableSpringBeanArray[0] = null;
                            break;
                        }
                        if (mutableSpringBeanArray[0].getClassName() == null) {
                            mutableSpringBeanArray[0].setClassName(springBean.getClassName());
                        }
                        if (mutableSpringBeanArray[0].getFactoryBean() == null) {
                            mutableSpringBeanArray[0].setFactoryBean(springBean.getFactoryBean());
                        }
                        if (mutableSpringBeanArray[0].getFactoryMethod() == null) {
                            mutableSpringBeanArray[0].setFactoryMethod(springBean.getFactoryMethod());
                        }
                        hashSet.add(springBean);
                        string = springBean.getParent();
                    }
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            mutableSpringBeanArray[0] = null;
        }
        return mutableSpringBeanArray[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeBasedSpringBean
    implements MutableSpringBean {
        private String className;
        private String factoryBean;
        private String factoryMethod;
        private String parent;
        private String id;
        private List<String> names;

        public NodeBasedSpringBean(Map<String, String> map) {
            this.className = map.get("class");
            this.factoryBean = map.get("factory-bean");
            this.factoryMethod = map.get("factory-method");
            this.parent = map.get("parent");
            this.id = map.get("id");
            if (map.get("name") == null) {
                this.names = Collections.emptyList();
            }
            this.names = StringUtils.tokenize(map.get("name"), SpringXMLConfigEditorUtils.BEAN_NAME_DELIMITERS);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public void setClassName(String string) {
            this.className = string;
        }

        @Override
        public String getParent() {
            return this.parent;
        }

        @Override
        public String getFactoryBean() {
            return this.factoryBean;
        }

        @Override
        public void setFactoryBean(String string) {
            this.factoryBean = string;
        }

        @Override
        public String getFactoryMethod() {
            return this.factoryMethod;
        }

        @Override
        public void setFactoryMethod(String string) {
            this.factoryMethod = string;
        }

        @Override
        public Location getLocation() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelBasedSpringBean
    implements MutableSpringBean {
        private String className;
        private String factoryBean;
        private String factoryMethod;
        private String parent;
        private String id;
        private List<String> names;
        private Location location;

        public ModelBasedSpringBean(SpringBean springBean, FileObject fileObject) {
            this.className = springBean.getClassName();
            this.factoryBean = springBean.getFactoryBean();
            this.factoryMethod = springBean.getFactoryMethod();
            this.parent = springBean.getParent();
            this.id = springBean.getId();
            this.location = springBean.getLocation();
            this.names = springBean.getNames();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public void setClassName(String string) {
            this.className = string;
        }

        @Override
        public String getParent() {
            return this.parent;
        }

        @Override
        public String getFactoryBean() {
            return this.factoryBean;
        }

        @Override
        public void setFactoryBean(String string) {
            this.factoryBean = string;
        }

        @Override
        public String getFactoryMethod() {
            return this.factoryMethod;
        }

        @Override
        public void setFactoryMethod(String string) {
            this.factoryMethod = string;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }
    }

    private static interface MutableSpringBean
    extends SpringBean {
        public void setClassName(String var1);

        public void setFactoryBean(String var1);

        public void setFactoryMethod(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MethodFinder
    implements Task<CompilationController> {
        private String classBinName;
        private String methodName;
        private int argCount;
        private Public publicFlag;
        private Static staticFlag;
        private ElementHandle<ExecutableElement> methodHandle;

        public MethodFinder(String string, String string2, int n, Public public_, Static static_) {
            this.classBinName = string;
            this.methodName = string2;
            this.argCount = n;
            this.publicFlag = public_;
            this.staticFlag = static_;
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TypeElement typeElement = SpringXMLConfigEditorUtils.findClassElementByBinaryName(this.classBinName, compilationController);
            while (typeElement != null) {
                Object object;
                List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
                for (ExecutableElement executableElement : list) {
                    int n;
                    object = executableElement.getSimpleName().toString();
                    if (!((String)object).equals(this.methodName) || this.argCount != -1 && (n = executableElement.getParameters().size()) != this.argCount || this.staticFlag != Static.DONT_CARE && ((n = (int)(executableElement.getModifiers().contains((Object)Modifier.STATIC) ? 1 : 0)) != 0 && this.staticFlag == Static.NO || n == 0 && this.staticFlag == Static.YES) || this.publicFlag != Public.DONT_CARE && ((n = (int)(executableElement.getModifiers().contains((Object)Modifier.PUBLIC) ? 1 : 0)) != 0 && this.publicFlag == Public.NO || n == 0 && this.publicFlag == Public.YES)) continue;
                    this.methodHandle = ElementHandle.create((Element)executableElement);
                    return;
                }
                TypeMirror typeMirror = typeElement.getSuperclass();
                if (typeMirror instanceof DeclaredType) {
                    DeclaredType declaredType = (DeclaredType)typeMirror;
                    object = declaredType.asElement();
                    if (object.getKind() != ElementKind.CLASS) continue;
                    typeElement = (TypeElement)object;
                    continue;
                }
                typeElement = null;
            }
        }

        public ElementHandle<ExecutableElement> getMethodHandle() {
            return this.methodHandle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryNameTypeScanner
    extends SimpleElementVisitor6<TypeElement, String> {
        private BinaryNameTypeScanner() {
        }

        @Override
        public TypeElement visitPackage(PackageElement packageElement, String string) {
            for (Element element : packageElement.getEnclosedElements()) {
                TypeElement typeElement;
                if (!element.getKind().isClass() || (typeElement = element.accept(this, string)) == null) continue;
                return typeElement;
            }
            return null;
        }

        @Override
        public TypeElement visitType(TypeElement typeElement, String string) {
            String string2 = ElementUtilities.getBinaryName((TypeElement)typeElement);
            if (string.equals(string2)) {
                return typeElement;
            }
            if (string.startsWith(string2)) {
                for (Element element : typeElement.getEnclosedElements()) {
                    TypeElement typeElement2;
                    if (!element.getKind().isClass() || (typeElement2 = element.accept(this, string)) == null) continue;
                    return typeElement2;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Static {
        YES,
        NO,
        DONT_CARE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Public {
        YES,
        NO,
        DONT_CARE;

    }
}

