/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api.beans;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.ProjectSpringScopeProvider;
import org.netbeans.modules.spring.beans.SpringScopeAccessor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringScope {
    private final ConfigFileManager configFileManager;
    private Listener listener;
    final Map<ConfigFileGroup, SpringConfigModel> group2Model = new HashMap<ConfigFileGroup, SpringConfigModel>();
    final Map<FileObject, SpringConfigModel> file2Model = new HashMap<FileObject, SpringConfigModel>();

    private SpringScope(ConfigFileManager configFileManager) {
        this.configFileManager = configFileManager;
    }

    private void initialize() {
        this.listener = new Listener();
        this.configFileManager.addChangeListener(this.listener);
    }

    public static SpringScope getSpringScope(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fo", (Object)fileObject);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ProjectSpringScopeProvider projectSpringScopeProvider = (ProjectSpringScopeProvider)project.getLookup().lookup(ProjectSpringScopeProvider.class);
        if (projectSpringScopeProvider == null) {
            return null;
        }
        return projectSpringScopeProvider.getSpringScope();
    }

    public ConfigFileManager getConfigFileManager() {
        return this.configFileManager;
    }

    public List<SpringConfigModel> getAllFilesConfigModels() {
        List<File> list = this.getConfigFileManager().getConfigFiles();
        ArrayList<SpringConfigModel> arrayList = new ArrayList<SpringConfigModel>(list.size());
        for (File file : list) {
            SpringConfigModel springConfigModel;
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null || (springConfigModel = this.getFileConfigModel(fileObject)) == null) continue;
            arrayList.add(springConfigModel);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private SpringConfigModel getConfigModel(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        SpringConfigModel springConfigModel = this.getGroupConfigModel(file);
        if (springConfigModel != null) {
            return springConfigModel;
        }
        return this.getFileConfigModel(fileObject);
    }

    private SpringConfigModel getGroupConfigModel(File file) {
        for (ConfigFileGroup configFileGroup : this.configFileManager.getConfigFileGroups()) {
            if (!configFileGroup.containsFile(file)) continue;
            return this.getGroupConfigModel(configFileGroup);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpringConfigModel getGroupConfigModel(ConfigFileGroup configFileGroup) {
        SpringConfigModel springConfigModel;
        SpringScope springScope = this;
        synchronized (springScope) {
            springConfigModel = this.group2Model.get(configFileGroup);
            if (springConfigModel == null) {
                springConfigModel = new SpringConfigModel(configFileGroup);
                this.group2Model.put(configFileGroup, springConfigModel);
            }
        }
        return springConfigModel;
    }

    private synchronized SpringConfigModel getFileConfigModel(FileObject fileObject) {
        SpringConfigModel springConfigModel = this.file2Model.get(fileObject);
        if (springConfigModel != null) {
            return springConfigModel;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        ConfigFileGroup configFileGroup = ConfigFileGroup.create(Collections.singletonList(file));
        springConfigModel = new SpringConfigModel(configFileGroup);
        this.file2Model.put(fileObject, springConfigModel);
        fileObject.addFileChangeListener((FileChangeListener)this.listener);
        if (!fileObject.isValid()) {
            this.file2Model.remove(fileObject);
            fileObject.removeFileChangeListener((FileChangeListener)this.listener);
            return null;
        }
        return springConfigModel;
    }

    private synchronized void notifyFileDeleted(FileObject fileObject) {
        this.file2Model.remove(fileObject);
        fileObject.removeFileChangeListener((FileChangeListener)this.listener);
    }

    synchronized void notifyConfigFileManagerChanged() {
        this.group2Model.clear();
        this.file2Model.clear();
    }

    static {
        SpringScopeAccessor.DEFAULT = new SpringScopeAccessor(){

            public SpringScope createSpringScope(ConfigFileManager configFileManager) {
                SpringScope springScope = new SpringScope(configFileManager);
                springScope.initialize();
                return springScope;
            }

            public SpringConfigModel getConfigModel(SpringScope springScope, FileObject fileObject) {
                return springScope.getConfigModel(fileObject);
            }
        };
    }

    private final class Listener
    extends FileChangeAdapter
    implements ChangeListener {
        private Listener() {
        }

        public void fileDeleted(FileEvent fileEvent) {
            SpringScope.this.notifyFileDeleted(fileEvent.getFile());
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            SpringScope.this.notifyFileDeleted(fileRenameEvent.getFile());
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SpringScope.this.notifyConfigFileManagerChanged();
        }
    }
}

