/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api.beans;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.beans.ConfigFileManagerAccessor;
import org.netbeans.modules.spring.beans.ConfigFileManagerImplementation;
import org.openide.util.Mutex;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigFileManager {
    private final ConfigFileManagerImplementation impl;

    private ConfigFileManager(ConfigFileManagerImplementation configFileManagerImplementation) {
        this.impl = configFileManagerImplementation;
    }

    public Mutex mutex() {
        return this.impl.mutex();
    }

    public List<File> getConfigFiles() {
        return this.impl.getConfigFiles();
    }

    public List<ConfigFileGroup> getConfigFileGroups() {
        return this.impl.getConfigFileGroups();
    }

    public void putConfigFilesAndGroups(List<File> list, List<ConfigFileGroup> list2) {
        Parameters.notNull((CharSequence)"files", list);
        Parameters.notNull((CharSequence)"groups", list2);
        if (!this.mutex().isWriteAccess()) {
            throw new IllegalStateException("The putConfigFilesAndGroups() method should be called under mutex() write access");
        }
        this.impl.putConfigFilesAndGroups(list, list2);
    }

    public void save() throws IOException {
        if (!this.mutex().isWriteAccess()) {
            throw new IllegalStateException("The save() method should be called under mutex() write access");
        }
        this.impl.save();
    }

    void addChangeListener(ChangeListener changeListener) {
        this.impl.addChangeListener(changeListener);
    }

    static {
        ConfigFileManagerAccessor.DEFAULT = new ConfigFileManagerAccessor(){

            public ConfigFileManager createConfigFileManager(ConfigFileManagerImplementation configFileManagerImplementation) {
                return new ConfigFileManager(configFileManagerImplementation);
            }
        };
    }
}

