/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.beans.Customizer;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class BreakpointCustomizer
extends JPanel
implements Customizer,
Controller {
    private RubyBreakpoint bp;
    private JLabel fileLbl;
    private JTextField fileValue;
    private JLabel lineLbl;
    private JTextField lineValue;

    public BreakpointCustomizer() {
        this.initComponents();
    }

    public static void customize(RubyBreakpoint rubyBreakpoint) {
        BreakpointCustomizer breakpointCustomizer = new BreakpointCustomizer();
        breakpointCustomizer.setObject((Object)rubyBreakpoint);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)breakpointCustomizer, NbBundle.getMessage(BreakpointCustomizer.class, (String)"BreakpointCustomizer.title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == NotifyDescriptor.OK_OPTION) {
            try {
                int n = Integer.valueOf(breakpointCustomizer.lineValue.getText()) - 1;
                String string = breakpointCustomizer.fileValue.getText();
                if (!new File(string).isFile()) {
                    Util.notifyLocalized(BreakpointCustomizer.class, (String)"BreakpointCustomizer.file.not.found", (Object[])new Object[]{string});
                } else {
                    rubyBreakpoint.setLine(EditorUtil.getLine(string, n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                Util.notifyLocalized(BreakpointCustomizer.class, (String)"BreakpointCustomizer.invalid.number", (Object[])new Object[]{breakpointCustomizer.lineValue.getText()});
            }
        }
    }

    public void setObject(Object object) {
        RubyBreakpoint rubyBreakpoint;
        if (!(object instanceof RubyBreakpoint)) {
            throw new IllegalArgumentException(object.toString());
        }
        this.bp = rubyBreakpoint = (RubyBreakpoint)((Object)object);
        this.fileValue.setText(rubyBreakpoint.getFilePath());
        this.lineValue.setText("" + rubyBreakpoint.getLineNumber());
    }

    public boolean ok() {
        try {
            int n = Integer.valueOf(this.lineValue.getText()) - 1;
            String string = this.fileValue.getText();
            if (!new File(string).isFile()) {
                Util.notifyLocalized(BreakpointCustomizer.class, (String)"BreakpointCustomizer.file.not.found", (Object[])new Object[]{string});
                return false;
            }
            this.bp.setLine(EditorUtil.getLine(string, n));
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Util.notifyLocalized(BreakpointCustomizer.class, (String)"BreakpointCustomizer.invalid.number", (Object[])new Object[]{this.lineValue.getText()});
            return false;
        }
    }

    public boolean cancel() {
        return true;
    }

    private void initComponents() {
        this.fileLbl = new JLabel();
        this.lineLbl = new JLabel();
        this.fileValue = new JTextField();
        this.lineValue = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.fileLbl, (String)NbBundle.getMessage(BreakpointCustomizer.class, (String)"BreakpointCustomizer.fileLbl.text"));
        Mnemonics.setLocalizedText((JLabel)this.lineLbl, (String)NbBundle.getMessage(BreakpointCustomizer.class, (String)"BreakpointCustomizer.lineLbl.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fileLbl).add((Component)this.lineLbl)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lineValue, -1, 406, Short.MAX_VALUE).add((Component)this.fileValue, -1, 406, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fileLbl).add((Component)this.fileValue, -2, 19, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lineLbl).add((Component)this.lineValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

