/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.util.logging.Level;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.ruby.debugger.ContextProviderWrapper;
import org.netbeans.modules.ruby.debugger.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;

public final class RubyBreakpoint
extends Breakpoint
implements IRubyBreakpoint {
    static final String PROP_UPDATED = "updated";
    private boolean enabled;
    private Line line;

    RubyBreakpoint(Line line) {
        this.line = line;
        this.enabled = true;
    }

    private void updateBreakpoint() {
        for (RubyDebuggerProxy rubyDebuggerProxy : RubyDebuggerProxy.PROXIES) {
            try {
                rubyDebuggerProxy.updateBreakpoint((IRubyBreakpoint)this);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                Util.LOGGER.log(Level.WARNING, "Exception during breakpoint update.", rubyDebuggerException);
            }
        }
    }

    public void notifyUpdated() {
        ContextProviderWrapper.getBreakpointModel().fireChanges();
        this.firePropertyChange(PROP_UPDATED, null, null);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (this.enabled) {
            this.enabled = false;
            this.updateBreakpoint();
            this.firePropertyChange("enabled", true, false);
        }
    }

    public void enable() {
        if (!this.enabled) {
            this.enabled = true;
            this.updateBreakpoint();
            this.firePropertyChange("enabled", false, true);
        }
    }

    public Line getLine() {
        return this.line;
    }

    public void setLine(Line line) {
        this.line = line;
        this.firePropertyChange(PROP_UPDATED, false, true);
    }

    public FileObject getFileObject() {
        return (FileObject)this.getLine().getLookup().lookup(FileObject.class);
    }

    public String getFilePath() {
        return FileUtil.toFile((FileObject)this.getFileObject()).getAbsolutePath();
    }

    public int getLineNumber() {
        return this.getLine().getLineNumber() + 1;
    }

    public String toString() {
        return this.getFilePath() + ':' + this.getLineNumber();
    }
}

