/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public final class BreakpointsReader
implements Properties.Reader {
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_LINE_NUMBER = "lineNumber";

    public String[] getSupportedClassNames() {
        return new String[]{RubyBreakpoint.class.getName()};
    }

    public Object read(String string, Properties properties) {
        if (!string.equals(RubyBreakpoint.class.getName())) {
            return null;
        }
        Line line = BreakpointsReader.getLine(properties.getString(PROPERTY_URL, null), properties.getInt(PROPERTY_LINE_NUMBER, 1));
        if (line == null) {
            return null;
        }
        return RubyBreakpointManager.createBreakpoint(line);
    }

    public void write(Object object, Properties properties) {
        RubyBreakpoint rubyBreakpoint = (RubyBreakpoint)((Object)object);
        FileObject fileObject = rubyBreakpoint.getFileObject();
        try {
            properties.setString(PROPERTY_URL, fileObject.getURL().toString());
            properties.setInt(PROPERTY_LINE_NUMBER, rubyBreakpoint.getLine().getLineNumber());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
    }

    private static Line getLine(String string, int n) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Util.finest("Did not find FileObject. Malformed URL '" + string + "'");
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        LineCookie lineCookie = EditorUtil.getLineCookie(fileObject);
        if (lineCookie == null) {
            return null;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            return null;
        }
        try {
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Util.LOGGER.log(Level.FINE, indexOutOfBoundsException.getMessage(), indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Util.LOGGER.log(Level.FINE, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        return null;
    }
}

