/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public final class BreakpointModel
implements NodeModel,
TableModel {
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    private List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof RubyBreakpoint) {
            RubyBreakpoint rubyBreakpoint = (RubyBreakpoint)((Object)object);
            return rubyBreakpoint.getFileObject().getNameExt() + ':' + rubyBreakpoint.getLineNumber();
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof RubyBreakpoint) {
            if (!((RubyBreakpoint)((Object)object)).isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            return LINE_BREAKPOINT;
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof RubyBreakpoint) {
            RubyBreakpoint rubyBreakpoint = (RubyBreakpoint)((Object)object);
            return rubyBreakpoint.getLine().getDisplayName();
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof RubyBreakpoint && "BreakpointEnabled".equals(string)) {
            return ((RubyBreakpoint)((Object)object)).isEnabled();
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof RubyBreakpoint && "BreakpointEnabled".equals(string)) {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (object instanceof RubyBreakpoint && "BreakpointEnabled".equals(string)) {
            if (((Boolean)object2).booleanValue()) {
                ((RubyBreakpoint)((Object)object)).enable();
            } else {
                ((RubyBreakpoint)((Object)object)).disable();
            }
        } else {
            throw new UnknownTypeException(object);
        }
    }

    public void fireChanges() {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }
}

