/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.modules.project.ant.ProjectLibraryProvider;
import org.netbeans.modules.project.ant.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.SubprojectProviderImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbCollections;
import org.openide.util.Parameters;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ReferenceHelper {
    static final String REFS_NAME = "references";
    static final String REF_NAME = "reference";
    static final String REFS_NS = "http://www.netbeans.org/ns/ant-project-references/1";
    static final String REFS_NS2 = "http://www.netbeans.org/ns/ant-project-references/2";
    private Set<String> extraBaseDirectories = new HashSet<String>();
    private final AntProjectHelper h;
    final PropertyEvaluator eval;
    private final AuxiliaryConfiguration aux;
    private static final Pattern FOREIGN_FILE_REFERENCE = Pattern.compile("\\$\\{reference\\.([^.${}]+)\\.([^.${}]+)\\.([\\d&&[^.${}]]+)\\}");
    private static final Pattern FOREIGN_FILE_REFERENCE_OLD = Pattern.compile("\\$\\{reference\\.([^.${}]+)\\.([^.${}]+)\\}");
    private static final Pattern FOREIGN_PLAIN_FILE_REFERENCE = Pattern.compile("\\$\\{file\\.reference\\.([^${}]+)\\}");
    private static final Pattern LIBRARY_REFERENCE = Pattern.compile("\\$\\{libs\\.([^${}]+)\\.[^${}]+\\}");

    public ReferenceHelper(AntProjectHelper antProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration, PropertyEvaluator propertyEvaluator) {
        this.h = antProjectHelper;
        this.aux = auxiliaryConfiguration;
        this.eval = propertyEvaluator;
    }

    private Element loadReferences() {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        Element element = this.aux.getConfigurationFragment(REFS_NAME, REFS_NS2, true);
        if (element == null) {
            element = this.aux.getConfigurationFragment(REFS_NAME, REFS_NS, true);
        }
        return element;
    }

    private void storeReferences(Element element) {
        assert (ProjectManager.mutex().isWriteAccess());
        assert (element != null && element.getLocalName().equals(REFS_NAME) && (REFS_NS.equals(element.getNamespaceURI()) || REFS_NS2.equals(element.getNamespaceURI())));
        this.aux.putConfigurationFragment(element, true);
    }

    private void removeOldReferences() {
        assert (ProjectManager.mutex().isWriteAccess());
        this.aux.removeConfigurationFragment(REFS_NAME, REFS_NS, true);
    }

    @Deprecated
    public boolean addReference(AntArtifact antArtifact) throws IllegalArgumentException {
        Object[] objectArray = this.addReference0(antArtifact, antArtifact.getArtifactLocations()[0]);
        return (Boolean)objectArray[0];
    }

    private Object[] addReference0(final AntArtifact antArtifact, final URI uRI) throws IllegalArgumentException {
        return (Object[])ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object[]>(){

            public Object[] run() {
                String string;
                String string2;
                RawReference rawReference;
                Object object;
                String string3;
                int n = ReferenceHelper.this.findLocationIndex(antArtifact, uRI);
                Project project = antArtifact.getProject();
                if (project == null) {
                    throw new IllegalArgumentException("No project associated with " + antArtifact);
                }
                File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                assert (file != null) : project.getProjectDirectory();
                String string4 = ReferenceHelper.getUsableReferenceID(ProjectUtils.getInformation((Project)project).getName());
                String string5 = ReferenceHelper.this.findReferenceID(string4, "project.", file.getAbsolutePath());
                if (string5 == null) {
                    string5 = ReferenceHelper.this.generateUniqueID(string4, "project.", file.getAbsolutePath());
                }
                File file2 = antArtifact.getScriptLocation();
                if (ReferenceHelper.canUseVersion10(antArtifact, file)) {
                    string3 = PropertyUtils.relativizeFile(file, file2);
                    try {
                        object = new URI(null, null, string3, null);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        object = file.toURI().relativize(file2.toURI());
                    }
                    rawReference = new RawReference(string5, antArtifact.getType(), (URI)object, antArtifact.getTargetName(), antArtifact.getCleanTargetName(), antArtifact.getID());
                } else {
                    if (file2.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                        object = PropertyUtils.relativizeFile(file, file2);
                        assert (object != null) : "Relativization must succeed for files: " + file + " " + file2;
                        string3 = "${project." + string5 + "}/" + (String)object;
                    } else {
                        string3 = "build.script.reference." + string5;
                        ReferenceHelper.this.setPathProperty(file, file2, string3);
                        string3 = "${" + string3 + "}";
                    }
                    rawReference = new RawReference(string5, antArtifact.getType(), string3, antArtifact.getTargetName(), antArtifact.getCleanTargetName(), antArtifact.getID(), antArtifact.getProperties());
                }
                boolean bl = ReferenceHelper.this.addRawReference0(rawReference);
                object = AntBasedProjectFactorySingleton.getProjectFor(ReferenceHelper.this.h).getProjectDirectory();
                File file3 = FileUtil.toFile((FileObject)object);
                if (ReferenceHelper.this.setPathProperty(file3, file, "project." + string5)) {
                    bl = true;
                }
                String string6 = "project." + string5;
                URI uRI2 = uRI;
                if (uRI2.isAbsolute()) {
                    string2 = new File(uRI2).getAbsolutePath();
                    string = "nbproject/private/private.properties";
                } else {
                    string2 = "${" + string6 + "}/" + uRI2.getPath();
                    string = "nbproject/project.properties";
                }
                EditableProperties editableProperties = ReferenceHelper.this.h.getProperties(string);
                String string7 = "reference." + string5 + '.' + ReferenceHelper.getUsableReferenceID(antArtifact.getID());
                if (n > 0) {
                    string7 = string7 + "." + n;
                }
                if (!string2.equals(editableProperties.getProperty(string7))) {
                    editableProperties.put(string7, string2);
                    ReferenceHelper.this.h.putProperties(string, editableProperties);
                    bl = true;
                }
                return new Object[]{bl, "${" + string7 + "}"};
            }
        });
    }

    private int findLocationIndex(AntArtifact antArtifact, URI uRI) throws IllegalArgumentException {
        if (uRI == null) {
            throw new IllegalArgumentException("location cannot be null");
        }
        URI[] uRIArray = antArtifact.getArtifactLocations();
        for (int i = 0; i < uRIArray.length; ++i) {
            if (!uRIArray[i].equals(uRI)) continue;
            return i;
        }
        throw new IllegalArgumentException("location (" + uRI + ") must be in AntArtifact's locations (" + antArtifact + ")");
    }

    private static boolean canUseVersion10(AntArtifact antArtifact, File file) {
        if (antArtifact.getArtifactLocations().length > 1) {
            return false;
        }
        if (antArtifact.getProperties().keySet().size() > 0) {
            return false;
        }
        return antArtifact.getScriptLocation().getAbsolutePath().startsWith(file.getAbsolutePath());
    }

    private boolean setPathProperty(File file, File file2, String string) {
        Object[] objectArray;
        String[] stringArray;
        String string2 = this.relativizeFileToExtraBaseFolders(file2);
        if (string2 != null) {
            stringArray = new String[]{"nbproject/project.properties"};
            objectArray = new String[]{string2};
        } else if (PropertyUtils.relativizeFile(file, file2) != null) {
            string2 = PropertyUtils.relativizeFile(file, file2);
            assert (string2 != null) : "These dirs are not really collocated: " + file + " & " + file2;
            objectArray = new String[]{string2};
            stringArray = new String[]{"nbproject/project.properties"};
        } else {
            stringArray = new String[]{"nbproject/private/private.properties"};
            objectArray = new String[]{file2.getAbsolutePath()};
        }
        assert (!Arrays.asList(objectArray).contains(null)) : "values=" + Arrays.toString(objectArray) + " base=" + file + " path=" + file2;
        return this.setPathPropertyImpl(string, (String[])objectArray, stringArray);
    }

    private boolean setPathProperty(String string, String string2) {
        String[] stringArray = new String[]{"nbproject/project.properties"};
        String[] stringArray2 = new String[]{string};
        return this.setPathPropertyImpl(string2, stringArray2, stringArray);
    }

    private boolean setPathPropertyImpl(String string, String[] stringArray, String[] stringArray2) {
        String string2;
        EditableProperties editableProperties;
        boolean bl = false;
        for (int i = 0; i < stringArray2.length; ++i) {
            editableProperties = this.h.getProperties(stringArray2[i]);
            assert (editableProperties != null) : this.h.getProjectDirectory();
            if (stringArray[i].equals(editableProperties.getProperty(string))) continue;
            editableProperties.put(string, stringArray[i]);
            this.h.putProperties(stringArray2[i], editableProperties);
            bl = true;
        }
        if (stringArray2.length == 1 && (editableProperties = this.h.getProperties(string2 = stringArray2[0].equals("nbproject/project.properties") ? "nbproject/private/private.properties" : "nbproject/project.properties")).remove(string) != null) {
            this.h.putProperties(string2, editableProperties);
        }
        return bl;
    }

    public String addReference(AntArtifact antArtifact, URI uRI) throws IllegalArgumentException {
        Object[] objectArray = this.addReference0(antArtifact, uRI);
        return (String)objectArray[1];
    }

    public boolean isReferenced(final AntArtifact antArtifact, final URI uRI) throws IllegalArgumentException {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                int n = ReferenceHelper.this.findLocationIndex(antArtifact, uRI);
                Project project = antArtifact.getProject();
                if (project == null) {
                    throw new IllegalArgumentException("No project associated with " + antArtifact);
                }
                File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                assert (file != null) : project.getProjectDirectory();
                String string = ReferenceHelper.getUsableReferenceID(ProjectUtils.getInformation((Project)project).getName());
                String string2 = ReferenceHelper.this.findReferenceID(string, "project.", file.getAbsolutePath());
                if (string2 == null) {
                    return false;
                }
                RawReference rawReference = ReferenceHelper.this.getRawReference(string2, ReferenceHelper.getUsableReferenceID(antArtifact.getID()));
                if (rawReference == null) {
                    return false;
                }
                File file2 = ReferenceHelper.this.h.resolveFile(ReferenceHelper.this.eval.evaluate(rawReference.getScriptLocationValue()));
                if (!(antArtifact.getType().equals(rawReference.getArtifactType()) && antArtifact.getID().equals(rawReference.getID()) && antArtifact.getScriptLocation().equals(file2) && antArtifact.getProperties().equals(rawReference.getProperties()) && antArtifact.getTargetName().equals(rawReference.getTargetName()) && antArtifact.getCleanTargetName().equals(rawReference.getCleanTargetName()))) {
                    return false;
                }
                String string3 = "reference." + string2 + '.' + ReferenceHelper.getUsableReferenceID(antArtifact.getID());
                if (n > 0) {
                    string3 = string3 + "." + n;
                }
                return ReferenceHelper.this.eval.getProperty(string3) != null;
            }
        });
    }

    public boolean addRawReference(final RawReference rawReference) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                try {
                    return ReferenceHelper.this.addRawReference0(rawReference);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    return false;
                }
            }
        });
    }

    private boolean addRawReference0(RawReference rawReference) throws IllegalArgumentException {
        Element element = this.loadReferences();
        if (element == null) {
            element = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS(rawReference.getNS(), REFS_NAME);
        }
        boolean bl = false;
        if (element.getNamespaceURI().equals(REFS_NS) && rawReference.getNS().equals(REFS_NS2)) {
            element = this.upgradeTo20(element);
            this.removeOldReferences();
            bl = true;
        } else if (element.getNamespaceURI().equals(REFS_NS2) && rawReference.getNS().equals(REFS_NS)) {
            rawReference.upgrade();
        }
        if (bl |= ReferenceHelper.updateRawReferenceElement(rawReference, element)) {
            this.storeReferences(element);
        }
        return bl;
    }

    private Element upgradeTo20(Element element) {
        Element element2 = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS(REFS_NS2, REFS_NAME);
        RawReference[] rawReferenceArray = ReferenceHelper.getRawReferences(element);
        for (int i = 0; i < rawReferenceArray.length; ++i) {
            rawReferenceArray[i].upgrade();
            ReferenceHelper.updateRawReferenceElement(rawReferenceArray[i], element2);
        }
        return element2;
    }

    private static boolean updateRawReferenceElement(RawReference rawReference, Element element) throws IllegalArgumentException {
        Element element2;
        Element element3 = null;
        Iterator<Element> iterator = Util.findSubElements(element).iterator();
        while (iterator.hasNext()) {
            element2 = iterator.next();
            RawReference rawReference2 = RawReference.create(element2);
            if (rawReference2.getForeignProjectName().compareTo(rawReference.getForeignProjectName()) > 0) {
                element3 = element2;
                break;
            }
            if (!rawReference2.getForeignProjectName().equals(rawReference.getForeignProjectName())) continue;
            if (rawReference2.getID().compareTo(rawReference.getID()) > 0) {
                element3 = element2;
                break;
            }
            if (!rawReference2.getID().equals(rawReference.getID())) continue;
            if (rawReference2.getArtifactType().equals(rawReference.getArtifactType()) && rawReference2.getScriptLocationValue().equals(rawReference.getScriptLocationValue()) && rawReference2.getProperties().equals(rawReference.getProperties()) && rawReference2.getTargetName().equals(rawReference.getTargetName()) && rawReference2.getCleanTargetName().equals(rawReference.getCleanTargetName())) {
                return false;
            }
            element.removeChild(element2);
            if (iterator.hasNext()) {
                element3 = iterator.next();
                break;
            }
            element3 = null;
            break;
        }
        element2 = rawReference.toXml(element.getNamespaceURI(), element.getOwnerDocument());
        element.insertBefore(element2, element3);
        return true;
    }

    @Deprecated
    public boolean removeReference(String string, String string2) {
        return this.removeReference(string, string2, false, null);
    }

    private boolean isLastReference(String string) {
        Object[] objectArray = this.findArtifactAndLocation(string);
        if (objectArray[0] == null || objectArray[1] == null) {
            return true;
        }
        AntArtifact antArtifact = (AntArtifact)objectArray[0];
        URI uRI = (URI)objectArray[1];
        URI[] uRIArray = antArtifact.getArtifactLocations();
        boolean bl = true;
        for (int i = 0; i < uRIArray.length; ++i) {
            if (uRIArray[i].equals(uRI) || !this.isReferenced(antArtifact, uRIArray[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean removeReference(final String string, final String string2, final boolean bl, final String string3) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                Object object;
                Object object2;
                boolean bl3 = false;
                try {
                    if (ReferenceHelper.this.isLastReference("${" + string3 + "}")) {
                        bl3 = ReferenceHelper.this.removeRawReference0(string, string2, bl);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    return false;
                }
                String[] stringArray = new String[]{"nbproject/project.properties", "nbproject/private/private.properties"};
                if (bl3) {
                    object2 = new RawReference[]{};
                    object = ReferenceHelper.this.loadReferences();
                    if (object != null) {
                        object2 = ReferenceHelper.getRawReferences((Element)object);
                    }
                    boolean bl2 = true;
                    for (int i = 0; i < ((RawReference[])object2).length; ++i) {
                        if (!object2[i].getForeignProjectName().equals(string)) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        String string4 = "project." + string;
                        for (int i = 0; i < stringArray.length; ++i) {
                            EditableProperties object3 = ReferenceHelper.this.h.getProperties(stringArray[i]);
                            if (!object3.containsKey(string4)) continue;
                            object3.remove(string4);
                            ReferenceHelper.this.h.putProperties(stringArray[i], object3);
                            bl3 = true;
                        }
                    }
                }
                if ((object2 = string3) == null) {
                    object2 = "reference." + string + '.' + ReferenceHelper.getUsableReferenceID(string2);
                }
                object = "build.script.reference." + string;
                for (String string5 : stringArray) {
                    EditableProperties editableProperties = ReferenceHelper.this.h.getProperties(string5);
                    if (editableProperties.containsKey(object2)) {
                        editableProperties.remove(object2);
                        ReferenceHelper.this.h.putProperties(string5, editableProperties);
                        bl3 = true;
                    }
                    if (!editableProperties.containsKey(object)) continue;
                    editableProperties.remove(object);
                    ReferenceHelper.this.h.putProperties(string5, editableProperties);
                    bl3 = true;
                }
                return bl3;
            }
        });
    }

    @Deprecated
    public boolean removeReference(String string) {
        return this.removeFileReference(string);
    }

    private boolean removeFileReference(final String string) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                boolean bl = false;
                String[] stringArray = new String[]{"nbproject/project.properties", "nbproject/private/private.properties"};
                String string3 = string;
                if (string3.startsWith("${") && string3.endsWith("}")) {
                    string3 = string3.substring(2, string3.length() - 1);
                }
                for (String string2 : stringArray) {
                    EditableProperties editableProperties = ReferenceHelper.this.h.getProperties(string2);
                    if (!editableProperties.containsKey(string3)) continue;
                    editableProperties.remove(string3);
                    ReferenceHelper.this.h.putProperties(string2, editableProperties);
                    bl = true;
                }
                return bl;
            }
        });
    }

    public boolean removeRawReference(final String string, final String string2) {
        return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                try {
                    return ReferenceHelper.this.removeRawReference0(string, string2, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    return false;
                }
            }
        });
    }

    private boolean removeRawReference0(String string, String string2, boolean bl) throws IllegalArgumentException {
        Element element = this.loadReferences();
        if (element == null) {
            return false;
        }
        boolean bl2 = ReferenceHelper.removeRawReferenceElement(string, string2, element, bl);
        if (bl2) {
            this.storeReferences(element);
        }
        return bl2;
    }

    private static boolean removeRawReferenceElement(String string, String string2, Element element, boolean bl) throws IllegalArgumentException {
        for (Element element2 : Util.findSubElements(element)) {
            RawReference rawReference = RawReference.create(element2);
            String string3 = rawReference.getID();
            String string4 = rawReference.getForeignProjectName();
            if (bl) {
                string3 = ReferenceHelper.getUsableReferenceID(rawReference.getID());
                string4 = ReferenceHelper.getUsableReferenceID(rawReference.getForeignProjectName());
            }
            if (string4.compareTo(string) > 0) {
                return false;
            }
            if (!string4.equals(string)) continue;
            if (string3.compareTo(string2) > 0) {
                return false;
            }
            if (!string3.equals(string2)) continue;
            element.removeChild(element2);
            return true;
        }
        return false;
    }

    public RawReference[] getRawReferences() {
        return (RawReference[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<RawReference[]>(){

            public RawReference[] run() {
                Element element = ReferenceHelper.this.loadReferences();
                if (element != null) {
                    try {
                        return ReferenceHelper.getRawReferences(element);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    }
                }
                return new RawReference[0];
            }
        });
    }

    private static RawReference[] getRawReferences(Element element) throws IllegalArgumentException {
        List<Element> list = Util.findSubElements(element);
        ArrayList<RawReference> arrayList = new ArrayList<RawReference>(list.size());
        for (Element element2 : list) {
            arrayList.add(RawReference.create(element2));
        }
        return arrayList.toArray(new RawReference[arrayList.size()]);
    }

    public RawReference getRawReference(String string, String string2) {
        return this.getRawReference(string, string2, false);
    }

    RawReference getRawReference(final String string, final String string2, final boolean bl) {
        return (RawReference)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<RawReference>(){

            public RawReference run() {
                Element element = ReferenceHelper.this.loadReferences();
                if (element != null) {
                    try {
                        return ReferenceHelper.getRawReference(string, string2, element, bl);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                    }
                }
                return null;
            }
        });
    }

    private static RawReference getRawReference(String string, String string2, Element element, boolean bl) throws IllegalArgumentException {
        for (Element element2 : Util.findSubElements(element)) {
            RawReference rawReference = RawReference.create(element2);
            String string3 = rawReference.getID();
            String string4 = rawReference.getForeignProjectName();
            if (bl) {
                string3 = ReferenceHelper.getUsableReferenceID(rawReference.getID());
                string4 = ReferenceHelper.getUsableReferenceID(rawReference.getForeignProjectName());
            }
            if (!string4.equals(string) || !string3.equals(string2)) continue;
            return rawReference;
        }
        return null;
    }

    public String createForeignFileReference(File file, String string) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile((File)file));
        }
        return this.createForeignFileReferenceImpl(file.getAbsolutePath(), string, true);
    }

    public String createForeignFileReferenceAsIs(String string, String string2) {
        return this.createForeignFileReferenceImpl(string, string2, false);
    }

    private String createForeignFileReferenceImpl(final String string, final String string2, final boolean bl) {
        FileObject fileObject = this.h.getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        final File file2 = FileUtil.normalizeFile((File)PropertyUtils.resolveFile(file, string));
        return (String)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                String string3;
                AntArtifact antArtifact = AntArtifactQuery.findArtifactFromFile(file2);
                if (antArtifact != null && antArtifact.getType().equals(string2) && antArtifact.getProject() != null) {
                    try {
                        return ReferenceHelper.this.createForeignFileReference(antArtifact);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new AssertionError((Object)illegalArgumentException);
                    }
                }
                File file = FileUtil.toFile((FileObject)AntBasedProjectFactorySingleton.getProjectFor(ReferenceHelper.this.h).getProjectDirectory());
                String string22 = file2.getName();
                if (file2.isDirectory() && file2.getParentFile() != null) {
                    string22 = file2.getParentFile().getName() + "-" + file2.getName();
                }
                if ((string3 = ReferenceHelper.this.findReferenceID(string22 = PropertyUtils.getUsablePropertyName(string22), "file.reference.", file2.getAbsolutePath())) == null) {
                    string3 = ReferenceHelper.this.generateUniqueID(string22, "file.reference.", file2.getAbsolutePath());
                }
                if (bl) {
                    ReferenceHelper.this.setPathProperty(file, file2, "file.reference." + string3);
                } else {
                    ReferenceHelper.this.setPathProperty(string, "file.reference." + string3);
                }
                return "${file.reference." + string3 + '}';
            }
        });
    }

    public String createExtraForeignFileReferenceAsIs(final String string, final String string2) {
        return (String)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                ReferenceHelper.this.setPathProperty(string, string2);
                return "${" + string2 + '}';
            }
        });
    }

    private String relativizeFileToExtraBaseFolders(File file) {
        File file2 = FileUtil.toFile((FileObject)this.h.getProjectDirectory());
        String string = file.getAbsolutePath();
        for (String string2 : this.extraBaseDirectories) {
            String string3 = this.eval.getProperty(string2);
            File file3 = PropertyUtils.resolveFile(file2, string3);
            if (!(string3 = file3.getAbsolutePath()).endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            if (!string.startsWith(string3)) continue;
            return "${" + string2 + "}/" + string.substring(string3.length()).replace('\\', '/');
        }
        return null;
    }

    public void addExtraBaseDirectory(final String string) {
        if (string == null || this.eval.getProperty(string) == null) {
            throw new IllegalArgumentException("propertyName is null or such a property does not exist: " + string);
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                ReferenceHelper.this.extraBaseDirectories.add(string);
            }
        });
    }

    public void removeExtraBaseDirectory(final String string) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (!ReferenceHelper.this.extraBaseDirectories.remove(string)) {
                    throw new IllegalArgumentException("Non-existing extra base directory property: " + string);
                }
                String string4 = "${" + string + "}";
                boolean bl = ReferenceHelper.this.h.getProperties("nbproject/project.properties").containsKey(string);
                String string2 = ReferenceHelper.this.eval.getProperty(string);
                EditableProperties editableProperties = ReferenceHelper.this.h.getProperties("nbproject/project.properties");
                EditableProperties editableProperties2 = ReferenceHelper.this.h.getProperties("nbproject/private/private.properties");
                boolean bl2 = false;
                boolean bl3 = false;
                Iterator<Map.Entry<String, String>> iterator = editableProperties.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    String string3 = entry.getValue();
                    int n = string3.indexOf(string4);
                    if (n == -1) continue;
                    string3 = string3.substring(0, n) + string2 + string3.substring(n + string4.length());
                    if (bl) {
                        entry.setValue(string3);
                    } else {
                        iterator.remove();
                        editableProperties2.put(entry.getKey(), string3);
                        bl3 = true;
                    }
                    bl2 = true;
                }
                if (bl2) {
                    ReferenceHelper.this.h.putProperties("nbproject/project.properties", editableProperties);
                }
                if (bl3) {
                    ReferenceHelper.this.h.putProperties("nbproject/private/private.properties", editableProperties2);
                }
            }
        });
    }

    private String findReferenceID(String string, String string2, String string3) {
        Map<String, String> map = this.h.getStandardPropertyEvaluator().getProperties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string4;
            String string5 = entry.getKey();
            if (!string5.startsWith(string2 + string) || !string3.equals(string4 = this.h.resolvePath(entry.getValue()))) continue;
            return string5.substring(string2.length());
        }
        return null;
    }

    private String generateUniqueID(String string, String string2, String string3) {
        PropertyEvaluator propertyEvaluator = this.h.getStandardPropertyEvaluator();
        if (propertyEvaluator.getProperty(string2 + string) == null) {
            return string;
        }
        int n = 1;
        while (propertyEvaluator.getProperty(string2 + string + "-" + n) != null) {
            ++n;
        }
        return string + "-" + n;
    }

    @Deprecated
    public String createForeignFileReference(AntArtifact antArtifact) throws IllegalArgumentException {
        Object[] objectArray = this.addReference0(antArtifact, antArtifact.getArtifactLocations()[0]);
        return (String)objectArray[1];
    }

    private static String getUsableReferenceID(String string) {
        return PropertyUtils.getUsablePropertyName(string).replace('.', '_');
    }

    @Deprecated
    public AntArtifact getForeignFileReferenceAsArtifact(String string) {
        Object[] objectArray = this.findArtifactAndLocation(string);
        return (AntArtifact)objectArray[0];
    }

    public Object[] findArtifactAndLocation(final String string) {
        return (Object[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Object[]>(){

            public Object[] run() {
                Object object;
                AntArtifact antArtifact = null;
                Matcher matcher = FOREIGN_FILE_REFERENCE.matcher(string);
                boolean bl = matcher.matches();
                int n = 0;
                if (!bl) {
                    matcher = FOREIGN_FILE_REFERENCE_OLD.matcher(string);
                    bl = matcher.matches();
                } else {
                    try {
                        n = Integer.parseInt(matcher.group(3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ErrorManager.getDefault().log(1, "Could not parse reference (" + string + ") for the jar index. " + "Expected number: " + matcher.group(3));
                        bl = false;
                    }
                }
                if (bl && (object = ReferenceHelper.this.getRawReference(matcher.group(1), matcher.group(2), true)) != null) {
                    antArtifact = ((RawReference)object).toAntArtifact(ReferenceHelper.this);
                }
                if (antArtifact == null) {
                    return new Object[]{null, null};
                }
                if (n >= antArtifact.getArtifactLocations().length) {
                    return new Object[]{null, null};
                }
                object = antArtifact.getArtifactLocations()[n];
                return new Object[]{antArtifact, object};
            }
        });
    }

    @Deprecated
    public void destroyForeignFileReference(String string) {
        this.destroyReference(string);
    }

    public boolean destroyReference(String string) {
        Matcher matcher = FOREIGN_FILE_REFERENCE.matcher(string);
        boolean bl = matcher.matches();
        if (!bl) {
            matcher = FOREIGN_FILE_REFERENCE_OLD.matcher(string);
            bl = matcher.matches();
        }
        if (bl) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            return this.removeReference(string2, string3, true, string.substring(2, string.length() - 1));
        }
        matcher = FOREIGN_PLAIN_FILE_REFERENCE.matcher(string);
        if (matcher.matches()) {
            return this.removeFileReference(string);
        }
        return false;
    }

    public SubprojectProvider createSubprojectProvider() {
        return new SubprojectProviderImpl(this);
    }

    AntProjectHelper getAntProjectHelper() {
        return this.h;
    }

    public void fixReferences(File file) {
        boolean bl;
        String string;
        String[] stringArray = new String[]{"file.reference.", "project."};
        EditableProperties editableProperties = this.h.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = this.h.getProperties("nbproject/private/private.properties");
        File file2 = FileUtil.toFile((FileObject)this.h.getProjectDirectory());
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (Map.Entry<String, String> object2 : editableProperties.entrySet()) {
            String string2;
            File file3;
            String string3;
            string = object2.getKey();
            bl = false;
            for (String string4 : stringArray) {
                if (!string.startsWith(string4)) continue;
                bl = true;
                break;
            }
            if (!bl || (string3 = PropertyUtils.relativizeFile(file2, file3 = FileUtil.normalizeFile((File)PropertyUtils.resolveFile(file, string2 = object2.getValue())))) != null) continue;
            arrayList.add(string);
            hashMap2.put(string, file3.getAbsolutePath());
        }
        for (Map.Entry<String, String> entry : editableProperties.entrySet()) {
            String string5;
            string = entry.getKey();
            bl = false;
            for (String string4 : stringArray) {
                if (!string.startsWith(string4)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            String string6 = entry.getValue();
            File file4 = FileUtil.normalizeFile((File)PropertyUtils.resolveFile(file, string6));
            if (file4.getAbsolutePath().startsWith(file.getAbsolutePath())) {
                String string7 = PropertyUtils.relativizeFile(file, file4);
                file4 = FileUtil.normalizeFile((File)new File(file2, string7));
                arrayList2.add(string);
                hashMap2.put(string, file4.getAbsolutePath());
            }
            if ((string5 = PropertyUtils.relativizeFile(file2, file4)) == null) continue;
            hashMap.put(string, string5);
        }
        for (String string8 : arrayList) {
            editableProperties.remove(string8);
        }
        for (String string9 : arrayList2) {
            editableProperties2.remove(string9);
        }
        editableProperties.putAll(hashMap);
        editableProperties2.putAll(hashMap2);
        this.h.putProperties("nbproject/project.properties", editableProperties);
        this.h.putProperties("nbproject/private/private.properties", editableProperties2);
    }

    public String createLibraryReference(Library library, String string) {
        if (library.getManager() == LibraryManager.getDefault()) {
            if (this.h.isSharableProject()) {
                throw new IllegalArgumentException("Project [" + this.h.getProjectDirectory() + "] is sharable and cannot reference global library " + library.getName());
            }
        } else if (!ProjectLibraryProvider.isReachableLibrary(library, this.h)) {
            throw new IllegalArgumentException("Project [" + this.h.getProjectDirectory() + "] cannot reference a library from " + library.getManager().getLocation());
        }
        return "${libs." + library.getName() + "." + string + "}";
    }

    public LibraryManager getProjectLibraryManager() {
        return ProjectLibraryProvider.getProjectLibraryManager(this.h);
    }

    public static LibraryManager getProjectLibraryManager(Project project) {
        File file;
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (auxiliaryConfiguration != null && (file = ProjectLibraryProvider.getLibrariesLocation(auxiliaryConfiguration, FileUtil.toFile((FileObject)project.getProjectDirectory()))) != null) {
            try {
                return LibraryManager.forLocation((URL)file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(ReferenceHelper.class.getName()).info("library manager cannot be found for " + file + ". " + malformedURLException.toString());
            }
        }
        return null;
    }

    public Library copyLibrary(Library library) throws IOException {
        Parameters.notNull((CharSequence)"lib", (Object)library);
        if (library.getManager() != LibraryManager.getDefault()) {
            throw new IllegalArgumentException("cannot copy non-global library " + library.getManager().getLocation());
        }
        if (!this.h.isSharableProject()) {
            return library;
        }
        File file = this.h.resolveFile(this.h.getLibrariesLocation());
        return ProjectLibraryProvider.copyLibrary(library, file.toURI().toURL(), true);
    }

    public LibraryChooser.LibraryImportHandler getLibraryChooserImportHandler() {
        return new LibraryChooser.LibraryImportHandler(){

            public Library importLibrary(Library library) throws IOException {
                return ReferenceHelper.this.copyLibrary(library);
            }
        };
    }

    public Library findLibrary(String string) {
        LibraryManager libraryManager;
        Matcher matcher = LIBRARY_REFERENCE.matcher(string);
        if (matcher.matches()) {
            string = matcher.group(1);
        }
        if ((libraryManager = this.getProjectLibraryManager()) == null) {
            return LibraryManager.getDefault().getLibrary(string);
        }
        return libraryManager.getLibrary(string);
    }

    public static final class RawReference {
        private final String foreignProjectName;
        private final String artifactType;
        private URI scriptLocation;
        private String newScriptLocation;
        private final String targetName;
        private final String cleanTargetName;
        private final String artifactID;
        private final Properties props;
        private static final List SUB_ELEMENT_NAMES = Arrays.asList("foreign-project", "artifact-type", "script", "target", "clean-target", "id");

        public RawReference(String string, String string2, URI uRI, String string3, String string4, String string5) throws IllegalArgumentException {
            this(string, string2, uRI, null, string3, string4, string5, new Properties());
        }

        public RawReference(String string, String string2, String string3, String string4, String string5, String string6, Properties properties) throws IllegalArgumentException {
            this(string, string2, null, string3, string4, string5, string6, properties);
        }

        private RawReference(String string, String string2, URI uRI, String string3, String string4, String string5, String string6, Properties properties) throws IllegalArgumentException {
            this.foreignProjectName = string;
            this.artifactType = string2;
            if (uRI != null && uRI.isAbsolute()) {
                throw new IllegalArgumentException("Cannot use an absolute URI " + uRI + " for script location");
            }
            this.scriptLocation = uRI;
            this.newScriptLocation = string3;
            this.targetName = string4;
            this.cleanTargetName = string5;
            this.artifactID = string6;
            this.props = properties;
        }

        static RawReference create(Element element) throws IllegalArgumentException {
            if (ReferenceHelper.REFS_NS.equals(element.getNamespaceURI())) {
                return RawReference.create1(element);
            }
            return RawReference.create2(element);
        }

        private static RawReference create1(Element element) throws IllegalArgumentException {
            if (!ReferenceHelper.REF_NAME.equals(element.getLocalName()) || !ReferenceHelper.REFS_NS.equals(element.getNamespaceURI())) {
                throw new IllegalArgumentException("bad element name: " + element);
            }
            NodeList nodeList = element.getElementsByTagNameNS("*", "*");
            if (nodeList.getLength() != 6) {
                throw new IllegalArgumentException("missing or extra data: " + element);
            }
            String[] stringArray = new String[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                if (!ReferenceHelper.REFS_NS.equals(element2.getNamespaceURI())) {
                    throw new IllegalArgumentException("bad subelement ns: " + element2);
                }
                String string = element2.getLocalName();
                int n = SUB_ELEMENT_NAMES.indexOf(string);
                if (n == -1) {
                    throw new IllegalArgumentException("bad subelement name: " + string);
                }
                String string2 = Util.findText(element2);
                if (string2 == null) {
                    throw new IllegalArgumentException("empty subelement: " + element2);
                }
                if (stringArray[n] != null) {
                    throw new IllegalArgumentException("duplicate " + string + ": " + stringArray[n] + " and " + string2);
                }
                stringArray[n] = string2;
            }
            assert (!Arrays.asList(stringArray).contains(null));
            URI uRI = URI.create(stringArray[2]);
            return new RawReference(stringArray[0], stringArray[1], uRI, stringArray[3], stringArray[4], stringArray[5]);
        }

        private static RawReference create2(Element element) throws IllegalArgumentException {
            String string;
            Element element2;
            if (!ReferenceHelper.REF_NAME.equals(element.getLocalName()) || !ReferenceHelper.REFS_NS2.equals(element.getNamespaceURI())) {
                throw new IllegalArgumentException("bad element name: " + element);
            }
            List<Element> list = Util.findSubElements(element);
            if (list.size() < 6) {
                throw new IllegalArgumentException("missing or extra data: " + element);
            }
            String[] stringArray = new String[6];
            for (int i = 0; i < 6; ++i) {
                element2 = list.get(i);
                if (!ReferenceHelper.REFS_NS2.equals(element2.getNamespaceURI())) {
                    throw new IllegalArgumentException("bad subelement ns: " + element2);
                }
                String string2 = element2.getLocalName();
                int n = SUB_ELEMENT_NAMES.indexOf(string2);
                if (n == -1) {
                    throw new IllegalArgumentException("bad subelement name: " + (String)string2);
                }
                string = Util.findText(element2);
                if (string == null) {
                    throw new IllegalArgumentException("empty subelement: " + element2);
                }
                if (stringArray[n] != null) {
                    throw new IllegalArgumentException("duplicate " + (String)string2 + ": " + stringArray[n] + " and " + string);
                }
                stringArray[n] = string;
            }
            Properties properties = new Properties();
            if (list.size() == 7) {
                element2 = list.get(6);
                if (!ReferenceHelper.REFS_NS2.equals(element2.getNamespaceURI())) {
                    throw new IllegalArgumentException("bad subelement ns: " + element2);
                }
                if (!"properties".equals(element2.getLocalName())) {
                    throw new IllegalArgumentException("bad subelement. expected 'properties': " + element2);
                }
                for (Element element3 : Util.findSubElements(element2)) {
                    string = element3.getAttribute("name");
                    String string3 = Util.findText(element3);
                    if (string3 == null) {
                        string3 = "";
                    }
                    properties.setProperty(string, string3);
                }
            }
            assert (!Arrays.asList(stringArray).contains(null));
            return new RawReference(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], properties);
        }

        Element toXml(String string, Document document) {
            Element element = document.createElementNS(string, ReferenceHelper.REF_NAME);
            String[] stringArray = new String[]{this.foreignProjectName, this.artifactType, this.newScriptLocation != null ? this.newScriptLocation : this.scriptLocation.toString(), this.targetName, this.cleanTargetName, this.artifactID};
            for (int i = 0; i < 6; ++i) {
                Element element2 = document.createElementNS(string, (String)SUB_ELEMENT_NAMES.get(i));
                element2.appendChild(document.createTextNode(stringArray[i]));
                element.appendChild(element2);
            }
            if (this.props.keySet().size() > 0) {
                assert (string.equals(ReferenceHelper.REFS_NS2)) : "can happen only in /2";
                Element element3 = document.createElementNS(string, "properties");
                element.appendChild(element3);
                for (String string2 : new TreeSet(NbCollections.checkedSetByFilter(this.props.keySet(), String.class, (boolean)true))) {
                    Element element4 = document.createElementNS(string, "property");
                    element4.appendChild(document.createTextNode(this.props.getProperty(string2)));
                    element4.setAttribute("name", string2);
                    element3.appendChild(element4);
                }
            }
            return element;
        }

        private String getNS() {
            if (this.newScriptLocation != null) {
                return ReferenceHelper.REFS_NS2;
            }
            return ReferenceHelper.REFS_NS;
        }

        public String getForeignProjectName() {
            return this.foreignProjectName;
        }

        public String getArtifactType() {
            return this.artifactType;
        }

        @Deprecated
        public URI getScriptLocation() {
            return this.scriptLocation;
        }

        public String getScriptLocationValue() {
            if (this.newScriptLocation != null) {
                return this.newScriptLocation;
            }
            return "${project." + this.foreignProjectName + "}/" + this.scriptLocation.toString();
        }

        public String getTargetName() {
            return this.targetName;
        }

        public String getCleanTargetName() {
            return this.cleanTargetName;
        }

        public String getID() {
            return this.artifactID;
        }

        public Properties getProperties() {
            return this.props;
        }

        public AntArtifact toAntArtifact(final ReferenceHelper referenceHelper) {
            return (AntArtifact)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<AntArtifact>(){

                public AntArtifact run() {
                    Project project;
                    AntProjectHelper antProjectHelper = referenceHelper.h;
                    String string = referenceHelper.eval.getProperty("project." + RawReference.this.foreignProjectName);
                    if (string == null) {
                        return null;
                    }
                    FileObject fileObject = antProjectHelper.resolveFileObject(string);
                    if (fileObject == null) {
                        return null;
                    }
                    try {
                        project = ProjectManager.getDefault().findProject(fileObject);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        return null;
                    }
                    if (project == null) {
                        return null;
                    }
                    return AntArtifactQuery.findArtifactByID(project, RawReference.this.artifactID);
                }
            });
        }

        private void upgrade() {
            assert (this.newScriptLocation == null && this.scriptLocation != null) : "was already upgraded " + this;
            this.newScriptLocation = "${project." + this.foreignProjectName + "}/" + this.scriptLocation.toString();
            this.scriptLocation = null;
        }

        public String toString() {
            return "ReferenceHelper.RawReference<" + this.foreignProjectName + "," + this.artifactType + "," + this.newScriptLocation != null ? this.newScriptLocation : this.scriptLocation + "," + this.targetName + "," + this.cleanTargetName + "," + this.artifactID + ">";
        }
    }
}

