/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import javax.swing.JFileChooser;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.project.ant.FileChooserAccessory;
import org.netbeans.modules.project.ant.ProjectLibraryProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class FileChooser
extends JFileChooser {
    private FileChooserAccessory accessory;

    public FileChooser(AntProjectHelper antProjectHelper, boolean bl) {
        URL uRL;
        LibraryManager libraryManager = ProjectLibraryProvider.getProjectLibraryManager(antProjectHelper);
        if (libraryManager != null && (uRL = libraryManager.getLocation()) != null) {
            File file = new File(URI.create(uRL.toExternalForm())).getParentFile();
            this.accessory = new FileChooserAccessory(this, FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory()), file, bl);
            this.setAccessory(this.accessory);
        }
    }

    public FileChooser(File file, File file2) {
        if (file != null) {
            this.accessory = new FileChooserAccessory(this, file, file2, file2 != null);
            this.setAccessory(this.accessory);
        }
    }

    public String[] getSelectedPaths() throws IOException {
        if (this.accessory != null) {
            this.accessory.copyFilesIfNecessary();
            if (this.accessory.isRelative()) {
                return this.accessory.getFiles();
            }
        }
        if (this.isMultiSelectionEnabled()) {
            File[] fileArray = this.getSelectedFiles();
            String[] stringArray = new String[fileArray.length];
            int n = 0;
            for (File file : fileArray) {
                stringArray[n] = file.getAbsolutePath();
                ++n;
            }
            return stringArray;
        }
        if (this.getSelectedFile() != null) {
            return new String[]{this.getSelectedFile().getAbsolutePath()};
        }
        return new String[0];
    }

    public void approveSelection() {
        if (this.accessory != null && !this.accessory.canApprove()) {
            return;
        }
        super.approveSelection();
    }
}

