/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.filesystems.DefaultParser;
import org.netbeans.core.filesystems.MIMEComponent;
import org.netbeans.core.filesystems.Util;
import org.netbeans.core.filesystems.XMLEnvironmentProvider;
import org.netbeans.core.filesystems.XMLMIMEComponent;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MIMEResolverImpl
extends XMLEnvironmentProvider
implements Environment.Provider {
    private static final long serialVersionUID = 18975L;
    private static final Logger ERR = Logger.getLogger(MIMEResolverImpl.class.getName());
    private static final boolean CASE_INSENSITIVE = Utilities.isWindows() || Utilities.getOperatingSystem() == 16384;

    protected InstanceContent createInstanceContent(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        InstanceContent instanceContent = new InstanceContent();
        instanceContent.add((Object)new Impl(fileObject));
        return instanceContent;
    }

    private static class Type {
        private String[] exts;
        private String[] mimes;
        private String[] fatts;
        private String[] vals;
        private byte[] magic;
        private byte[] mask;

        Type() {
        }

        public String toString() {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("fast-check(");
            if (this.exts != null) {
                stringBuffer.append("exts:");
                for (n = 0; n < this.exts.length; ++n) {
                    stringBuffer.append(this.exts[n]).append(", ");
                }
            }
            if (this.mimes != null) {
                stringBuffer.append("mimes:");
                for (n = 0; n < this.mimes.length; ++n) {
                    stringBuffer.append(this.mimes[n]).append(", ");
                }
            }
            if (this.fatts != null) {
                stringBuffer.append("file-attributes:");
                for (n = 0; n < this.fatts.length; ++n) {
                    stringBuffer.append(this.fatts[n]).append("='").append(this.vals[n]).append("', ");
                }
            }
            if (this.magic != null) {
                stringBuffer.append("magic:").append(XMLUtil.toHex((byte[])this.magic, (int)0, (int)this.magic.length));
            }
            if (this.mask != null) {
                stringBuffer.append("mask:").append(XMLUtil.toHex((byte[])this.mask, (int)0, (int)this.mask.length));
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        private void addExt(String string) {
            this.exts = Util.addString(this.exts, string);
        }

        private void addMIME(String string) {
            this.mimes = Util.addString(this.mimes, string.toLowerCase());
        }

        private void addAttr(String string, String string2) {
            this.fatts = Util.addString(this.fatts, string);
            this.vals = Util.addString(this.vals, string2);
        }

        private boolean setMagic(byte[] byArray, byte[] byArray2) {
            if (byArray == null) {
                return true;
            }
            if (byArray2 != null && byArray.length != byArray2.length) {
                return false;
            }
            this.magic = byArray;
            if (byArray2 != null) {
                this.mask = byArray2;
                for (int i = 0; i < byArray2.length; ++i) {
                    int n = i;
                    this.magic[n] = (byte)(this.magic[n] & byArray2[i]);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean accept(FileObject fileObject) throws IOException {
            int n;
            int n2;
            Object object;
            int n3;
            if (this.exts != null) {
                if (fileObject.getExt() == null) {
                    return false;
                }
                if (!Util.contains(this.exts, fileObject.getExt(), CASE_INSENSITIVE)) {
                    return false;
                }
            }
            if (this.mimes != null) {
                n3 = 0;
                object = FileUtil.getMIMEType((String)fileObject.getExt());
                if (object == null) {
                    return false;
                }
                n2 = ((String)object).indexOf(59);
                if (n2 >= 0) {
                    object = ((String)object).substring(0, n2);
                }
                object = ((String)object).toLowerCase();
                for (n = this.mimes.length - 1; n >= 0; --n) {
                    if (((String)object).equals(this.mimes[n])) {
                        n3 = 1;
                        break;
                    }
                    if (this.mimes[n].length() <= 0 || this.mimes[n].charAt(0) != '+' || !((String)object).endsWith(this.mimes[n])) continue;
                    n3 = 1;
                    break;
                }
                if (n3 == 0) {
                    return false;
                }
            }
            if (this.magic != null) {
                byte[] byArray = new byte[this.magic.length];
                object = null;
                n2 = 0;
                try {
                    int n4;
                    object = fileObject.getInputStream();
                    for (n = 0; n < this.magic.length; n += n4) {
                        try {
                            n4 = ((InputStream)object).read(byArray, n, this.magic.length - n);
                            if (n4 >= 0) continue;
                            n2 = 1;
                            continue;
                        }
                        catch (IOException iOException) {
                            n2 = 1;
                            break;
                        }
                    }
                }
                catch (IOException iOException) {
                    n2 = 1;
                    boolean bl = false;
                    if (Utilities.isWindows() && fileObject.canRead() && iOException instanceof FileNotFoundException && fileObject.isValid() && fileObject.getName().toLowerCase().indexOf("ntuser") != -1) {
                        bl = true;
                    }
                    if (fileObject.canRead() && !bl) {
                        throw iOException;
                    }
                }
                finally {
                    try {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (n2 != 0) {
                    return false;
                }
                for (n = 0; n < this.magic.length; ++n) {
                    if (this.mask != null) {
                        int n5 = n;
                        byArray[n5] = (byte)(byArray[n5] & this.mask[n]);
                    }
                    if (this.magic[n] == byArray[n]) continue;
                    return false;
                }
            }
            if (this.fatts != null) {
                for (n3 = this.fatts.length - 1; n3 >= 0; --n3) {
                    object = fileObject.getAttribute(this.fatts[n3]);
                    if (object == null || object.toString().equals(this.vals[n3]) || this.vals[n3] == null) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class FileElement {
        private Type fileCheck = new Type();
        private String mime = null;
        private MIMEComponent rule = null;

        FileElement() {
        }

        private void setMIME(String string) {
            if ("null".equals(string)) {
                return;
            }
            this.mime = string;
        }

        private String resolve(FileObject fileObject) {
            try {
                if (this.fileCheck.accept(fileObject)) {
                    if (this.mime == null) {
                        return null;
                    }
                    if (this.rule == null) {
                        return this.mime;
                    }
                    if (this.rule.acceptFileObject(fileObject)) {
                        return this.mime;
                    }
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(MIMEResolverImpl.class.getName()).log(Level.INFO, null, iOException);
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("FileElement(");
            stringBuffer.append(this.fileCheck).append(' ');
            stringBuffer.append(this.rule).append(' ');
            stringBuffer.append("Result:").append(this.mime);
            return stringBuffer.toString();
        }
    }

    private static class DescParser
    extends DefaultParser {
        private FileElement[] template = null;
        private short file_state = 0;
        private MIMEComponent component = null;
        private String componentDelimiter = null;
        private static final short IN_ROOT = 1;
        private static final short IN_FILE = 2;
        private static final short IN_RESOLVER = 3;
        private static final short IN_COMPONENT = 4;
        private static final short IN_EXIT = 1;
        private static final String ROOT = "MIME-resolver";
        private static final String FILE = "file";
        private static final String MIME = "mime";
        private static final String EXT = "ext";
        private static final String RESOLVER = "resolver";
        private static final String FATTR = "fattr";
        private static final String NAME = "name";
        private static final String MAGIC = "magic";
        private static final String HEX = "hex";
        private static final String MASK = "mask";
        private static final String VALUE = "text";
        private static final String EXIT = "exit";
        private static final String XML_RULE_COMPONENT = "xml-rule";

        DescParser(FileObject fileObject) {
            super(fileObject);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!ROOT.equals(string3)) {
                        this.error();
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (!FILE.equals(string3)) {
                        this.error();
                    }
                    if (this.template == null) {
                        this.template = new FileElement[]{new FileElement()};
                    } else {
                        FileElement[] fileElementArray = new FileElement[this.template.length + 1];
                        System.arraycopy(this.template, 0, fileElementArray, 1, this.template.length);
                        fileElementArray[0] = new FileElement();
                        this.template = fileElementArray;
                    }
                    this.state = (short)2;
                    break;
                }
                case 2: {
                    if (this.file_state == 1) {
                        this.error();
                    }
                    if (EXT.equals(string3)) {
                        String string4 = attributes.getValue(NAME);
                        if (string4 == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addExt(string4);
                        break;
                    }
                    if (MAGIC.equals(string3)) {
                        String string5 = attributes.getValue(HEX);
                        if (string5 == null) {
                            this.error();
                        }
                        String string6 = attributes.getValue(MASK);
                        char[] cArray = string5.toCharArray();
                        byte[] byArray = null;
                        try {
                            Object[] objectArray;
                            if (string6 != null) {
                                objectArray = string6.toCharArray();
                                byArray = XMLUtil.fromHex((char[])objectArray, (int)0, (int)objectArray.length);
                            }
                            objectArray = XMLUtil.fromHex((char[])cArray, (int)0, (int)cArray.length);
                            if (this.template[0].fileCheck.setMagic((byte[])objectArray, byArray)) break;
                            this.error();
                        }
                        catch (IOException iOException) {
                            this.error();
                        }
                        break;
                    }
                    if (MIME.equals(string3)) {
                        String string7 = attributes.getValue(NAME);
                        if (string7 == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addMIME(string7);
                        break;
                    }
                    if (FATTR.equals(string3)) {
                        String string8 = attributes.getValue(NAME);
                        if (string8 == null) {
                            this.error();
                        }
                        String string9 = attributes.getValue(VALUE);
                        this.template[0].fileCheck.addAttr(string8, string9);
                        break;
                    }
                    if (RESOLVER.equals(string3)) {
                        String string10;
                        if (this.template[0].fileCheck.exts == null && this.template[0].fileCheck.mimes == null && this.template[0].fileCheck.fatts == null && this.template[0].fileCheck.magic == null) {
                            this.error();
                        }
                        if ((string10 = attributes.getValue(MIME)) == null) {
                            this.error();
                        }
                        this.template[0].setMIME(string10);
                        this.state = (short)3;
                        break;
                    }
                    if (EXIT.equals(string3)) {
                        this.file_state = 1;
                        break;
                    }
                    String string11 = "Unexpected element:  " + string3;
                    this.error(string11);
                    break;
                }
                case 3: {
                    if (!XML_RULE_COMPONENT.equals(string3)) break;
                    this.enterComponent(XML_RULE_COMPONENT, new XMLMIMEComponent());
                    this.component.startElement(string, string2, string3, attributes);
                    break;
                }
                case 4: {
                    this.component.startElement(string, string2, string3, attributes);
                    break;
                }
            }
        }

        private void enterComponent(String string, MIMEComponent mIMEComponent) {
            this.component = mIMEComponent;
            this.componentDelimiter = string;
            mIMEComponent.setDocumentLocator(this.getLocator());
            this.template[0].rule = mIMEComponent;
            this.state = (short)4;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            switch (this.state) {
                case 2: {
                    if (!FILE.equals(string3)) break;
                    this.state = 1;
                    this.file_state = 0;
                    break;
                }
                case 3: {
                    if (!RESOLVER.equals(string3)) break;
                    this.state = (short)2;
                    break;
                }
                case 4: {
                    this.component.endElement(string, string2, string3);
                    if (!this.componentDelimiter.equals(string3)) break;
                    this.state = (short)3;
                    this.component.setDocumentLocator(null);
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.state == 4) {
                this.component.characters(cArray, n, n2);
            }
        }
    }

    static class Impl
    extends MIMEResolver
    implements InstanceCookie {
        private final FileObject data;
        private FileElement[] smell = null;
        private short state = 0;

        Impl(FileObject fileObject) {
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("MIMEResolverImpl.Impl.<init>(" + fileObject + ")");
            }
            this.data = fileObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String findMIMEType(FileObject fileObject) {
            Impl impl = this;
            synchronized (impl) {
                if (this.state == 0) {
                    this.state = this.parseDesc();
                }
                if (this.state == -1) {
                    return null;
                }
            }
            for (int i = this.smell.length - 1; i >= 0; --i) {
                String string = this.smell[i].resolve(fileObject);
                if (string == null) continue;
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("MIMEResolverImpl.findMIMEType(" + fileObject + ")=" + string);
                }
                return string;
            }
            return null;
        }

        private short parseDesc() {
            this.smell = new FileElement[0];
            DescParser descParser = new DescParser(this.data);
            descParser.parse();
            FileElement[] fileElementArray = this.smell = descParser.template != null ? descParser.template : this.smell;
            if (ERR.isLoggable(Level.FINE)) {
                if (descParser.state == -1) {
                    ERR.fine("MIMEResolverImpl.Impl parsing error!");
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Parse: ");
                    for (int i = 0; i < this.smell.length; ++i) {
                        stringBuffer.append('\n').append(this.smell[i]);
                    }
                    ERR.fine(stringBuffer.toString());
                }
            }
            return descParser.state;
        }

        public Object instanceCreate() {
            return this;
        }

        public Class instanceClass() {
            return ((Object)((Object)this)).getClass();
        }

        public String instanceName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public String toString() {
            return "MIMEResolverImpl.Impl[" + this.data + ", " + this.smell + "]";
        }
    }
}

