/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelutil;

import java.awt.Container;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmUtilities {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int LOCAL_MEMBER_BIT = 256;
    public static final int CONST_MEMBER_BIT = 512;
    public static final int PUBLIC_LEVEL = 2;
    public static final int PROTECTED_LEVEL = 1;
    public static final int PRIVATE_LEVEL = 0;
    public static final int GLOBAL = 4096;
    public static final int LOCAL = 8192;
    public static final int FILE_LOCAL = 16384;
    public static final int MEMBER = 32768;
    public static final int ENUMERATOR = 1024;
    public static final int CONSTRUCTOR = 2048;
    public static final int DESTRUCTOR = 131072;
    public static final int OPERATOR = 262144;
    public static final int MACRO = 65536;
    public static final int EXTERN = 524288;
    public static final boolean DEBUG = Boolean.getBoolean("csm.utilities.trace.summary") || Boolean.getBoolean("csm.utilities.trace");
    private static String[] headerExts = new String[]{"h", "hh", "hpp"};
    private static String[] sourceExts = new String[]{"c", "cc", "cpp"};
    private static final char EXT_SEP = '.';
    private static final CsmOffsetable.Position DUMMY_POSITION = new CsmOffsetable.Position(){

        public int getOffset() {
            return -1;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }
    };

    public static int getModifiers(CsmObject csmObject) {
        CsmFunctionDefinition csmFunctionDefinition;
        int n = 0;
        if (CsmKindUtilities.isClassMember((CsmObject)csmObject)) {
            n |= CsmUtilities.getMemberModifiers((CsmMember)csmObject);
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
            csmFunctionDefinition = (CsmFunctionDefinition)csmObject;
            if (CsmKindUtilities.isClassMember((CsmObject)csmFunctionDefinition.getDeclaration())) {
                n |= CsmUtilities.getMemberModifiers((CsmMember)csmFunctionDefinition.getDeclaration());
            }
        } else {
            if (CsmKindUtilities.isGlobalVariable((CsmObject)csmObject) || CsmKindUtilities.isGlobalVariable((CsmObject)csmObject)) {
                n |= 0x1000;
            }
            if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObject)) {
                n |= 0x4000;
            }
            if (CsmKindUtilities.isEnumerator((CsmObject)csmObject)) {
                n |= 0x400;
            }
        }
        if (CsmKindUtilities.isOperator((CsmObject)csmObject)) {
            n |= 0x40000;
        }
        if (CsmKindUtilities.isVariable((CsmObject)csmObject)) {
            csmFunctionDefinition = (CsmVariable)csmObject;
            n |= csmFunctionDefinition.getType() != null && csmFunctionDefinition.getType().isConst() ? 512 : 0;
            if (csmFunctionDefinition.isExtern()) {
                n |= 0x80000;
            }
        }
        return n;
    }

    public static int getMemberModifiers(CsmMember csmMember) {
        int n = 0;
        CsmVisibility csmVisibility = csmMember.getVisibility();
        if (CsmVisibility.PRIVATE == csmVisibility) {
            n = 2;
        } else if (CsmVisibility.PROTECTED == csmVisibility) {
            n = 4;
        } else if (CsmVisibility.PUBLIC == csmVisibility) {
            n = 1;
        }
        if (csmMember.isStatic()) {
            n |= 8;
        }
        n |= 0x8000;
        if (CsmKindUtilities.isConstructor((CsmObject)csmMember)) {
            n |= 0x800;
        } else if (CsmKindUtilities.isDestructor((CsmObject)csmMember)) {
            n |= 0x20000;
        }
        return n;
    }

    public static int getLevel(int n) {
        if ((n & 1) != 0) {
            return 2;
        }
        if ((n & 4) != 0) {
            return 1;
        }
        return 0;
    }

    public static boolean isPrimitiveClassName(String string) {
        return CCTokenContext.isTypeOrVoid((String)string);
    }

    public static boolean isPrimitiveClass(CsmClassifier csmClassifier) {
        return csmClassifier.getKind() == CsmDeclaration.Kind.BUILT_IN;
    }

    public static CsmFile getCsmFile(Node node, boolean bl) {
        return CsmUtilities.getCsmFile((DataObject)node.getLookup().lookup(DataObject.class), bl);
    }

    public static JEditorPane[] getOpenedPanesInEQ(final EditorCookie editorCookie) {
        assert (editorCookie != null);
        final JEditorPane[][] jEditorPaneArray = new JEditorPane[][]{null};
        if (SwingUtilities.isEventDispatchThread()) {
            jEditorPaneArray[0] = editorCookie.getOpenedPanes();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        jEditorPaneArray[0] = editorCookie.getOpenedPanes();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        }
        return jEditorPaneArray[0];
    }

    public static File getFile(Document document) {
        FileObject fileObject;
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        if (dataObject != null && dataObject.isValid() && (fileObject = dataObject.getPrimaryFile()) != null) {
            File file = FileUtil.toFile((FileObject)fileObject);
            return file;
        }
        return null;
    }

    public static CsmFile getCsmFile(JTextComponent jTextComponent, boolean bl) {
        return jTextComponent == null ? null : CsmUtilities.getCsmFile(jTextComponent.getDocument(), bl);
    }

    public static CsmFile getCsmFile(Document document, boolean bl) {
        CsmFile csmFile = null;
        try {
            csmFile = CsmUtilities.getCsmFile(NbEditorUtilities.getDataObject((Document)document), bl);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return csmFile;
    }

    public static CsmProject getCsmProject(Document document) {
        CsmProject csmProject = null;
        try {
            csmProject = CsmUtilities.getCsmFile(document, false).getProject();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return csmProject;
    }

    public static boolean isAnyNativeProjectOpened() {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (projectArray[i].getLookup().lookup(NativeProject.class) == null) continue;
            return true;
        }
        return false;
    }

    public static CsmFile[] getCsmFiles(DataObject dataObject) {
        block7: {
            if (dataObject != null && dataObject.isValid()) {
                try {
                    NativeFileItemSet nativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
                    if (nativeFileItemSet == null) {
                        File file;
                        FileObject fileObject = dataObject.getPrimaryFile();
                        if (fileObject != null && (file = FileUtil.toFile((FileObject)fileObject)) != null) {
                            file = FileUtil.normalizeFile((File)file);
                            CsmFile csmFile = CsmModelAccessor.getModel().findFile((CharSequence)file.getAbsolutePath());
                            if (csmFile != null) {
                                return new CsmFile[]{csmFile};
                            }
                        }
                        break block7;
                    }
                    ArrayList<CsmFile> arrayList = new ArrayList<CsmFile>(nativeFileItemSet.getItems().size());
                    for (NativeFileItem nativeFileItem : nativeFileItemSet.getItems()) {
                        CsmFile csmFile;
                        CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)nativeFileItem.getNativeProject());
                        if (csmProject == null || (csmFile = csmProject.findFile((CharSequence)nativeFileItem.getFile().getAbsolutePath())) == null) continue;
                        arrayList.add(csmFile);
                    }
                    return arrayList.toArray(new CsmFile[arrayList.size()]);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
        return new CsmFile[0];
    }

    public static CsmFile[] getCsmFiles(FileObject fileObject) {
        try {
            return CsmUtilities.getCsmFiles(DataObject.find((FileObject)fileObject));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return new CsmFile[0];
        }
    }

    public static CsmFile getCsmFile(DataObject dataObject, boolean bl) {
        CsmFile[] csmFileArray = CsmUtilities.getCsmFiles(dataObject);
        if (csmFileArray == null || csmFileArray.length == 0) {
            return null;
        }
        if (bl) {
            try {
                csmFileArray[0].scheduleParsing(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return csmFileArray[0];
    }

    public static CsmFile getCsmFile(FileObject fileObject, boolean bl) {
        if (fileObject == null) {
            return null;
        }
        try {
            return CsmUtilities.getCsmFile(DataObject.find((FileObject)fileObject), bl);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    public static FileObject getFileObject(CsmFile csmFile) {
        FileObject fileObject = null;
        if (csmFile != null) {
            try {
                try {
                    fileObject = FileUtil.toFileObject((File)new File(((Object)csmFile.getAbsolutePath()).toString()).getCanonicalFile());
                }
                catch (IOException iOException) {
                    fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(((Object)csmFile.getAbsolutePath()).toString())));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        return fileObject;
    }

    public static DataObject getDataObject(CsmFile csmFile) {
        return CsmUtilities.getDataObject(CsmUtilities.getFileObject(csmFile));
    }

    public static DataObject getDataObject(FileObject fileObject) {
        DataObject dataObject = null;
        if (fileObject != null) {
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dataObject;
    }

    public static PositionBounds createPositionBounds(CsmOffsetable csmOffsetable) {
        if (csmOffsetable == null) {
            return null;
        }
        CloneableEditorSupport cloneableEditorSupport = CsmUtilities.findCloneableEditorSupport(csmOffsetable.getContainingFile());
        if (cloneableEditorSupport != null) {
            PositionRef positionRef = cloneableEditorSupport.createPositionRef(csmOffsetable.getStartOffset(), Position.Bias.Forward);
            PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(csmOffsetable.getEndOffset(), Position.Bias.Backward);
            return new PositionBounds(positionRef, positionRef2);
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(CsmFile csmFile) {
        DataObject dataObject = CsmUtilities.getDataObject(csmFile);
        return CsmUtilities.findCloneableEditorSupport(dataObject);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static CsmFile findHeaderFile(CsmFile csmFile) {
        return CsmUtilities.findCsmFile(csmFile, true);
    }

    public static CsmFile findSourceFile(CsmFile csmFile) {
        return CsmUtilities.findCsmFile(csmFile, false);
    }

    public static CsmFile toggleFileKind(CsmFile csmFile) {
        assert (csmFile != null) : "can't be null file";
        boolean bl = CsmUtilities.isHeaderFile(csmFile);
        CsmFile csmFile2 = CsmUtilities.findCsmFile(csmFile, !bl);
        return csmFile2 == null ? csmFile : csmFile2;
    }

    public static boolean isHeaderFile(CsmFile csmFile) {
        assert (csmFile != null) : "can't be null file";
        String string = ((Object)csmFile.getAbsolutePath()).toString();
        String string2 = FileUtil.getExtension((String)string);
        return CsmUtilities.isHeaderExt(string2);
    }

    public static boolean isSourceFile(CsmFile csmFile) {
        assert (csmFile != null) : "can't be null file";
        return !CsmUtilities.isHeaderFile(csmFile);
    }

    protected static CsmFile findCsmFile(CsmFile csmFile, boolean bl) {
        String string = ((Object)csmFile.getAbsolutePath()).toString();
        String string2 = FileUtil.getExtension((String)string);
        CsmFile csmFile2 = null;
        if (string2.length() > 0) {
            String string3 = string.substring(0, string.length() - string2.length() - 1);
            String string4 = bl ? CsmUtilities.findHeaderFileName(string3) : CsmUtilities.findSourceFileName(string3);
            if (string4 != null && string4.length() > 0) {
                csmFile2 = csmFile.getProject().findFile((CharSequence)string4);
            }
        }
        return csmFile2;
    }

    protected static String findHeaderFileName(String string) {
        for (int i = 0; i < headerExts.length; ++i) {
            String string2 = string + '.' + headerExts[i];
            File file = new File(string2);
            if (!file.exists()) continue;
            return string2;
        }
        return "";
    }

    protected static String findSourceFileName(String string) {
        for (int i = 0; i < sourceExts.length; ++i) {
            String string2 = string + '.' + sourceExts[i];
            File file = new File(string2);
            if (!file.exists()) continue;
            return string2;
        }
        return "";
    }

    protected static boolean isHeaderExt(String string) {
        for (int i = 0; i < headerExts.length; ++i) {
            if (string.compareToIgnoreCase(headerExts[i]) != 0) continue;
            return true;
        }
        return false;
    }

    protected static boolean isSourcesExt(String string) {
        for (int i = 0; i < sourceExts.length; ++i) {
            if (string.compareToIgnoreCase(sourceExts[i]) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean openSource(CsmObject csmObject) {
        if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            return CsmUtilities.openAtElement((CsmOffsetable)csmObject, false);
        }
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            CsmFile csmFile = (CsmFile)csmObject;
            FileTarget fileTarget = new FileTarget(csmFile);
            return CsmUtilities.openAtElement(fileTarget, false);
        }
        return false;
    }

    private static boolean openAtElement(final CsmOffsetable csmOffsetable, final boolean bl) {
        final DataObject dataObject = CsmUtilities.getDataObject(csmOffsetable.getContainingFile());
        if (dataObject != null) {
            final EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
            if (observable != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        NbEditorUtilities.addJumpListEntry((DataObject)dataObject);
                        JEditorPane[] jEditorPaneArray = observable.getOpenedPanes();
                        boolean bl2 = true;
                        if (jEditorPaneArray != null && jEditorPaneArray.length >= 0) {
                            bl2 = true;
                        } else {
                            bl2 = false;
                            observable.open();
                            jEditorPaneArray = observable.getOpenedPanes();
                        }
                        if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                            CsmUtilities.selectElementInPane(jEditorPaneArray[0], csmOffsetable, !bl2, bl);
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private static void selectElementInPane(final JEditorPane jEditorPane, final CsmOffsetable csmOffsetable, boolean bl, final boolean bl2) {
        if (bl) {
            jEditorPane.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            CsmUtilities.jumpToElement(jEditorPane, csmOffsetable, bl2);
                        }
                    });
                    jEditorPane.removeFocusListener(this);
                }
            });
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CsmUtilities.jumpToElement(jEditorPane, csmOffsetable, bl2);
                }
            });
            Container container = jEditorPane;
            while (!(container instanceof TopComponent)) {
                container = container.getParent();
            }
            ((TopComponent)container).requestActive();
        }
    }

    private static void jumpToElement(JEditorPane jEditorPane, CsmOffsetable csmOffsetable, boolean bl) {
        int n;
        int n2 = n = bl ? CsmUtilities.lineToPosition(jEditorPane, csmOffsetable.getStartPosition().getLine() - 1) : csmOffsetable.getStartOffset();
        if (jEditorPane.getDocument() != null && n >= 0 && n < jEditorPane.getDocument().getLength()) {
            jEditorPane.setCaretPosition(n);
            if (DEBUG) {
                System.err.println("I'm going to " + n + " for element" + CsmUtilities.getElementJumpName((CsmObject)csmOffsetable));
            }
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    private static int lineToPosition(JEditorPane jEditorPane, int n) {
        Document document = jEditorPane.getDocument();
        int n2 = 0;
        if (document instanceof BaseDocument) {
            n2 = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)document), (int)n);
        } else {
            int n3 = document.getLength();
            try {
                String string = document.getText(0, n3);
                boolean bl = false;
                for (int i = 0; i < n3; ++i) {
                    char c = string.charAt(i);
                    if (c == '\n') {
                        if (--n == 0) {
                            return n2;
                        }
                        bl = true;
                        continue;
                    }
                    if (!bl) continue;
                    n2 = i;
                    bl = false;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static String getElementJumpName(CsmObject csmObject) {
        String string = "";
        if (csmObject != null) {
            if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
                string = ((Object)((CsmNamedElement)csmObject).getName()).toString();
            } else if (CsmKindUtilities.isStatement((CsmObject)csmObject)) {
                string = ((Object)((CsmStatement)csmObject).getText()).toString();
            } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
                string = ((Object)((CsmOffsetable)csmObject).getText()).toString();
            }
            if (string.length() > 0) {
                string = "\"" + string + "\"";
            }
        }
        return string;
    }

    public static <T> Collection<T> merge(Collection<T> arrayList, Collection<T> collection) {
        ArrayList<T> arrayList2 = arrayList = arrayList != null ? arrayList : new ArrayList<T>();
        if (collection != null && collection.size() > 0) {
            arrayList.addAll(collection);
        }
        return arrayList;
    }

    public static <T> boolean removeAll(Collection<T> collection, Collection<T> collection2) {
        if (collection != null && collection2 != null) {
            return collection.removeAll(collection2);
        }
        return false;
    }

    public static String getCsmName(CsmObject csmObject) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (CsmKindUtilities.isNamedElement((CsmObject)csmObject)) {
            object = (CsmNamedElement)csmObject;
            stringBuilder.append(" [name] ").append(object.getName());
        } else {
            object = csmObject.getClass().getName();
            object = ((String)object).substring(((String)object).lastIndexOf(".") + 1);
            stringBuilder.append(" [class] ").append((String)object);
        }
        if (CsmKindUtilities.isDeclaration((CsmObject)csmObject)) {
            object = (CsmDeclaration)csmObject;
            stringBuilder.append(" [kind] ").append(object.getKind());
        }
        return stringBuilder.toString();
    }

    public static String getSignature(CsmFunction csmFunction) {
        return CsmUtilities.getSignature(csmFunction, true);
    }

    public static String getSignature(CsmFunction csmFunction, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(csmFunction.isTemplate() ? ((CsmTemplate)csmFunction).getDisplayName() : csmFunction.getName());
        stringBuilder.append('(');
        boolean bl2 = false;
        for (CsmParameter csmParameter : csmFunction.getParameters()) {
            if (bl2) {
                stringBuilder.append(", ");
            } else {
                bl2 = true;
            }
            if (bl) {
                stringBuilder.append(csmParameter.getDisplayText());
                continue;
            }
            CsmType csmType = csmParameter.getType();
            if (csmType != null) {
                stringBuilder.append(csmType.getText());
                continue;
            }
            if (!csmParameter.isVarArgs()) continue;
            stringBuilder.append("...");
        }
        stringBuilder.append(')');
        if (CsmKindUtilities.isMethodDeclaration((CsmObject)csmFunction) && ((CsmMethod)csmFunction).isConst()) {
            stringBuilder.append(" const");
        }
        return stringBuilder.toString();
    }

    private static final class FileTarget
    implements CsmOffsetable {
        private CsmFile file;

        public FileTarget(CsmFile csmFile) {
            this.file = csmFile;
        }

        public CsmFile getContainingFile() {
            return this.file;
        }

        public int getStartOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public int getEndOffset() {
            return DUMMY_POSITION.getOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return DUMMY_POSITION;
        }

        public CsmOffsetable.Position getEndPosition() {
            return DUMMY_POSITION;
        }

        public String getText() {
            return "";
        }
    }
}

