/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.editor.ext.html.parser.AstPath;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.html.editor.gsf.HtmlParserResult;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlStructureScanner
implements StructureScanner {
    private static final Logger LOGGER = Logger.getLogger(HtmlStructureScanner.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private HtmlFormatter formatter;

    public List<? extends StructureItem> scan(CompilationInfo compilationInfo, HtmlFormatter htmlFormatter) {
        ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/html").iterator().next();
        TranslatedSource translatedSource = parserResult.getTranslatedSource();
        AstNode astNode = ((HtmlParserResult)parserResult).root();
        if (LOG) {
            LOGGER.log(Level.FINE, "HTML parser tree output:");
            LOGGER.log(Level.FINE, astNode.toString());
        }
        ArrayList<? extends StructureItem> arrayList = new ArrayList<StructureItem>(1);
        arrayList.addAll(new HtmlStructureItem(new HtmlElementHandle(astNode, compilationInfo), translatedSource).getNestedItems());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<OffsetRange>> folds(CompilationInfo compilationInfo) {
        try {
            ParserResult parserResult = (ParserResult)compilationInfo.getEmbeddedResults("text/html").iterator().next();
            final TranslatedSource translatedSource = parserResult.getTranslatedSource();
            final BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            AstNode astNode = ((HtmlParserResult)parserResult).root();
            HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
            final ArrayList arrayList = new ArrayList();
            AstNodeVisitor astNodeVisitor = new AstNodeVisitor(){

                public void visit(AstNode astNode) {
                    if (astNode.type() == AstNode.NodeType.TAG || astNode.type() == AstNode.NodeType.COMMENT) {
                        try {
                            int n = HtmlStructureScanner.documentPosition(astNode.startOffset(), translatedSource);
                            int n2 = HtmlStructureScanner.documentPosition(astNode.endOffset(), translatedSource);
                            if (Utilities.getLineOffset((BaseDocument)baseDocument, (int)n) < Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2)) {
                                arrayList.add(new OffsetRange(n, n2));
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.log(Level.INFO, null, badLocationException);
                        }
                    }
                }
            };
            baseDocument.readLock();
            try {
                AstNodeUtils.visitChildren((AstNode)astNode, (AstNodeVisitor)astNodeVisitor);
            }
            finally {
                baseDocument.readUnlock();
            }
            hashMap.put("codeblocks", arrayList);
            return hashMap;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public static int documentPosition(int n, TranslatedSource translatedSource) {
        return translatedSource == null ? n : translatedSource.getLexicalOffset(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HtmlStructureItem
    implements StructureItem {
        private TranslatedSource source;
        private HtmlElementHandle handle;
        private int myIndexInParent = -1;
        private List<StructureItem> items = null;

        private HtmlStructureItem(HtmlElementHandle htmlElementHandle, TranslatedSource translatedSource) {
            this.handle = htmlElementHandle;
            this.source = translatedSource;
        }

        public String getName() {
            return this.handle.getName();
        }

        public String getSortText() {
            return Integer.toHexString(10000 + (int)this.getPosition());
        }

        public String getHtml() {
            return this.getName();
        }

        public ElementHandle getElementHandle() {
            return this.handle;
        }

        synchronized int indexInParent() {
            if (this.myIndexInParent == -1) {
                AstNode astNode = this.handle.node().parent();
                this.myIndexInParent = astNode == null ? -2 : AstPath.indexInSimilarNodes((AstNode)astNode, (AstNode)this.handle.node());
            }
            return this.myIndexInParent;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HtmlStructureItem)) {
                return false;
            }
            HtmlStructureItem htmlStructureItem = (HtmlStructureItem)object;
            AstNode astNode = ((HtmlStructureItem)object).handle.node();
            AstNode astNode2 = this.handle.node();
            if (astNode.type() == astNode2.type() && astNode.name().equals(astNode2.name())) {
                return this.indexInParent() == htmlStructureItem.indexInParent();
            }
            return false;
        }

        public int hashCode() {
            return this.handle.node().name().hashCode() + this.indexInParent();
        }

        public ElementKind getKind() {
            return ElementKind.TAG;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return false;
        }

        public synchronized List<? extends StructureItem> getNestedItems() {
            if (this.items == null) {
                this.items = new ArrayList<StructureItem>(this.handle.node().children().size());
                for (AstNode astNode : this.handle.node().children()) {
                    if (astNode.type() != AstNode.NodeType.TAG && astNode.type() != AstNode.NodeType.UNMATCHED_TAG) continue;
                    HtmlElementHandle htmlElementHandle = new HtmlElementHandle(astNode, this.handle.compilationInfo());
                    this.items.add(new HtmlStructureItem(htmlElementHandle, this.source));
                }
            }
            return this.items;
        }

        public long getPosition() {
            return HtmlStructureScanner.documentPosition(this.handle.node().startOffset(), this.source);
        }

        public long getEndPosition() {
            return HtmlStructureScanner.documentPosition(this.handle.node().endOffset(), this.source);
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }
}

