/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.coloring;

import java.awt.Color;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;

public class EmbeddingHighlightsContainer
extends AbstractHighlightsContainer {
    private static final Logger LOG = Logger.getLogger(EmbeddingHighlightsContainer.class.getName());
    private static final String CSS_BACKGROUND_TOKEN_NAME = "css-embedded";
    private static final String JAVASCRIPT_BACKGROUND_TOKEN_NAME = "javascript-embedded";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String CSS_MIME_TYPE = "text/x-css";
    private static final String CSS_INLINED_MIME_TYPE = "text/x-css-inlined";
    private static final String JAVASCRIPT_MIME_TYPE = "text/javascript";
    private final AttributeSet cssBackground;
    private final AttributeSet javascriptBackground;
    private final Document document;

    EmbeddingHighlightsContainer(Document document) {
        this.document = document;
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)HTML_MIME_TYPE).lookup(FontColorSettings.class);
        Color color = null;
        Color color2 = null;
        if (fontColorSettings != null) {
            color = EmbeddingHighlightsContainer.getColoring(fontColorSettings, CSS_BACKGROUND_TOKEN_NAME);
            color2 = EmbeddingHighlightsContainer.getColoring(fontColorSettings, JAVASCRIPT_BACKGROUND_TOKEN_NAME);
        }
        this.cssBackground = color == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color, ATTR_EXTENDS_EOL, Boolean.TRUE});
        this.javascriptBackground = color2 == null ? SimpleAttributeSet.EMPTY : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color2, ATTR_EXTENDS_EOL, Boolean.TRUE});
    }

    private static Color getColoring(FontColorSettings fontColorSettings, String string) {
        AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string);
        if (attributeSet != null) {
            return (Color)attributeSet.getAttribute(StyleConstants.Background);
        }
        return null;
    }

    public HighlightsSequence getHighlights(int n, int n2) {
        return new Highlights(this.document, n, n2);
    }

    private class Highlights
    implements HighlightsSequence {
        private Document document;
        private int startOffsetBoundary;
        private int endOffsetBoundary;
        private int startOffset;
        private int endOffset;
        private int realEndOffset;
        private AttributeSet attributeSet;
        private List<TokenSequence<?>> tokenSequenceList;
        private String mimeType;

        private Highlights(Document document, int n, int n2) {
            this.document = document;
            this.mimeType = (String)document.getProperty("mimeType");
            this.startOffsetBoundary = n;
            this.endOffsetBoundary = n2;
            this.startOffset = this.startOffsetBoundary;
            this.endOffset = this.startOffsetBoundary;
            this.realEndOffset = this.startOffsetBoundary;
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            Language language = Language.find((String)this.mimeType);
            if (language == null) {
                LOG.log(Level.WARNING, "Language " + this.mimeType + " obtained from the document mimeType property cannot be found!");
                return;
            }
            LanguagePath languagePath = LanguagePath.get((Language)language);
            if (this.mimeType.equals(EmbeddingHighlightsContainer.HTML_MIME_TYPE)) {
                this.tokenSequenceList = tokenHierarchy.tokenSequenceList(languagePath, n, n2);
            } else {
                LanguagePath languagePath2 = LanguagePath.get((LanguagePath)languagePath, (Language)HTMLTokenId.language());
                this.tokenSequenceList = tokenHierarchy.tokenSequenceList(languagePath2, n, n2);
            }
        }

        public boolean moveNext() {
            for (TokenSequence<?> tokenSequence : this.tokenSequenceList) {
                assert (tokenSequence.language().mimeType().equals(EmbeddingHighlightsContainer.HTML_MIME_TYPE));
                tokenSequence.move(this.realEndOffset);
                while (tokenSequence.moveNext() && tokenSequence.offset() < this.endOffsetBoundary) {
                    String string;
                    TokenSequence tokenSequence2 = tokenSequence.embedded();
                    if (tokenSequence2 == null || !tokenSequence2.moveNext() || !EmbeddingHighlightsContainer.CSS_MIME_TYPE.equals(string = tokenSequence2.language().mimeType()) && !EmbeddingHighlightsContainer.CSS_INLINED_MIME_TYPE.equals(string) && !EmbeddingHighlightsContainer.JAVASCRIPT_MIME_TYPE.equals(string)) continue;
                    try {
                        int n;
                        this.endOffset = this.startOffset = tokenSequence2.offset();
                        while (tokenSequence2.moveNext()) {
                            this.endOffset = tokenSequence2.offset() + tokenSequence2.token().length();
                        }
                        this.realEndOffset = this.endOffset > this.realEndOffset ? this.endOffset : this.realEndOffset + 1;
                        int n2 = Utilities.getLineOffset((BaseDocument)((BaseDocument)this.document), (int)this.startOffset);
                        if (n2 != (n = Utilities.getLineOffset((BaseDocument)((BaseDocument)this.document), (int)this.endOffset))) {
                            if (Utilities.getFirstNonWhiteBwd((BaseDocument)((BaseDocument)this.document), (int)Utilities.getRowEnd((BaseDocument)((BaseDocument)this.document), (int)this.startOffset)) + 1 == this.startOffset) {
                                this.startOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.document), (int)(n2 + 1));
                            }
                            if (Utilities.getFirstNonWhiteFwd((BaseDocument)((BaseDocument)this.document), (int)Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.document), (int)n)) == this.endOffset) {
                                this.endOffset = Utilities.getRowStartFromLineOffset((BaseDocument)((BaseDocument)this.document), (int)n);
                            }
                        }
                        this.attributeSet = string.equals(EmbeddingHighlightsContainer.JAVASCRIPT_MIME_TYPE) ? EmbeddingHighlightsContainer.this.javascriptBackground : EmbeddingHighlightsContainer.this.cssBackground;
                        return true;
                    }
                    catch (BadLocationException badLocationException) {
                        LOG.log(Level.INFO, "An error occured when creating coloured background for CSS and JavaScript.", badLocationException);
                    }
                }
            }
            return false;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public AttributeSet getAttributes() {
            return this.attributeSet;
        }
    }
}

