/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.html;

import java.util.Collection;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.modules.editor.html.NbReaderProvider;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class HTMLCompletionProvider
implements CompletionProvider {
    public HTMLCompletionProvider() {
        NbReaderProvider.setupReaders();
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        int n = HTMLSyntaxSupport.get((Document)jTextComponent.getDocument()).checkCompletion(jTextComponent, string, false);
        return n == 0 ? 3 : 0;
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        AsyncCompletionTask asyncCompletionTask = null;
        if ((n & 1 & 9) != 0) {
            asyncCompletionTask = new AsyncCompletionTask((AsyncCompletionQuery)new Query(), jTextComponent);
        } else if (n == 2) {
            asyncCompletionTask = new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), jTextComponent);
        }
        return asyncCompletionTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkHideCompletion(BaseDocument baseDocument, int n) {
        baseDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            tokenSequence.move(n == 0 ? 0 : n - 1);
            if (!tokenSequence.moveNext()) {
                return;
            }
            Token token = tokenSequence.token();
            if (token.id() == HTMLTokenId.TEXT && !((Object)token.text()).toString().startsWith("<") && !((Object)token.text()).toString().startsWith("&")) {
                HTMLCompletionProvider.hideCompletion();
            }
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
        Completion.get().hideDocumentation();
    }

    private static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        private AbstractQuery() {
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getCaretPosition();
            Document document = jTextComponent.getDocument();
            HTMLCompletionProvider.checkHideCompletion((BaseDocument)document, n);
        }

        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            this.doQuery(completionResultSet, document, n);
            completionResultSet.finish();
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    static class DocQuery
    extends AbstractQuery {
        private JTextComponent component;
        private CompletionItem item;

        DocQuery(HTMLCompletionQuery.HTMLResultItem hTMLResultItem) {
            this.item = hTMLResultItem;
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void doQuery(CompletionResultSet completionResultSet, Document document, int n) {
            HTMLCompletionQuery.HTMLResultItem hTMLResultItem;
            List list = null;
            if (this.item == null && (list = HTMLCompletionQuery.getDefault().query(this.component, n)) != null && list.size() > 0) {
                this.item = (CompletionItem)list.get(0);
            }
            if ((hTMLResultItem = (HTMLCompletionQuery.HTMLResultItem)this.item) != null && hTMLResultItem.getHelpID() != null) {
                completionResultSet.setDocumentation((CompletionDocumentation)new HTMLCompletionQuery.DocItem(hTMLResultItem));
            }
        }
    }

    static class Query
    extends AbstractQuery {
        private JTextComponent component;

        Query() {
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        protected void doQuery(CompletionResultSet completionResultSet, Document document, int n) {
            List list = HTMLCompletionQuery.getDefault().query(this.component, n);
            if (list == null) {
                return;
            }
            completionResultSet.addAllItems((Collection)list);
        }
    }
}

