/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.AddressRangeSet;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfArangesSection
extends ElfSection {
    ArrayList<AddressRangeSet> addressRangeSets = new ArrayList();

    public DwarfArangesSection(DwarfReader dwarfReader, int n) {
        super(dwarfReader, n);
    }

    void addAddressRangeSet(AddressRangeSet addressRangeSet) {
        this.addressRangeSets.add(addressRangeSet);
    }

    public ArrayList<AddressRangeSet> getAddressRangeSets() {
        if (this.addressRangeSets.size() == 0) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.addressRangeSets;
    }

    @Override
    public DwarfArangesSection read() throws IOException {
        long l = this.header.getSectionOffset();
        long l2 = this.header.getSectionSize() + l;
        this.reader.seek(l);
        while (this.reader.getFilePointer() != l2) {
            long l3;
            long l4;
            int n;
            AddressRangeSet addressRangeSet = new AddressRangeSet();
            addressRangeSet.length = this.reader.readInt();
            addressRangeSet.version = this.reader.readShort();
            addressRangeSet.info_offset = this.reader.readInt();
            addressRangeSet.address_size = (byte)(0xFF & this.reader.readByte());
            addressRangeSet.segment_descriptor_size = (byte)(0xFF & this.reader.readByte());
            int n2 = 12;
            for (n = addressRangeSet.address_size * 2; n < n2; n <<= 1) {
            }
            this.reader.skipBytes(n - n2);
            do {
                l4 = this.reader.readNumber(addressRangeSet.address_size);
                l3 = this.reader.readNumber(addressRangeSet.address_size);
                addressRangeSet.addRange(l4, l3);
            } while (l4 != 0L || l3 != 0L);
            this.addAddressRangeSet(addressRangeSet);
        }
        return this;
    }

    @Override
    public void dump(PrintStream printStream) {
        super.dump(printStream);
        for (AddressRangeSet addressRangeSet : this.getAddressRangeSets()) {
            addressRangeSet.dump(printStream);
        }
        printStream.println();
    }
}

