/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.dwarf;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfAbbriviationTableEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfDeclaration;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ACCESS;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATTR;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfEntry {
    private CompilationUnit compilationUnit;
    private DwarfAbbriviationTableEntry abbriviationTableEntry;
    private ArrayList<Object> values = new ArrayList();
    private ArrayList<DwarfEntry> children = new ArrayList();
    private long refference;
    private int hierarchyLevel;
    private String qualifiedName = null;
    private String name = null;
    private DwarfEntry parent;

    public DwarfEntry(CompilationUnit compilationUnit, DwarfAbbriviationTableEntry dwarfAbbriviationTableEntry, long l, int n) {
        this.abbriviationTableEntry = dwarfAbbriviationTableEntry;
        this.compilationUnit = compilationUnit;
        this.refference = l;
        this.hierarchyLevel = n;
    }

    public TAG getKind() {
        return this.abbriviationTableEntry.getKind();
    }

    public String getName() {
        if (this.name == null) {
            Object object = this.getAttributeValue(ATTR.DW_AT_name);
            this.name = object == null ? "" : this.stripComments((String)object);
        }
        return this.name;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            DwarfEntry dwarfEntry = this.getSpecification();
            if (dwarfEntry != null) {
                return dwarfEntry.getQualifiedName();
            }
            this.qualifiedName = this.constructQualifiedName();
        }
        return this.qualifiedName;
    }

    private String constructQualifiedName() {
        if (this.parent == null) {
            return this.getName();
        }
        TAG tAG = this.parent.getKind();
        switch (tAG) {
            case DW_TAG_compile_unit: {
                return this.getName();
            }
            case DW_TAG_lexical_block: {
                return null;
            }
        }
        String string = this.getName();
        String string2 = this.parent.getQualifiedName();
        String string3 = string2 != null && string != null && !string2.equals("") && !string.equals("") ? string2 + "::" + string : null;
        return string3;
    }

    private String stripComments(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.trim();
    }

    public void setQualifiedName(String string) {
        DwarfEntry dwarfEntry;
        this.qualifiedName = string;
        DwarfEntry dwarfEntry2 = this.getAbstractOrigin();
        if (dwarfEntry2 != null) {
            dwarfEntry2.setQualifiedName(string);
        }
        if ((dwarfEntry = this.getSpecification()) != null) {
            dwarfEntry.setQualifiedName(string);
        }
    }

    public String getType() {
        return this.compilationUnit.getType(this);
    }

    public int getUintAttributeValue(ATTR aTTR) {
        Object object = this.getAttributeValue(aTTR);
        if (object == null) {
            return -1;
        }
        int n = ((Number)object).intValue();
        if (n < 0) {
            n &= 0xFF;
        }
        return n;
    }

    public Object getAttributeValue(ATTR aTTR) {
        return this.getAttributeValue(aTTR, true);
    }

    public Object getAttributeValue(ATTR aTTR, boolean bl) {
        Object object = null;
        int n = this.abbriviationTableEntry.getAttribute(aTTR);
        if (n == -1) {
            if (bl) {
                DwarfEntry dwarfEntry;
                Integer n2 = -1;
                if (this.abbriviationTableEntry.getAttribute(ATTR.DW_AT_abstract_origin) >= 0) {
                    n2 = (Integer)this.getAttributeValue(ATTR.DW_AT_abstract_origin);
                } else if (this.abbriviationTableEntry.getAttribute(ATTR.DW_AT_specification) >= 0) {
                    n2 = (Integer)this.getAttributeValue(ATTR.DW_AT_specification);
                }
                if (n2 >= 0 && (dwarfEntry = this.compilationUnit.getEntry(n2.intValue())) != null) {
                    object = dwarfEntry.getAttributeValue(aTTR);
                }
            }
        } else {
            object = this.values.get(n);
        }
        return object;
    }

    public void addValue(Object object) {
        this.values.add(object);
    }

    public ArrayList<DwarfEntry> getChildren() {
        return this.children;
    }

    public DwarfEntry getDefinition() {
        return this.compilationUnit.getDefinition(this);
    }

    public DwarfEntry getSpecification() {
        Object object = this.getAttributeValue(ATTR.DW_AT_specification);
        if (object instanceof Integer) {
            return this.compilationUnit.getEntry(((Integer)object).intValue());
        }
        return null;
    }

    public DwarfEntry getAbstractOrigin() {
        Object object = this.getAttributeValue(ATTR.DW_AT_abstract_origin);
        if (object instanceof Integer) {
            return this.compilationUnit.getEntry(((Integer)object).intValue());
        }
        return null;
    }

    public boolean hasChildren() {
        return this.abbriviationTableEntry.hasChildren();
    }

    public void addChild(DwarfEntry dwarfEntry) {
        this.children.add(dwarfEntry);
        dwarfEntry.setParent(this);
    }

    public DwarfEntry getParent() {
        return this.parent;
    }

    private void setParent(DwarfEntry dwarfEntry) {
        this.parent = dwarfEntry;
    }

    public long getRefference() {
        return this.refference;
    }

    public String getParametersString() {
        return this.getParametersString(true);
    }

    public String getParametersString(boolean bl) {
        ArrayList<DwarfEntry> arrayList = this.getParameters();
        StringBuilder stringBuilder = new StringBuilder();
        DwarfEntry dwarfEntry = null;
        stringBuilder.append('(');
        Iterator<DwarfEntry> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            dwarfEntry = iterator.next();
            if (dwarfEntry.getKind().equals((Object)TAG.DW_TAG_unspecified_parameters)) {
                stringBuilder.append("...");
            } else {
                stringBuilder.append(dwarfEntry.getType());
                if (bl) {
                    stringBuilder.append(" ");
                    stringBuilder.append(dwarfEntry.getName());
                }
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public DwarfDeclaration getDeclaration() {
        TAG tAG = this.getKind();
        String string = this.getQualifiedName();
        String string2 = this.getType();
        String string3 = "";
        if (tAG.equals((Object)TAG.DW_TAG_subprogram)) {
            string3 = string3 + this.getParametersString();
        }
        String string4 = string2 + " " + (string == null ? this.getName() : string) + string3;
        int n = this.getLine();
        int n2 = this.getColumn();
        String string5 = (n == -1 ? "" : Integer.valueOf(n)) + (n2 == -1 ? "" : ":" + n2);
        string5 = string5 + " <" + this.refference + " (0x" + Long.toHexString(this.refference) + ")>";
        return new DwarfDeclaration(tAG.toString(), string4, this.getDeclarationFilePath(), string5);
    }

    public int getLine() {
        return this.getUintAttributeValue(ATTR.DW_AT_decl_line);
    }

    public int getColumn() {
        return this.getUintAttributeValue(ATTR.DW_AT_decl_column);
    }

    public ArrayList<DwarfEntry> getParameters() {
        ArrayList<DwarfEntry> arrayList = new ArrayList<DwarfEntry>();
        ArrayList<DwarfEntry> arrayList2 = this.getChildren();
        for (DwarfEntry dwarfEntry : arrayList2) {
            if (!dwarfEntry.isParameter() || dwarfEntry.isArtifitial()) continue;
            arrayList.add(dwarfEntry);
        }
        return arrayList;
    }

    public ArrayList<DwarfEntry> getMembers() {
        ArrayList<DwarfEntry> arrayList = new ArrayList<DwarfEntry>();
        ArrayList<DwarfEntry> arrayList2 = this.getChildren();
        for (DwarfEntry dwarfEntry : arrayList2) {
            if (!dwarfEntry.isMember() || dwarfEntry.isArtifitial()) continue;
            arrayList.add(dwarfEntry);
        }
        return arrayList;
    }

    public String toString() {
        return this.getDeclaration().toString();
    }

    public TAG getTag() {
        return this.abbriviationTableEntry.getKind();
    }

    public void dump(PrintStream printStream) {
        printStream.print("<" + this.hierarchyLevel + "><" + Long.toHexString(this.refference) + ">: ");
        this.abbriviationTableEntry.dump(printStream, this);
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).dump(printStream);
        }
    }

    public boolean isArtifitial() {
        Object object = this.getAttributeValue(ATTR.DW_AT_artificial);
        return object != null && (Boolean)object != false;
    }

    public boolean hasAbastractOrigin() {
        Object object = this.getAttributeValue(ATTR.DW_AT_abstract_origin);
        return object != null;
    }

    public boolean isExternal() {
        Object object = this.getAttributeValue(ATTR.DW_AT_external);
        return object != null && (Boolean)object != false;
    }

    public boolean isNamespace() {
        return this.getKind().equals((Object)TAG.DW_TAG_namespace);
    }

    public ACCESS getAccessibility() {
        Object object = this.getAttributeValue(ATTR.DW_AT_accessibility);
        return object == null ? null : ACCESS.get(((Number)object).intValue());
    }

    public boolean isParameter() {
        TAG tAG = this.getKind();
        return tAG.equals((Object)TAG.DW_TAG_formal_parameter) || tAG.equals((Object)TAG.DW_TAG_unspecified_parameters);
    }

    public boolean isMember() {
        TAG tAG = this.getKind();
        return !tAG.equals((Object)TAG.DW_TAG_inheritance);
    }

    public boolean isEntryDefinedInFile(int n) {
        int n2 = this.getUintAttributeValue(ATTR.DW_AT_decl_file);
        return n2 == n;
    }

    public String getDeclarationFilePath() {
        int n = this.getUintAttributeValue(ATTR.DW_AT_decl_file);
        return n <= 0 ? null : this.compilationUnit.getStatementList().getFilePath(n);
    }

    public String getTypeDef() {
        if (this.getKind().equals((Object)TAG.DW_TAG_typedef)) {
            return this.getType();
        }
        Integer n = (Integer)this.getAttributeValue(ATTR.DW_AT_type);
        DwarfEntry dwarfEntry = this.compilationUnit.getTypedefFor(n);
        return dwarfEntry == null ? this.getType() : dwarfEntry.getType();
    }

    ArrayList<Object> getValues() {
        return this.values;
    }
}

