/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbEncoder;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbUtils {
    protected static double extractGdbVersion(String string) {
        double d;
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 != (n = string.indexOf(46))) {
            string = string.substring(0, n2);
        }
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        return d;
    }

    public static boolean isSimpleType(Object object) {
        if (object == null || object instanceof Map) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(object.toString().replaceAll("[\\[\\]()<>,:*]", " "));
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (GdbUtils.isSimpleTypeKeyword(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSimplePointer(String string) {
        return string != null && GdbUtils.isSimpleType(string.replaceFirst("[*]", " "));
    }

    private static boolean isSimpleTypeKeyword(String string) {
        return string != null && string.equals("char") || string.equals("void") || string.equals("short") || string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("const") || string.equals("volatile") || string.equals("unsigned") || string.equals("signed");
    }

    public static boolean isClass(Object object) {
        return object instanceof Map || object instanceof String && object.toString().startsWith("class ");
    }

    public static boolean isArray(Object object) {
        return object instanceof String && object.toString().endsWith("]");
    }

    public static boolean isPointer(Object object) {
        return object instanceof String && (object.toString().endsWith("*") || object.toString().endsWith("* const"));
    }

    public static boolean isSinglePointer(Object object) {
        return GdbUtils.isPointer(object) && !GdbUtils.isMultiPointer(object);
    }

    public static boolean isMultiPointer(Object object) {
        return object instanceof String && (object.toString().endsWith("**") || object.toString().endsWith("** const"));
    }

    public static boolean isFunctionPointer(Object object) {
        return object instanceof String && object.toString().contains("(*)(");
    }

    public static String getBaseType(String string) {
        if (string != null) {
            string = string.replace("const ", "");
            string = string.replace("volatile ", "");
            string = string.replace("static ", "");
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (Character.isLetter(c) || Character.isDigit(c) || GdbUtils.isOneOf(c, " _:<>,")) continue;
                return string.substring(0, i).trim();
            }
            return string.trim();
        }
        return null;
    }

    public static boolean containesOneOf(String string, String string2) {
        for (int i = 0; i < string.length(); ++i) {
            if (!GdbUtils.isOneOf(string.charAt(i), string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneOf(char c, String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (c != string.charAt(i)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> createMapFromString(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c;
            int n4 = n2++;
            while (string.charAt(n2++) != '=') {
            }
            String string2 = string.substring(n4, n2 - 1);
            if ((c = string.charAt(n2++)) == '{') {
                n3 = GdbUtils.findMatchingCurly(string, n2);
            } else if (c == '\"') {
                n3 = GdbUtils.findEndOfString(string, n2);
            } else {
                if (c != '[') break;
                n3 = GdbUtils.findMatchingBrace(string, n2);
            }
            String string3 = string.substring(n2, n3);
            if (Utilities.isWindows() && string3.startsWith("/cygdrive/")) {
                string3 = string3.toUpperCase().charAt(10) + ":" + string3.substring(11);
            }
            if (string2.equals("fullname") || string2.equals("file")) {
                string3 = GdbUtils.gdbToUserEncoding(string3);
            }
            hashMap.put(string2, string3);
            n2 = n3 + 2;
        }
        return hashMap;
    }

    public static String gdbToUserEncoding(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i = 0; i < cArray.length; ++i) {
            char c;
            n = cArray[i];
            char c2 = c = i + 1 < cArray.length ? cArray[i + 1] : (char)'\u0000';
            if (n == 92 && n2 != 92 && c != '\\') {
                char[] cArray2 = new char[]{cArray[++i], cArray[++i], cArray[++i]};
                n = (char)Integer.valueOf(String.valueOf(cArray2), 8).intValue();
            }
            arrayList.add((byte)n);
            n2 = cArray[i];
        }
        byte[] byArray = new byte[arrayList.size()];
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = (Byte)arrayList.get(n);
        }
        try {
            string = new String(byArray, System.getProperty("sun.jnu.encoding"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public static String utfToGdb(String string) {
        ByteBuffer byteBuffer;
        CharBuffer charBuffer;
        CharsetEncoder charsetEncoder;
        Charset charset;
        GdbEncoder gdbEncoder;
        CoderResult coderResult;
        String string2 = System.getenv("LANG") + System.getenv("LC_ALL");
        if (string2 != null && (string2.contains("UTF-8") || string2.contains("UTF8")) && !(coderResult = (gdbEncoder = new GdbEncoder(charset = Charset.forName("UTF-8"), charsetEncoder = charset.newEncoder())).encode(charBuffer = CharBuffer.wrap(string.toCharArray()), byteBuffer = ByteBuffer.allocate(string.length() << 3), true)).isError()) {
            string = new String(byteBuffer.array()).substring(0, byteBuffer.position());
        }
        return string;
    }

    public static boolean isMultiByte(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < string.length(); ++i) {
            if (cArray[i] <= '\u0080') continue;
            return true;
        }
        return false;
    }

    public static List<String> createListFromString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2;
            char c;
            int n3 = i++;
            while (string.charAt(i++) != '=') {
            }
            String string2 = string.substring(n3, i - 1);
            if ((c = string.charAt(i++)) == '{') {
                n2 = GdbUtils.findMatchingCurly(string, i);
            } else if (c == '\"') {
                n2 = GdbUtils.findEndOfString(string, i);
            } else {
                throw new IllegalStateException(NbBundle.getMessage(GdbUtils.class, (String)"ERR_UnexpectedGDBReasonMessage"));
            }
            String string3 = string.substring(i, n2);
            if (Utilities.isWindows() && string3.startsWith("/cygdrive/")) {
                string3 = string3.charAt(10) + ":" + string3.substring(11);
            }
            if (string2.equals("fullname") || string2.equals("file")) {
                string3 = GdbUtils.gdbToUserEncoding(string3);
            }
            arrayList.add(string2 + "=" + string3);
            i = n2 + 1;
        }
        return arrayList;
    }

    public static List<GdbVariable> createLocalsList(String string) {
        ArrayList<GdbVariable> arrayList = new ArrayList<GdbVariable>();
        int n = 0;
        int n2 = 0;
        while ((n2 = GdbUtils.findMatchingCurly(string, n)) != -1 && n2 < string.length()) {
            String string2 = string.substring(n, n2 + 1);
            int n3 = GdbUtils.findNextComma(string2, 0, 1);
            if (n3 != -1) {
                String string3 = string2.substring(7, n3 - 1);
                String string4 = string2.substring(n3 + 8, string2.length() - 2);
                arrayList.add(new GdbVariable(string3, null, string4));
            }
            n = string.indexOf(123, n2);
        }
        return arrayList;
    }

    public static List<GdbVariable> createArgumentList(String string) {
        String string2;
        ArrayList<GdbVariable> arrayList = new ArrayList<GdbVariable>();
        int n = 0;
        for (int i = string.length(); i > 0; i -= string2.length() + 1) {
            int n2;
            string2 = string.substring(n, GdbUtils.findMatchingCurly(string, n) + 1);
            n += string2.length() + 1;
            if (!string2.startsWith("{name=\"") || !string2.endsWith("\"}") || (n2 = string2.indexOf("\",value=\"")) <= 0) continue;
            String string3 = string2.substring(7, n2);
            String string4 = string2.substring(n2 + 9, string2.length() - 2);
            arrayList.add(new GdbVariable(string3, null, string4));
        }
        return arrayList;
    }

    public static String mackHack(String string) {
        if (string != null && string.indexOf("\\n") != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            int n3 = string.indexOf("&) @0x");
            int n4 = string.indexOf(123);
            int n5 = string.indexOf(58);
            if (string.charAt(0) == '(' && n3 != -1 && n4 != -1 && n5 != -1 && n5 < n4) {
                n = n4;
            }
            while (n < string.length()) {
                char c = string.charAt(n);
                if (bl) {
                    if (c == '\"' && n2 != 92) {
                        bl = false;
                    }
                } else if (bl2) {
                    if (c == '\'' && n2 != 92) {
                        bl2 = false;
                    }
                } else if (c == '\"' && n2 != 92) {
                    bl = !bl;
                } else if (c == '\'') {
                    bl2 = true;
                } else if (c == 'n' && n2 == 92) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    c = '\u0000';
                } else if (string.substring(n).startsWith("members of ")) {
                    n3 = string.indexOf(58, n);
                    n4 = string.indexOf(32, n + 11);
                    if (n3 != -1 && n4 != -1 && n3 < n4) {
                        n = n3 + 1;
                        c = '\u0000';
                    }
                }
                if (c != '\u0000') {
                    stringBuilder.append(c);
                }
                n2 = c;
                ++n;
            }
            return stringBuilder.toString();
        }
        return string;
    }

    private static int findEndOfString(String string, int n) {
        int n2 = 0;
        int n3 = string.length();
        while (n3-- > 0) {
            char c = string.charAt(n);
            if (c == '\"' && n2 != 92) {
                return n;
            }
            ++n;
            n2 = c;
        }
        throw new IllegalStateException(NbBundle.getMessage(GdbUtils.class, (String)"ERR_UnexpectedGDBStopMessage"));
    }

    public static int findMatchingBrace(String string, int n) {
        return GdbUtils.findMatchingPair("[]", string, n);
    }

    public static int findMatchingCurly(String string, int n) {
        return GdbUtils.findMatchingPair("{}", string, n);
    }

    public static int findMatchingParen(String string, int n) {
        return GdbUtils.findMatchingPair("()", string, n);
    }

    public static int findMatchingLtGt(String string, int n) {
        return GdbUtils.findMatchingPair("<>", string, n);
    }

    private static int findMatchingPair(String string, String string2, int n) {
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        int n2 = 32;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (string2 == null || string2.length() == 0 || n < 0) {
            return -1;
        }
        if (string2.charAt(n) == c) {
            ++n;
        }
        while (n < string2.length()) {
            char c3 = string2.charAt(n);
            if (bl) {
                if (c3 == '\"' && n2 != 92) {
                    bl = false;
                }
            } else if (bl2) {
                if (c3 == '\'' && n2 != 92) {
                    bl2 = false;
                }
            } else {
                if (c3 == c2 && n3 == 0) {
                    return n;
                }
                if (c3 == '\"' && n2 != 92) {
                    bl = !bl;
                } else if (c3 == '\'') {
                    bl2 = true;
                } else if (c3 == c) {
                    ++n3;
                } else if (c3 == c2) {
                    --n3;
                }
            }
            n2 = c3;
            ++n;
        }
        return -1;
    }

    public static int findNextComma(String string, int n) {
        return GdbUtils.findNextComma(string, n, 0);
    }

    public static int findNextComma(String string, int n, int n2) {
        int n3 = 32;
        boolean bl = false;
        boolean bl2 = false;
        assert (string != null && string.length() > 0);
        if (n < 0) {
            return -1;
        }
        n += n2;
        while (n < string.length()) {
            int n4;
            char c = string.charAt(n);
            if (bl) {
                if (c == '\"' && n3 != 92) {
                    bl = false;
                }
            } else if (bl2) {
                if (c == '\'' && n3 != 92) {
                    bl2 = false;
                }
            } else if (c == '{') {
                n4 = GdbUtils.findMatchingCurly(string, n);
                if (n4 == -1) break;
                n = n4;
            } else if (c == '<') {
                n4 = GdbUtils.findMatchingLtGt(string, n);
                if (n4 == -1) break;
                n = n4;
            } else if (c == '[') {
                n4 = GdbUtils.findMatchingBrace(string, n);
                if (n4 == -1) break;
                n = n4;
            } else {
                if (c == ',' && !GdbUtils.isMultiString(string, n)) {
                    return n;
                }
                if (c == '\"' && n3 != 92) {
                    bl = !bl;
                } else if (c == '\'' && n3 != 92) {
                    bl2 = true;
                }
            }
            n3 = c;
            ++n;
        }
        return -1;
    }

    private static boolean isMultiString(String string, int n) {
        int n2;
        String string2;
        return ++n < string.length() && (string2 = (n2 = string.indexOf(44, n)) == -1 ? string.substring(n) : string.substring(n, n2)).startsWith("<repeats ") && string2.contains(" times>");
    }

    public static int findNextSemi(String string, int n) {
        int n2 = 32;
        boolean bl = false;
        boolean bl2 = false;
        assert (string != null && string.length() > 0);
        if (n < 0) {
            return -1;
        }
        char c = string.charAt(n);
        if (c == ';' || c == '{') {
            ++n;
        }
        while (n < string.length()) {
            int n3;
            c = string.charAt(n);
            if (bl) {
                if (c == '\"' && n2 != 92) {
                    bl = false;
                }
            } else if (bl2) {
                if (c == '\'' && n2 != 92) {
                    bl2 = false;
                }
            } else if (c == '{') {
                n3 = GdbUtils.findMatchingCurly(string, n);
                if (n3 == -1) break;
                n = n3;
            } else if (c == '<') {
                n3 = GdbUtils.findMatchingLtGt(string, n);
                if (n3 == -1) break;
                n = n3;
            } else if (c == '[') {
                n3 = GdbUtils.findMatchingBrace(string, n);
                if (n3 == -1) break;
                n = n3;
            } else {
                if (c == ';') {
                    return n;
                }
                if (c == '\"' && n2 != 92) {
                    bl = !bl;
                } else if (c == '\'' && n2 != 92) {
                    bl2 = true;
                }
            }
            n2 = c;
            ++n;
        }
        return -1;
    }

    public static int firstNonWhite(String string, int n) {
        int n2 = string.length();
        if (n >= 0 && n < n2) {
            char c;
            while (n < n2 && ((c = string.charAt(n)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
                ++n;
            }
            if (n < n2) {
                return n;
            }
        }
        return -1;
    }

    public static String threadId() {
        Thread thread = Thread.currentThread();
        return thread.getName() + ':' + Long.toString(thread.getId());
    }
}

