/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Vector;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class CallStackNodeModel
implements NodeModel {
    public static final String CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    public static final String CURRENT_CALL_STACK = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private GdbDebugger debugger;
    private Session session;
    private Vector listeners = new Vector();

    public CallStackNodeModel(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        new Listener(this, this.debugger);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Name");
        }
        if (object instanceof CallStackFrame) {
            CallStackFrame callStackFrame = (CallStackFrame)object;
            CallStackFrame callStackFrame2 = this.debugger.getCurrentCallStackFrame();
            if (callStackFrame2 != null && callStackFrame2.equals(callStackFrame)) {
                return BoldVariablesTableModelFilterFirst.toHTML(CallStackNodeModel.getCSFName(this.session, callStackFrame, false), true, false, null);
            }
            return CallStackNodeModel.getCSFName(this.session, callStackFrame, false);
        }
        if ("No current thread" == object) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == object) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return NbBundle.getBundle(CallStackNodeModel.class).getString("CTL_CallstackModel_Column_Name_Desc");
        }
        if (object instanceof CallStackFrame) {
            CallStackFrame callStackFrame = (CallStackFrame)object;
            return CallStackNodeModel.getCSFName(this.session, callStackFrame, true);
        }
        if ("No current thread" == object) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"NoCurrentThread");
        }
        if ("Thread is running" == object) {
            return NbBundle.getMessage(CallStackNodeModel.class, (String)"ThreadIsRunning");
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof String) {
            return null;
        }
        if (object instanceof CallStackFrame) {
            CallStackFrame callStackFrame = this.debugger.getCurrentCallStackFrame();
            if (callStackFrame != null && callStackFrame.equals(object)) {
                return CURRENT_CALL_STACK;
            }
            return CALL_STACK;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    private void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged(null);
        }
    }

    public static String getCSFName(Session session, CallStackFrame callStackFrame, boolean bl) {
        String string = callStackFrame.getFunctionName();
        String string2 = string != null && !string.equals("??") ? string : (callStackFrame.getAddr() != null ? NbBundle.getMessage(CallStackNodeModel.class, (String)"CTL_CallstackModel_Msg_Format", (Object)callStackFrame.getAddr()) : "");
        int n = callStackFrame.getLineNumber();
        if (string2.length() == 0) {
            String string3;
            String string4 = string3 = bl ? callStackFrame.getFullname() : callStackFrame.getFileName();
            if (n < 0) {
                string2 = string3 == null ? "??" : string3;
            }
        } else {
            String string5 = callStackFrame.getFileName();
            if (string5 != null && n >= 0) {
                string2 = NbBundle.getMessage(CallStackNodeModel.class, (String)"FMT_StackFrame", (Object[])new Object[]{string2, string5, String.valueOf(n)});
            }
        }
        return string2.toString();
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference ref;
        private GdbDebugger debugger;

        private Listener(CallStackNodeModel callStackNodeModel, GdbDebugger gdbDebugger) {
            this.ref = new WeakReference<CallStackNodeModel>(callStackNodeModel);
            this.debugger = gdbDebugger;
            gdbDebugger.addPropertyChangeListener("currentCallStackFrame", this);
        }

        private CallStackNodeModel getModel() {
            CallStackNodeModel callStackNodeModel = (CallStackNodeModel)this.ref.get();
            if (callStackNodeModel == null) {
                this.debugger.removePropertyChangeListener("currentCallStackFrame", this);
            }
            return callStackNodeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            CallStackNodeModel callStackNodeModel = this.getModel();
            if (callStackNodeModel == null) {
                return;
            }
            callStackNodeModel.fireTreeChanged();
        }
    }
}

