/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointsReader;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;

public class FunctionBreakpointImpl
extends BreakpointImpl {
    private FunctionBreakpoint breakpoint;
    private String functionName;
    private BreakpointsReader reader;

    public FunctionBreakpointImpl(FunctionBreakpoint functionBreakpoint, BreakpointsReader breakpointsReader, GdbDebugger gdbDebugger, Session session) {
        super(functionBreakpoint, breakpointsReader, gdbDebugger, session);
        this.reader = breakpointsReader;
        this.breakpoint = functionBreakpoint;
        this.functionName = functionBreakpoint.getFunctionName();
        this.set();
    }

    protected void setRequests() {
        String string = this.getState();
        if (this.getDebugger().getState().equals("state_running")) {
            this.getDebugger().setSilentStop();
            this.setRunWhenValidated(true);
        }
        if (string.equals("BpState_Unvalidated") || string.equals("BpState_Revalidate")) {
            if (string.equals("BpState_Revalidate") && this.getBreakpointNumber() > 0) {
                this.getDebugger().getGdbProxy().break_delete(this.getBreakpointNumber());
            }
            this.setState("BpState_ValidationPending");
            this.functionName = this.breakpoint.getFunctionName();
            int n = this.getBreakpoint().getSuspend() == 1 ? this.getDebugger().getGdbProxy().break_insert(1, this.functionName, this.getBreakpoint().getThreadID()) : this.getDebugger().getGdbProxy().break_insert(this.functionName);
            this.getDebugger().addPendingBreakpoint(n, this);
        } else {
            if (string.equals("BpState_DeletionPending")) {
                this.getDebugger().getGdbProxy().break_delete(this.getBreakpointNumber());
            } else if (string.equals("BpState_Validated")) {
                if (this.breakpoint.isEnabled()) {
                    this.getDebugger().getGdbProxy().break_enable(this.getBreakpointNumber());
                } else {
                    this.getDebugger().getGdbProxy().break_disable(this.getBreakpointNumber());
                }
            }
            if (this.isRunWhenValidated()) {
                this.getDebugger().setRunning();
                this.setRunWhenValidated(false);
            }
        }
    }
}

