/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.faces.dt.std;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.RowSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.visualweb.faces.dt.std.DataModelBindingCustomizer;
import org.netbeans.modules.visualweb.faces.dt.std.ValueBindingPanel;
import org.netbeans.modules.visualweb.faces.dt.std.table.HtmlDataTableState;
import org.netbeans.modules.visualweb.faces.dt.util.ComponentBundle;

public class DataModelBindingPanel
extends JPanel {
    private static final ComponentBundle bundle = ComponentBundle.getBundle(DataModelBindingPanel.class);
    protected DesignProperty prop;
    protected ValueBindingPanel vbp;
    protected JScrollPane listScroll = new JScrollPane();
    protected JList list = new JList();
    protected JLabel listLabel = new JLabel();
    protected GridBagLayout gridbag = new GridBagLayout();
    protected JTextPane noneText = new JTextPane();
    protected JCheckBox chkGenColumns = new JCheckBox();
    private HtmlDataTableState tableState;
    protected int modelIndex = -1;
    protected boolean initializing = true;
    protected DataModelBindingCustomizer customizer;
    GridBagConstraints listScrollConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 8, 8, 8), 0, 0);

    public DataModelBindingPanel(ValueBindingPanel valueBindingPanel, DataModelBindingCustomizer dataModelBindingCustomizer, DesignProperty designProperty) {
        this.vbp = valueBindingPanel;
        this.customizer = dataModelBindingCustomizer;
        this.prop = designProperty;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        DefaultListModel<DesignBean> defaultListModel = new DefaultListModel<DesignBean>();
        if (designProperty != null) {
            this.listLabel.setText(bundle.getMessage("chooseRs", designProperty.getDesignBean().getInstanceName()));
            this.tableState = new HtmlDataTableState(designProperty.getDesignBean());
            this.tableState.varName = "currentRow";
            DesignContext designContext = designProperty.getDesignBean().getDesignContext();
            DesignContext[] designContextArray = this.getDesignContexts(designProperty.getDesignBean());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(designContext);
            ArrayList<DesignContext> arrayList2 = new ArrayList<DesignContext>();
            ArrayList<DesignContext> arrayList3 = new ArrayList<DesignContext>();
            for (int i = 0; i < designContextArray.length; ++i) {
                if (designContextArray[i] == designContext) continue;
                Iterator iterator = designContextArray[i].getContextData("scope");
                if ("session".equals(iterator)) {
                    arrayList2.add(designContextArray[i]);
                    continue;
                }
                if (!"application".equals(iterator)) continue;
                arrayList3.add(designContextArray[i]);
            }
            arrayList.addAll(arrayList2);
            arrayList.addAll(arrayList3);
            ArrayList<DesignBean> arrayList4 = new ArrayList<DesignBean>();
            for (DesignContext designContext2 : arrayList) {
                DesignBean[] designBeanArray = designContext2.getBeansOfType(RowSet.class);
                for (int i = 0; i < designBeanArray.length; ++i) {
                    arrayList4.add(designBeanArray[i]);
                }
            }
            defaultListModel.addElement(null);
            if (arrayList4.size() > 0) {
                for (int i = 0; i < arrayList4.size(); ++i) {
                    DesignBean designBean = (DesignBean)arrayList4.get(i);
                    defaultListModel.addElement(designBean);
                    if (this.modelIndex >= 0 || this.tableState.getSourceBean() != designBean) continue;
                    this.modelIndex = i + 1;
                }
            } else {
                this.remove(this.listScroll);
                this.remove(this.chkGenColumns);
                this.add((Component)this.noneText, this.listScrollConstraints);
            }
        }
        this.list.setModel(defaultListModel);
        this.repaint(100L);
        if (this.modelIndex > -1) {
            this.list.setSelectedIndex(this.modelIndex);
            this.chkGenColumns.setEnabled(true);
        } else {
            this.list.setSelectedIndex(0);
            this.chkGenColumns.setEnabled(false);
            this.tableState.setSourceBean(null);
            if (valueBindingPanel != null) {
                valueBindingPanel.setValueBinding("");
            }
        }
        this.initializing = false;
    }

    private DesignContext[] getDesignContexts(DesignBean designBean) {
        DesignProject designProject = designBean.getDesignContext().getProject();
        DesignContext[] designContextArray = designProject instanceof FacesDesignProject ? ((FacesDesignProject)designProject).findDesignContexts(new String[]{"request", "session", "application"}) : new DesignContext[]{};
        DesignContext[] designContextArray2 = new DesignContext[designContextArray.length + 1];
        designContextArray2[0] = designBean.getDesignContext();
        System.arraycopy(designContextArray, 0, designContextArray2, 1, designContextArray.length);
        return designContextArray2;
    }

    private void jbInit() throws Exception {
        this.noneText.setEditable(false);
        this.noneText.setFont(this.listLabel.getFont());
        this.noneText.setBorder(UIManager.getBorder("TextField.border"));
        this.noneText.setText(bundle.getMessage("noRss"));
        this.chkGenColumns.setText(bundle.getMessage("autoGenCols"));
        this.chkGenColumns.setSelected(true);
        this.list.setCellRenderer(new RSListRenderer());
        this.setPreferredSize(new Dimension(400, 200));
        this.setLayout(this.gridbag);
        this.listLabel.setText(bundle.getMessage("chooseRsSimple"));
        this.add((Component)this.listLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 8, 2, 8), 0, 0));
        this.add((Component)this.listScroll, this.listScrollConstraints);
        if (this.customizer != null) {
            this.add((Component)this.chkGenColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 8, 8, 8), 0, 0));
        }
        this.listScroll.setPreferredSize(new Dimension(200, 200));
        this.listScroll.getViewport().add((Component)this.list, null);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (DataModelBindingPanel.this.initializing) {
                    return;
                }
                Object e = DataModelBindingPanel.this.list.getSelectedValue();
                if (e == null || e instanceof DesignBean) {
                    DesignBean designBean = (DesignBean)e;
                    String string = DataModelBindingPanel.this.calcValueRef(designBean);
                    if (DataModelBindingPanel.this.vbp != null) {
                        DataModelBindingPanel.this.vbp.setValueBinding(string == null ? "" : string);
                    } else if (DataModelBindingPanel.this.customizer != null) {
                        DataModelBindingPanel.this.customizer.setModified(true);
                        DataModelBindingPanel.this.chkGenColumns.setEnabled(e != null);
                    } else {
                        DataModelBindingPanel.this.prop.setValueSource(string);
                    }
                }
            }
        });
    }

    public void customizerApply() {
        Object e = this.list.getSelectedValue();
        this.tableState.setSourceBean((DesignBean)e);
        if (this.chkGenColumns.isSelected()) {
            this.tableState.refreshColumnInfo();
        }
        this.tableState.saveState();
    }

    protected String calcValueRef(DesignBean designBean) {
        if (designBean == null) {
            return null;
        }
        DesignContext designContext = designBean.getDesignContext();
        if (designContext instanceof FacesDesignContext) {
            return "#{" + ((FacesDesignContext)designContext).getReferenceName() + "." + designBean.getInstanceName() + "}";
        }
        return "#{" + designContext.getDisplayName() + "." + designBean.getInstanceName() + "}";
    }

    class RSListRenderer
    extends DefaultListCellRenderer {
        RSListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof DesignBean) {
                DesignBean designBean = (DesignBean)object;
                this.setText(bundle.getMessage("rsDisplayTextPattern", designBean.getInstanceName(), designBean.getDesignContext().getDisplayName()));
            } else if (object == null) {
                this.setText(bundle.getMessage("noneBrackets"));
            }
            return this;
        }
    }
}

