/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Main;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ModeFlags;

public class ShellLauncher {
    private static String[] getCurrentEnv(Ruby runtime) {
        RubyHash hash = (RubyHash)runtime.getObject().fastGetConstant("ENV");
        String[] ret = new String[hash.size()];
        int i = 0;
        for (Map.Entry e : hash.directEntrySet()) {
            ret[i] = e.getKey().toString() + "=" + e.getValue().toString();
            ++i;
        }
        return ret;
    }

    public static int runAndWait(Ruby runtime, IRubyObject[] rawArgs) {
        return ShellLauncher.runAndWait(runtime, rawArgs, runtime.getOutputStream());
    }

    public static int execAndWait(Ruby runtime, IRubyObject[] rawArgs) {
        String[] args = ShellLauncher.parseCommandLine(runtime, rawArgs);
        if (ShellLauncher.shouldRunInProcess(runtime, args)) {
            try {
                int startIndex;
                File pwd = new File(runtime.getCurrentDirectory());
                String command = args[0];
                int n = startIndex = command.endsWith(".rb") ? 0 : 1;
                if (command.trim().endsWith("irb")) {
                    startIndex = 0;
                    args[0] = runtime.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
                }
                String[] newargs = new String[args.length - startIndex];
                System.arraycopy(args, startIndex, newargs, 0, newargs.length);
                ScriptThreadProcess ipScript = new ScriptThreadProcess(newargs, ShellLauncher.getCurrentEnv(runtime), pwd, false);
                ipScript.start();
                return ipScript.waitFor();
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
            catch (InterruptedException e) {
                throw runtime.newThreadError("unexpected interrupt");
            }
        }
        return ShellLauncher.runAndWait(runtime, rawArgs);
    }

    public static int runAndWait(Ruby runtime, IRubyObject[] rawArgs, OutputStream output) {
        PrintStream error = runtime.getErrorStream();
        InputStream input = runtime.getInputStream();
        try {
            Process aProcess = ShellLauncher.run(runtime, rawArgs);
            ShellLauncher.handleStreams(aProcess, input, output, error);
            return aProcess.waitFor();
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (InterruptedException e) {
            throw runtime.newThreadError("unexpected interrupt");
        }
    }

    public static Process run(Ruby runtime, IRubyObject string) throws IOException {
        return ShellLauncher.run(runtime, new IRubyObject[]{string});
    }

    public static Process popen(Ruby runtime, IRubyObject string, ModeFlags modes) throws IOException {
        String shell = ShellLauncher.getShell(runtime);
        Process aProcess = null;
        File pwd = new File(runtime.getCurrentDirectory());
        String[] args = ShellLauncher.parseCommandLine(runtime, new IRubyObject[]{string});
        if (ShellLauncher.shouldRunInShell(shell, args)) {
            String[] argArray = new String[3];
            String cmdline = string.toString();
            argArray[0] = shell;
            argArray[1] = shell.endsWith("sh") ? "-c" : "/c";
            argArray[2] = cmdline;
            aProcess = Runtime.getRuntime().exec(argArray, ShellLauncher.getCurrentEnv(runtime), pwd);
        } else {
            aProcess = Runtime.getRuntime().exec(args, ShellLauncher.getCurrentEnv(runtime), pwd);
        }
        aProcess = new POpenProcess(aProcess, runtime, modes);
        return aProcess;
    }

    public static Process run(Ruby runtime, IRubyObject[] rawArgs) throws IOException {
        String shell = ShellLauncher.getShell(runtime);
        Process aProcess = null;
        File pwd = new File(runtime.getCurrentDirectory());
        String[] args = ShellLauncher.parseCommandLine(runtime, rawArgs);
        if (ShellLauncher.shouldRunInProcess(runtime, args)) {
            int startIndex;
            String command = args[0];
            int n = startIndex = command.endsWith(".rb") ? 0 : 1;
            if (command.trim().endsWith("irb")) {
                startIndex = 0;
                args[0] = runtime.getJRubyHome() + File.separator + "bin" + File.separator + "jirb";
            }
            String[] newargs = new String[args.length - startIndex];
            System.arraycopy(args, startIndex, newargs, 0, newargs.length);
            ScriptThreadProcess ipScript = new ScriptThreadProcess(newargs, ShellLauncher.getCurrentEnv(runtime), pwd);
            ipScript.start();
            aProcess = ipScript;
        } else if (rawArgs.length == 1 && ShellLauncher.shouldRunInShell(shell, args)) {
            String[] argArray = new String[3];
            String cmdline = rawArgs[0].toString();
            argArray[0] = shell;
            argArray[1] = shell.endsWith("sh") ? "-c" : "/c";
            argArray[2] = cmdline;
            aProcess = Runtime.getRuntime().exec(argArray, ShellLauncher.getCurrentEnv(runtime), pwd);
        } else {
            aProcess = Runtime.getRuntime().exec(args, ShellLauncher.getCurrentEnv(runtime), pwd);
        }
        return aProcess;
    }

    private static void handleStreams(Process p, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InputStream pOut = p.getInputStream();
        InputStream pErr = p.getErrorStream();
        OutputStream pIn = p.getOutputStream();
        StreamPumper t1 = new StreamPumper(pOut, out, false);
        StreamPumper t2 = new StreamPumper(pErr, err, false);
        StreamPumper t3 = new StreamPumper(in, pIn, true);
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        try {
            t2.join();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        t3.quit();
        try {
            err.flush();
        }
        catch (IOException io) {
            // empty catch block
        }
        try {
            out.flush();
        }
        catch (IOException io) {
            // empty catch block
        }
        try {
            pIn.close();
        }
        catch (IOException io) {
            // empty catch block
        }
        try {
            pOut.close();
        }
        catch (IOException io) {
            // empty catch block
        }
        try {
            pErr.close();
        }
        catch (IOException io) {
            // empty catch block
        }
        try {
            t3.interrupt();
        }
        catch (SecurityException se) {
            // empty catch block
        }
    }

    private static String[] parseCommandLine(Ruby runtime, IRubyObject[] rawArgs) {
        String[] args;
        if (rawArgs.length == 1) {
            RubyArray parts = (RubyArray)runtime.evalScriptlet("require 'jruby/path_helper'; JRuby::PathHelper").callMethod(runtime.getCurrentContext(), "smart_split_command", rawArgs);
            args = new String[parts.getLength()];
            for (int i = 0; i < parts.getLength(); ++i) {
                args[i] = parts.entry(i).toString();
            }
        } else {
            args = new String[rawArgs.length];
            for (int i = 0; i < rawArgs.length; ++i) {
                args[i] = rawArgs[i].toString();
            }
        }
        return args;
    }

    private static boolean shouldRunInProcess(Ruby runtime, String[] commands) {
        if (!runtime.getInstanceConfig().isRunRubyInProcess()) {
            return false;
        }
        for (int i = 0; i < commands.length; ++i) {
            String c = commands[i];
            if (c.trim().length() == 0) continue;
            char[] firstLast = new char[]{c.charAt(0), c.charAt(c.length() - 1)};
            for (int j = 0; j < firstLast.length; ++j) {
                switch (firstLast[j]) {
                    case '<': 
                    case '>': 
                    case '|': {
                        return false;
                    }
                }
            }
        }
        String command = commands[0];
        String[] slashDelimitedTokens = command.split("/");
        String finalToken = slashDelimitedTokens[slashDelimitedTokens.length - 1];
        int indexOfRuby = finalToken.indexOf("ruby");
        return indexOfRuby != -1 && indexOfRuby == finalToken.length() - 4 || finalToken.endsWith(".rb") || finalToken.endsWith("irb");
    }

    private static boolean shouldRunInShell(String shell, String[] args) {
        return !Platform.IS_WINDOWS || shell != null && args.length > 1 && !new File(args[0]).exists();
    }

    private static String getShell(Ruby runtime) {
        return runtime.evalScriptlet("require 'rbconfig'; Config::CONFIG['SHELL']").toString();
    }

    private static class StreamPumper
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private boolean onlyIfAvailable;
        private volatile boolean quit;
        private final Object waitLock = new Object();

        StreamPumper(InputStream in, OutputStream out, boolean avail) {
            this.in = in;
            this.out = out;
            this.onlyIfAvailable = avail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            byte[] buf = new byte[1024];
            boolean hasReadSomething = false;
            while (!this.quit) {
                int numRead;
                if (this.onlyIfAvailable && !hasReadSomething) {
                    if (this.in.available() == 0) {
                        Object object = this.waitLock;
                        synchronized (object) {
                            this.waitLock.wait(10L);
                            continue;
                        }
                    }
                    hasReadSomething = true;
                }
                if ((numRead = this.in.read(buf)) == -1) break;
                this.out.write(buf, 0, numRead);
            }
            Object var7_7 = null;
            if (!this.onlyIfAvailable) return;
            try {
                this.out.close();
                return;
            }
            catch (IOException ioe) {}
            return;
            {
                catch (Exception exception) {
                    Object var7_8 = null;
                    if (!this.onlyIfAvailable) return;
                    try {
                        this.out.close();
                        return;
                    }
                    catch (IOException ioe) {}
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (!this.onlyIfAvailable) throw throwable;
                try {
                    this.out.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            this.quit = true;
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
    }

    public static class POpenProcess
    extends Process {
        private Process child;
        private Ruby runtime;
        private ModeFlags modes;
        private InputStream in;
        private OutputStream out;
        private StreamPumper pumper;

        public POpenProcess(Process child, Ruby runtime, ModeFlags modes) {
            this.child = child;
            this.runtime = runtime;
            this.modes = modes;
            if (modes.isWritable()) {
                this.out = child.getOutputStream();
            } else {
                try {
                    child.getOutputStream().close();
                }
                catch (IOException ioe) {
                    throw runtime.newIOErrorFromException(ioe);
                }
                this.out = new OutputStream(){

                    public void write(int b) throws IOException {
                    }
                };
            }
            if (modes.isReadable()) {
                this.in = child.getInputStream();
            } else {
                this.pumper = new StreamPumper(child.getInputStream(), runtime.getOut(), false);
                this.pumper.setDaemon(true);
                this.pumper.start();
                this.in = new InputStream(){

                    public int read() throws IOException {
                        return -1;
                    }
                };
            }
        }

        public OutputStream getOutputStream() {
            return this.out;
        }

        public InputStream getInputStream() {
            return this.in;
        }

        public InputStream getErrorStream() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int waitFor() throws InterruptedException {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            int result = this.child.waitFor();
            if (this.pumper != null) {
                this.pumper.quit();
            }
            return result;
        }

        public int exitValue() {
            return this.child.exitValue();
        }

        public void destroy() {
            if (this.pumper != null) {
                this.pumper.quit();
            }
            try {
                this.in.close();
                this.out.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.child.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScriptThreadProcess
    extends Process
    implements Runnable {
        private String[] argArray;
        private int result;
        private RubyInstanceConfig config;
        private Thread processThread;
        private PipedInputStream processOutput;
        private PipedInputStream processError;
        private PipedOutputStream processInput;
        private final String[] env;
        private final File pwd;
        private final boolean pipedStreams;

        public ScriptThreadProcess(String[] argArray, String[] env, File dir) {
            this(argArray, env, dir, true);
        }

        public ScriptThreadProcess(String[] argArray, String[] env, File dir, boolean pipedStreams) {
            this.argArray = argArray;
            this.env = env;
            this.pwd = dir;
            this.pipedStreams = pipedStreams;
            if (pipedStreams) {
                this.processOutput = new PipedInputStream();
                this.processError = new PipedInputStream();
                this.processInput = new PipedOutputStream();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    this.result = new Main(this.config).run(this.argArray);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(this.config.getError());
                    this.result = -1;
                    Object var3_2 = null;
                    this.config.getOutput().close();
                    this.config.getError().close();
                }
                Object var3_1 = null;
                this.config.getOutput().close();
                this.config.getError().close();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.config.getOutput().close();
                this.config.getError().close();
                throw throwable;
            }
        }

        private Map<String, String> environmentMap(String[] env) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (int i = 0; i < env.length; ++i) {
                String[] kv = env[i].split("=", 2);
                m.put(kv[0], kv[1]);
            }
            return m;
        }

        public void start() throws IOException {
            this.config = new RubyInstanceConfig(){
                {
                    this.setEnvironment(ScriptThreadProcess.this.environmentMap(ScriptThreadProcess.this.env));
                    this.setCurrentDirectory(ScriptThreadProcess.this.pwd.toString());
                }
            };
            if (this.pipedStreams) {
                this.config.setInput(new PipedInputStream(this.processInput));
                this.config.setOutput(new PrintStream(new PipedOutputStream(this.processOutput)));
                this.config.setError(new PrintStream(new PipedOutputStream(this.processError)));
            }
            String procName = "piped";
            if (this.argArray.length > 0) {
                procName = this.argArray[0];
            }
            this.processThread = new Thread((Runnable)this, "ScriptThreadProcess: " + procName);
            this.processThread.setDaemon(true);
            this.processThread.start();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.processInput;
        }

        @Override
        public InputStream getInputStream() {
            return this.processOutput;
        }

        @Override
        public InputStream getErrorStream() {
            return this.processError;
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.processThread.join();
            return this.result;
        }

        @Override
        public int exitValue() {
            return this.result;
        }

        @Override
        public void destroy() {
            if (this.pipedStreams) {
                this.closeStreams();
            }
            this.processThread.interrupt();
        }

        private void closeStreams() {
            try {
                this.processInput.close();
            }
            catch (IOException io) {
                // empty catch block
            }
            try {
                this.processOutput.close();
            }
            catch (IOException io) {
                // empty catch block
            }
            try {
                this.processError.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

