/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledBlockLight
extends BlockBody {
    protected final CompiledBlockCallback callback;
    protected final boolean hasMultipleArgsHead;
    protected final Arity arity;
    protected final DynamicScope dummyScope;

    public static Block newCompiledClosureLight(IRubyObject self, Frame frame, Visibility visibility, RubyModule klass, DynamicScope dynamicScope, Arity arity, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        Binding binding = new Binding(self, frame, visibility, klass, dynamicScope);
        CompiledBlockLight body = new CompiledBlockLight(arity, DynamicScope.newDynamicScope(scope, dynamicScope), callback, hasMultipleArgsHead, argumentType);
        return new Block(body, binding);
    }

    public static Block newCompiledClosureLight(ThreadContext context, IRubyObject self, Arity arity, StaticScope scope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        return CompiledBlockLight.newCompiledClosureLight(self, context.getCurrentFrame(), Visibility.PUBLIC, context.getRubyClass(), context.getCurrentScope(), arity, scope, callback, hasMultipleArgsHead, argumentType);
    }

    protected CompiledBlockLight(Arity arity, DynamicScope dummyScope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        super(argumentType);
        this.arity = arity;
        this.callback = callback;
        this.hasMultipleArgsHead = hasMultipleArgsHead;
        this.dummyScope = dummyScope;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args, Binding binding, Block.Type type) {
        args = this.prepareArgumentsForCall(context, args, type);
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true, binding, type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value, Binding binding, Block.Type type) {
        return this.yield(context, value, null, null, false, binding, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject yield(ThreadContext context, IRubyObject args, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
        if (klass == null) {
            self = binding.getSelf();
            binding.getFrame().setSelf(self);
        }
        Visibility oldVis = binding.getFrame().getVisibility();
        IRubyObject[] realArgs = aValue ? this.setupBlockArgs(context, args, self) : this.setupBlockArg(context, args, self);
        this.pre(context, klass, binding);
        try {
            IRubyObject iRubyObject;
            try {
                iRubyObject = this.callback.call(context, self, realArgs);
                Object var13_13 = null;
            }
            catch (JumpException.BreakJump bj) {
                if (bj.getTarget() != null) throw bj;
                bj.setTarget(this);
                throw bj;
            }
            catch (JumpException.NextJump nj) {
                IRubyObject iRubyObject2 = type == Block.Type.LAMBDA ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
                Object var13_14 = null;
                binding.getFrame().setVisibility(oldVis);
                this.post(context, binding);
                return iRubyObject2;
            }
            binding.getFrame().setVisibility(oldVis);
            this.post(context, binding);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            binding.getFrame().setVisibility(oldVis);
            this.post(context, binding);
            throw throwable;
        }
    }

    protected void pre(ThreadContext context, RubyModule klass, Binding binding) {
        context.preYieldLightBlock(binding, this.dummyScope, klass);
    }

    protected void post(ThreadContext context, Binding binding) {
        context.postYieldLight(binding);
    }

    private IRubyObject[] setupBlockArgs(ThreadContext context, IRubyObject value, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: 
            case 3: {
                return new IRubyObject[]{value};
            }
        }
        int length = this.arrayLength(value);
        switch (length) {
            case 0: {
                value = context.getRuntime().getNil();
                break;
            }
            case 1: {
                value = ((RubyArray)value).eltInternal(0);
                break;
            }
            default: {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length + " for 1)", new Object[0]);
            }
        }
        return new IRubyObject[]{value};
    }

    private IRubyObject[] setupBlockArg(ThreadContext context, IRubyObject value, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: 
            case 3: {
                return new IRubyObject[]{ArgsUtil.convertToRubyArray(context.getRuntime(), value, this.hasMultipleArgsHead)};
            }
        }
        if (value == null) {
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
            return new IRubyObject[]{context.getRuntime().getNil()};
        }
        return new IRubyObject[]{value};
    }

    public StaticScope getStaticScope() {
        return this.dummyScope.getStaticScope();
    }

    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope());
        return new Block(this, binding);
    }

    public Arity arity() {
        return this.arity;
    }
}

