/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedJavaMethod
extends JavaMethod {
    private final Method method;
    private final boolean needsBlock;
    private final boolean isStatic;
    private final int required;
    private final int optional;
    private final boolean rest;
    private final int max;
    private final boolean argsAsIs;
    private final boolean needsThreadContext;

    public ReflectedJavaMethod(RubyModule implementationClass, Method method, JRubyMethod annotation) {
        super(implementationClass, annotation.visibility());
        this.method = method;
        Class[] params = method.getParameterTypes();
        this.needsBlock = params.length > 0 && params[params.length - 1] == Block.class;
        this.isStatic = Modifier.isStatic(method.getModifiers());
        Arity arity = Arity.fromAnnotation(annotation, params, this.isStatic);
        this.setArity(arity);
        this.required = arity.getValue() >= 0 ? arity.getValue() : Math.abs(arity.getValue()) - 1;
        this.optional = annotation.optional();
        this.rest = annotation.rest();
        this.needsThreadContext = params.length > 0 && params[0] == ThreadContext.class;
        this.argsAsIs = !this.isStatic && this.optional == 0 && !this.rest && !this.needsBlock && !this.needsThreadContext;
        this.max = this.rest ? -1 : this.required + this.optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        IRubyObject iRubyObject;
        block32: {
            IRubyObject iRubyObject2;
            block31: {
                Ruby runtime = context.getRuntime();
                Arity.checkArgumentCount(runtime, args, this.required, this.max);
                this.callConfig.pre(context, self, this.getImplementationClass(), this.arity, name, args, block, null, this);
                try {
                    IRubyObject iRubyObject3;
                    block30: {
                        try {
                            if (!this.isStatic && !this.method.getDeclaringClass().isAssignableFrom(self.getClass())) {
                                throw new ClassCastException(self.getClass().getName() + " cannot be converted to " + this.method.getDeclaringClass().getName());
                            }
                            if (this.argsAsIs) {
                                boolean isTrace = runtime.hasEventHooks();
                                try {
                                    if (isTrace) {
                                        runtime.callEventHooks(context, 5, context.getFile(), context.getLine(), name, this.getImplementationClass());
                                    }
                                    iRubyObject3 = (IRubyObject)this.method.invoke((Object)self, (Object[])args);
                                    Object var11_16 = null;
                                    if (isTrace) {
                                        runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var11_17 = null;
                                    if (!isTrace) throw throwable;
                                    runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
                                    throw throwable;
                                }
                                Object var16_20 = null;
                                break block30;
                            }
                            int argsLength = this.calcArgsLength();
                            Object[] params = new Object[argsLength];
                            int offset = 0;
                            if (this.needsThreadContext) {
                                params[offset++] = context;
                            }
                            if (this.isStatic) {
                                params[offset++] = self;
                            }
                            if (this.optional == 0 && !this.rest) {
                                for (int i = 0; i < args.length; ++i) {
                                    params[offset++] = args[i];
                                }
                            } else {
                                params[offset++] = args;
                            }
                            if (this.needsBlock) {
                                params[offset++] = block;
                            }
                            boolean isTrace = runtime.hasEventHooks();
                            try {
                                if (isTrace) {
                                    runtime.callEventHooks(context, 5, context.getFile(), context.getLine(), name, this.getImplementationClass());
                                }
                                if (this.isStatic) {
                                    iRubyObject2 = (IRubyObject)this.method.invoke(null, params);
                                    Object var14_30 = null;
                                    if (isTrace) {
                                        runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
                                    }
                                    break block31;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var14_32 = null;
                                if (!isTrace) throw throwable;
                                runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
                                throw throwable;
                            }
                            {
                                iRubyObject = (IRubyObject)this.method.invoke((Object)self, params);
                                Object var14_31 = null;
                                if (!isTrace) break block32;
                                runtime.callEventHooks(context, 6, context.getFile(), context.getLine(), name, this.getImplementationClass());
                            }
                            break block32;
                        }
                        catch (IllegalArgumentException e) {
                            throw RaiseException.createNativeRaiseException(runtime, e);
                        }
                        catch (IllegalAccessException e) {
                            throw RaiseException.createNativeRaiseException(runtime, e);
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof JumpException.ReturnJump) {
                                JumpException.FlowControlException f = (JumpException.FlowControlException)cause;
                                if (f.getTarget() != this) throw f;
                                IRubyObject iRubyObject4 = (IRubyObject)f.getValue();
                                Object var16_23 = null;
                                this.callConfig.post(context);
                                return iRubyObject4;
                            }
                            if (cause instanceof JumpException.RedoJump) {
                                throw runtime.newLocalJumpError("redo", runtime.getNil(), "unexpected redo");
                            }
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            if (!(cause instanceof Error)) throw RaiseException.createNativeRaiseException(runtime, cause);
                            throw (Error)cause;
                        }
                    }
                    this.callConfig.post(context);
                    return iRubyObject3;
                }
                catch (Throwable throwable) {
                    Object var16_24 = null;
                    this.callConfig.post(context);
                    throw throwable;
                }
            }
            Object var16_21 = null;
            this.callConfig.post(context);
            return iRubyObject2;
        }
        Object var16_22 = null;
        this.callConfig.post(context);
        return iRubyObject;
    }

    private int calcArgsLength() {
        int argsLength = 0;
        if (this.needsThreadContext) {
            ++argsLength;
        }
        if (this.isStatic) {
            ++argsLength;
        }
        argsLength = this.optional == 0 && !this.rest ? (argsLength += this.required) : ++argsLength;
        if (this.needsBlock) {
            ++argsLength;
        }
        return argsLength;
    }
}

