/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;

public class RubyUDPSocket
extends RubyIPSocket {
    private static ObjectAllocator UDPSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyUDPSocket(runtime, klass);
        }
    };

    static void createUDPSocket(Ruby runtime) {
        RubyClass rb_cUDPSocket = runtime.defineClass("UDPSocket", runtime.fastGetClass("IPSocket"), UDPSOCKET_ALLOCATOR);
        CallbackFactory cfact = runtime.callbackFactory(RubyUDPSocket.class);
        try {
            rb_cUDPSocket.includeModule(runtime.fastGetClass("Socket").fastGetConstant("Constants"));
            rb_cUDPSocket.defineFastMethod("initialize", cfact.getFastMethod("initialize"));
            rb_cUDPSocket.defineFastMethod("bind", cfact.getFastMethod("bind", IRubyObject.class, IRubyObject.class));
            rb_cUDPSocket.defineFastMethod("connect", cfact.getFastMethod("connect", IRubyObject.class, IRubyObject.class));
            rb_cUDPSocket.defineFastMethod("recvfrom", cfact.getFastOptMethod("recvfrom"));
            rb_cUDPSocket.defineFastMethod("send", cfact.getFastOptMethod("send"));
            rb_cUDPSocket.getMetaClass().defineMethod("open", cfact.getOptSingletonMethod("open"));
            runtime.getObject().fastSetConstant("UDPsocket", rb_cUDPSocket);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public RubyUDPSocket(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public IRubyObject initialize() {
        try {
            DatagramChannel channel = DatagramChannel.open();
            this.initSocket(new ChannelDescriptor(channel, RubyIO.getNewFileno(), new ModeFlags(2L), new FileDescriptor()));
        }
        catch (InvalidValueException ex) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (ConnectException e) {
            throw this.getRuntime().newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "initialize: name or service not known");
        }
        return this;
    }

    public IRubyObject setsockopt(IRubyObject[] args) {
        return this.getRuntime().getNil();
    }

    public IRubyObject bind(IRubyObject host, IRubyObject port) {
        InetSocketAddress addr = null;
        try {
            addr = host.isNil() ? new InetSocketAddress(RubyNumeric.fix2int(port)) : new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), RubyNumeric.fix2int(port));
            ((DatagramChannel)this.getChannel()).socket().bind(addr);
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
        }
        catch (SocketException e) {
            throw RubyUDPSocket.sockerr(this, "bind: name or service not known");
        }
    }

    public IRubyObject connect(IRubyObject host, IRubyObject port) {
        try {
            InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), RubyNumeric.fix2int(port));
            ((DatagramChannel)this.getChannel()).connect(addr);
            return RubyFixnum.zero(this.getRuntime());
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "connect: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "connect: name or service not known");
        }
    }

    public IRubyObject recvfrom(IRubyObject[] args) {
        try {
            int length = RubyNumeric.fix2int(args[0]);
            ByteBuffer buf = ByteBuffer.allocate(length);
            InetSocketAddress sender = (InetSocketAddress)((DatagramChannel)this.getChannel()).receive(buf);
            RubyArray addressArray = this.getRuntime().newArray(new IRubyObject[]{this.getRuntime().newString("AF_INET"), this.getRuntime().newFixnum(sender.getPort()), this.getRuntime().newString(sender.getHostName()), this.getRuntime().newString(sender.getAddress().getHostAddress())});
            RubyString result = this.getRuntime().newString(new ByteList(buf.array(), 0, buf.position()));
            return this.getRuntime().newArray(new IRubyObject[]{result, addressArray});
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "recvfrom: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "recvfrom: name or service not known");
        }
    }

    public IRubyObject recv(IRubyObject[] args) {
        try {
            int length = RubyNumeric.fix2int(args[0]);
            ByteBuffer buf = ByteBuffer.allocate(length);
            ((DatagramChannel)this.getChannel()).receive(buf);
            return this.getRuntime().newString(new ByteList(buf.array(), 0, buf.position()));
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "recv: name or service not known");
        }
    }

    public IRubyObject send(IRubyObject[] args) {
        try {
            if (args.length >= 3) {
                InetSocketAddress addr = new InetSocketAddress(InetAddress.getByName(args[2].convertToString().toString()), RubyNumeric.fix2int(args[3]));
                RubyString data = args[0].convertToString();
                ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
                ((DatagramChannel)this.getChannel()).send(buf, addr);
                return data.length();
            }
            RubyString data = args[0].convertToString();
            ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
            ((DatagramChannel)this.getChannel()).write(buf);
            return data.length();
        }
        catch (UnknownHostException e) {
            throw RubyUDPSocket.sockerr(this, "send: name or service not known");
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(this, "send: name or service not known");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject iRubyObject;
        block3: {
            RubyUDPSocket sock = (RubyUDPSocket)recv.callMethod(recv.getRuntime().getCurrentContext(), "new", args);
            if (!block.isGiven()) {
                return sock;
            }
            try {
                iRubyObject = block.yield(recv.getRuntime().getCurrentContext(), sock);
                Object var6_5 = null;
                if (!sock.openFile.isOpen()) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var6_6 = null;
                    if (!sock.openFile.isOpen()) break block4;
                    sock.close();
                }
                throw throwable;
            }
            sock.close();
        }
        return iRubyObject;
    }
}

