/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;
import jruby.objectweb.asm.ClassReader;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.Opcodes;
import jruby.objectweb.asm.util.CheckClassAdapter;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.NodeType;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.CacheCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.MethodCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ScriptCompiler;
import org.jruby.compiler.VariableCompiler;
import org.jruby.compiler.impl.BoxedVariableCompiler;
import org.jruby.compiler.impl.HeapBasedVariableCompiler;
import org.jruby.compiler.impl.InheritedCacheCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StackBasedVariableCompiler;
import org.jruby.compiler.impl.StandardInvocationCompiler;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardASMCompiler
implements ScriptCompiler,
Opcodes {
    private static final String THREADCONTEXT = CodegenUtils.p(ThreadContext.class);
    private static final String RUBY = CodegenUtils.p(Ruby.class);
    private static final String IRUBYOBJECT = CodegenUtils.p(IRubyObject.class);
    private static final String METHOD_SIGNATURE = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
    private static final String CLOSURE_SIGNATURE = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class);
    public static final int THIS = 0;
    public static final int THREADCONTEXT_INDEX = 1;
    public static final int SELF_INDEX = 2;
    public static final int ARGS_INDEX = 3;
    public static final int CLOSURE_INDEX = 4;
    public static final int DYNAMIC_SCOPE_INDEX = 5;
    public static final int RUNTIME_INDEX = 6;
    public static final int VARS_ARRAY_INDEX = 7;
    public static final int NIL_INDEX = 8;
    public static final int EXCEPTION_INDEX = 9;
    public static final int PREVIOUS_EXCEPTION_INDEX = 10;
    public static final int FIRST_TEMP_INDEX = 11;
    private String classname;
    private String sourcename;
    private ClassWriter classWriter;
    private SkinnyMethodAdapter initMethod;
    private SkinnyMethodAdapter clinitMethod;
    int methodIndex = -1;
    int innerIndex = -1;
    int fieldIndex = 0;
    int rescueNumber = 1;
    int ensureNumber = 1;
    StaticScope topLevelScope;
    CacheCompiler cacheCompiler;
    static boolean USE_INHERITED_CACHE_FIELDS = true;
    private int constants = 0;

    public StandardASMCompiler(String classname, String sourcename) {
        this.classname = classname;
        this.sourcename = sourcename;
    }

    public byte[] getClassByteArray() {
        return this.classWriter.toByteArray();
    }

    public Class<?> loadClass(JRubyClassLoader classLoader) throws ClassNotFoundException {
        classLoader.defineClass(CodegenUtils.c(this.classname), this.classWriter.toByteArray());
        return classLoader.loadClass(CodegenUtils.c(this.classname));
    }

    public void writeClass(File destination) throws IOException {
        this.writeClass(this.classname, destination, this.classWriter);
    }

    private void writeClass(String classname, File destination, ClassWriter writer) throws IOException {
        String fullname = classname + ".class";
        String filename = null;
        String path = null;
        byte[] bytecode = writer.toByteArray();
        CheckClassAdapter.verify(new ClassReader(bytecode), false, new PrintWriter(System.err));
        if (fullname.lastIndexOf("/") == -1) {
            filename = fullname;
            path = "";
        } else {
            filename = fullname.substring(fullname.lastIndexOf("/") + 1);
            path = fullname.substring(0, fullname.lastIndexOf("/"));
        }
        File pathfile = new File(destination, path);
        pathfile.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(pathfile, filename));
        out.write(bytecode);
        out.close();
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    @Override
    public void startScript(StaticScope scope) {
        this.classWriter = new ClassWriter(1);
        this.classWriter.visit(48, 33, this.classname, null, CodegenUtils.p(AbstractScript.class), null);
        this.classWriter.visitSource(this.sourcename, null);
        this.topLevelScope = scope;
        this.beginInit();
        this.beginClassInit();
        this.cacheCompiler = new InheritedCacheCompiler(this);
    }

    @Override
    public void endScript(boolean generateRun, boolean generateLoad, boolean generateMain) {
        SkinnyMethodAdapter method;
        String methodName = "__file__";
        if (generateRun) {
            method = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "run", METHOD_SIGNATURE, null, null));
            method.start();
            method.aload(0);
            method.aload(1);
            method.aload(2);
            method.aload(3);
            method.aload(4);
            method.invokevirtual(this.classname, methodName, METHOD_SIGNATURE);
            method.areturn();
            method.end();
        }
        if (generateLoad || generateMain) {
            method = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(1, "load", METHOD_SIGNATURE, null, null));
            method.start();
            Label tryBegin = new Label();
            Label tryFinally = new Label();
            method.label(tryBegin);
            method.aload(1);
            this.buildStaticScopeNames(method, this.topLevelScope);
            method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "preLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class, String[].class));
            method.aload(0);
            method.aload(1);
            method.aload(2);
            method.aload(3);
            method.aload(4);
            method.invokevirtual(this.classname, methodName, METHOD_SIGNATURE);
            method.aload(1);
            method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            method.areturn();
            method.label(tryFinally);
            method.aload(1);
            method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "postLoad", CodegenUtils.sig(Void.TYPE, ThreadContext.class));
            method.athrow();
            method.trycatch(tryBegin, tryFinally, tryFinally, null);
            method.end();
        }
        if (generateMain) {
            method = new SkinnyMethodAdapter(this.getClassVisitor().visitMethod(9, "main", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String[].class)), null, null));
            method.start();
            method.newobj(this.classname);
            method.dup();
            method.invokespecial(this.classname, "<init>", CodegenUtils.sig(Void.TYPE));
            method.newobj(CodegenUtils.p(RubyInstanceConfig.class));
            method.dup();
            method.invokespecial(CodegenUtils.p(RubyInstanceConfig.class), "<init>", "()V");
            method.dup();
            method.aload(0);
            method.invokevirtual(CodegenUtils.p(RubyInstanceConfig.class), "setArgv", CodegenUtils.sig(Void.TYPE, String[].class));
            method.invokestatic(CodegenUtils.p(Ruby.class), "newInstance", CodegenUtils.sig(Ruby.class, RubyInstanceConfig.class));
            method.dup();
            method.invokevirtual(RUBY, "getCurrentContext", CodegenUtils.sig(ThreadContext.class));
            method.swap();
            method.invokevirtual(RUBY, "getTopSelf", CodegenUtils.sig(IRubyObject.class));
            method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            method.invokevirtual(this.classname, "load", METHOD_SIGNATURE);
            method.voidreturn();
            method.end();
        }
        this.endInit();
        this.endClassInit();
    }

    public void buildStaticScopeNames(SkinnyMethodAdapter method, StaticScope scope) {
        method.ldc(new Integer(scope.getNumberOfVariables()));
        method.anewarray(CodegenUtils.p(String.class));
        for (int i = 0; i < scope.getNumberOfVariables(); ++i) {
            method.dup();
            method.ldc(new Integer(i));
            method.ldc(scope.getVariables()[i]);
            method.arraystore();
        }
    }

    private void beginInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.initMethod = new SkinnyMethodAdapter(cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE), null, null));
        this.initMethod.start();
        this.initMethod.aload(0);
        if (USE_INHERITED_CACHE_FIELDS) {
            this.initMethod.invokespecial(CodegenUtils.p(AbstractScript.class), "<init>", CodegenUtils.sig(Void.TYPE));
        } else {
            this.initMethod.invokespecial(CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE));
        }
        cv.visitField(18, "$class", CodegenUtils.ci(Class.class), null, null);
        this.initMethod.aload(0);
        this.initMethod.ldc(CodegenUtils.c(this.classname));
        this.initMethod.invokestatic(CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(Class.class, CodegenUtils.params(String.class)));
        this.initMethod.putfield(this.classname, "$class", CodegenUtils.ci(Class.class));
    }

    private void endInit() {
        this.initMethod.voidreturn();
        this.initMethod.end();
    }

    private void beginClassInit() {
        ClassVisitor cv = this.getClassVisitor();
        this.clinitMethod = new SkinnyMethodAdapter(cv.visitMethod(9, "<clinit>", CodegenUtils.sig(Void.TYPE), null, null));
        this.clinitMethod.start();
    }

    private void endClassInit() {
        this.clinitMethod.voidreturn();
        this.clinitMethod.end();
    }

    public SkinnyMethodAdapter getInitMethod() {
        return this.initMethod;
    }

    public SkinnyMethodAdapter getClassInitMethod() {
        return this.clinitMethod;
    }

    public CacheCompiler getCacheCompiler() {
        return this.cacheCompiler;
    }

    @Override
    public MethodCompiler startMethod(String friendlyName, CompilerCallback args, StaticScope scope, ASTInspector inspector) {
        ASMMethodCompiler methodCompiler = new ASMMethodCompiler(friendlyName, inspector);
        methodCompiler.beginMethod(args, scope);
        return methodCompiler;
    }

    public String getNewConstant(String type, String name_prefix) {
        return this.getNewConstant(type, name_prefix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewConstant(String type, String name_prefix, Object init) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = "_" + this.constants++;
        }
        cv.visitField(2, realName, type, null, null).visitEnd();
        if (init != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(init);
            this.initMethod.putfield(this.classname, realName, type);
        }
        return realName;
    }

    public String getNewField(String type, String name, Object init) {
        ClassVisitor cv = this.getClassVisitor();
        cv.visitField(2, name, type, null, null).visitEnd();
        if (init != null) {
            this.initMethod.aload(0);
            this.initMethod.ldc(init);
            this.initMethod.putfield(this.classname, name, type);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNewStaticConstant(String type, String name_prefix) {
        String realName;
        ClassVisitor cv = this.getClassVisitor();
        StandardASMCompiler standardASMCompiler = this;
        synchronized (standardASMCompiler) {
            realName = "__" + this.constants++;
        }
        cv.visitField(10, realName, type, null, null).visitEnd();
        return realName;
    }

    public class ASMMethodCompiler
    extends AbstractMethodCompiler {
        private String friendlyName;

        public ASMMethodCompiler(String friendlyName, ASTInspector inspector) {
            this.friendlyName = friendlyName;
            this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(1, friendlyName, METHOD_SIGNATURE, null, null));
            this.variableCompiler = inspector == null ? new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4, 11) : (inspector.hasClosure() || inspector.hasScopeAwareMethods() ? (RubyInstanceConfig.BOXED_COMPILE_ENABLED && !inspector.hasScopeAwareMethods() ? new BoxedVariableCompiler(this, this.method, 5, 7, 3, 4, 11) : new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4, 11)) : new StackBasedVariableCompiler(this, this.method, 5, 3, 4, 11));
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }

        public void beginChainedMethod() {
            this.method.start();
            this.method.aload(1);
            this.method.dup();
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class));
            this.method.astore(8);
            this.method.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class));
            this.method.dup();
            this.method.astore(5);
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
            this.method.astore(7);
        }

        public void beginMethod(CompilerCallback args, StaticScope scope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class));
            this.method.astore(8);
            this.variableCompiler.beginMethod(args, scope);
            Label start = new Label();
            this.method.label(start);
            this.scopeStart = start;
        }

        public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class));
            this.method.astore(8);
            this.variableCompiler.beginClass(bodyPrep, scope);
            Label start = new Label();
            this.method.label(start);
            this.scopeStart = start;
        }

        public void endMethod() {
            this.method.areturn();
            Label end = new Label();
            this.method.label(end);
            this.method.end();
        }

        public void performReturn() {
            if (this.withinProtection) {
                this.loadThreadContext();
                this.invokeUtilityMethod("returnJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class));
            } else {
                this.method.areturn();
            }
        }

        public void issueBreakEvent(CompilerCallback value) {
            if (this.withinProtection) {
                value.call(this);
                this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                value.call(this);
                this.issueLoopBreak();
            } else {
                this.loadRuntime();
                value.call(this);
                this.invokeUtilityMethod("breakLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        public void issueNextEvent(CompilerCallback value) {
            if (this.withinProtection) {
                value.call(this);
                this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                value.call(this);
                this.issueLoopNext();
            } else {
                this.loadRuntime();
                value.call(this);
                this.invokeUtilityMethod("nextLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class));
            }
        }

        public void issueRedoEvent() {
            if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else {
                this.loadRuntime();
                this.invokeUtilityMethod("redoLocalJumpError", CodegenUtils.sig(IRubyObject.class, Ruby.class));
            }
        }
    }

    public class ASMClosureCompiler
    extends AbstractMethodCompiler {
        private String closureMethodName;

        public ASMClosureCompiler(String closureMethodName, String closureFieldName, ASTInspector inspector) {
            this.closureMethodName = closureMethodName;
            StandardASMCompiler.this.getClassVisitor().visitField(2, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class), null, null);
            this.method = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, closureMethodName, CLOSURE_SIGNATURE, null, null));
            this.variableCompiler = inspector == null ? new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4, 11) : (inspector.hasClosure() || inspector.hasScopeAwareMethods() ? (RubyInstanceConfig.BOXED_COMPILE_ENABLED && !inspector.hasScopeAwareMethods() ? new BoxedVariableCompiler(this, this.method, 5, 7, 3, 4, 11) : new HeapBasedVariableCompiler(this, this.method, 5, 7, 3, 4, 11)) : new StackBasedVariableCompiler(this, this.method, 5, 3, 4, 11));
            this.invocationCompiler = new StandardInvocationCompiler(this, this.method);
        }

        public void beginMethod(CompilerCallback args, StaticScope scope) {
            this.method.start();
            this.method.aload(1);
            this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
            this.method.dup();
            this.method.astore(6);
            this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class));
            this.method.astore(8);
            this.variableCompiler.beginClosure(args, scope);
            this.scopeStart = new Label();
            this.scopeEnd = new Label();
            this.redoJump = new Label();
            this.method.label(this.scopeStart);
        }

        public void beginClass(CompilerCallback bodyPrep, StaticScope scope) {
            throw new NotCompilableException("ERROR: closure compiler should not be used for class bodies");
        }

        public void endMethod() {
            this.scopeEnd = new Label();
            this.method.areturn();
            this.method.label(this.scopeEnd);
            this.method.pop();
            this.method.go_to(this.scopeStart);
            this.method.trycatch(this.scopeStart, this.scopeEnd, this.scopeEnd, CodegenUtils.p(JumpException.RedoJump.class));
            this.method.end();
        }

        public void loadBlock() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameBlock", CodegenUtils.sig(Block.class));
        }

        protected String getNewRescueName() {
            return this.closureMethodName + "_" + super.getNewRescueName();
        }

        protected String getNewEnsureName() {
            return this.closureMethodName + "_" + super.getNewEnsureName();
        }

        public void performReturn() {
            this.loadThreadContext();
            this.invokeUtilityMethod("returnJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class));
        }

        public void processRequiredArgs(Arity arity, int requiredArgs, int optArgs, int restArg) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void assignOptionalArgs(Object object, int expectedArgsCount, int size, ArrayCallback optEval) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processRestArg(int startIndex, int restArg) {
            throw new NotCompilableException("Shouldn't be calling this...");
        }

        public void processBlockArgument(int index) {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadBlock();
            this.method.ldc(new Integer(index));
            this.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Ruby.class, ThreadContext.class, Block.class, Integer.TYPE)));
        }

        public void issueBreakEvent(CompilerCallback value) {
            if (this.withinProtection || this.currentLoopLabels == null) {
                value.call(this);
                this.invokeUtilityMethod("breakJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else {
                value.call(this);
                this.issueLoopBreak();
            }
        }

        public void issueNextEvent(CompilerCallback value) {
            if (this.withinProtection || this.currentLoopLabels == null) {
                value.call(this);
                this.invokeUtilityMethod("nextJump", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
            } else {
                value.call(this);
                this.issueLoopNext();
            }
        }

        public void issueRedoEvent() {
            if (this.withinProtection) {
                this.invokeUtilityMethod("redoJump", CodegenUtils.sig(IRubyObject.class));
            } else if (this.currentLoopLabels != null) {
                this.issueLoopRedo();
            } else {
                this.method.go_to(this.scopeStart);
            }
        }
    }

    public abstract class AbstractMethodCompiler
    implements MethodCompiler {
        protected SkinnyMethodAdapter method;
        protected VariableCompiler variableCompiler;
        protected InvocationCompiler invocationCompiler;
        protected Label[] currentLoopLabels;
        protected Label scopeStart;
        protected Label scopeEnd;
        protected Label redoJump;
        protected boolean withinProtection = false;
        private int lastLine = -1;

        public abstract void beginMethod(CompilerCallback var1, StaticScope var2);

        public abstract void endMethod();

        public MethodCompiler chainToMethod(String methodName, ASTInspector inspector) {
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.aload(3);
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
            this.endMethod();
            ASMMethodCompiler methodCompiler = new ASMMethodCompiler(methodName, inspector);
            methodCompiler.beginChainedMethod();
            return methodCompiler;
        }

        public StandardASMCompiler getScriptCompiler() {
            return StandardASMCompiler.this;
        }

        public void lineNumber(ISourcePosition position) {
            int thisLine = position.getStartLine();
            if (thisLine == this.lastLine) {
                return;
            }
            this.lastLine = thisLine;
            Label line = new Label();
            this.method.label(line);
            this.method.visitLineNumber(thisLine + 1, line);
        }

        public void loadThreadContext() {
            this.method.aload(1);
        }

        public void loadSelf() {
            this.method.aload(2);
        }

        public void loadRuntime() {
            this.method.aload(6);
        }

        public void loadBlock() {
            this.method.aload(4);
        }

        public void loadNil() {
            this.method.aload(8);
        }

        public void loadNull() {
            this.method.aconst_null();
        }

        public void loadSymbol(String symbol) {
            this.loadRuntime();
            this.method.ldc(symbol);
            this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
        }

        public void loadObject() {
            this.loadRuntime();
            this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
        }

        public void invokeUtilityMethod(String methodName, String signature) {
            this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), methodName, signature);
        }

        public void invokeThreadContext(String methodName, String signature) {
            this.method.invokevirtual(THREADCONTEXT, methodName, signature);
        }

        public void invokeIRuby(String methodName, String signature) {
            this.method.invokevirtual(RUBY, methodName, signature);
        }

        public void invokeIRubyObject(String methodName, String signature) {
            this.method.invokeinterface(IRUBYOBJECT, methodName, signature);
        }

        public void consumeCurrentValue() {
            this.method.pop();
        }

        public void duplicateCurrentValue() {
            this.method.dup();
        }

        public void swapValues() {
            this.method.swap();
        }

        public void retrieveSelf() {
            this.loadSelf();
        }

        public void retrieveSelfClass() {
            this.loadSelf();
            this.metaclass();
        }

        public VariableCompiler getVariableCompiler() {
            return this.variableCompiler;
        }

        public InvocationCompiler getInvocationCompiler() {
            return this.invocationCompiler;
        }

        public void assignConstantInCurrent(String name) {
            this.loadThreadContext();
            this.method.ldc(name);
            this.method.dup2_x1();
            this.method.pop2();
            this.invokeThreadContext("setConstantInCurrent", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void assignConstantInModule(String name) {
            this.method.ldc(name);
            this.loadThreadContext();
            this.invokeUtilityMethod("setConstantInModule", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, String.class, ThreadContext.class));
        }

        public void assignConstantInObject(String name) {
            this.loadRuntime();
            this.invokeIRuby("getObject", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(new Class[0])));
            this.method.swap();
            this.assignConstantInModule(name);
        }

        public void retrieveConstant(String name) {
            this.loadThreadContext();
            this.method.ldc(name);
            this.invokeThreadContext("getConstant", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void retrieveConstantFromModule(String name) {
            this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantFrom", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void retrieveClassVariable(String name) {
            this.loadThreadContext();
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(name);
            this.invokeUtilityMethod("fastFetchClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class)));
        }

        public void assignClassVariable(String name) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.invokeUtilityMethod("fastSetClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        public void declareClassVariable(String name) {
            this.loadThreadContext();
            this.method.swap();
            this.loadRuntime();
            this.method.swap();
            this.loadSelf();
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.invokeUtilityMethod("fastDeclareClassVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, Ruby.class, IRubyObject.class, String.class, IRubyObject.class)));
        }

        public void createNewFloat(double value) {
            this.loadRuntime();
            this.method.ldc(new Double(value));
            this.invokeIRuby("newFloat", CodegenUtils.sig(RubyFloat.class, CodegenUtils.params(Double.TYPE)));
        }

        public void createNewFixnum(long value) {
            this.loadRuntime();
            this.method.ldc(new Long(value));
            this.invokeIRuby("newFixnum", CodegenUtils.sig(RubyFixnum.class, CodegenUtils.params(Long.TYPE)));
        }

        public void createNewBignum(BigInteger value) {
            this.loadRuntime();
            StandardASMCompiler.this.getCacheCompiler().cacheBigInteger(this.method, value);
            this.method.invokestatic(CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(RubyBignum.class, CodegenUtils.params(Ruby.class, BigInteger.class)));
        }

        public void createNewString(ArrayCallback callback, int count) {
            this.loadRuntime();
            this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(new Class[0])));
            for (int i = 0; i < count; ++i) {
                callback.nextValue(this, null, i);
                this.method.invokevirtual(CodegenUtils.p(RubyString.class), "append", CodegenUtils.sig(RubyString.class, CodegenUtils.params(IRubyObject.class)));
            }
        }

        public void createNewSymbol(ArrayCallback callback, int count) {
            this.loadRuntime();
            this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(new Class[0])));
            for (int i = 0; i < count; ++i) {
                callback.nextValue(this, null, i);
                this.method.invokevirtual(CodegenUtils.p(RubyString.class), "append", CodegenUtils.sig(RubyString.class, CodegenUtils.params(IRubyObject.class)));
            }
            this.toJavaString();
            this.loadRuntime();
            this.method.swap();
            this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
        }

        public void createNewString(ByteList value) {
            this.loadRuntime();
            StandardASMCompiler.this.getCacheCompiler().cacheByteList(this.method, value.toString());
            this.invokeIRuby("newStringShared", CodegenUtils.sig(RubyString.class, CodegenUtils.params(ByteList.class)));
        }

        public void createNewSymbol(String name) {
            StandardASMCompiler.this.getCacheCompiler().cacheSymbol(this.method, name);
        }

        public void createNewArray(boolean lightweight) {
            this.loadRuntime();
            this.method.swap();
            if (lightweight) {
                this.invokeIRuby("newArrayNoCopyLight", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject[].class)));
            } else {
                this.invokeIRuby("newArrayNoCopy", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject[].class)));
            }
        }

        public void createEmptyArray() {
            this.loadRuntime();
            this.invokeIRuby("newArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(new Class[0])));
        }

        public void createObjectArray(Object[] sourceArray, ArrayCallback callback) {
            this.buildObjectArray(IRUBYOBJECT, sourceArray, callback);
        }

        public void createObjectArray(int elementCount) {
            if (elementCount >= 6) {
                throw new NotCompilableException("Don't use createObjectArray(int) for more than 5 elements");
            }
            Object[] params = new Class[elementCount];
            Arrays.fill(params, IRubyObject.class);
            this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, (Class[])params));
        }

        private void buildObjectArray(String type, Object[] sourceArray, ArrayCallback callback) {
            if (sourceArray.length == 0) {
                this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            } else if (sourceArray.length <= 5) {
                for (int i = 0; i < sourceArray.length; ++i) {
                    callback.nextValue(this, sourceArray, i);
                }
                this.invokeUtilityMethod("constructObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class, sourceArray.length)));
            } else {
                this.method.ldc(new Integer(sourceArray.length));
                this.method.anewarray(type);
                for (int i = 0; i < sourceArray.length; ++i) {
                    this.method.dup();
                    this.method.ldc(new Integer(i));
                    callback.nextValue(this, sourceArray, i);
                    this.method.arraystore();
                }
            }
        }

        public void createEmptyHash() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
        }

        public void createNewHash(Object elements, ArrayCallback callback, int keyCount) {
            this.loadRuntime();
            if (keyCount <= 3) {
                for (int i = 0; i < keyCount; ++i) {
                    callback.nextValue(this, elements, i);
                }
                this.invokeUtilityMethod("constructHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class, IRubyObject.class, keyCount * 2)));
            } else {
                this.method.invokestatic(CodegenUtils.p(RubyHash.class), "newHash", CodegenUtils.sig(RubyHash.class, CodegenUtils.params(Ruby.class)));
                for (int i = 0; i < keyCount; ++i) {
                    this.method.dup();
                    callback.nextValue(this, elements, i);
                    this.method.invokevirtual(CodegenUtils.p(RubyHash.class), "fastASet", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(IRubyObject.class, IRubyObject.class)));
                }
            }
        }

        public void createNewRange(boolean isExclusive) {
            this.loadRuntime();
            this.loadThreadContext();
            this.method.dup2_x2();
            this.method.pop2();
            this.method.ldc(isExclusive);
            this.method.invokestatic(CodegenUtils.p(RubyRange.class), "newRange", CodegenUtils.sig(RubyRange.class, CodegenUtils.params(Ruby.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, Boolean.TYPE)));
        }

        private void isTrue() {
            this.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
        }

        public void performBooleanBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
            Label afterJmp = new Label();
            Label falseJmp = new Label();
            this.isTrue();
            this.method.ifeq(falseJmp);
            trueBranch.branch(this);
            this.method.go_to(afterJmp);
            this.method.label(falseJmp);
            falseBranch.branch(this);
            this.method.label(afterJmp);
        }

        public void performLogicalAnd(BranchCallback longBranch) {
            Label falseJmp = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifeq(falseJmp);
            this.method.pop();
            longBranch.branch(this);
            this.method.label(falseJmp);
        }

        public void performLogicalOr(BranchCallback longBranch) {
            Label falseJmp = new Label();
            this.method.dup();
            this.isTrue();
            this.method.ifne(falseJmp);
            this.method.pop();
            longBranch.branch(this);
            this.method.label(falseJmp);
        }

        public void performBooleanLoop(BranchCallback condition, BranchCallback body, boolean checkFirst) {
            Label tryBegin = new Label();
            Label tryEnd = new Label();
            Label catchRedo = new Label();
            Label catchNext = new Label();
            Label catchBreak = new Label();
            Label catchRaised = new Label();
            Label endOfBody = new Label();
            Label conditionCheck = new Label();
            Label topOfBody = new Label();
            Label done = new Label();
            Label normalLoopEnd = new Label();
            this.method.trycatch(tryBegin, tryEnd, catchRedo, CodegenUtils.p(JumpException.RedoJump.class));
            this.method.trycatch(tryBegin, tryEnd, catchNext, CodegenUtils.p(JumpException.NextJump.class));
            this.method.trycatch(tryBegin, tryEnd, catchBreak, CodegenUtils.p(JumpException.BreakJump.class));
            if (checkFirst) {
                this.method.trycatch(tryBegin, tryEnd, catchRaised, CodegenUtils.p(RaiseException.class));
            }
            this.method.label(tryBegin);
            Label[] oldLoopLabels = this.currentLoopLabels;
            this.currentLoopLabels = new Label[]{endOfBody, topOfBody, done};
            if (checkFirst) {
                this.method.go_to(conditionCheck);
            }
            this.method.label(topOfBody);
            body.branch(this);
            this.method.label(endOfBody);
            this.method.pop();
            this.method.label(conditionCheck);
            condition.branch(this);
            this.isTrue();
            this.method.ifne(topOfBody);
            this.currentLoopLabels = oldLoopLabels;
            this.method.label(tryEnd);
            this.method.go_to(normalLoopEnd);
            this.method.label(catchRedo);
            this.method.pop();
            this.method.go_to(topOfBody);
            this.method.label(catchNext);
            this.method.pop();
            this.method.go_to(conditionCheck);
            this.method.label(catchBreak);
            this.loadBlock();
            this.invokeUtilityMethod("breakJumpInWhile", CodegenUtils.sig(IRubyObject.class, JumpException.BreakJump.class, Block.class));
            this.method.go_to(done);
            if (checkFirst) {
                this.method.label(catchRaised);
                Label raiseNext = new Label();
                Label raiseRedo = new Label();
                Label raiseRethrow = new Label();
                this.method.dup();
                this.invokeUtilityMethod("getLocalJumpTypeOrRethrow", CodegenUtils.sig(String.class, CodegenUtils.params(RaiseException.class)));
                this.method.dup();
                this.method.ldc("break");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(raiseNext);
                this.method.pop();
                this.invokeUtilityMethod("unwrapLocalJumpErrorValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(RaiseException.class)));
                this.method.go_to(done);
                this.method.label(raiseNext);
                this.method.dup();
                this.method.ldc("next");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(raiseRedo);
                this.method.pop2();
                this.method.go_to(conditionCheck);
                this.method.label(raiseRedo);
                this.method.dup();
                this.method.ldc("redo");
                this.method.invokevirtual(CodegenUtils.p(String.class), "equals", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(Object.class)));
                this.method.ifeq(raiseRethrow);
                this.method.pop2();
                this.method.go_to(topOfBody);
                this.method.label(raiseRethrow);
                this.method.pop();
                this.method.athrow();
            }
            this.method.label(normalLoopEnd);
            this.loadNil();
            this.method.label(done);
        }

        public void createNewClosure(int line, StaticScope scope, int arity, CompilerCallback body, CompilerCallback args, boolean hasMultipleArgsHead, NodeType argsNodeId, ASTInspector inspector) {
            String closureMethodName = "closure_" + line + "_" + ++StandardASMCompiler.this.innerIndex;
            String closureFieldName = "_" + closureMethodName;
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, closureFieldName, inspector);
            closureCompiler.beginMethod(args, scope);
            body.call(closureCompiler);
            closureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(closureMethodName);
            this.method.aload(0);
            this.method.invokevirtual(CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.label(alreadyCreated);
            this.loadThreadContext();
            this.loadSelf();
            this.method.ldc(new Integer(arity));
            StandardASMCompiler.this.buildStaticScopeNames(this.method, scope);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.ldc(hasMultipleArgsHead);
            this.method.ldc(BlockBody.asArgumentType(argsNodeId));
            this.method.ldc(!inspector.hasClosure() && !inspector.hasScopeAwareMethods());
            this.invokeUtilityMethod("createBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, String[].class, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE, Boolean.TYPE)));
        }

        public void runBeginBlock(StaticScope scope, CompilerCallback body) {
            String closureMethodName = "closure" + ++StandardASMCompiler.this.innerIndex;
            String closureFieldName = "_" + closureMethodName;
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, closureFieldName, null);
            closureCompiler.beginMethod(null, scope);
            body.call(closureCompiler);
            closureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(closureMethodName);
            this.method.aload(0);
            this.method.invokevirtual(CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.label(alreadyCreated);
            this.loadThreadContext();
            this.loadSelf();
            StandardASMCompiler.this.buildStaticScopeNames(this.method, scope);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            this.invokeUtilityMethod("runBeginBlock", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, String[].class, CompiledBlockCallback.class)));
        }

        public void createNewForLoop(int arity, CompilerCallback body, CompilerCallback args, boolean hasMultipleArgsHead, NodeType argsNodeId) {
            String closureMethodName = "closure" + ++StandardASMCompiler.this.innerIndex;
            String closureFieldName = "_" + closureMethodName;
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, closureFieldName, null);
            closureCompiler.beginMethod(args, null);
            body.call(closureCompiler);
            closureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(closureMethodName);
            this.method.aload(0);
            this.method.invokevirtual(CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.label(alreadyCreated);
            this.loadThreadContext();
            this.loadSelf();
            this.method.ldc(new Integer(arity));
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.ldc(hasMultipleArgsHead);
            this.method.ldc(BlockBody.asArgumentType(argsNodeId));
            this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
        }

        public void createNewEndBlock(CompilerCallback body) {
            String closureMethodName = "END_closure" + ++StandardASMCompiler.this.innerIndex;
            String closureFieldName = "_" + closureMethodName;
            ASMClosureCompiler closureCompiler = new ASMClosureCompiler(closureMethodName, closureFieldName, null);
            closureCompiler.beginMethod(null, null);
            body.call(closureCompiler);
            closureCompiler.endMethod();
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            this.method.aload(0);
            this.getCallbackFactory();
            this.method.ldc(closureMethodName);
            this.method.aload(0);
            this.method.invokevirtual(CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(CompiledBlockCallback.class, CodegenUtils.params(String.class, Object.class)));
            this.method.putfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.label(alreadyCreated);
            this.loadThreadContext();
            this.loadSelf();
            this.method.ldc(new Integer(0));
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
            this.method.ldc(false);
            this.method.ldc(0);
            this.invokeUtilityMethod("createSharedScopeBlock", CodegenUtils.sig(Block.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, CompiledBlockCallback.class, Boolean.TYPE, Integer.TYPE)));
            this.loadRuntime();
            this.invokeUtilityMethod("registerEndBlock", CodegenUtils.sig(Void.TYPE, Block.class, Ruby.class));
            this.loadNil();
        }

        private void getCallbackFactory() {
            this.loadRuntime();
            this.getCompiledClass();
            this.method.dup();
            this.method.invokevirtual(CodegenUtils.p(Class.class), "getClassLoader", CodegenUtils.sig(ClassLoader.class));
            this.method.invokestatic(CodegenUtils.p(CallbackFactory.class), "createFactory", CodegenUtils.sig(CallbackFactory.class, CodegenUtils.params(Ruby.class, Class.class, ClassLoader.class)));
        }

        public void getCompiledClass() {
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, "$class", CodegenUtils.ci(Class.class));
        }

        private void getRubyClass() {
            this.loadThreadContext();
            this.invokeThreadContext("getRubyClass", CodegenUtils.sig(RubyModule.class));
        }

        public void println() {
            this.method.dup();
            this.method.getstatic(CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(PrintStream.class), "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
        }

        public void defineAlias(String newName, String oldName) {
            this.loadThreadContext();
            this.method.ldc(newName);
            this.method.ldc(oldName);
            this.invokeUtilityMethod("defineAlias", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, String.class));
        }

        public void loadFalse() {
            this.loadRuntime();
            this.invokeIRuby("getFalse", CodegenUtils.sig(RubyBoolean.class));
        }

        public void loadTrue() {
            this.loadRuntime();
            this.invokeIRuby("getTrue", CodegenUtils.sig(RubyBoolean.class));
        }

        public void loadCurrentModule() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentScope", CodegenUtils.sig(DynamicScope.class));
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getStaticScope", CodegenUtils.sig(StaticScope.class));
            this.method.invokevirtual(CodegenUtils.p(StaticScope.class), "getModule", CodegenUtils.sig(RubyModule.class));
        }

        public void retrieveInstanceVariable(String name) {
            this.loadRuntime();
            this.loadSelf();
            this.method.ldc(name);
            this.invokeUtilityMethod("fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, Ruby.class, IRubyObject.class, String.class));
        }

        public void assignInstanceVariable(String name) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class));
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastSetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void retrieveGlobalVariable(String name) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "get", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void assignGlobalVariable(String name) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
            this.method.swap();
            this.method.ldc(name);
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "set", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
        }

        public void negateCurrentValue() {
            this.loadRuntime();
            this.invokeUtilityMethod("negate", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Ruby.class));
        }

        public void splatCurrentValue() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(ASTInterpreter.class), "splatValue", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class, Ruby.class)));
        }

        public void singlifySplattedValue() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(ASTInterpreter.class), "aValueSplat", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, Ruby.class)));
        }

        public void aryToAry() {
            this.loadRuntime();
            this.method.invokestatic(CodegenUtils.p(ASTInterpreter.class), "aryToAry", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, Ruby.class)));
        }

        public void ensureRubyArray() {
            this.invokeUtilityMethod("ensureRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void ensureMultipleAssignableRubyArray(boolean masgnHasHead) {
            this.loadRuntime();
            this.method.swap();
            this.method.ldc(new Boolean(masgnHasHead));
            this.invokeUtilityMethod("ensureMultipleAssignableRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(Ruby.class, IRubyObject.class, Boolean.TYPE)));
        }

        public void forEachInValueArray(int start, int count, Object source, ArrayCallback callback, ArrayCallback nilCallback, CompilerCallback argsCallback) {
            while (start < count) {
                Label noMoreArrayElements = new Label();
                Label doneWithElement = new Label();
                this.method.dup();
                this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "getLength", CodegenUtils.sig(Integer.TYPE));
                this.method.ldc(new Integer(start));
                this.method.if_icmple(noMoreArrayElements);
                this.method.dup();
                this.method.ldc(new Integer(start));
                this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "entry", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE)));
                callback.nextValue(this, source, start);
                this.method.go_to(doneWithElement);
                this.method.label(noMoreArrayElements);
                nilCallback.nextValue(this, source, start);
                this.method.label(doneWithElement);
                this.method.pop();
                ++start;
            }
            if (argsCallback != null) {
                Label emptyArray = new Label();
                Label readyForArgs = new Label();
                this.method.dup();
                this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "getLength", CodegenUtils.sig(Integer.TYPE));
                this.method.ldc(new Integer(start));
                this.method.if_icmple(emptyArray);
                this.method.dup();
                this.method.ldc(start);
                this.invokeUtilityMethod("createSubarray", CodegenUtils.sig(RubyArray.class, RubyArray.class, Integer.TYPE));
                this.method.go_to(readyForArgs);
                this.method.label(emptyArray);
                this.createEmptyArray();
                this.method.label(readyForArgs);
                argsCallback.call(this);
                this.method.pop();
            }
        }

        public void asString() {
            this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(new Class[0])));
        }

        public void toJavaString() {
            this.method.invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class));
        }

        public void nthRef(int match) {
            this.method.ldc(new Integer(match));
            this.backref();
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "nth_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class)));
        }

        public void match() {
            this.loadThreadContext();
            this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match2", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
        }

        public void match2() {
            this.loadThreadContext();
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(RubyRegexp.class), "op_match", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
        }

        public void match3() {
            this.loadThreadContext();
            this.invokeUtilityMethod("match3", CodegenUtils.sig(IRubyObject.class, RubyRegexp.class, IRubyObject.class, ThreadContext.class));
        }

        public void createNewRegexp(ByteList value, int options) {
            String regexpField = StandardASMCompiler.this.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
            Label alreadyCreated = new Label();
            this.method.ifnonnull(alreadyCreated);
            String regexpString = value.toString();
            this.loadRuntime();
            this.method.ldc(regexpString);
            this.method.ldc(new Integer(options));
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, String.class, Integer.TYPE)));
            this.method.aload(0);
            this.method.swap();
            this.method.putfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
            this.method.label(alreadyCreated);
            this.method.aload(0);
            this.method.getfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
        }

        public void createNewRegexp(CompilerCallback createStringCallback, int options) {
            boolean onceOnly = (options & 0x80) != 0;
            Label alreadyCreated = null;
            String regexpField = null;
            if (onceOnly) {
                regexpField = StandardASMCompiler.this.getNewConstant(CodegenUtils.ci(RubyRegexp.class), "lit_reg_");
                this.method.aload(0);
                this.method.getfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
                alreadyCreated = new Label();
                this.method.ifnonnull(alreadyCreated);
            }
            this.loadRuntime();
            createStringCallback.call(this);
            this.method.invokevirtual(CodegenUtils.p(RubyString.class), "getByteList", CodegenUtils.sig(ByteList.class));
            this.method.ldc(new Integer(options));
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), "newRegexp", CodegenUtils.sig(RubyRegexp.class, CodegenUtils.params(Ruby.class, ByteList.class, Integer.TYPE)));
            if (onceOnly) {
                this.method.aload(0);
                this.method.swap();
                this.method.putfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
                this.method.label(alreadyCreated);
                this.method.aload(0);
                this.method.getfield(StandardASMCompiler.this.classname, regexpField, CodegenUtils.ci(RubyRegexp.class));
            }
        }

        public void pollThreadEvents() {
            if (!RubyInstanceConfig.THREADLESS_COMPILE_ENABLED) {
                this.loadThreadContext();
                this.invokeThreadContext("pollThreadEvents", CodegenUtils.sig(Void.TYPE));
            }
        }

        public void nullToNil() {
            Label notNull = new Label();
            this.method.dup();
            this.method.ifnonnull(notNull);
            this.method.pop();
            this.method.aload(8);
            this.method.label(notNull);
        }

        public void isInstanceOf(Class clazz, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.method.instance_of(CodegenUtils.p(clazz));
            Label falseJmp = new Label();
            Label afterJmp = new Label();
            this.method.ifeq(falseJmp);
            trueBranch.branch(this);
            this.method.go_to(afterJmp);
            this.method.label(falseJmp);
            falseBranch.branch(this);
            this.method.label(afterJmp);
        }

        public void isCaptured(final int number, final BranchCallback trueBranch, final BranchCallback falseBranch) {
            this.backref();
            this.method.dup();
            this.isInstanceOf(RubyMatchData.class, new BranchCallback(){

                public void branch(MethodCompiler context) {
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyMatchData.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "use", CodegenUtils.sig(Void.TYPE));
                    AbstractMethodCompiler.this.method.ldc(new Long(number));
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyMatchData.class), "group", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Long.TYPE)));
                    AbstractMethodCompiler.this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE));
                    Label isNil = new Label();
                    Label after = new Label();
                    AbstractMethodCompiler.this.method.ifne(isNil);
                    trueBranch.branch(context);
                    AbstractMethodCompiler.this.method.go_to(after);
                    AbstractMethodCompiler.this.method.label(isNil);
                    falseBranch.branch(context);
                    AbstractMethodCompiler.this.method.label(after);
                }
            }, new BranchCallback(){

                public void branch(MethodCompiler context) {
                    AbstractMethodCompiler.this.method.pop();
                    falseBranch.branch(context);
                }
            });
        }

        public void branchIfModule(CompilerCallback receiverCallback, BranchCallback moduleCallback, BranchCallback notModuleCallback) {
            receiverCallback.call(this);
            this.isInstanceOf(RubyModule.class, moduleCallback, notModuleCallback);
        }

        public void backref() {
            this.loadThreadContext();
            this.invokeThreadContext("getCurrentFrame", CodegenUtils.sig(Frame.class));
            this.method.invokevirtual(CodegenUtils.p(Frame.class), "getBackRef", CodegenUtils.sig(IRubyObject.class));
        }

        public void backrefMethod(String methodName) {
            this.backref();
            this.method.invokestatic(CodegenUtils.p(RubyRegexp.class), methodName, CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void issueLoopBreak() {
            this.method.go_to(this.currentLoopLabels[2]);
        }

        public void issueLoopNext() {
            this.method.go_to(this.currentLoopLabels[0]);
        }

        public void issueLoopRedo() {
            this.method.go_to(this.currentLoopLabels[1]);
        }

        protected String getNewEnsureName() {
            return "__ensure_" + StandardASMCompiler.this.ensureNumber++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void protect(BranchCallback regularCode, BranchCallback protectedCode, Class ret) {
            String mname = this.getNewEnsureName();
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class), null, null));
            SkinnyMethodAdapter old_method = null;
            SkinnyMethodAdapter var_old_method = null;
            SkinnyMethodAdapter inv_old_method = null;
            boolean oldWithinProtection = this.withinProtection;
            this.withinProtection = true;
            try {
                old_method = this.method;
                var_old_method = this.getVariableCompiler().getMethodAdapter();
                inv_old_method = this.getInvocationCompiler().getMethodAdapter();
                this.method = mv;
                this.getVariableCompiler().setMethodAdapter(mv);
                this.getInvocationCompiler().setMethodAdapter(mv);
                mv.visitCode();
                mv.aload(1);
                mv.dup();
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
                mv.dup();
                mv.astore(6);
                mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class));
                mv.astore(8);
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class));
                mv.dup();
                mv.astore(5);
                mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
                mv.astore(7);
                Label codeBegin = new Label();
                Label codeEnd = new Label();
                Label ensureBegin = new Label();
                Label ensureEnd = new Label();
                this.method.label(codeBegin);
                regularCode.branch(this);
                this.method.label(codeEnd);
                protectedCode.branch(this);
                mv.areturn();
                this.method.label(ensureBegin);
                this.method.astore(9);
                this.method.label(ensureEnd);
                protectedCode.branch(this);
                this.method.aload(9);
                this.method.athrow();
                this.method.trycatch(codeBegin, codeEnd, ensureBegin, null);
                this.method.trycatch(ensureBegin, ensureEnd, ensureBegin, null);
                mv.visitMaxs(1, 1);
                mv.visitEnd();
                Object var15_14 = null;
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
                this.withinProtection = oldWithinProtection;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
                this.withinProtection = oldWithinProtection;
                throw throwable;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.aload(3);
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }

        protected String getNewRescueName() {
            return "__rescue_" + StandardASMCompiler.this.rescueNumber++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rescue(BranchCallback regularCode, Class exception, BranchCallback catchCode, Class ret) {
            String mname = this.getNewRescueName();
            SkinnyMethodAdapter mv = new SkinnyMethodAdapter(StandardASMCompiler.this.getClassVisitor().visitMethod(4097, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class), null, null));
            SkinnyMethodAdapter old_method = null;
            SkinnyMethodAdapter var_old_method = null;
            SkinnyMethodAdapter inv_old_method = null;
            Label afterMethodBody = new Label();
            Label catchRetry = new Label();
            Label catchRaised = new Label();
            Label catchJumps = new Label();
            Label exitRescue = new Label();
            boolean oldWithinProtection = this.withinProtection;
            this.withinProtection = true;
            try {
                old_method = this.method;
                var_old_method = this.getVariableCompiler().getMethodAdapter();
                inv_old_method = this.getInvocationCompiler().getMethodAdapter();
                this.method = mv;
                this.getVariableCompiler().setMethodAdapter(mv);
                this.getInvocationCompiler().setMethodAdapter(mv);
                mv.visitCode();
                mv.aload(1);
                mv.dup();
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getRuntime", CodegenUtils.sig(Ruby.class));
                mv.dup();
                mv.astore(6);
                this.loadRuntime();
                this.invokeUtilityMethod("getErrorInfo", CodegenUtils.sig(IRubyObject.class, Ruby.class));
                mv.astore(10);
                mv.invokevirtual(CodegenUtils.p(Ruby.class), "getNil", CodegenUtils.sig(IRubyObject.class));
                mv.astore(8);
                mv.invokevirtual(CodegenUtils.p(ThreadContext.class), "getCurrentScope", CodegenUtils.sig(DynamicScope.class));
                mv.dup();
                mv.astore(5);
                mv.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValues", CodegenUtils.sig(IRubyObject[].class));
                mv.astore(7);
                Label beforeBody = new Label();
                Label afterBody = new Label();
                Label catchBlock = new Label();
                mv.visitTryCatchBlock(beforeBody, afterBody, catchBlock, CodegenUtils.p(exception));
                mv.visitLabel(beforeBody);
                regularCode.branch(this);
                mv.label(afterBody);
                mv.go_to(exitRescue);
                mv.label(catchBlock);
                mv.astore(9);
                catchCode.branch(this);
                mv.label(afterMethodBody);
                mv.go_to(exitRescue);
                mv.trycatch(catchBlock, afterMethodBody, catchRetry, CodegenUtils.p(JumpException.RetryJump.class));
                mv.label(catchRetry);
                mv.pop();
                mv.go_to(beforeBody);
                mv.trycatch(beforeBody, afterMethodBody, catchRaised, CodegenUtils.p(RaiseException.class));
                mv.label(catchRaised);
                mv.athrow();
                mv.trycatch(beforeBody, afterMethodBody, catchJumps, CodegenUtils.p(JumpException.class));
                mv.label(catchJumps);
                this.loadRuntime();
                mv.aload(10);
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.athrow();
                mv.label(exitRescue);
                this.loadRuntime();
                mv.aload(10);
                this.invokeUtilityMethod("setErrorInfo", CodegenUtils.sig(Void.TYPE, Ruby.class, IRubyObject.class));
                mv.areturn();
                mv.visitMaxs(1, 1);
                mv.visitEnd();
                Object var20_19 = null;
                this.withinProtection = oldWithinProtection;
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                this.withinProtection = oldWithinProtection;
                this.method = old_method;
                this.getVariableCompiler().setMethodAdapter(var_old_method);
                this.getInvocationCompiler().setMethodAdapter(inv_old_method);
                throw throwable;
            }
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.aload(3);
            if (this instanceof ASMClosureCompiler) {
                this.pushNull();
            } else {
                this.loadBlock();
            }
            this.method.invokevirtual(StandardASMCompiler.this.classname, mname, CodegenUtils.sig(ret, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }

        public void inDefined() {
            this.method.aload(1);
            this.method.iconst_1();
            this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
        }

        public void outDefined() {
            this.method.aload(1);
            this.method.iconst_0();
            this.invokeThreadContext("setWithinDefined", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Boolean.TYPE)));
        }

        public void stringOrNil() {
            this.loadRuntime();
            this.loadNil();
            this.invokeUtilityMethod("stringOrNil", CodegenUtils.sig(IRubyObject.class, String.class, Ruby.class, IRubyObject.class));
        }

        public void pushNull() {
            this.method.aconst_null();
        }

        public void pushString(String str) {
            this.method.ldc(str);
        }

        public void isMethodBound(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.metaclass();
            this.method.ldc(name);
            this.method.iconst_0();
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        public void hasBlock(BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadBlock();
            this.method.invokevirtual(CodegenUtils.p(Block.class), "isGiven", CodegenUtils.sig(Boolean.TYPE));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        public void isGlobalDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "isDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        public void isConstantDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadThreadContext();
            this.method.ldc(name);
            this.invokeThreadContext("getConstantDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        public void isInstanceVariableDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.loadSelf();
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class));
            this.method.ldc(name);
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastHasInstanceVariable", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label trueLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifne(trueLabel);
            falseBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(trueLabel);
            trueBranch.branch(this);
            this.method.label(exitLabel);
        }

        public void isClassVarDefined(String name, BranchCallback trueBranch, BranchCallback falseBranch) {
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            Label trueLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifne(trueLabel);
            falseBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(trueLabel);
            trueBranch.branch(this);
            this.method.label(exitLabel);
        }

        public Object getNewEnding() {
            return new Label();
        }

        public void isNil(BranchCallback trueBranch, BranchCallback falseBranch) {
            this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "isNil", CodegenUtils.sig(Boolean.TYPE));
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifeq(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        public void isNull(BranchCallback trueBranch, BranchCallback falseBranch) {
            Label falseLabel = new Label();
            Label exitLabel = new Label();
            this.method.ifnonnull(falseLabel);
            trueBranch.branch(this);
            this.method.go_to(exitLabel);
            this.method.label(falseLabel);
            falseBranch.branch(this);
            this.method.label(exitLabel);
        }

        public void ifNull(Object gotoToken) {
            this.method.ifnull((Label)gotoToken);
        }

        public void ifNotNull(Object gotoToken) {
            this.method.ifnonnull((Label)gotoToken);
        }

        public void setEnding(Object endingToken) {
            this.method.label((Label)endingToken);
        }

        public void go(Object gotoToken) {
            this.method.go_to((Label)gotoToken);
        }

        public void isConstantBranch(final BranchCallback setup, final BranchCallback isConstant, final BranchCallback isMethod, final BranchCallback none, final String name) {
            this.rescue(new BranchCallback(){

                public void branch(MethodCompiler context) {
                    setup.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.instance_of(CodegenUtils.p(RubyModule.class));
                    Label falseJmp = new Label();
                    Label afterJmp = new Label();
                    Label nextJmp = new Label();
                    Label nextJmpPop = new Label();
                    AbstractMethodCompiler.this.method.ifeq(nextJmp);
                    AbstractMethodCompiler.this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ldc(name);
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastGetConstantAt", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
                    AbstractMethodCompiler.this.method.dup();
                    AbstractMethodCompiler.this.method.ifnull(nextJmpPop);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.pop();
                    isConstant.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(afterJmp);
                    AbstractMethodCompiler.this.method.label(nextJmpPop);
                    AbstractMethodCompiler.this.method.pop();
                    AbstractMethodCompiler.this.method.label(nextJmp);
                    AbstractMethodCompiler.this.metaclass();
                    AbstractMethodCompiler.this.method.ldc(name);
                    AbstractMethodCompiler.this.method.iconst_1();
                    AbstractMethodCompiler.this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
                    AbstractMethodCompiler.this.method.ifeq(falseJmp);
                    isMethod.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.go_to(afterJmp);
                    AbstractMethodCompiler.this.method.label(falseJmp);
                    none.branch(AbstractMethodCompiler.this);
                    AbstractMethodCompiler.this.method.label(afterJmp);
                }
            }, JumpException.class, none, String.class);
        }

        public void metaclass() {
            this.invokeIRubyObject("getMetaClass", CodegenUtils.sig(RubyClass.class));
        }

        public void getVisibilityFor(String name) {
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "searchMethod", CodegenUtils.sig(DynamicMethod.class, CodegenUtils.params(String.class)));
            this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "getVisibility", CodegenUtils.sig(Visibility.class));
        }

        public void isPrivate(Object gotoToken, int toConsume) {
            this.method.invokevirtual(CodegenUtils.p(Visibility.class), "isPrivate", CodegenUtils.sig(Boolean.TYPE));
            Label temp = new Label();
            this.method.ifeq(temp);
            while (toConsume-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)gotoToken);
            this.method.label(temp);
        }

        public void isNotProtected(Object gotoToken, int toConsume) {
            this.method.invokevirtual(CodegenUtils.p(Visibility.class), "isProtected", CodegenUtils.sig(Boolean.TYPE));
            Label temp = new Label();
            this.method.ifne(temp);
            while (toConsume-- > 0) {
                this.method.pop();
            }
            this.method.go_to((Label)gotoToken);
            this.method.label(temp);
        }

        public void selfIsKindOf(Object gotoToken) {
            this.method.invokevirtual(CodegenUtils.p(RubyClass.class), "getRealClass", CodegenUtils.sig(RubyClass.class));
            this.loadSelf();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
            this.method.ifne((Label)gotoToken);
        }

        public void notIsModuleAndClassVarDefined(String name, Object gotoToken) {
            this.method.dup();
            this.method.instance_of(CodegenUtils.p(RubyModule.class));
            Label falsePopJmp = new Label();
            Label successJmp = new Label();
            this.method.ifeq(falsePopJmp);
            this.method.visitTypeInsn(192, CodegenUtils.p(RubyModule.class));
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "fastIsClassVarDefined", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class)));
            this.method.ifeq((Label)gotoToken);
            this.method.go_to(successJmp);
            this.method.label(falsePopJmp);
            this.method.pop();
            this.method.go_to((Label)gotoToken);
            this.method.label(successJmp);
        }

        public void ifSingleton(Object gotoToken) {
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isSingleton", CodegenUtils.sig(Boolean.TYPE));
            this.method.ifne((Label)gotoToken);
        }

        public void getInstanceVariable(String name) {
            this.method.ldc(name);
            this.invokeIRubyObject("getInstanceVariables", CodegenUtils.sig(InstanceVariables.class));
            this.method.invokeinterface(CodegenUtils.p(InstanceVariables.class), "fastGetInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        }

        public void getFrameName() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameName", CodegenUtils.sig(String.class));
        }

        public void getFrameKlazz() {
            this.loadThreadContext();
            this.invokeThreadContext("getFrameKlazz", CodegenUtils.sig(RubyModule.class));
        }

        public void superClass() {
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "getSuperClass", CodegenUtils.sig(RubyClass.class));
        }

        public void attached() {
            this.method.visitTypeInsn(192, CodegenUtils.p(MetaClass.class));
            this.method.invokevirtual(CodegenUtils.p(MetaClass.class), "getAttached", CodegenUtils.sig(IRubyObject.class));
        }

        public void ifNotSuperMethodBound(Object token) {
            this.method.swap();
            this.method.iconst_0();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isMethodBound", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(String.class, Boolean.TYPE)));
            this.method.ifeq((Label)token);
        }

        public void concatArrays() {
            this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "concat", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void concatObjectArrays() {
            this.invokeUtilityMethod("concatObjectArrays", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject[].class)));
        }

        public void appendToArray() {
            this.method.invokevirtual(CodegenUtils.p(RubyArray.class), "append", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
        }

        public void appendToObjectArray() {
            this.invokeUtilityMethod("appendToObjectArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject[].class, IRubyObject.class)));
        }

        public void convertToJavaArray() {
            this.method.invokestatic(CodegenUtils.p(ArgsUtil.class), "convertToJavaArray", CodegenUtils.sig(IRubyObject[].class, CodegenUtils.params(IRubyObject.class)));
        }

        public void aliasGlobal(String newName, String oldName) {
            this.loadRuntime();
            this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
            this.method.ldc(newName);
            this.method.ldc(oldName);
            this.method.invokevirtual(CodegenUtils.p(GlobalVariables.class), "alias", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class, String.class)));
            this.loadNil();
        }

        public void undefMethod(String name) {
            this.loadThreadContext();
            this.invokeThreadContext("getRubyClass", CodegenUtils.sig(RubyModule.class));
            Label notNull = new Label();
            this.method.dup();
            this.method.ifnonnull(notNull);
            this.method.pop();
            this.loadRuntime();
            this.method.ldc("No class to undef method '" + name + "'.");
            this.invokeIRuby("newTypeError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(String.class)));
            this.method.athrow();
            this.method.label(notNull);
            this.loadThreadContext();
            this.method.ldc(name);
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "undef", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(ThreadContext.class, String.class)));
            this.loadNil();
        }

        public void defineClass(final String name, final StaticScope staticScope, final CompilerCallback superCallback, final CompilerCallback pathCallback, CompilerCallback bodyCallback, final CompilerCallback receiverCallback) {
            String methodName = "rubyclass__" + JavaNameMangler.mangleStringForCleanJavaIdentifier(name) + "__" + ++StandardASMCompiler.this.methodIndex;
            final ASMMethodCompiler methodCompiler = new ASMMethodCompiler(methodName, null);
            CompilerCallback bodyPrep = new CompilerCallback(){

                public void call(MethodCompiler context) {
                    if (receiverCallback == null) {
                        if (superCallback != null) {
                            methodCompiler.loadRuntime();
                            superCallback.call(methodCompiler);
                            methodCompiler.invokeUtilityMethod("prepareSuperClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                        } else {
                            methodCompiler.method.aconst_null();
                        }
                        methodCompiler.loadThreadContext();
                        pathCallback.call(methodCompiler);
                        methodCompiler.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                        methodCompiler.method.swap();
                        methodCompiler.method.ldc(name);
                        methodCompiler.method.swap();
                        methodCompiler.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetClassUnder", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(String.class, RubyClass.class)));
                    } else {
                        methodCompiler.loadRuntime();
                        methodCompiler.method.aload(3);
                        methodCompiler.method.iconst_0();
                        methodCompiler.method.arrayload();
                        methodCompiler.invokeUtilityMethod("getSingletonClass", CodegenUtils.sig(RubyClass.class, CodegenUtils.params(Ruby.class, IRubyObject.class)));
                    }
                    methodCompiler.method.dup();
                    methodCompiler.method.astore(2);
                    methodCompiler.loadThreadContext();
                    methodCompiler.method.swap();
                    StandardASMCompiler.this.buildStaticScopeNames(methodCompiler.method, staticScope);
                    methodCompiler.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
                }
            };
            Label start = new Label();
            Label end = new Label();
            Label after = new Label();
            Label noException = new Label();
            methodCompiler.method.trycatch(start, end, after, null);
            methodCompiler.beginClass(bodyPrep, staticScope);
            methodCompiler.method.label(start);
            bodyCallback.call(methodCompiler);
            methodCompiler.method.label(end);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            methodCompiler.method.go_to(noException);
            methodCompiler.method.label(after);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            methodCompiler.method.athrow();
            methodCompiler.method.label(noException);
            methodCompiler.endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            if (receiverCallback == null) {
                this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            } else {
                receiverCallback.call(this);
                this.createObjectArray(1);
            }
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, METHOD_SIGNATURE);
        }

        public void defineModule(final String name, final StaticScope staticScope, final CompilerCallback pathCallback, CompilerCallback bodyCallback) {
            String methodName = "rubyclass__" + JavaNameMangler.mangleStringForCleanJavaIdentifier(name) + "__" + ++StandardASMCompiler.this.methodIndex;
            final ASMMethodCompiler methodCompiler = new ASMMethodCompiler(methodName, null);
            CompilerCallback bodyPrep = new CompilerCallback(){

                public void call(MethodCompiler context) {
                    methodCompiler.loadThreadContext();
                    pathCallback.call(methodCompiler);
                    methodCompiler.invokeUtilityMethod("prepareClassNamespace", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class)));
                    methodCompiler.method.ldc(name);
                    methodCompiler.method.invokevirtual(CodegenUtils.p(RubyModule.class), "defineOrGetModuleUnder", CodegenUtils.sig(RubyModule.class, CodegenUtils.params(String.class)));
                    methodCompiler.method.dup();
                    methodCompiler.method.astore(2);
                    methodCompiler.loadThreadContext();
                    methodCompiler.method.swap();
                    StandardASMCompiler.this.buildStaticScopeNames(methodCompiler.method, staticScope);
                    methodCompiler.invokeThreadContext("preCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(RubyModule.class, String[].class)));
                }
            };
            Label start = new Label();
            Label end = new Label();
            Label after = new Label();
            Label noException = new Label();
            methodCompiler.method.trycatch(start, end, after, null);
            methodCompiler.beginClass(bodyPrep, staticScope);
            methodCompiler.method.label(start);
            bodyCallback.call(methodCompiler);
            methodCompiler.method.label(end);
            methodCompiler.method.go_to(noException);
            methodCompiler.method.label(after);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            methodCompiler.method.athrow();
            methodCompiler.method.label(noException);
            methodCompiler.loadThreadContext();
            methodCompiler.invokeThreadContext("postCompiledClass", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(new Class[0])));
            methodCompiler.endMethod();
            this.method.aload(0);
            this.loadThreadContext();
            this.loadSelf();
            this.method.getstatic(CodegenUtils.p(IRubyObject.class), "NULL_ARRAY", CodegenUtils.ci(IRubyObject[].class));
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            this.method.invokevirtual(StandardASMCompiler.this.classname, methodName, METHOD_SIGNATURE);
        }

        public void unwrapPassedBlock() {
            this.loadBlock();
            this.invokeUtilityMethod("getBlockFromBlockPassBody", CodegenUtils.sig(Block.class, CodegenUtils.params(IRubyObject.class, Block.class)));
        }

        public void performBackref(char type) {
            this.loadThreadContext();
            switch (type) {
                case '~': {
                    this.invokeUtilityMethod("backref", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '&': {
                    this.invokeUtilityMethod("backrefLastMatch", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '`': {
                    this.invokeUtilityMethod("backrefMatchPre", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '\'': {
                    this.invokeUtilityMethod("backrefMatchPost", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                case '+': {
                    this.invokeUtilityMethod("backrefMatchLast", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class)));
                    break;
                }
                default: {
                    throw new NotCompilableException("ERROR: backref with invalid type");
                }
            }
        }

        public void callZSuper(CompilerCallback closure) {
            this.loadRuntime();
            this.loadThreadContext();
            if (closure != null) {
                closure.call(this);
            } else {
                this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
            }
            this.loadSelf();
            this.invokeUtilityMethod("callZSuper", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, ThreadContext.class, Block.class, IRubyObject.class)));
        }

        public void checkIsExceptionHandled() {
            this.loadRuntime();
            this.loadThreadContext();
            this.loadSelf();
            this.invokeUtilityMethod("isExceptionHandled", CodegenUtils.sig(IRubyObject.class, RubyException.class, IRubyObject[].class, Ruby.class, ThreadContext.class, IRubyObject.class));
        }

        public void rethrowException() {
            this.loadException();
            this.method.athrow();
        }

        public void loadClass(String name) {
            this.loadRuntime();
            this.method.ldc(name);
            this.invokeIRuby("getClass", CodegenUtils.sig(RubyClass.class, String.class));
        }

        public void unwrapRaiseException() {
            this.method.invokevirtual(CodegenUtils.p(RaiseException.class), "getException", CodegenUtils.sig(RubyException.class));
        }

        public void loadException() {
            this.method.aload(9);
        }

        public void setFilePosition(ISourcePosition position) {
            if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
                this.loadThreadContext();
                this.method.ldc(position.getFile());
                this.invokeThreadContext("setFile", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class)));
            }
        }

        public void setLinePosition(ISourcePosition position) {
            if (!RubyInstanceConfig.POSITIONLESS_COMPILE_ENABLED) {
                this.setFilePosition(position);
                this.loadThreadContext();
                this.method.ldc(position.getStartLine());
                this.invokeThreadContext("setLine", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Integer.TYPE)));
            }
        }

        public void checkWhenWithSplat() {
            this.loadThreadContext();
            this.invokeUtilityMethod("isWhenTriggered", CodegenUtils.sig(RubyBoolean.class, IRubyObject.class, IRubyObject.class, ThreadContext.class));
        }

        public void issueRetryEvent() {
            this.invokeUtilityMethod("retryJump", CodegenUtils.sig(IRubyObject.class));
        }

        public void defineNewMethod(String name, int methodArity, StaticScope scope, CompilerCallback body, CompilerCallback args, CompilerCallback receiver, ASTInspector inspector, boolean root) {
            ++StandardASMCompiler.this.methodIndex;
            String methodName = root && Boolean.getBoolean("jruby.compile.toplevel") ? name : JavaNameMangler.mangleStringForCleanJavaIdentifier(name) + "__" + StandardASMCompiler.this.methodIndex;
            MethodCompiler methodCompiler = StandardASMCompiler.this.startMethod(methodName, args, scope, inspector);
            body.call(methodCompiler);
            methodCompiler.endMethod();
            this.loadThreadContext();
            this.loadSelf();
            if (receiver != null) {
                receiver.call(this);
            }
            this.method.aload(0);
            this.method.ldc(name);
            this.method.ldc(methodName);
            StandardASMCompiler.this.buildStaticScopeNames(this.method, scope);
            this.method.ldc(methodArity);
            this.method.ldc(scope.getRequiredArgs());
            this.method.ldc(scope.getOptionalArgs());
            this.method.ldc(scope.getRestArg());
            if (inspector.hasFrameAwareMethods() || !RubyInstanceConfig.FRAMELESS_COMPILE_ENABLED) {
                if (inspector.hasClosure() || inspector.hasScopeAwareMethods()) {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
                } else {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.FRAME_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
                }
            } else if (inspector.hasClosure() || inspector.hasScopeAwareMethods()) {
                if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED) {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.SCOPE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
                } else {
                    this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_AND_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
                }
            } else if (RubyInstanceConfig.FASTEST_COMPILE_ENABLED) {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.NO_FRAME_NO_SCOPE.name(), CodegenUtils.ci(CallConfiguration.class));
            } else {
                this.method.getstatic(CodegenUtils.p(CallConfiguration.class), CallConfiguration.BACKTRACE_ONLY.name(), CodegenUtils.ci(CallConfiguration.class));
            }
            if (receiver != null) {
                this.invokeUtilityMethod("defs", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            } else {
                this.invokeUtilityMethod("def", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Object.class, String.class, String.class, String[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, CallConfiguration.class)));
            }
        }

        public void rethrowIfSystemExit() {
            this.loadRuntime();
            this.method.ldc("SystemExit");
            this.method.invokevirtual(CodegenUtils.p(Ruby.class), "fastGetClass", CodegenUtils.sig(RubyClass.class, String.class));
            this.method.swap();
            this.method.invokevirtual(CodegenUtils.p(RubyModule.class), "isInstance", CodegenUtils.sig(Boolean.TYPE, CodegenUtils.params(IRubyObject.class)));
            this.method.iconst_0();
            Label ifEnd = new Label();
            this.method.if_icmpeq(ifEnd);
            this.loadException();
            this.method.athrow();
            this.method.label(ifEnd);
        }
    }
}

