/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.switcher;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.trace.TraceXRef;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProjectReferencesAction
extends NodeAction {
    private CsmModel model;
    private static boolean running = false;
    private final JMenuItem presenter = new JMenuItem();
    private static final boolean TEST_XREF = Boolean.getBoolean("test.xref.action");

    public TestProjectReferencesAction() {
        this.model = CsmModelAccessor.getModel();
        Actions.connect((JMenuItem)this.presenter, (Action)((Object)this), (boolean)true);
    }

    protected boolean enable(Node[] nodeArray) {
        if (!TEST_XREF) {
            return false;
        }
        if (this.model == null) {
            return false;
        }
        if (running) {
            return false;
        }
        Collection<NativeProject> collection = this.getNativeProjects(this.getActivatedNodes());
        if (collection == null) {
            return false;
        }
        return this.getState(collection) != State.Indeterminate;
    }

    public void performAction(Node[] nodeArray) {
        running = true;
        this.model.enqueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TestProjectReferencesAction.this.performAction(TestProjectReferencesAction.this.getNativeProjects(TestProjectReferencesAction.this.getActivatedNodes()));
                }
                finally {
                    running = false;
                }
            }
        }, (CharSequence)"Testing xRef");
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TestProjectReferencesAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    private JMenuItem getPresenter() {
        Collection<NativeProject> collection = this.getNativeProjects(this.getActivatedNodes());
        if (TEST_XREF) {
            if (collection == null) {
                this.setEnabled(!running);
                this.presenter.setVisible(false);
            } else {
                try {
                    this.presenter.setVisible(true);
                    this.setEnabled(!running);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.setEnabled(false);
                }
            }
        } else {
            this.presenter.setVisible(false);
        }
        return this.presenter;
    }

    private Collection<NativeProject> getNativeProjects(Node[] nodeArray) {
        ArrayList<NativeProject> arrayList = new ArrayList<NativeProject>();
        for (int i = 0; i < nodeArray.length; ++i) {
            Object object = nodeArray[i].getValue("Project");
            if (!(object instanceof Project)) {
                return null;
            }
            NativeProject nativeProject = (NativeProject)((Project)object).getLookup().lookup(NativeProject.class);
            if (nativeProject == null) {
                return null;
            }
            arrayList.add(nativeProject);
        }
        return arrayList;
    }

    private State getState(Collection<NativeProject> collection) {
        if (this.model == null) {
            return State.Indeterminate;
        }
        State state = State.Indeterminate;
        for (NativeProject nativeProject : collection) {
            State state2 = this.getState(nativeProject);
            if (state == State.Indeterminate) {
                state = state2;
                continue;
            }
            if (state == state2) continue;
            return State.Indeterminate;
        }
        return state;
    }

    private State getState(NativeProject nativeProject) {
        CsmProject csmProject = this.model.getProject((Object)nativeProject);
        return csmProject != null && csmProject.isStable(null) ? State.Enabled : State.Disabled;
    }

    private void performAction(Collection<NativeProject> collection) {
        if (collection != null) {
            for (NativeProject nativeProject : collection) {
                this.testProject(nativeProject);
            }
        }
    }

    private void testProject(NativeProject nativeProject) {
        String string = "xRef - " + nativeProject.getProjectDisplayName();
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        inputOutput.select();
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
        progressHandle.start();
        final OutputWriter outputWriter = inputOutput.getOut();
        OutputWriter outputWriter2 = inputOutput.getErr();
        final long[] lArray = new long[2];
        lArray[0] = System.currentTimeMillis();
        TraceXRef.traceProjectRefsStatistics((NativeProject)nativeProject, (PrintWriter)outputWriter, (OutputWriter)outputWriter2, (CsmProgressListener)new CsmProgressAdapter(){
            private int handled = 0;

            public void projectFilesCounted(CsmProject csmProject, int n) {
                outputWriter.println("Project " + csmProject.getName() + " has " + n + " files");
                progressHandle.switchToDeterminate(n);
            }

            public void fileParsingStarted(CsmFile csmFile) {
                progressHandle.progress("Analyzing " + csmFile.getName(), this.handled++);
            }

            public void projectParsingFinished(CsmProject csmProject) {
                lArray[1] = System.currentTimeMillis();
            }
        });
        progressHandle.finish();
        outputWriter.println("Analyzing " + nativeProject.getProjectDisplayName() + " took " + (lArray[1] - lArray[0]) + "ms");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Enabled,
        Disabled,
        Indeterminate;

    }
}

