/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.entitygenerator.DbSchemaEjbGenerator;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.GeneratedTables;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.DBSchemaFileList;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SelectedTables;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.Table;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableClosure;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.TableSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RelatedCMPHelper {
    private final Project project;
    private final FileObject configFilesFolder;
    private final PersistenceGenerator persistenceGen;
    private final DBSchemaFileList dbschemaFileList;
    private SchemaElement schemaElement;
    private DatabaseConnection dbconn;
    private FileObject dbschemaFile;
    private String datasourceName;
    private TableClosure tableClosure;
    private SelectedTables selectedTables;
    private SourceGroup location;
    private String packageName;
    private boolean cmpFieldsInInterface;
    private boolean generateFinderMethods;
    private DbSchemaEjbGenerator generator;
    private TableSource tableSource;
    private PersistenceUnit persistenceUnit;

    public RelatedCMPHelper(Project project, FileObject fileObject, PersistenceGenerator persistenceGenerator) {
        this.project = project;
        this.configFilesFolder = fileObject;
        this.persistenceGen = persistenceGenerator;
        this.tableSource = TableSource.get(project);
        this.dbschemaFileList = new DBSchemaFileList(project, fileObject);
    }

    public Project getProject() {
        return this.project;
    }

    FileObject getConfigFilesFolder() {
        return this.configFilesFolder;
    }

    PersistenceGenerator getPersistenceGenerator() {
        return this.persistenceGen;
    }

    public DBSchemaFileList getDBSchemaFileList() {
        return this.dbschemaFileList;
    }

    public void setTableClosure(TableClosure tableClosure) {
        assert (tableClosure != null);
        this.tableClosure = tableClosure;
    }

    public TableClosure getTableClosure() {
        return this.tableClosure;
    }

    public void setSelectedTables(SelectedTables selectedTables) {
        assert (selectedTables != null);
        this.selectedTables = selectedTables;
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(PersistenceUnit persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public void setTableSource(SchemaElement schemaElement, DatabaseConnection databaseConnection, String string) {
        this.schemaElement = schemaElement;
        this.dbconn = databaseConnection;
        this.dbschemaFile = null;
        this.datasourceName = string;
        this.updateTableSource();
    }

    public void setTableSource(SchemaElement schemaElement, FileObject fileObject) {
        this.schemaElement = schemaElement;
        this.dbconn = null;
        this.dbschemaFile = fileObject;
        this.datasourceName = null;
        this.updateTableSource();
    }

    public TableSource getTableSource() {
        return this.tableSource;
    }

    private void updateTableSource() {
        this.tableSource = this.dbconn != null ? (this.datasourceName != null ? new TableSource(this.datasourceName, TableSource.Type.DATA_SOURCE) : new TableSource(this.dbconn.getName(), TableSource.Type.CONNECTION)) : (this.dbschemaFile != null ? new TableSource(FileUtil.toFile((FileObject)this.dbschemaFile).getAbsolutePath(), TableSource.Type.SCHEMA_FILE) : null);
    }

    public SchemaElement getSchemaElement() {
        return this.schemaElement;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public FileObject getDBSchemaFile() {
        return this.dbschemaFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public SourceGroup getLocation() {
        return this.location;
    }

    public void setLocation(SourceGroup sourceGroup) {
        this.location = sourceGroup;
    }

    public boolean isCmpFieldsInInterface() {
        return this.cmpFieldsInInterface;
    }

    public void setCmpFieldsInInterface(boolean bl) {
        this.cmpFieldsInInterface = bl;
    }

    public boolean isGenerateFinderMethods() {
        return this.generateFinderMethods;
    }

    public void setGenerateFinderMethods(boolean bl) {
        this.generateFinderMethods = bl;
    }

    public void buildBeans() {
        TableSource.put(this.project, this.tableSource);
        GenerateTablesImpl generateTablesImpl = new GenerateTablesImpl();
        FileObject fileObject = this.getLocation().getRootFolder();
        String string = this.getPackageName();
        for (Table table : this.selectedTables.getTables()) {
            generateTablesImpl.addTable(table.getName(), fileObject, string, this.selectedTables.getClassName(table));
        }
        for (Table table : this.tableClosure.getAvailableTables()) {
            if (!(table.getDisabledReason() instanceof Table.ExistingDisabledReason)) continue;
            Table.ExistingDisabledReason existingDisabledReason = (Table.ExistingDisabledReason)table.getDisabledReason();
            String string2 = existingDisabledReason.getFQClassName();
            SourceGroup sourceGroup = Util.getClassSourceGroup(this.getProject(), string2);
            if (sourceGroup == null) continue;
            generateTablesImpl.addTable(table.getName(), sourceGroup.getRootFolder(), JavaIdentifiers.getPackageName((String)string2), JavaIdentifiers.unqualify((String)string2));
        }
        this.generator = new DbSchemaEjbGenerator(generateTablesImpl, this.schemaElement);
    }

    public EntityClass[] getBeans() {
        return this.generator.getBeans();
    }

    public EntityRelation[] getRelations() {
        return this.generator.getRelations();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GenerateTablesImpl
    implements GeneratedTables {
        private final Set<String> tableNames = new HashSet<String>();
        private final Map<String, FileObject> rootFolders = new HashMap<String, FileObject>();
        private final Map<String, String> packageNames = new HashMap<String, String>();
        private final Map<String, String> classNames = new HashMap<String, String>();

        private GenerateTablesImpl() {
        }

        @Override
        public Set<String> getTableNames() {
            return Collections.unmodifiableSet(this.tableNames);
        }

        private void addTable(String string, FileObject fileObject, String string2, String string3) {
            this.tableNames.add(string);
            this.rootFolders.put(string, fileObject);
            this.packageNames.put(string, string2);
            this.classNames.put(string, string3);
        }

        @Override
        public FileObject getRootFolder(String string) {
            return this.rootFolders.get(string);
        }

        @Override
        public String getPackageName(String string) {
            return this.packageNames.get(string);
        }

        @Override
        public String getClassName(String string) {
            return this.classNames.get(string);
        }
    }
}

