/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.entity;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.SourceUtils;
import org.netbeans.modules.j2ee.core.api.support.wizard.DelegatingWizardDescriptorPanel;
import org.netbeans.modules.j2ee.core.api.support.wizard.Wizards;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.unit.PUDataObject;
import org.netbeans.modules.j2ee.persistence.util.EntityMethodGenerator;
import org.netbeans.modules.j2ee.persistence.util.JPAClassPathHelper;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.entity.EntityWizardDescriptor;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class EntityWizard
implements WizardDescriptor.InstantiatingIterator {
    private WizardDescriptor.Panel[] panels;
    private int index = 0;
    private EntityWizardDescriptor ejbPanel;
    private WizardDescriptor wiz;
    private SourceGroup[] sourceGroups;

    public static EntityWizard create() {
        return new EntityWizard();
    }

    public String name() {
        return NbBundle.getMessage(EntityWizard.class, (String)"LBL_EntityEJBWizardTitle");
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        this.sourceGroups = SourceGroups.getJavaSourceGroups((Project)project);
        this.ejbPanel = new EntityWizardDescriptor();
        ValidatingPanel validatingPanel = new ValidatingPanel(JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])this.sourceGroups, (WizardDescriptor.Panel)this.ejbPanel, (boolean)true));
        this.panels = new WizardDescriptor.Panel[]{validatingPanel};
        Wizards.mergeSteps((WizardDescriptor)this.wiz, (WizardDescriptor.Panel[])this.panels, null);
    }

    public Set instantiate() throws IOException {
        FileObject fileObject = EntityWizard.generateEntity(Templates.getTargetFolder((WizardDescriptor)this.wiz), Templates.getTargetName((WizardDescriptor)this.wiz), this.ejbPanel.getPrimaryKeyClassName(), false);
        try {
            PersistenceUnit persistenceUnit = this.ejbPanel.getPersistenceUnit();
            if (persistenceUnit != null) {
                ProviderUtil.addPersistenceUnit(persistenceUnit, Templates.getProject((WizardDescriptor)this.wiz));
            }
            this.addEntityToPersistenceUnit(fileObject);
        }
        catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
            Logger.getLogger(EntityWizard.class.getName()).log(Level.FINE, "Invalid persistence.xml: " + invalidPersistenceXmlException.getPath(), invalidPersistenceXmlException);
        }
        return Collections.singleton(fileObject);
    }

    private void addEntityToPersistenceUnit(FileObject fileObject) throws InvalidPersistenceXmlException {
        PUDataObject pUDataObject;
        PersistenceUnit[] persistenceUnitArray;
        Project project = Templates.getProject((WizardDescriptor)this.wiz);
        String string = "";
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (classPathProvider != null) {
            string = classPathProvider.findClassPath(fileObject, "classpath/source").getResourceName(fileObject, '.', false);
        }
        if (project != null && !Util.isSupportedJavaEEVersion(project) && ProviderUtil.getDDFile(project) != null && (persistenceUnitArray = (pUDataObject = ProviderUtil.getPUDataObject(project)).getPersistence().getPersistenceUnit()).length == 1) {
            pUDataObject.addClass(persistenceUnitArray[0], string);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public static FileObject generateEntity(FileObject fileObject, final String string, final String string2, final boolean bl) throws IOException {
        FileObject fileObject2 = GenerationUtils.createClass((FileObject)fileObject, (String)string, null);
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        HashSet<ClassPath> hashSet = new HashSet<ClassPath>();
        hashSet.add(classPath);
        JPAClassPathHelper jPAClassPathHelper = new JPAClassPathHelper(Collections.singleton(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot")), Collections.singleton(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile")), Collections.singleton(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")));
        JavaSource javaSource = JavaSource.create((ClasspathInfo)jPAClassPathHelper.createClasspathInfo(), (FileObject[])new FileObject[]{fileObject2});
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                assert (typeElement != null);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                GenerationUtils generationUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                ClassTree classTree2 = generationUtils.ensureNoArgConstructor(classTree);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                String string3 = "id";
                TypeMirror typeMirror = workingCopy.getTreeUtilities().parseType(string2, typeElement);
                Tree tree = treeMaker.Type(typeMirror);
                HashSet<Modifier> hashSet = new HashSet<Modifier>();
                hashSet.add(Modifier.PRIVATE);
                hashSet.add(Modifier.STATIC);
                hashSet.add(Modifier.FINAL);
                VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(hashSet), (CharSequence)"serialVersionUID", generationUtils.createType("long", typeElement), (ExpressionTree)treeMaker.Literal((Object)Long.valueOf("1")));
                VariableTree variableTree2 = treeMaker.Variable(generationUtils.createModifiers(Modifier.PRIVATE), (CharSequence)string3, tree, null);
                ModifiersTree modifiersTree = generationUtils.createModifiers(Modifier.PUBLIC);
                MethodTree methodTree = generationUtils.createPropertyGetterMethod(modifiersTree, string3, tree);
                MethodTree methodTree2 = generationUtils.createPropertySetterMethod(modifiersTree, string3, tree);
                AnnotationTree annotationTree = generationUtils.createAnnotation("javax.persistence.Id");
                ExpressionTree expressionTree = generationUtils.createAnnotationArgument("strategy", "javax.persistence.GenerationType", "AUTO");
                AnnotationTree annotationTree2 = generationUtils.createAnnotation("javax.persistence.GeneratedValue", Collections.singletonList(expressionTree));
                if (bl) {
                    variableTree2 = generationUtils.addAnnotation(variableTree2, annotationTree);
                    variableTree2 = generationUtils.addAnnotation(variableTree2, annotationTree2);
                } else {
                    methodTree = generationUtils.addAnnotation(methodTree, annotationTree);
                    methodTree = generationUtils.addAnnotation(methodTree, annotationTree2);
                }
                ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>();
                arrayList.add(variableTree);
                arrayList.add(variableTree2);
                classTree2 = generationUtils.addClassFields(classTree, arrayList);
                classTree2 = treeMaker.addClassMember(classTree2, (Tree)methodTree2);
                classTree2 = treeMaker.addClassMember(classTree2, (Tree)methodTree);
                classTree2 = generationUtils.addImplementsClause(classTree2, "java.io.Serializable");
                classTree2 = generationUtils.addAnnotation(classTree2, generationUtils.createAnnotation("javax.persistence.Entity"));
                String string22 = typeElement.getQualifiedName().toString();
                EntityMethodGenerator entityMethodGenerator = new EntityMethodGenerator(workingCopy, generationUtils, typeElement);
                List<VariableTree> list = Collections.singletonList(variableTree2);
                classTree2 = treeMaker.addClassMember(classTree2, (Tree)entityMethodGenerator.createHashCodeMethod(list));
                classTree2 = treeMaker.addClassMember(classTree2, (Tree)entityMethodGenerator.createEqualsMethod(string, list));
                classTree2 = treeMaker.addClassMember(classTree2, (Tree)entityMethodGenerator.createToStringMethod(string22, list));
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        };
        javaSource.runModificationTask((Task)task).commit();
        return fileObject2;
    }

    private static final class ValidatingPanel
    extends DelegatingWizardDescriptorPanel {
        public ValidatingPanel(WizardDescriptor.Panel panel) {
            super(panel);
        }

        public boolean isValid() {
            if (!ProviderUtil.isValidServerInstanceOrNone(this.getProject())) {
                this.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(EntityWizardDescriptor.class, (String)"ERR_MissingServer"));
                return false;
            }
            return super.isValid();
        }
    }
}

