/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class NNPaintComponent
extends JPanel {
    static final String COLUMN_ICON = "org/netbeans/modules/j2ee/persistence/editor/completion/resources/column.gif";
    static final String TABLE_ICON = "org/netbeans/modules/j2ee/persistence/editor/completion/resources/table.gif";
    static final String NOCONNECTION_ICON = "org/netbeans/modules/j2ee/persistence/editor/completion/resources/connectionDisconnected.gif";
    static final String PU_ICON = "org/netbeans/modules/j2ee/persistence/ui/resources/EntityNodeIcon.gif";
    private static final int ICON_WIDTH = 16;
    private static final int ICON_TEXT_GAP = 5;
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    public static final Color KEYWORD_COLOR = Color.darkGray;
    public static final Color TYPE_COLOR = Color.black;
    static final Color ENCLOSING_CALL_COLOR = Color.gray;
    static final Color ACTIVE_PARAMETER_COLOR = Color.black;

    public NNPaintComponent() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    protected void setSelected(boolean bl) {
        this.isSelected = bl;
    }

    protected void setDeprecated(boolean bl) {
        this.isDeprecated = bl;
    }

    protected boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        Rectangle rectangle = graphics.getClipBounds();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.draw(graphics);
    }

    protected void draw(Graphics graphics) {
    }

    protected void drawIcon(Graphics graphics, Icon icon) {
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX = insets.left;
            this.drawY = insets.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (graphics != null) {
                icon.paintIcon(this, graphics, this.drawX, this.drawY);
            }
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        this.drawX += 21;
        if (insets != null) {
            this.drawHeight += insets.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics graphics, String string) {
        this.drawString(graphics, string, false);
    }

    protected void drawString(Graphics graphics, String string, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getForeground());
        }
        this.drawStringToGraphics(graphics, string, null, bl);
    }

    protected void drawString(Graphics graphics, String string, Color color) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
        }
        this.drawStringToGraphics(graphics, string);
    }

    protected void drawString(Graphics graphics, String string, Color color, Font font, boolean bl) {
        if (graphics != null) {
            graphics.setColor(this.getColor(string, color));
            graphics.setFont(font);
        }
        this.drawStringToGraphics(graphics, string, font, bl);
        if (graphics != null) {
            graphics.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics graphics, String string, Color color) {
        if (graphics == null) {
            this.drawString(graphics, "   ");
            this.drawString(graphics, string, color);
        } else {
            int n;
            int n2 = this.getWidth() - this.getWidth(string) - this.drawX;
            if (n2 > (n = this.getWidth(" ")) * 2) {
                this.drawX = this.getWidth() - 2 * n - this.getWidth(string);
            } else {
                this.drawX = this.getWidth() - 2 * n - this.getWidth(string) - this.getWidth("...   ");
                graphics.setColor(this.getBackground());
                graphics.fillRect(this.drawX, 0, this.getWidth() - this.drawX, this.getHeight());
                this.drawString(graphics, "...   ", color);
            }
            this.drawString(graphics, string, color);
        }
    }

    protected void drawStringToGraphics(Graphics graphics, String string) {
        this.drawStringToGraphics(graphics, string, null, false);
    }

    protected void drawStringToGraphics(Graphics graphics, String string, Font font, boolean bl) {
        if (graphics != null) {
            if (!bl) {
                graphics.drawString(string, this.drawX, this.drawY);
            } else {
                Graphics2D graphics2D = (Graphics2D)graphics;
                AttributedString attributedString = new AttributedString(string);
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                attributedString.addAttribute(TextAttribute.FONT, graphics.getFont());
                graphics2D.drawString(attributedString.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(string, font);
    }

    protected int getWidth(String string) {
        Integer n = (Integer)this.widths.get(string);
        if (n != null) {
            return n;
        }
        if (string == null) {
            string = "";
        }
        return this.fontMetrics.stringWidth(string);
    }

    protected int getWidth(String string, Font font) {
        if (font == null) {
            return this.getWidth(string);
        }
        return this.getFontMetrics(font).stringWidth(string);
    }

    protected Color getColor(String string, Color color) {
        return this.isSelected ? this.getForeground() : color;
    }

    private void storeWidth(String string) {
        this.fontMetrics.stringWidth(string);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    public Dimension getPreferredSize() {
        this.draw(null);
        Insets insets = this.getInsets();
        if (insets != null) {
            this.drawX += insets.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    public static final class NoConnectionItemPaintComponent
    extends NbStringPaintComponent {
        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, new ImageIcon(Utilities.loadImage((String)NNPaintComponent.NOCONNECTION_ICON)));
            this.drawString(graphics, NbBundle.getMessage(NNPaintComponent.class, (String)"LBL_ConnectToDatabase"), Color.RED, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class EntityPropertyElementPaintComponent
    extends NbStringPaintComponent {
        private String elName;

        public void setContent(String string) {
            this.elName = string;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, new ImageIcon(Utilities.loadImage((String)NNPaintComponent.PU_ICON)));
            this.drawString(graphics, this.elName, Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class PersistenceUnitElementPaintComponent
    extends NbStringPaintComponent {
        private String puName;

        public void setContent(String string) {
            this.puName = string;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, new ImageIcon(Utilities.loadImage((String)NNPaintComponent.PU_ICON)));
            this.drawString(graphics, this.puName, Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class TableElementPaintComponent
    extends NbStringPaintComponent {
        private String tableName;

        public void setContent(String string) {
            this.tableName = string;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, new ImageIcon(Utilities.loadImage((String)NNPaintComponent.TABLE_ICON)));
            this.drawString(graphics, this.tableName, Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class ColumnElementPaintComponent
    extends NbStringPaintComponent {
        private String tableName;
        private String columnName;

        public void setContent(String string, String string2) {
            this.tableName = string2;
            this.columnName = string;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, new ImageIcon(Utilities.loadImage((String)NNPaintComponent.COLUMN_ICON)));
            this.drawString(graphics, this.tableName + ".", Color.BLACK);
            this.drawString(graphics, this.columnName, Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class DBElementPaintComponent
    extends NbStringPaintComponent {
    }

    public static class NbStringPaintComponent
    extends NNPaintComponent {
        private String str;

        public void setString(String string) {
            this.str = string;
        }

        protected void draw(Graphics graphics) {
            this.drawIcon(graphics, null);
            this.drawString(graphics, this.str, TYPE_COLOR);
        }
    }
}

