/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import com.tomsawyer.editor.ui.TSEJComponentNodeUI;
import com.tomsawyer.util.TSProperty;
import editor.ExGraphWindow;
import editor.Tomahawk;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class ExJEditorPaneNodeUI
extends TSEJComponentNodeUI
implements HyperlinkListener,
PropertyChangeListener,
FocusListener,
MouseListener,
ActionListener {
    public static TSEInspectorPropertyID SCROLLBAR_SIZE_ID = new TSEInspectorPropertyID(Tomahawk.getResources().getStringResource("string.Scrollbar_Size"), class$java$lang$Integer == null ? (class$java$lang$Integer = ExJEditorPaneNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String SCROLLBARSIZE = "scrollBarSize";
    public static final String MINIMIZED = "minimized";
    public static final String NON_MINIMIZED_WIDTH = "nonMinimizedWidth";
    public static final String NON_MINIMIZED_HEIGHT = "nonMinimizedHeight";
    JEditorPane editorPane;
    JScrollPane scrollPane;
    double nonMinimizedWidth;
    double nonMinimizedHeight;
    PanelWindow window;
    static /* synthetic */ Class class$editor$Tomahawk;
    static /* synthetic */ Class class$java$lang$Integer;

    public int getMinimumJComponentSize() {
        if (this.isMinimized()) {
            return 5;
        }
        return 100;
    }

    public boolean isResizable() {
        return !this.isMinimized();
    }

    public boolean isMinimized() {
        return this.window.isMinimized();
    }

    public boolean isMinimizedByDefault() {
        return false;
    }

    public void setMinimized(boolean bl) {
        if (this.isMinimized() == bl) {
            return;
        }
        this.window.setMinimized(bl);
        TSTransform tSTransform = this.getLocalToMainGraphWindowTransform();
        if (this.getParentWindow() != null) {
            this.getParentWindow().addInvalidRegion(this.getOwner());
        }
        if (bl) {
            this.nonMinimizedWidth = ((TSENode)this.getOwner()).getWidth();
            this.nonMinimizedHeight = ((TSENode)this.getOwner()).getHeight();
            this.window.setPreferredSize(this.window.getLayout().preferredLayoutSize(this.window));
            this.updateOwnerSize(tSTransform);
        } else if (this.nonMinimizedWidth != -1.0) {
            ((TSENode)this.getOwner()).setAdjustedSize(this.nonMinimizedWidth, this.nonMinimizedHeight);
            ((TSENode)this.getOwner()).setAdjustedOriginalSize(this.nonMinimizedWidth, this.nonMinimizedHeight);
            this.nonMinimizedWidth = -1.0;
            this.nonMinimizedHeight = -1.0;
        }
        this.updateLocationFromOwner(tSTransform);
        this.updateSizeFromOwner(tSTransform);
        if (this.getParentWindow() != null) {
            this.getParentWindow().addInvalidRegion(this.getOwner());
            this.getParentWindow().updateInvalidRegion(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.window.getMinimizeButton()) {
            this.setMinimized(!this.isMinimized());
        }
    }

    public JComponent newJComponent() {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        this.editorPane.addHyperlinkListener(this);
        this.editorPane.addPropertyChangeListener(this);
        this.scrollPane = new JScrollPane(this.editorPane);
        this.scrollPane.setCursor(Cursor.getDefaultCursor());
        this.setScrollBarSize(this.getDefaultScrollBarSize());
        this.scrollPane.setPreferredSize(new Dimension(400, 300));
        this.window = new PanelWindow();
        this.window.getContentPane().add(this.scrollPane);
        this.window.getMinimizeButton().addActionListener(this);
        this.window.setCursor(Cursor.getDefaultCursor());
        Tomahawk.getInstance();
        this.window.setIcon(Tomahawk.getResources().getIconResource("node.component.browser.icon", class$editor$Tomahawk == null ? (class$editor$Tomahawk = ExJEditorPaneNodeUI.class$("editor.Tomahawk")) : class$editor$Tomahawk));
        return this.window;
    }

    public void reset() {
        super.reset();
        this.nonMinimizedWidth = -1.0;
        this.nonMinimizedHeight = -1.0;
        if (this.getOwnerNode() != null) {
            this.setURL(this.getDefaultURL());
            this.setScrollBarSize(this.getDefaultScrollBarSize());
            this.setMinimized(this.isMinimizedByDefault());
        }
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        ExJEditorPaneNodeUI exJEditorPaneNodeUI = (ExJEditorPaneNodeUI)tSEObjectUI;
        this.setScrollBarSize(exJEditorPaneNodeUI.getScrollBarSize());
    }

    protected void addToCanvas() {
        this.editorPane.addFocusListener(this);
        this.editorPane.addMouseListener(this);
        super.addToCanvas();
    }

    protected void removeFromCanvas() {
        this.editorPane.removeFocusListener(this);
        this.editorPane.removeMouseListener(this);
        super.removeFromCanvas();
    }

    protected String makeErrorString(URL uRL, Exception exception) {
        String string = "<HTML>";
        if (exception instanceof IOException) {
            string = string + "<HEAD><TITLE>Unreachable Resource</TITLE></HEAD>" + "<BODY><H1>Unreachable Resource</H1>";
            string = string + "<P>Please check your computer's connection to the " + "resource you requested.</P>";
        } else if (exception instanceof SecurityException) {
            string = string + "<HEAD><TITLE>Resource Forbidden</TITLE></HEAD>" + "<BODY><H1>Resource Forbidden</H1>";
            string = string + "<P>Please check your computer's security settings." + "</P>";
        } else {
            string = string + "<HEAD><TITLE>Unable to Load Resource</TITLE></HEAD>" + "<BODY><H1>Unable to Load Resource</H1>";
            string = uRL == null ? string + "<P>No resource was specified.</P>" : string + "<P>The resource you specified, \"" + uRL + "\" could not be loaded.</P>";
            string = string + "<P>With the editor in Run Mode, click " + "<A HREF=http://www.tomsawyer.com>" + "here</A> to try to connect to Tom Sawyer Software.</P>";
        }
        string = string + "<P><FONT size=1>" + exception.getClass().getName() + ": " + exception.getMessage() + "</FONT></P></BODY></HTML>";
        return string;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)this.editorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                this.setURL(hyperlinkEvent.getURL());
                if (Tomahawk.getInstance().getInspectorWindow() != null) {
                    Tomahawk.getInstance().getInspectorWindow().getInspector().update();
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("page") && this.getParentWindow() instanceof ExGraphWindow) {
            String string = "";
            if (this.getURL() != null) {
                string = this.getURL().toString();
            }
            this.window.getTitle().setText(string);
            this.getParentWindow().addInvalidRegion((TSEObject)this.getOwnerNode());
            ((ExGraphWindow)this.getParentWindow()).requestUpdateOnTimer();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ((JLayeredPane)this.getParentWindow().getCanvas()).moveToFront(this.scrollPane);
    }

    public void focusGained(FocusEvent focusEvent) {
        ((JLayeredPane)this.getParentWindow().getCanvas()).moveToFront(this.scrollPane);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public double getTightWidth() {
        if (this.window != null) {
            return this.window.getPreferredSize().width + 2 * this.getMarginSize();
        }
        return super.getTightWidth();
    }

    public double getTightHeight() {
        if (this.window != null) {
            return this.window.getPreferredSize().height + 2 * this.getMarginSize();
        }
        return super.getTightHeight();
    }

    public void setURL(URL uRL) {
        if (!(this.getOwnerNode() == null || this.getOwnerNode().getURL() != null && this.getOwnerNode().getURL().equals(uRL))) {
            this.getOwnerNode().setURL(uRL);
            this.updateEditorPane(uRL);
        }
    }

    void updateEditorPane(URL uRL) {
        block2: {
            try {
                this.editorPane.setPage(uRL);
                this.window.getTitle().setText("Loading " + uRL + "...");
            }
            catch (Exception exception) {
                if (this.editorPane == null) break block2;
                this.editorPane.setText(this.makeErrorString(uRL, exception));
                this.window.getTitle().setText("Error Loading Page");
            }
        }
    }

    public URL getURL() {
        return this.getOwnerNode().getURL();
    }

    public URL getDefaultURL() {
        try {
            return new URL("http://www.tomsawyer.com");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void onOwnerInserted() {
        if (this.getOwnerNode() != null) {
            this.reset();
            if (this.getOwnerNode().getURL() == null) {
                this.setURL(this.getDefaultURL());
            }
        }
        super.onOwnerInserted();
    }

    public void draw(TSEGraphics tSEGraphics) {
        if (!(this.getOwnerNode() == null || this.getOwnerNode().getURL() != null && this.getOwnerNode().getURL().equals(this.editorPane.getPage()))) {
            this.updateEditorPane(this.getOwnerNode().getURL());
        }
        super.draw(tSEGraphics);
    }

    public int getScrollBarSize() {
        if (this.scrollPane != null) {
            return Math.max(this.scrollPane.getVerticalScrollBar().getPreferredSize().width, this.scrollPane.getHorizontalScrollBar().getPreferredSize().height);
        }
        return this.getDefaultScrollBarSize();
    }

    public void setScrollBarSize(int n) {
        if (this.scrollPane != null && n > 0) {
            this.scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(n, 0));
            this.scrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, n));
            this.scrollPane.revalidate();
        }
    }

    public int getDefaultScrollBarSize() {
        return 10;
    }

    public boolean isTransparentByDefault() {
        return true;
    }

    public boolean isAnnotationEditable() {
        return false;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        int n = this.getScrollBarSize();
        if (n != this.getDefaultScrollBarSize() && n != 0) {
            list.add(new TSProperty(SCROLLBARSIZE, (Object)new Integer(n)));
        }
        if (this.isMinimized() != this.isMinimizedByDefault()) {
            list.add(new TSProperty(MINIMIZED, (Object)new Boolean(this.isMinimized())));
        }
        if (this.nonMinimizedWidth != -1.0) {
            list.add(new TSProperty(NON_MINIMIZED_WIDTH, (Object)new Double(this.nonMinimizedWidth)));
            list.add(new TSProperty(NON_MINIMIZED_HEIGHT, (Object)new Double(this.nonMinimizedHeight)));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (SCROLLBARSIZE.equals(tSProperty.getName())) {
            this.setScrollBarSize(Integer.parseInt(tSProperty.getValue().toString()));
        } else if (NON_MINIMIZED_WIDTH.equals(tSProperty.getName())) {
            this.nonMinimizedWidth = Double.parseDouble(tSProperty.getValue().toString());
        } else if (NON_MINIMIZED_HEIGHT.equals(tSProperty.getName())) {
            this.nonMinimizedHeight = Double.parseDouble(tSProperty.getValue().toString());
        } else if (MINIMIZED.equals(tSProperty.getName())) {
            this.setMinimized(Boolean.valueOf(tSProperty.getValue().toString()));
        } else {
            super.setProperty(tSProperty);
        }
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(SCROLLBAR_SIZE_ID);
        super.getInspectorPropertyIDs(list);
        list.remove(TSENode.NAME_ID);
        list.remove(TSEAnnotatedUI.FONT_ID);
        list.remove(TSEAnnotatedUI.TEXT_COLOR_ID);
        list.remove(TSEAnnotatedUI.JUSTIFICATION_ID);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        if (tSEInspectorPropertyID.equals((Object)SCROLLBAR_SIZE_ID)) {
            return new TSENumericInspectorProperty((Number)new Integer(this.getScrollBarSize()), (Number)new Integer(0), (Number)new Integer(99));
        }
        return super.getInspectorProperty(tSEInspectorPropertyID);
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals((Object)SCROLLBAR_SIZE_ID)) {
            this.setScrollBarSize((Integer)tSEInspectorProperty.getValue());
            return 1;
        }
        return super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PanelWindow
    extends JPanel {
        JPanel titleBar;
        JPanel contentPane;
        JLabel title;
        Icon icon;
        JButton minimizeButton;
        boolean minimized;

        public PanelWindow() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BorderLayout());
            this.contentPane.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
            this.titleBar = new JPanel();
            this.titleBar.setLayout(new BorderLayout());
            this.titleBar.setBackground(new Color(153, 153, 204));
            this.titleBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(102, 102, 153)), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.title = new JLabel();
            this.title.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 7));
            this.title.setForeground(Color.white);
            this.minimizeButton = new JButton();
            this.minimizeButton.setPreferredSize(new Dimension(16, 16));
            this.minimizeButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createBevelBorder(0)));
            this.titleBar.add((Component)this.title, "Center");
            this.titleBar.add((Component)this.minimizeButton, "East");
            this.add((Component)this.titleBar, "North");
            this.add((Component)this.contentPane, "Center");
            this.minimized = false;
        }

        public boolean isMinimized() {
            return this.minimized;
        }

        public void setMinimized(boolean bl) {
            if (this.minimized == bl) {
                return;
            }
            if (!bl) {
                this.add((Component)this.contentPane, "Center");
                this.title.setForeground(Color.white);
                this.title.setIcon(this.icon);
                this.titleBar.setBackground(new Color(153, 153, 204));
                this.titleBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(102, 102, 153)), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            } else {
                this.remove(this.contentPane);
                this.title.setForeground(new Color(102, 102, 153));
                this.title.setIcon(null);
                this.titleBar.setBackground(this.getBackground());
                this.titleBar.setBorder(null);
            }
            this.minimized = bl;
            this.validate();
        }

        public JPanel getTitleBar() {
            return this.titleBar;
        }

        public JPanel getContentPane() {
            return this.contentPane;
        }

        public JLabel getTitle() {
            return this.title;
        }

        public JButton getMinimizeButton() {
            return this.minimizeButton;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
            if (!this.minimized) {
                this.title.setIcon(icon);
            }
        }
    }
}

