/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import com.tomsawyer.editor.ui.TSEJComponentNodeUI;
import com.tomsawyer.util.TSProperty;
import com.tomsawyer.util.TSSystem;
import editor.Tomahawk;
import java.awt.Cursor;
import java.awt.Font;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class ExJComboBoxNodeUI
extends TSEJComponentNodeUI {
    public static TSEInspectorPropertyID OPTION_NUMBER_ID = new TSEInspectorPropertyID(Tomahawk.getResources().getStringResource("string.Number_of_Options"), class$java$lang$Integer == null ? (class$java$lang$Integer = ExJComboBoxNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String OPTION_NAME_TEMPLATE = Tomahawk.getResources().getStringResource("string.Option_%X%");
    public static final String STRING = "string";
    public static final String SELECTED_STRING_INDEX = "selectedStringIndex";
    JComboBox comboBox;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public JComponent newJComponent() {
        this.comboBox = new JComboBox();
        this.comboBox.setCursor(Cursor.getDefaultCursor());
        return this.comboBox;
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        ExJComboBoxNodeUI exJComboBoxNodeUI = (ExJComboBoxNodeUI)tSEObjectUI;
        if (exJComboBoxNodeUI.comboBox != null) {
            for (int i = 0; i < exJComboBoxNodeUI.comboBox.getItemCount(); ++i) {
                this.comboBox.addItem(new String(exJComboBoxNodeUI.comboBox.getItemAt(i).toString()));
            }
            this.comboBox.setSelectedIndex(exJComboBoxNodeUI.comboBox.getSelectedIndex());
        }
    }

    public void setTextColor(TSEColor tSEColor) {
        if (this.comboBox != null) {
            if (tSEColor != null) {
                this.comboBox.setForeground(tSEColor.getColor());
            } else {
                this.comboBox.setForeground(null);
            }
        }
        super.setTextColor(tSEColor);
    }

    public void setFont(TSEFont tSEFont) {
        if (this.comboBox != null) {
            if (tSEFont != null) {
                this.comboBox.setFont(tSEFont.getFont());
            } else {
                this.comboBox.setFont(null);
            }
        }
        super.setFont(tSEFont);
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.comboBox != null) {
            for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                list.add(new TSProperty(STRING, (Object)new String(this.comboBox.getItemAt(i).toString())));
            }
            list.add(new TSProperty(SELECTED_STRING_INDEX, (Object)new Integer(this.comboBox.getSelectedIndex())));
        }
        return list;
    }

    public List getProperties() {
        List list = super.getProperties();
        if (this.comboBox != null) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                linkedList.add(this.comboBox.getItemAt(i).toString());
            }
            list.add(new TSProperty(STRING, linkedList));
            list.add(new TSProperty(SELECTED_STRING_INDEX, (Object)new Integer(this.comboBox.getSelectedIndex())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (STRING.equals(tSProperty.getName())) {
            if (this.comboBox != null) {
                Object object = tSProperty.getValue();
                if (object instanceof List) {
                    Iterator iterator = ((List)object).iterator();
                    while (iterator.hasNext()) {
                        String string = iterator.next().toString();
                        this.addItemToComboBox(string);
                    }
                } else {
                    this.addItemToComboBox(object.toString());
                }
            }
        } else if (SELECTED_STRING_INDEX.equals(tSProperty.getName())) {
            int n = Integer.parseInt(tSProperty.getValue().toString());
            if (this.comboBox != null && this.comboBox.getItemCount() > n) {
                Integer n2 = new Integer(this.comboBox.getSelectedIndex());
                this.comboBox.setSelectedIndex(n);
                this.firePropertyChangedEvent(SELECTED_STRING_INDEX, n2, tSProperty.getValue());
            }
        } else {
            super.setProperty(tSProperty);
        }
    }

    private void addItemToComboBox(String string) {
        this.comboBox.addItem(string);
        this.firePropertyChangedEvent(STRING, null, string);
    }

    public int getDefaultMinimumJComponentSize() {
        return 10;
    }

    public boolean isTransparentByDefault() {
        return true;
    }

    public boolean isAnnotationEditable() {
        return false;
    }

    public TSEFont getDefaultFont() {
        return new TSEFont(new Font("Dialog", 1, 12));
    }

    public void setOwner(TSENode tSENode) {
        super.setOwner(tSENode);
        if (tSENode != null && (tSENode.getResizability() & 0x1000000) == 0) {
            tSENode.setResizability(3);
        }
    }

    protected String buildOptionName(int n) {
        return TSSystem.replace((String)OPTION_NAME_TEMPLATE, (String)"%X%", (String)("" + (n + 1)));
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(OPTION_NUMBER_ID);
        if (this.comboBox != null) {
            for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                list.add(new TSEInspectorPropertyID(this.buildOptionName(i), class$java$lang$String == null ? ExJComboBoxNodeUI.class$("java.lang.String") : class$java$lang$String));
            }
        }
        super.getInspectorPropertyIDs(list);
        list.remove(TSENode.NAME_ID);
        list.remove(TSEAnnotatedUI.JUSTIFICATION_ID);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        if (this.comboBox != null) {
            if (tSEInspectorPropertyID.equals((Object)OPTION_NUMBER_ID)) {
                return new TSENumericInspectorProperty((Number)new Integer(this.comboBox.getItemCount()), (Number)new Integer(1), (Number)new Integer(99));
            }
            for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                TSEInspectorPropertyID tSEInspectorPropertyID2 = new TSEInspectorPropertyID(this.buildOptionName(i), class$java$lang$String == null ? ExJComboBoxNodeUI.class$("java.lang.String") : class$java$lang$String);
                if (!tSEInspectorPropertyID.equals((Object)tSEInspectorPropertyID2)) continue;
                return new TSEInspectorProperty(this.comboBox.getItemAt(i));
            }
        }
        return super.getInspectorProperty(tSEInspectorPropertyID);
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (this.comboBox != null) {
            if (tSEInspectorPropertyID.equals((Object)OPTION_NUMBER_ID)) {
                int n;
                int n2 = (Integer)tSEInspectorProperty.getValue();
                Object[] objectArray = new Object[n2];
                int n3 = this.comboBox.getItemCount();
                for (n = 0; n < n2; ++n) {
                    objectArray[n] = n < n3 ? this.comboBox.getItemAt(n) : this.buildOptionName(n);
                }
                n = this.comboBox.getSelectedIndex();
                if (this.comboBox.getItemCount() > 0) {
                    this.comboBox.removeAllItems();
                }
                for (int i = 0; i < n2; ++i) {
                    this.comboBox.addItem(objectArray[i]);
                }
                this.comboBox.setSelectedIndex(Math.min(n, n2 - 1));
                ((TSENode)this.getOwner()).resize();
                return 2;
            }
            for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                TSEInspectorPropertyID tSEInspectorPropertyID2 = new TSEInspectorPropertyID(this.buildOptionName(i), class$java$lang$String == null ? ExJComboBoxNodeUI.class$("java.lang.String") : class$java$lang$String);
                if (!tSEInspectorPropertyID.equals((Object)tSEInspectorPropertyID2)) continue;
                String string = (String)tSEInspectorProperty.getValue();
                int n = this.comboBox.getSelectedIndex();
                this.comboBox.removeItemAt(i);
                this.comboBox.insertItemAt(string, i);
                this.comboBox.setSelectedIndex(n);
                ((TSENode)this.getOwner()).resize();
                return 1;
            }
        }
        return super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

