/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.ui.TSEJComponentLabelUI;
import com.tomsawyer.util.TSProperty;
import java.awt.Cursor;
import java.awt.Font;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class ExJCheckBoxLabelUI
extends TSEJComponentLabelUI {
    public static final String SELECTED = "selected";
    JCheckBox checkBox;

    public JComponent newJComponent() {
        this.checkBox = new JCheckBox();
        this.checkBox.setCursor(Cursor.getDefaultCursor());
        return this.checkBox;
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        ExJCheckBoxLabelUI exJCheckBoxLabelUI = (ExJCheckBoxLabelUI)tSEObjectUI;
        if (exJCheckBoxLabelUI.checkBox != null) {
            this.checkBox.setSelected(exJCheckBoxLabelUI.checkBox.isSelected());
        }
    }

    public void setTextColor(TSEColor tSEColor) {
        if (this.checkBox != null) {
            if (tSEColor != null) {
                this.checkBox.setForeground(tSEColor.getColor());
            } else {
                this.checkBox.setForeground(null);
            }
        }
        super.setTextColor(tSEColor);
    }

    public void setFont(TSEFont tSEFont) {
        if (this.checkBox != null) {
            if (tSEFont != null) {
                this.checkBox.setFont(tSEFont.getFont());
            } else {
                this.checkBox.setFont(null);
            }
        }
        super.setFont(tSEFont);
    }

    public void setJustification(int n) {
        if (this.checkBox != null) {
            switch (n) {
                case 2: {
                    this.checkBox.setHorizontalAlignment(2);
                    break;
                }
                case 0: {
                    this.checkBox.setHorizontalAlignment(4);
                    break;
                }
                case 1: {
                    this.checkBox.setHorizontalAlignment(0);
                }
            }
        }
        super.setJustification(n);
    }

    public void setTransparent(boolean bl) {
        if (this.checkBox != null) {
            this.checkBox.setOpaque(!bl);
        }
        super.setTransparent(bl);
    }

    protected void updateTextSize() {
        this.updateTextWidthAndHeight();
        if (this.checkBox != null && this.getOwnerLabel() != null) {
            String string = null;
            if (this.getOwnerLabel().getTag() instanceof String) {
                string = (String)this.getOwnerLabel().getTag();
            }
            this.checkBox.setText(string);
            if (this.getOwnerLabel() instanceof TSESolidObject) {
                ((TSESolidObject)this.getOwnerLabel()).resize();
            }
        }
    }

    public void setJComponent(JComponent jComponent) {
        super.setJComponent(jComponent);
        this.updateTextSize();
    }

    public List getProperties() {
        List list = super.getProperties();
        if (this.checkBox != null) {
            list.add(new TSProperty(SELECTED, (Object)new Boolean(this.checkBox.isSelected())));
        }
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (SELECTED.equals(tSProperty.getName())) {
            if (this.checkBox != null) {
                this.checkBox.setSelected(Boolean.valueOf(tSProperty.getValue().toString()));
            }
        } else {
            super.setProperty(tSProperty);
        }
    }

    public int getDefaultMinimumJComponentSize() {
        return 10;
    }

    public boolean isTransparentByDefault() {
        return false;
    }

    public TSEFont getDefaultFont() {
        return new TSEFont(new Font("Dialog", 1, 12));
    }
}

