/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSEFont;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.ui.TSEJComponentNodeUI;
import editor.Tomahawk;
import java.awt.Cursor;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JComponent;

public class ExJButtonNodeUI
extends TSEJComponentNodeUI {
    JButton button;

    public JComponent newJComponent() {
        this.button = new JButton();
        this.button.setCursor(Cursor.getDefaultCursor());
        return this.button;
    }

    public void setTextColor(TSEColor tSEColor) {
        if (this.button != null) {
            if (tSEColor != null) {
                this.button.setForeground(tSEColor.getColor());
            } else {
                this.button.setForeground(null);
            }
        }
        super.setTextColor(tSEColor);
    }

    public void setFont(TSEFont tSEFont) {
        if (this.button != null) {
            if (tSEFont != null) {
                this.button.setFont(tSEFont.getFont());
            } else {
                this.button.setFont(null);
            }
        }
        super.setFont(tSEFont);
    }

    public void setJustification(int n) {
        if (this.button != null) {
            switch (n) {
                case 2: {
                    this.button.setHorizontalAlignment(2);
                    break;
                }
                case 0: {
                    this.button.setHorizontalAlignment(4);
                    break;
                }
                case 1: {
                    this.button.setHorizontalAlignment(0);
                }
            }
        }
        super.setJustification(n);
    }

    public void setTransparent(boolean bl) {
        if (this.button != null) {
            this.button.setOpaque(!bl);
        }
        super.setTransparent(bl);
    }

    protected void updateTextSize() {
        this.updateTextWidthAndHeight();
        if (this.button != null && this.getOwnerNode() != null) {
            String string = null;
            if (this.getOwnerNode().getTag() instanceof String) {
                string = (String)this.getOwnerNode().getTag();
            }
            this.button.setText(string);
            this.getOwnerNode().resize();
        }
    }

    public int getDefaultMinimumJComponentSize() {
        return 10;
    }

    public void setJComponent(JComponent jComponent) {
        super.setJComponent(jComponent);
        this.updateTextSize();
    }

    public String getDefaultText() {
        return Tomahawk.getResources().getString("string.Untitled");
    }

    public TSEFont getDefaultFont() {
        return new TSEFont(new Font("Dialog", 1, 12));
    }

    public void setOwner(TSENode tSENode) {
        super.setOwner(tSENode);
        if (tSENode != null && (tSENode.getResizability() & 0x1000000) == 0) {
            tSENode.setResizability(3);
        }
    }
}

