/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.editor.dialog.TSUnsignedIntegerField;
import editor.ui.ExCompositeNodeUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ExCompositeUIEditor
extends JDialog {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    ExCompositeNodeUI nodeUI;
    int exitCode = 2;
    String nodeText;
    String[] choices = new String[]{"Dennis Rodman", "Michael Jordan", "Scotty Pippen"};
    JTextArea textArea;
    TSUnsignedIntegerField numberField;
    JComboBox comboBox;

    public ExCompositeUIEditor(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.init();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public ExCompositeUIEditor() {
        this((Frame)null, "Edit Text", true);
    }

    void init() {
        this.textArea = new JTextArea();
        this.numberField = new TSUnsignedIntegerField(5, 5);
        this.comboBox = new JComboBox();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new GridLayout());
        jButton.setMaximumSize(new Dimension(80, 25));
        jButton.setText("OK");
        jButton.setActionCommand("ok");
        jButton.setPreferredSize(new Dimension(80, 25));
        jButton.setMinimumSize(new Dimension(80, 25));
        jButton.addActionListener(new OKButtonActionAdapter());
        jButton2.setMaximumSize(new Dimension(80, 25));
        jButton2.setText("Cancel");
        jButton2.setPreferredSize(new Dimension(80, 25));
        jButton2.setMinimumSize(new Dimension(80, 25));
        jButton2.addActionListener(new CancelButtonActionAdapter());
        this.textArea.setPreferredSize(new Dimension(100, 50));
        this.textArea.setRows(5);
        this.textArea.setMinimumSize(new Dimension(100, 60));
        this.comboBox.setEditable(true);
        this.getContentPane().add(jPanel);
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.numberField, null);
        jPanel2.add((Component)this.comboBox, null);
        jPanel.add((Component)jPanel3, "South");
        jPanel3.add((Component)jButton, null);
        jPanel3.add((Component)jButton2, null);
        jPanel.add((Component)this.textArea, "Center");
    }

    public void insertStrings(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.textArea.append((String)list.get(i));
            if (i + 1 >= list.size()) continue;
            this.textArea.append("\n");
        }
    }

    public void setNodeUI(ExCompositeNodeUI exCompositeNodeUI) {
        this.nodeUI = exCompositeNodeUI;
        this.numberField.setText(Integer.toString(this.nodeUI.getNumber()));
        this.comboBox.addItem(this.nodeUI.getTitle());
        for (int i = 0; i < this.choices.length; ++i) {
            if (this.choices[i].equals(this.nodeUI.getTitle())) continue;
            this.comboBox.addItem(this.choices[i]);
        }
        this.insertStrings(this.nodeUI.getStrings());
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getText() {
        return this.nodeText;
    }

    void okPressed(ActionEvent actionEvent) {
        this.nodeText = this.numberField.getText() + "|" + this.comboBox.getSelectedItem() + "|" + this.textArea.getText();
        this.exitCode = 1;
        this.setVisible(false);
    }

    void cancelPressed(ActionEvent actionEvent) {
        this.nodeText = null;
        this.exitCode = 2;
        this.setVisible(false);
    }

    public static String showDialog(Component component, ExCompositeNodeUI exCompositeNodeUI) {
        ExCompositeUIEditor exCompositeUIEditor = new ExCompositeUIEditor(JOptionPane.getFrameForComponent(component), "Edit Text", true);
        exCompositeUIEditor.setLocationRelativeTo(component);
        exCompositeUIEditor.setNodeUI(exCompositeNodeUI);
        exCompositeUIEditor.show();
        exCompositeUIEditor.numberField.grabFocus();
        String string = null;
        if (exCompositeUIEditor.getExitCode() == 1) {
            string = exCompositeUIEditor.getText();
        }
        exCompositeUIEditor.dispose();
        return string;
    }

    class CancelButtonActionAdapter
    implements ActionListener {
        CancelButtonActionAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExCompositeUIEditor.this.cancelPressed(actionEvent);
        }
    }

    class OKButtonActionAdapter
    implements ActionListener {
        OKButtonActionAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExCompositeUIEditor.this.okPressed(actionEvent);
        }
    }
}

