/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEImage;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.event.TSEAnyChangeAdapter;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editorx.ui.TSEImageNodeUI;
import com.tomsawyer.event.TSEvent;
import editor.ExGraphWindow;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;

public class ExAnimatedImageNodeUI
extends TSEImageNodeUI
implements ActionListener {
    ExGraphWindow parentWindow;
    boolean listening;
    EventListener eventListener;

    public void reset() {
        super.reset();
        this.listening = false;
        this.eventListener = new AnimatedImageEventListener();
        this.parentWindow = null;
    }

    public void draw(TSEGraphics tSEGraphics) {
        TSEGraphWindow tSEGraphWindow = tSEGraphics.getGraphWindow();
        if (this.parentWindow == null && !tSEGraphWindow.isOverview() && tSEGraphWindow instanceof ExGraphWindow) {
            this.parentWindow = (ExGraphWindow)tSEGraphWindow;
        }
        this.setListening(true);
        super.draw(tSEGraphics);
    }

    protected void setListening(boolean bl) {
        if (this.listening != bl && this.parentWindow != null) {
            this.listening = bl;
            if (bl) {
                this.parentWindow.addTimerListener(this);
                this.registerListeners();
            } else {
                this.parentWindow.removeTimerListener(this);
                this.unregisterListeners();
            }
        }
    }

    public void invalidateWorldBounds() {
        this.parentWindow.addInvalidRegion(this.getOwner());
        this.parentWindow.requestUpdateOnTimer();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.parentWindow != null && this.parentWindow.isTimerEvent(actionEvent)) {
            this.invalidateWorldBounds();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }

    public void registerListeners() {
        TSEGraphManager tSEGraphManager = this.parentWindow.getGraphManager();
        TSEEventManager tSEEventManager = (TSEEventManager)tSEGraphManager.getEventManager();
        tSEEventManager.addGraphChangeListener((Object)tSEGraphManager, this.eventListener);
        tSEEventManager.addDrawingChangeListener((Object)tSEGraphManager, this.eventListener, 1L);
    }

    public void unregisterListeners() {
        this.parentWindow.getGraphManager().getEventManager().removeListener(this.eventListener);
    }

    public void setImage(TSEImage tSEImage) {
        super.setImage(tSEImage);
        tSEImage.setAnimated(true);
    }

    public class AnimatedImageEventListener
    extends TSEAnyChangeAdapter {
        AnimatedImageEventListener() {
        }

        public void drawingChanged(TSDrawingChangeEvent tSDrawingChangeEvent) {
            if (tSDrawingChangeEvent.getType() == 1L) {
                boolean bl;
                TSENode tSENode = ExAnimatedImageNodeUI.this.getOwnerNode();
                boolean bl2 = bl = tSENode != null && tSENode.isOwned() && tSENode.isViewable();
                if (!bl) {
                    ExAnimatedImageNodeUI.this.setListening(false);
                    ExAnimatedImageNodeUI.this.parentWindow = null;
                }
            }
        }

        public void anyChange(TSEvent tSEvent) {
            TSENode tSENode = ExAnimatedImageNodeUI.this.getOwnerNode();
            boolean bl = tSENode != null && tSENode.isOwned() && tSENode.isViewable();
            ExAnimatedImageNodeUI.this.setListening(bl);
        }
    }
}

