/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.LookupTable;
import java.awt.image.RescaleOp;
import java.awt.image.ShortLookupTable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.batik.dom.svg.ExtensibleSVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.svggen.ClipKey;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.DOMTreeManager;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.DefaultImageHandler;
import org.apache.batik.svggen.ImageHandlerBase64Encoder;
import org.apache.batik.svggen.ImageHandlerJPEGEncoder;
import org.apache.batik.svggen.ImageHandlerPNGEncoder;
import org.apache.batik.svggen.NullOp;
import org.apache.batik.svggen.SVGAlphaComposite;
import org.apache.batik.svggen.SVGBasicStroke;
import org.apache.batik.svggen.SVGBufferedImageOp;
import org.apache.batik.svggen.SVGCSSStyler;
import org.apache.batik.svggen.SVGClip;
import org.apache.batik.svggen.SVGColor;
import org.apache.batik.svggen.SVGCompositeDescriptor;
import org.apache.batik.svggen.SVGConvolveOp;
import org.apache.batik.svggen.SVGEllipse;
import org.apache.batik.svggen.SVGFilterDescriptor;
import org.apache.batik.svggen.SVGFont;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicContext;
import org.apache.batik.svggen.SVGGraphicContextConverter;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGLine;
import org.apache.batik.svggen.SVGLinearGradient;
import org.apache.batik.svggen.SVGLookupOp;
import org.apache.batik.svggen.SVGPaintDescriptor;
import org.apache.batik.svggen.SVGPath;
import org.apache.batik.svggen.SVGPolygon;
import org.apache.batik.svggen.SVGRectangle;
import org.apache.batik.svggen.SVGRenderingHints;
import org.apache.batik.svggen.SVGRescaleOp;
import org.apache.batik.svggen.SVGShape;
import org.apache.batik.svggen.SVGTexturePaint;
import org.apache.batik.svggen.SVGTransform;
import org.apache.batik.svggen.XmlWriter;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGGraphics2DUnitTester
implements SVGConstants {
    private String[] args;

    public static void main(String[] stringArray) {
        new SVGGraphics2DUnitTester(stringArray).runTest();
    }

    protected SVGGraphics2DUnitTester(String[] stringArray) {
        this.args = stringArray;
    }

    protected Document getDocumentPrototype() {
        return new SVGOMDocument(null, ExtensibleSVGDOMImplementation.getDOMImplementation());
    }

    protected SVGGeneratorContext getContext(Document document) {
        return SVGGeneratorContext.createDefault(document);
    }

    protected void trace(Element element, OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        XmlWriter.writeXml((Node)element, outputStreamWriter);
        ((Writer)outputStreamWriter).flush();
    }

    public void runTest() {
        Object[] objectArray = new Object[]{};
        Method[] methodArray = this.getClass().getMethods();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            String string = method.getName();
            if (this.isTestMethod(method)) {
                System.out.println();
                System.out.println("testing " + string.substring(4, string.length()));
                System.out.println();
                try {
                    method.invoke((Object)this, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n;
        }
        System.exit(0);
    }

    protected boolean isTestMethod(Method method) {
        return method.getName().startsWith("test") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Void.TYPE) && Modifier.isPublic(method.getModifiers());
    }

    public void testCustomization() throws Exception {
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(this.getDocumentPrototype(), new DefaultImageHandler(), new DefaultExtensionHandler(), false);
    }

    public void testDOMGroupManager() throws Exception {
    }

    public void testDOMTreeManager() throws Exception {
        Document document = this.getDocumentPrototype();
        GraphicContext graphicContext = new GraphicContext(new AffineTransform());
        SVGGeneratorContext sVGGeneratorContext = SVGGeneratorContext.createDefault(document);
        DOMTreeManager dOMTreeManager = new DOMTreeManager(graphicContext, sVGGeneratorContext, 2);
        DOMGroupManager dOMGroupManager = new DOMGroupManager(graphicContext, dOMTreeManager);
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "ellipse");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "circle");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "path");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "polygon");
        element.setAttributeNS(null, "fill", "none");
        element5.setAttributeNS(null, "stroke", "none");
        dOMGroupManager.addElement(element);
        graphicContext.setPaint(Color.red);
        dOMGroupManager.addElement(element2);
        graphicContext.setComposite(AlphaComposite.getInstance(5, 0.5f));
        dOMGroupManager.addElement(element3);
        graphicContext.setClip(new Rectangle(30, 30, 60, 60));
        graphicContext.translate(45, 45);
        GraphicContext graphicContext2 = (GraphicContext)graphicContext.clone();
        DOMGroupManager dOMGroupManager2 = new DOMGroupManager(graphicContext2, dOMTreeManager);
        dOMGroupManager2.addElement(element4);
        graphicContext2.setTransform(AffineTransform.getScaleInstance(45.0, 50.0));
        dOMGroupManager2.addElement(element5);
        Element element6 = dOMTreeManager.getTopLevelGroup();
        this.trace(element6, System.out);
    }

    public void testImageHandlerBase64Encoder() throws Exception {
        Object object;
        Object object2;
        Object object3;
        BufferedImage bufferedImage = null;
        if (this.args.length == 0) {
            bufferedImage = new BufferedImage(100, 100, 2);
            object3 = bufferedImage.createGraphics();
            ((Graphics2D)object3).setPaint(Color.red);
            ((Graphics)object3).fillRect(0, 0, 50, 50);
            ((Graphics)object3).fillRect(50, 50, 50, 50);
            ((Graphics)object3).dispose();
        } else {
            object3 = new Component(){};
            object2 = new MediaTracker((Component)object3);
            object = Toolkit.getDefaultToolkit().createImage(this.args[0]);
            ((MediaTracker)object2).addImage((Image)object, 0);
            try {
                ((MediaTracker)object2).waitForAll();
            }
            catch (InterruptedException interruptedException) {
                object = null;
            }
            if (object == null) {
                System.err.println("Could not load : " + this.args[0]);
            }
            bufferedImage = new BufferedImage(((Image)object).getWidth(null), ((Image)object).getHeight(null), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage((Image)object, 0, 0, null);
            graphics2D.dispose();
        }
        object3 = this.getDocumentPrototype();
        object2 = new ImageHandlerBase64Encoder();
        object = object3.createElementNS("http://www.w3.org/2000/svg", "image");
        object2.handleImage(bufferedImage, (Element)object, this.getContext((Document)object3));
        System.out.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        System.out.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20000802//EN\"");
        System.out.println("\"http://www.w3.org/TR/2000/CR-SVG-20000802/DTD/svg-20000802.dtd\">");
        System.out.println();
        System.out.println("<svg width=\"450\" height=\"500\">");
        System.out.println("    <rect width=\"100%\" height=\"100%\" fill=\"yellow\" />");
        System.out.println("    <image width=\"" + bufferedImage.getWidth() + "\" height=\"" + bufferedImage.getHeight() + "\" xlink:href=\"" + XLinkSupport.getXLinkHref((Element)object) + "\" />");
        System.out.println("</svg>");
    }

    public void testImageHandlerJPEGEncoder() throws Exception {
        String string;
        String string2 = null;
        if (this.args.length == 3) {
            string = this.args[1];
            string2 = this.args[2];
        } else {
            string = ".";
        }
        Document document = this.getDocumentPrototype();
        ImageHandlerJPEGEncoder imageHandlerJPEGEncoder = new ImageHandlerJPEGEncoder(string, string2);
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "image");
        BufferedImage bufferedImage = new BufferedImage(60, 40, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, 60, 40);
        graphics2D.setPaint(Color.green);
        graphics2D.fillRect(0, 0, 20, 40);
        graphics2D.setPaint(Color.red);
        graphics2D.fillRect(40, 0, 60, 40);
        graphics2D.dispose();
        imageHandlerJPEGEncoder.handleImage(bufferedImage, element, this.getContext(document));
        System.out.println("Generated xlink:href is : " + element.getAttributeNS("http://www.w3.org/1999/xlink", "href"));
    }

    public void testImageHandlerPNGEncoder() throws Exception {
        String string;
        String string2 = null;
        if (this.args.length == 3) {
            string = this.args[1];
            string2 = this.args[2];
        } else {
            string = ".";
        }
        Document document = this.getDocumentPrototype();
        ImageHandlerPNGEncoder imageHandlerPNGEncoder = new ImageHandlerPNGEncoder(string, string2);
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "image");
        BufferedImage bufferedImage = new BufferedImage(60, 40, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.green);
        graphics2D.fillRect(0, 0, 20, 40);
        graphics2D.setPaint(Color.red);
        graphics2D.fillRect(40, 0, 60, 40);
        graphics2D.dispose();
        imageHandlerPNGEncoder.handleImage(bufferedImage, element, this.getContext(document));
        System.out.println("Generated xlink:href is : " + element.getAttributeNS("http://www.w3.org/1999/xlink", "href"));
    }

    public void testSVGAlphaComposite() throws Exception {
        Element element;
        Element element2;
        AlphaComposite alphaComposite = AlphaComposite.Src;
        AlphaComposite[] alphaCompositeArray = new AlphaComposite[]{AlphaComposite.SrcOver, AlphaComposite.Src, AlphaComposite.SrcIn, AlphaComposite.SrcOut, AlphaComposite.DstIn, AlphaComposite.DstOut, AlphaComposite.Clear, AlphaComposite.getInstance(3, 0.5f), AlphaComposite.getInstance(2, 0.5f), AlphaComposite.getInstance(5, 0.5f), AlphaComposite.getInstance(7, 0.5f), AlphaComposite.getInstance(6, 0.5f), AlphaComposite.getInstance(8, 0.5f), AlphaComposite.getInstance(1, 0.5f)};
        Document document = this.getDocumentPrototype();
        SVGAlphaComposite sVGAlphaComposite = new SVGAlphaComposite(this.getContext(document));
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        element3.setAttributeNS(null, "id", "groupOne");
        this.buildTestGroup(element3, alphaCompositeArray, sVGAlphaComposite);
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        element4.setAttributeNS(null, "id", "group2");
        this.buildTestGroup(element4, alphaCompositeArray, sVGAlphaComposite);
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Iterator iterator = sVGAlphaComposite.getAlphaCompositeFilterSet().iterator();
        while (iterator.hasNext()) {
            element2 = (Element)iterator.next();
            element5.appendChild(element2);
        }
        element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        element2.setAttributeNS(null, "id", "groupThree");
        SVGAlphaComposite sVGAlphaComposite2 = new SVGAlphaComposite(this.getContext(document));
        this.buildTestGroup(element2, new AlphaComposite[]{AlphaComposite.SrcIn, AlphaComposite.DstOut}, sVGAlphaComposite2);
        Element element6 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        element6.setAttributeNS(null, "id", "alphaCompositeSubset");
        Iterator iterator2 = sVGAlphaComposite2.getDefinitionSet().iterator();
        while (iterator2.hasNext()) {
            element = (Element)iterator2.next();
            element6.appendChild(element);
        }
        element2.insertBefore(element6, element2.getFirstChild());
        element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        element.appendChild(element5);
        element.appendChild(element3);
        element.appendChild(element4);
        element.appendChild(element2);
        this.trace(element, System.out);
    }

    private void buildTestGroup(Element element, AlphaComposite[] alphaCompositeArray, SVGAlphaComposite sVGAlphaComposite) {
        Document document = element.getOwnerDocument();
        int n = 0;
        while (n < alphaCompositeArray.length) {
            SVGCompositeDescriptor sVGCompositeDescriptor = sVGAlphaComposite.toSVG(alphaCompositeArray[n]);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element2.setAttributeNS(null, "opacity", sVGCompositeDescriptor.getOpacityValue());
            if (sVGCompositeDescriptor.getDef() != null) {
                element2.setAttributeNS(null, "filter", sVGCompositeDescriptor.getFilterValue());
            }
            element.appendChild(element2);
            ++n;
        }
    }

    public void testSVGBasicStroke() throws Exception {
        Document document = this.getDocumentPrototype();
        BasicStroke[] basicStrokeArray = new BasicStroke[]{new BasicStroke(), new BasicStroke(2.0f), new BasicStroke(4.5f), new BasicStroke(10.0f, 0, 0), new BasicStroke(10.0f, 2, 0), new BasicStroke(10.0f, 1, 0), new BasicStroke(10.0f, 0, 2), new BasicStroke(10.0f, 0, 1), new BasicStroke(50.0f, 1, 0, 100.0f), new BasicStroke(75.0f, 1, 1, 50.0f, new float[]{1.0f, 2.0f, 3.0f, 4.0f}, 0.5f), new BasicStroke(75.0f, 1, 1, 60.0f, new float[]{10.1f, 2.4f, 3.5f, 4.2f}, 10.0f)};
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < basicStrokeArray.length) {
            BasicStroke basicStroke = basicStrokeArray[n];
            Map map = SVGBasicStroke.toSVG(basicStroke).getAttributeMap(null);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                element2.setAttributeNS(null, string, string2);
            }
            element.appendChild(element2);
            ++n;
        }
        this.trace(element, System.out);
    }

    public void testSVGBufferedImageOp() throws Exception {
        Element element;
        Object object;
        byte[] byArray = new byte[256];
        int n = 0;
        while (n <= 255) {
            byArray[n] = (byte)(0xFF & 255 - n);
            ++n;
        }
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f, 3.0f, 3.0f, 3.0f};
        Kernel kernel = new Kernel(3, 3, fArray);
        BufferedImageOp[] bufferedImageOpArray = new BufferedImageOp[]{new LookupOp(new ByteLookupTable(0, byArray), null), new RescaleOp(4.0f, 0.0f, null), new ConvolveOp(kernel), new NullOp()};
        Document document = this.getDocumentPrototype();
        SVGBufferedImageOp sVGBufferedImageOp = new SVGBufferedImageOp(this.getContext(document));
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n2 = 0;
        while (n2 < bufferedImageOpArray.length) {
            SVGFilterDescriptor sVGFilterDescriptor = sVGBufferedImageOp.toSVG(bufferedImageOpArray[n2], null);
            if (sVGFilterDescriptor != null) {
                object = document.createElementNS("http://www.w3.org/2000/svg", "rect");
                object.setAttributeNS(null, "filter", sVGFilterDescriptor.getFilterValue());
                element4.appendChild((Node)object);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < bufferedImageOpArray.length) {
            object = sVGBufferedImageOp.toSVG(bufferedImageOpArray[n3], null);
            if (object != null) {
                element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
                element.setAttributeNS(null, "filter", ((SVGFilterDescriptor)object).getFilterValue());
                element5.appendChild(element);
            }
            ++n3;
        }
        object = sVGBufferedImageOp.getDefinitionSet().iterator();
        while (object.hasNext()) {
            element = (Element)object.next();
            element3.appendChild(element);
        }
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        this.trace(element2, System.out);
    }

    public void testCSSStyler() throws Exception {
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(this.getDocumentPrototype());
        sVGGraphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        sVGGraphics2D.setPaint(new Color(103, 103, 152));
        sVGGraphics2D.fillRect(10, 10, 200, 50);
        sVGGraphics2D.setPaint(Color.white);
        sVGGraphics2D.setFont(new Font("SunSansCondensed-Heavy", 0, 20));
        sVGGraphics2D.drawString("Hello Java 2D to SVG", 40.0f, 40.0f);
        sVGGraphics2D.stream(new OutputStreamWriter(System.out));
    }

    public void testSVGClip() throws Exception {
        Object object;
        Element element;
        Polygon polygon = new Polygon();
        polygon.addPoint(1, 1);
        polygon.addPoint(2, 1);
        polygon.addPoint(3, 2);
        polygon.addPoint(3, 3);
        polygon.addPoint(2, 4);
        polygon.addPoint(1, 3);
        polygon.addPoint(1, 2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(1.0f, 0.0f);
        generalPath.lineTo(1.0f, 1.0f);
        generalPath.lineTo(0.0f, 1.0f);
        generalPath.closePath();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        Area area = new Area(generalPath);
        area.subtract(new Area(double_));
        ClipKey clipKey = new ClipKey(new GeneralPath(polygon));
        ClipKey clipKey2 = new ClipKey(new GeneralPath(polygon));
        System.out.println("key1.equals(key2) = " + clipKey.equals(clipKey2));
        int n = clipKey.hashCode();
        int n2 = clipKey2.hashCode();
        System.out.println("hash1 = " + n);
        System.out.println("hash2 = " + n2);
        Shape[] shapeArray = new Shape[]{polygon, new Rectangle(10, 20, 30, 40), new Rectangle2D.Double(100.0, 200.0, 300.0, 400.0), new Rectangle2D.Float(1000.0f, 2000.0f, 3000.0f, 4000.0f), new RoundRectangle2D.Double(15.0, 16.0, 17.0, 18.0, 30.0, 20.0), new RoundRectangle2D.Float(35.0f, 45.0f, 55.0f, 65.0f, 25.0f, 45.0f), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 100.0f), new Ellipse2D.Double(40.0, 40.0, 240.0, 240.0), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 200.0f), new Ellipse2D.Float(40.0f, 100.0f, 240.0f, 200.0f), new Line2D.Double(1.0, 2.0, 3.0, 4.0), new Line2D.Double(10.0, 20.0, 30.0, 40.0), new QuadCurve2D.Float(20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f), new CubicCurve2D.Float(15.0f, 25.0f, 35.0f, 45.0f, 55.0f, 65.0f, 75.0f, 85.0f), new Arc2D.Double(0.0, 0.0, 100.0, 100.0, 0.0, 90.0, 0), generalPath, area};
        Document document = this.getDocumentPrototype();
        SVGClip sVGClip = new SVGClip(this.getContext(document));
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n3 = 0;
        while (n3 < shapeArray.length) {
            element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element.setAttributeNS(null, "id", shapeArray[n3].getClass().getName());
            element.setAttributeNS(null, "clip-path", (String)sVGClip.toSVG(shapeArray[n3]).getAttributeMap(null).get("clip-path"));
            element4.appendChild(element);
            ++n3;
        }
        element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n4 = 0;
        while (n4 < shapeArray.length) {
            object = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            object.setAttributeNS(null, "id", shapeArray[n4].getClass().getName());
            object.setAttributeNS(null, "clip-path", (String)sVGClip.toSVG(shapeArray[n4]).getAttributeMap(null).get("clip-path"));
            element.appendChild((Node)object);
            ++n4;
        }
        object = sVGClip.getDefinitionSet().iterator();
        while (object.hasNext()) {
            Element element5 = (Element)object.next();
            element3.appendChild(element5);
        }
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element);
        this.trace(element2, System.out);
    }

    public void testSVGColor() throws Exception {
        Color[] colorArray = new Color[]{new Color(0, 255, 255), new Color(0, 0, 0), new Color(0, 0, 255), new Color(255, 0, 255), new Color(128, 128, 128), new Color(0, 128, 0), new Color(0, 255, 0), new Color(128, 0, 0), new Color(0, 0, 128), new Color(128, 128, 0), new Color(128, 0, 128), new Color(255, 0, 0), new Color(192, 192, 192), new Color(0, 128, 128), new Color(255, 255, 255), new Color(255, 255, 0), new Color(30, 40, 50), new Color(255, 30, 200), new Color(0, 0, 0, 128), new Color(255, 255, 255, 64)};
        Document document = this.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < colorArray.length) {
            SVGPaintDescriptor sVGPaintDescriptor = SVGColor.toSVG(colorArray[n]);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element2.setAttributeNS(null, "fill", sVGPaintDescriptor.getPaintValue());
            element2.setAttributeNS(null, "fill-opacity", sVGPaintDescriptor.getOpacityValue());
            element.appendChild(element2);
            ++n;
        }
        this.trace(element, System.out);
    }

    public void testSVGConvolveOp() throws Exception {
        Element element;
        Object object;
        Document document = this.getDocumentPrototype();
        Kernel kernel = new Kernel(5, 3, new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f});
        ConvolveOp[] convolveOpArray = new ConvolveOp[]{new ConvolveOp(kernel), new ConvolveOp(kernel, 1, null), new ConvolveOp(kernel, 0, null)};
        SVGConvolveOp sVGConvolveOp = new SVGConvolveOp(this.getContext(document));
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < convolveOpArray.length) {
            SVGFilterDescriptor sVGFilterDescriptor = sVGConvolveOp.toSVG(convolveOpArray[n]);
            object = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            object.setAttributeNS(null, "filter", sVGFilterDescriptor.getFilterValue());
            element4.appendChild((Node)object);
            ++n;
        }
        int n2 = 0;
        while (n2 < convolveOpArray.length) {
            object = sVGConvolveOp.toSVG(convolveOpArray[n2]);
            element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element.setAttributeNS(null, "filter", ((SVGFilterDescriptor)object).getFilterValue());
            element5.appendChild(element);
            ++n2;
        }
        object = sVGConvolveOp.getDefinitionSet().iterator();
        while (object.hasNext()) {
            element = (Element)object.next();
            element3.appendChild(element);
        }
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        this.trace(element2, System.out);
    }

    public void testSVGEllipse() throws Exception {
        Ellipse2D[] ellipse2DArray = new Ellipse2D[]{new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 100.0f), new Ellipse2D.Double(40.0, 40.0, 240.0, 240.0), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 200.0f), new Ellipse2D.Float(40.0f, 100.0f, 240.0f, 200.0f)};
        Document document = this.getDocumentPrototype();
        SVGEllipse sVGEllipse = new SVGEllipse(this.getContext(document));
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < ellipse2DArray.length) {
            element.appendChild(sVGEllipse.toSVG(ellipse2DArray[n]));
            ++n;
        }
        this.trace(element, System.out);
    }

    public void testSVGFont() throws Exception {
        Font[] fontArray;
        Font[] fontArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        Object[][] objectArrayArray = new Object[][]{{TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMILIGHT}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_SEMIBOLD}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_MEDIUM}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_DEMIBOLD}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_HEAVY}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRABOLD}, {TextAttribute.WEIGHT, TextAttribute.WEIGHT_ULTRABOLD}, {TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR}, {TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE}};
        Hashtable<TextAttribute, Object> hashtable = new Hashtable<TextAttribute, Object>();
        hashtable.put(TextAttribute.SIZE, new Float(45.0f));
        hashtable.put(TextAttribute.FAMILY, "Serif");
        hashtable.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        hashtable.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        Font[] fontArray3 = new Font[objectArrayArray.length];
        int n = 0;
        while (n < fontArray3.length) {
            fontArray = new Hashtable(hashtable);
            fontArray.put(objectArrayArray[n][0], objectArrayArray[n][1]);
            fontArray3[n] = new Font((Map<? extends AttributedCharacterIterator.Attribute, ?>)fontArray);
            ++n;
        }
        fontArray = new Font[]{new Font("dialog", 0, 12), new Font("dialoginput", 0, 12), new Font("monospaced", 0, 12), new Font("serif", 0, 12), new Font("sansserif", 0, 12), new Font("symbol", 0, 12)};
        this.traceFonts(fontArray);
    }

    private void traceFonts(Font[] fontArray) throws Exception {
        Document document = this.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        SVGFont sVGFont = new SVGFont(this.getContext(document));
        GraphicContext graphicContext = new GraphicContext(new AffineTransform());
        int n = 0;
        while (n < fontArray.length) {
            Font font = fontArray[n];
            Map map = sVGFont.toSVG(font, graphicContext.getFontRenderContext()).getAttributeMap(null);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "text");
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = (String)map.get(string);
                element2.setAttributeNS(null, string, string2);
            }
            element2.setAttributeNS(null, "font-size", "30");
            element2.setAttributeNS(null, "x", "30");
            element2.setAttributeNS(null, "y", "" + 40 * (n + 1));
            element2.appendChild(document.createTextNode(font.getFamily()));
            element.appendChild(element2);
            ++n;
        }
        SVGCSSStyler.style(element);
        this.trace(element, System.out);
    }

    public void testSVGGraphicContextConverter() throws Exception {
        Document document = this.getDocumentPrototype();
        GraphicContext graphicContext = new GraphicContext(new AffineTransform());
        SVGGraphicContextConverter sVGGraphicContextConverter = new SVGGraphicContextConverter(this.getContext(document));
        SVGGraphicContext sVGGraphicContext = sVGGraphicContextConverter.toSVG(graphicContext);
        SVGGraphics2DUnitTester.traceSVGGC(sVGGraphicContext, sVGGraphicContextConverter);
        graphicContext.translate(40, 40);
        graphicContext.setPaint(new GradientPaint(0.0f, 0.0f, Color.yellow, 200.0f, 200.0f, Color.red));
        graphicContext.setStroke(new BasicStroke(4.0f, 1, 2, 40.0f, new float[]{4.0f, 5.0f, 6.0f, 7.0f}, 3.0f));
        graphicContext.setComposite(AlphaComposite.getInstance(5, 0.25f));
        graphicContext.setClip(new Ellipse2D.Double(20.0, 30.0, 40.0, 50.0));
        graphicContext.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphicContext.setFont(new Font("French Script MT", 1, 45));
        SVGGraphicContext sVGGraphicContext2 = sVGGraphicContextConverter.toSVG(graphicContext);
        SVGGraphics2DUnitTester.traceSVGGC(sVGGraphicContext2, sVGGraphicContextConverter);
        List list = sVGGraphicContextConverter.getDefinitionSet();
        Iterator iterator = list.iterator();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            element.appendChild(element2);
        }
        this.trace(element, System.out);
    }

    static void traceSVGGC(SVGGraphicContext sVGGraphicContext, SVGGraphicContextConverter sVGGraphicContextConverter) {
        String string;
        Object object;
        System.out.println("=============================================");
        Map map = sVGGraphicContext.getGroupContext();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            string = (String)map.get(object);
            System.out.println((String)object + " = " + string);
        }
        System.out.println("++++++++++++++++++");
        object = sVGGraphicContext.getGraphicElementContext();
        iterator = object.keySet().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            String string2 = (String)object.get(string);
            System.out.println(string + " = " + string2);
        }
        System.out.println("++++++++++++++++++");
        System.out.println("transform: " + sVGGraphicContextConverter.toSVG(sVGGraphicContext.getTransformStack()));
        System.out.println("=============================================");
    }

    public void testSVGLine() throws Exception {
        Line2D[] line2DArray = new Line2D[]{new Line2D.Double(1.0, 2.0, 3.0, 4.0), new Line2D.Double(10.0, 20.0, 30.0, 40.0)};
        Document document = this.getDocumentPrototype();
        SVGLine sVGLine = new SVGLine(this.getContext(document));
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < line2DArray.length) {
            element.appendChild(sVGLine.toSVG(line2DArray[n]));
            ++n;
        }
        this.trace(element, System.out);
    }

    public void testSVGLinearGradient() throws Exception {
        Element element;
        Document document = this.getDocumentPrototype();
        GradientPaint gradientPaint = new GradientPaint(20.0f, 20.0f, Color.black, 300.0f, 300.0f, new Color(220, 230, 240), true);
        SVGLinearGradient sVGLinearGradient = new SVGLinearGradient(this.getContext(document));
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        SVGPaintDescriptor sVGPaintDescriptor = sVGLinearGradient.toSVG(gradientPaint);
        Iterator iterator = sVGLinearGradient.getDefinitionSet().iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            element3.appendChild(element);
        }
        element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
        element.setAttributeNS(null, "fill", sVGPaintDescriptor.getPaintValue());
        element.setAttributeNS(null, "fill-opacity", sVGPaintDescriptor.getOpacityValue());
        element2.appendChild(element3);
        element2.appendChild(element);
        this.trace(element2, System.out);
    }

    public void testSVGLookupOp() throws Exception {
        Element element;
        Object object;
        Document document = this.getDocumentPrototype();
        byte[] byArray = new byte[256];
        short[] sArray = new short[256];
        byte[] byArray2 = new byte[256];
        short[] sArray2 = new short[256];
        int n = 0;
        while (n <= 255) {
            byArray2[n] = (byte)(0xFF & 255 - n);
            byArray[n] = (byte)(0xFF & n);
            sArray2[n] = (short)(0xFFFF & 255 - n);
            sArray[n] = (short)(0xFFFF & n);
            ++n;
        }
        byte[] byArray3 = new byte[128];
        short[] sArray3 = new short[128];
        int n2 = 0;
        while (n2 < 128) {
            byArray3[n2] = (byte)(255 - n2);
            sArray3[n2] = (short)(255 - n2);
            ++n2;
        }
        LookupTable[] lookupTableArray = new LookupTable[]{new ByteLookupTable(0, byArray), new ByteLookupTable(0, new byte[][]{byArray2, byArray, byArray2}), new ByteLookupTable(0, new byte[][]{byArray, byArray2, byArray, byArray2}), new ByteLookupTable(128, byArray3), new ShortLookupTable(0, sArray), new ShortLookupTable(0, new short[][]{sArray2, sArray, sArray2}), new ShortLookupTable(0, new short[][]{sArray, sArray2, sArray, sArray2}), new ShortLookupTable(128, sArray3)};
        LookupOp[] lookupOpArray = new LookupOp[lookupTableArray.length];
        int n3 = 0;
        while (n3 < lookupTableArray.length) {
            lookupOpArray[n3] = new LookupOp(lookupTableArray[n3], null);
            ++n3;
        }
        SVGLookupOp sVGLookupOp = new SVGLookupOp(this.getContext(document));
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n4 = 0;
        while (n4 < lookupOpArray.length) {
            SVGFilterDescriptor sVGFilterDescriptor = sVGLookupOp.toSVG(lookupOpArray[n4]);
            object = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            object.setAttributeNS(null, "filter", sVGFilterDescriptor.getFilterValue());
            element4.appendChild((Node)object);
            ++n4;
        }
        int n5 = 0;
        while (n5 < lookupOpArray.length) {
            object = sVGLookupOp.toSVG(lookupOpArray[n5]);
            element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element.setAttributeNS(null, "filter", ((SVGFilterDescriptor)object).getFilterValue());
            element5.appendChild(element);
            ++n5;
        }
        object = sVGLookupOp.getDefinitionSet().iterator();
        while (object.hasNext()) {
            element = (Element)object.next();
            element3.appendChild(element);
        }
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        this.trace(element2, System.out);
    }

    public void testSVGPath() throws Exception {
        GeneralPath generalPath = new GeneralPath(0);
        generalPath.moveTo(0.0f, 0.0f);
        Shape[] shapeArray = new Shape[]{generalPath, new Rectangle2D.Float(20.0f, 30.0f, 40.0f, 50.0f), new Ellipse2D.Float(25.0f, 35.0f, 80.0f, 60.0f), new Line2D.Float(30.0f, 40.0f, 50.0f, 60.0f), new QuadCurve2D.Float(20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f), new CubicCurve2D.Float(15.0f, 25.0f, 35.0f, 45.0f, 55.0f, 65.0f, 75.0f, 85.0f)};
        Document document = this.getDocumentPrototype();
        SVGPath sVGPath = new SVGPath(this.getContext(document));
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < shapeArray.length) {
            Shape shape = shapeArray[n];
            Element element2 = sVGPath.toSVG(shape);
            element.appendChild(element2);
            ++n;
        }
        this.trace(element, System.out);
    }

    public void testSVGPolygon() throws Exception {
        Polygon polygon = new Polygon();
        polygon.addPoint(350, 75);
        polygon.addPoint(379, 161);
        polygon.addPoint(469, 161);
        polygon.addPoint(397, 215);
        polygon.addPoint(423, 301);
        polygon.addPoint(350, 250);
        polygon.addPoint(277, 301);
        polygon.addPoint(303, 215);
        polygon.addPoint(231, 161);
        polygon.addPoint(321, 161);
        SVGPolygon sVGPolygon = new SVGPolygon(this.getContext(this.getDocumentPrototype()));
        Element element = sVGPolygon.toSVG(polygon);
        this.trace(element, System.out);
        System.out.println();
    }

    public void testSVGRectangle() throws Exception {
        Document document = this.getDocumentPrototype();
        SVGRectangle sVGRectangle = new SVGRectangle(this.getContext(document));
        Element[] elementArray = new Element[]{sVGRectangle.toSVG(new Rectangle(10, 20, 30, 40)), sVGRectangle.toSVG(new Rectangle2D.Double(100.0, 200.0, 300.0, 400.0)), sVGRectangle.toSVG(new Rectangle2D.Float(1000.0f, 2000.0f, 3000.0f, 4000.0f)), sVGRectangle.toSVG(new RoundRectangle2D.Double(15.0, 16.0, 17.0, 18.0, 30.0, 20.0)), sVGRectangle.toSVG(new RoundRectangle2D.Float(35.0f, 45.0f, 55.0f, 65.0f, 25.0f, 45.0f))};
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < elementArray.length) {
            element.appendChild(elementArray[n]);
            ++n;
        }
        this.trace(element, System.out);
    }

    public void testSVGRenderingHints() throws Exception {
        Document document = this.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Hashtable<String, RenderingHints[]> hashtable = new Hashtable<String, RenderingHints[]>();
        RenderingHints renderingHints = new RenderingHints(null);
        RenderingHints[] renderingHintsArray = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT), new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY), new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED)};
        hashtable.put("rendering", renderingHintsArray);
        RenderingHints[] renderingHintsArray2 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT), new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON), new RenderingHints(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF)};
        hashtable.put("fractionalMetrics", renderingHintsArray2);
        RenderingHints[] renderingHintsArray3 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT), new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON), new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF)};
        hashtable.put("antialiasing", renderingHintsArray3);
        RenderingHints[] renderingHintsArray4 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT), new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED), new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY)};
        hashtable.put("colorRendering", renderingHintsArray4);
        RenderingHints[] renderingHintsArray5 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR), new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR), new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC)};
        hashtable.put("interpolation", renderingHintsArray5);
        RenderingHints[] renderingHintsArray6 = new RenderingHints[]{new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT), new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF), new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON)};
        hashtable.put("textAntialiasing", renderingHintsArray6);
        RenderingHints renderingHints2 = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        renderingHints2.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RenderingHints renderingHints3 = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints3.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        RenderingHints[] renderingHintsArray7 = new RenderingHints[]{renderingHints2, renderingHints3};
        hashtable.put("mixed", renderingHintsArray7);
        Iterator iterator = hashtable.keySet().iterator();
        SVGRenderingHints sVGRenderingHints = new SVGRenderingHints();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            RenderingHints[] renderingHintsArray8 = (RenderingHints[])hashtable.get(string);
            Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
            element2.setAttributeNS(null, "id", string);
            int n = 0;
            while (n < renderingHintsArray8.length) {
                Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "rect");
                Map map = SVGRenderingHints.toSVG(renderingHintsArray8[n]).getAttributeMap(null);
                Iterator iterator2 = map.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    element3.setAttributeNS(null, string2, (String)map.get(string2));
                }
                element2.appendChild(element3);
                ++n;
            }
            element.appendChild(element2);
        }
        this.trace(element, System.out);
    }

    public void testSVGRescaleOp() throws Exception {
        Element element;
        Object object;
        Document document = this.getDocumentPrototype();
        RescaleOp[] rescaleOpArray = new RescaleOp[]{new RescaleOp(3.0f, 25.0f, null), new RescaleOp(new float[]{1.0f, 2.0f, 3.0f}, new float[]{10.0f, 20.0f, 30.0f}, null), new RescaleOp(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, new float[]{10.0f, 20.0f, 30.0f, 40.0f}, null)};
        SVGRescaleOp sVGRescaleOp = new SVGRescaleOp(this.getContext(document));
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < rescaleOpArray.length) {
            SVGFilterDescriptor sVGFilterDescriptor = sVGRescaleOp.toSVG(rescaleOpArray[n]);
            object = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            object.setAttributeNS(null, "filter", sVGFilterDescriptor.getFilterValue());
            element4.appendChild((Node)object);
            ++n;
        }
        int n2 = 0;
        while (n2 < rescaleOpArray.length) {
            object = sVGRescaleOp.toSVG(rescaleOpArray[n2]);
            element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element.setAttributeNS(null, "filter", ((SVGFilterDescriptor)object).getFilterValue());
            element5.appendChild(element);
            ++n2;
        }
        object = sVGRescaleOp.getDefinitionSet().iterator();
        while (object.hasNext()) {
            element = (Element)object.next();
            element3.appendChild(element);
        }
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        this.trace(element2, System.out);
    }

    public void testSVGShape() throws Exception {
        Polygon polygon = new Polygon();
        polygon.addPoint(1, 1);
        polygon.addPoint(2, 1);
        polygon.addPoint(3, 2);
        polygon.addPoint(3, 3);
        polygon.addPoint(2, 4);
        polygon.addPoint(1, 3);
        polygon.addPoint(1, 2);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(1.0f, 0.0f);
        generalPath.lineTo(1.0f, 1.0f);
        generalPath.lineTo(0.0f, 1.0f);
        generalPath.closePath();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, 1.0, 1.0);
        Area area = new Area(generalPath);
        area.subtract(new Area(double_));
        Shape[] shapeArray = new Shape[]{polygon, new Rectangle(10, 20, 30, 40), new Rectangle2D.Double(100.0, 200.0, 300.0, 400.0), new Rectangle2D.Float(1000.0f, 2000.0f, 3000.0f, 4000.0f), new RoundRectangle2D.Double(15.0, 16.0, 17.0, 18.0, 30.0, 20.0), new RoundRectangle2D.Float(35.0f, 45.0f, 55.0f, 65.0f, 25.0f, 45.0f), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 100.0f), new Ellipse2D.Double(40.0, 40.0, 240.0, 240.0), new Ellipse2D.Float(0.0f, 0.0f, 100.0f, 200.0f), new Ellipse2D.Float(40.0f, 100.0f, 240.0f, 200.0f), new Line2D.Double(1.0, 2.0, 3.0, 4.0), new Line2D.Double(10.0, 20.0, 30.0, 40.0), new QuadCurve2D.Float(20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f), new CubicCurve2D.Float(15.0f, 25.0f, 35.0f, 45.0f, 55.0f, 65.0f, 75.0f, 85.0f), new Arc2D.Double(0.0, 0.0, 100.0, 100.0, 0.0, 90.0, 0), generalPath, area};
        Document document = this.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "g");
        SVGShape sVGShape = new SVGShape(this.getContext(document));
        int n = 0;
        while (n < shapeArray.length) {
            element.appendChild(sVGShape.toSVG(shapeArray[n]));
            ++n;
        }
        this.trace(element, System.out);
    }

    public void testTexturePaint() throws Exception {
        Element element;
        Document document = this.getDocumentPrototype();
        BufferedImage bufferedImage = new BufferedImage(200, 200, 1);
        TexturePaint texturePaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, 200, 200));
        SVGTexturePaint sVGTexturePaint = new SVGTexturePaint(this.getContext(document));
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        SVGPaintDescriptor sVGPaintDescriptor = sVGTexturePaint.toSVG(texturePaint);
        Iterator iterator = sVGTexturePaint.getDefinitionSet().iterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            element3.appendChild(element);
        }
        element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
        element.setAttributeNS(null, "fill", sVGPaintDescriptor.getPaintValue());
        element.setAttributeNS(null, "fill-opacity", sVGPaintDescriptor.getOpacityValue());
        element2.appendChild(element3);
        element2.appendChild(element);
        this.trace(element2, System.out);
    }

    public void testSVGTransform() throws Exception {
        GraphicContext graphicContext = new GraphicContext();
        graphicContext.translate(20, 20);
        graphicContext.rotate(0.7853981633974483);
        graphicContext.shear(0.5, 0.5);
        graphicContext.scale(20.0, 20.0);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(60.0, 60.0);
        graphicContext.transform(affineTransform);
        String string = SVGTransform.toSVGTransform(graphicContext);
        System.out.println("SVG Transform: " + string);
        graphicContext.setTransform(new AffineTransform());
        graphicContext.translate(45, 45);
        string = SVGTransform.toSVGTransform(graphicContext);
        System.out.println("SVG Transform: " + string);
        graphicContext.setTransform(new AffineTransform());
        graphicContext.translate(10, 10);
        graphicContext.translate(30, 30);
        graphicContext.scale(2.0, 3.0);
        graphicContext.scale(3.0, 2.0);
        graphicContext.rotate(1.5707963267948966);
        graphicContext.rotate(1.5707963267948966);
        graphicContext.translate(100, 100);
        graphicContext.translate(-100, -100);
        graphicContext.scale(2.0, 2.0);
        graphicContext.scale(0.5, 0.5);
        graphicContext.rotate(1.5707963267948966);
        graphicContext.rotate(-1.5707963267948966);
        string = SVGTransform.toSVGTransform(graphicContext);
        System.out.println("SVG Transform: " + string);
    }

    public void testXmlWriter() throws Exception {
        Document document = this.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "svg");
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element6 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Comment comment = document.createComment("This is the topLevelGroup comment");
        element3.appendChild(comment);
        element3.appendChild(element4);
        element3.appendChild(element5);
        element3.appendChild(element6);
        element.appendChild(element2);
        element.appendChild(element3);
        document.appendChild(element);
        this.trace(element, System.out);
        System.out.println("\n=======================================");
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            XmlWriter.writeXml((Node)document, outputStreamWriter);
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }
}

