/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.TextHit;
import org.apache.batik.gvt.text.TextSpanLayout;

public class TextLayoutAdapter
implements TextSpanLayout {
    private TextLayout layout;
    private AttributedCharacterIterator aci;
    private int[] charMap;
    private Point2D offset;
    private AffineTransform transform;

    public TextLayoutAdapter(TextLayout textLayout, Point2D point2D, AttributedCharacterIterator attributedCharacterIterator, int[] nArray) {
        this.layout = textLayout;
        this.aci = attributedCharacterIterator;
        this.charMap = nArray;
        this.offset = this.adjustOffset(point2D);
        this.transform = this.computeTransform();
    }

    public void draw(Graphics2D graphics2D) {
        Shape shape = this.getOutline();
        Paint paint = (Paint)this.aci.getAttribute(TextAttribute.FOREGROUND);
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        Stroke stroke = (Stroke)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE);
        paint = (Paint)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.STROKE_PAINT);
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(shape);
        }
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setOffset(Point2D point2D) {
        this.offset = point2D;
        this.transform = this.computeTransform();
    }

    public Shape getOutline() {
        return this.layout.getOutline(this.transform);
    }

    public Shape getDecorationOutline(int n) {
        GeneralPath generalPath = new GeneralPath();
        if ((n & 1) != 0) {
            generalPath.append(this.getUnderlineShape(this.aci, this.layout), false);
        }
        if ((n & 2) != 0) {
            generalPath.append(this.getStrikethroughShape(this.aci, this.layout), false);
        }
        if ((n & 4) != 0) {
            generalPath.append(this.getOverlineShape(this.aci, this.layout), false);
        }
        return this.transform.createTransformedShape(generalPath);
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = this.layout.getBounds();
        return this.transform.createTransformedShape(rectangle2D).getBounds2D();
    }

    public Rectangle2D getDecoratedBounds() {
        Rectangle2D rectangle2D = this.getDecorationOutline(7).getBounds2D();
        return rectangle2D.createUnion(this.getBounds());
    }

    public Point2D getAdvance2D() {
        return new Point2D.Float(this.layout.getAdvance(), 0.0f);
    }

    public Point2D getTextPathAdvance() {
        return this.getAdvance2D();
    }

    public int getGlyphIndex(int n) {
        int n2 = this.getGlyphCount();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.getCharacterCount(n4, n4);
            int n6 = 0;
            while (n6 < n5) {
                int n7;
                if (n == (n7 = this.charMap[n3++])) {
                    return n4;
                }
                if (n3 >= this.charMap.length) {
                    return -1;
                }
                ++n6;
            }
            ++n4;
        }
        return -1;
    }

    public Shape getHighlightShape(int n, int n2) {
        return this.transform.createTransformedShape(this.layout.getLogicalHighlightShape(Math.max(0, this.getGlyphIndex(n)), Math.max(this.getGlyphCount() - 1, this.getGlyphIndex(n2))));
    }

    public TextHit hitTestChar(float f, float f2) {
        Point2D.Float float_ = new Point2D.Float(f, f2);
        try {
            this.transform.inverseTransform(float_, float_);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        TextHitInfo textHitInfo = this.layout.hitTestChar((float)((Point2D)float_).getX(), (float)((Point2D)float_).getY());
        if (textHitInfo.getCharIndex() == -1) {
            return null;
        }
        int n = this.charMap[textHitInfo.getCharIndex()];
        return new TextHit(n, textHitInfo.isLeadingEdge());
    }

    public boolean isVertical() {
        return this.layout.isVertical();
    }

    public boolean isOnATextPath() {
        return false;
    }

    public int getGlyphCount() {
        return this.layout.getCharacterCount();
    }

    public int getCharacterCount(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 > this.getGlyphCount() - 1) {
            n2 = this.getGlyphCount() - 1;
        }
        return n2 - n + 1;
    }

    public boolean isLeftToRight() {
        return false;
    }

    protected Shape getOverlineShape(AttributedCharacterIterator attributedCharacterIterator, TextLayout textLayout) {
        double d = textLayout.getBaselineOffsets()[0] - textLayout.getAscent();
        BasicStroke basicStroke = new BasicStroke(this.getDecorationThickness(attributedCharacterIterator, textLayout));
        return basicStroke.createStrokedShape(new Line2D.Double(0.0, d, textLayout.getAdvance(), d));
    }

    protected Shape getUnderlineShape(AttributedCharacterIterator attributedCharacterIterator, TextLayout textLayout) {
        double d = (textLayout.getBaselineOffsets()[0] + textLayout.getDescent()) / 2.0f;
        BasicStroke basicStroke = new BasicStroke(this.getDecorationThickness(attributedCharacterIterator, textLayout));
        return basicStroke.createStrokedShape(new Line2D.Double(0.0, d, textLayout.getAdvance(), d));
    }

    protected Shape getStrikethroughShape(AttributedCharacterIterator attributedCharacterIterator, TextLayout textLayout) {
        double d = (textLayout.getBaselineOffsets()[0] - textLayout.getAscent()) / 3.0f;
        BasicStroke basicStroke = new BasicStroke(this.getDecorationThickness(attributedCharacterIterator, textLayout));
        return basicStroke.createStrokedShape(new Line2D.Double(0.0, d, textLayout.getAdvance(), d));
    }

    protected float getDecorationThickness(AttributedCharacterIterator attributedCharacterIterator, TextLayout textLayout) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.WEIGHT);
        float f = object == TextAttribute.WEIGHT_REGULAR ? 14.0f : (object == TextAttribute.WEIGHT_BOLD ? 11.0f : (object == TextAttribute.WEIGHT_LIGHT ? 18.0f : (object == TextAttribute.WEIGHT_DEMIBOLD ? 12.0f : (object == TextAttribute.WEIGHT_DEMILIGHT ? 16.0f : (object == TextAttribute.WEIGHT_EXTRABOLD ? 10.0f : (object == TextAttribute.WEIGHT_EXTRA_LIGHT ? 20.0f : (object == TextAttribute.WEIGHT_SEMIBOLD ? 13.0f : (object == TextAttribute.WEIGHT_ULTRABOLD ? 9.0f : 14.0f))))))));
        return textLayout.getAscent() / f;
    }

    private AffineTransform computeTransform() {
        Float f;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.offset.getX(), this.offset.getY());
        Integer n = (Integer)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST);
        if (n == GVTAttributedCharacterIterator.TextAttribute.ADJUST_ALL && (f = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.BBOX_WIDTH)) != null && !f.isNaN()) {
            double d = 1.0;
            double d2 = 1.0;
            if (this.isVertical()) {
                d2 = (double)f.floatValue() / this.layout.getBounds().getHeight();
            } else {
                d = (double)f.floatValue() / this.layout.getBounds().getWidth();
            }
            try {
                AffineTransform affineTransform2 = affineTransform.createInverse();
                affineTransform.concatenate(AffineTransform.getScaleInstance(d, d2));
                affineTransform.concatenate(affineTransform2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        return affineTransform;
    }

    private Point2D adjustOffset(Point2D point2D) {
        this.aci.first();
        Float f = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.X);
        Float f2 = (Float)this.aci.getAttribute(GVTAttributedCharacterIterator.TextAttribute.Y);
        if (f == null || f.isNaN()) {
            f = new Float((float)point2D.getX());
        }
        if (f2 == null || f2.isNaN()) {
            f2 = new Float((float)point2D.getY());
        }
        return new Point2D.Float(f.floatValue(), f2.floatValue());
    }
}

