/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.AbstractGraphicsNode;
import org.apache.batik.gvt.ShapePainter;

public class ShapeNode
extends AbstractGraphicsNode {
    protected Shape shape;
    protected ShapePainter shapePainter;
    private Rectangle2D primitiveBounds;
    private Rectangle2D geometryBounds;
    private Shape paintedArea;

    public void setShape(Shape shape) {
        this.invalidateGeometryCache();
        this.shape = shape;
        if (this.shapePainter != null) {
            this.shapePainter.setShape(shape);
        }
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShapePainter(ShapePainter shapePainter) {
        this.invalidateGeometryCache();
        this.shapePainter = shapePainter;
        if (this.shapePainter != null && this.shape != this.shapePainter.getShape()) {
            this.shapePainter.setShape(this.shape);
        }
    }

    public ShapePainter getShapePainter() {
        return this.shapePainter;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible) {
            super.paint(graphics2D);
        }
    }

    public void primitivePaint(Graphics2D graphics2D) {
        if (this.shapePainter != null) {
            this.shapePainter.paint(graphics2D);
        }
    }

    protected void invalidateGeometryCache() {
        super.invalidateGeometryCache();
        this.primitiveBounds = null;
        this.geometryBounds = null;
        this.paintedArea = null;
    }

    public boolean contains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getBounds();
        if (rectangle2D != null) {
            return rectangle2D.contains(point2D) && this.paintedArea != null && this.paintedArea.contains(point2D);
        }
        return false;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        if (rectangle2D2 != null) {
            return rectangle2D2.intersects(rectangle2D) && this.paintedArea != null && this.paintedArea.intersects(rectangle2D);
        }
        return false;
    }

    public Rectangle2D getPrimitiveBounds() {
        if (this.primitiveBounds == null) {
            if (this.shape == null || this.shapePainter == null) {
                return null;
            }
            this.paintedArea = this.shapePainter.getPaintedArea();
            this.primitiveBounds = this.paintedArea.getBounds2D();
            if (Thread.currentThread().isInterrupted()) {
                this.invalidateGeometryCache();
            }
        }
        return this.primitiveBounds;
    }

    public Rectangle2D getGeometryBounds() {
        if (this.geometryBounds == null) {
            if (this.shape == null) {
                return null;
            }
            this.geometryBounds = this.shape.getBounds2D();
        }
        return this.geometryBounds;
    }

    public Shape getOutline() {
        return this.shape;
    }
}

