/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeHitDetector;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.gvt.event.GraphicsNodeEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyEvent;
import org.apache.batik.gvt.event.GraphicsNodeKeyListener;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.gvt.filter.GraphicsNodeRable;
import org.apache.batik.gvt.filter.GraphicsNodeRable8Bit;
import org.apache.batik.gvt.filter.Mask;

public abstract class AbstractGraphicsNode
implements GraphicsNode {
    protected EventListenerList listeners;
    protected GraphicsNodeHitDetector hitDetector;
    protected AffineTransform transform;
    protected AffineTransform inverseTransform;
    protected Composite composite;
    protected boolean isVisible = true;
    protected ClipRable clip;
    protected RenderingHints hints;
    protected CompositeGraphicsNode parent;
    protected RootGraphicsNode root;
    protected Mask mask;
    protected Filter filter;
    protected WeakReference graphicsNodeRable;
    private Rectangle2D bounds;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeMouseListener;
    static /* synthetic */ Class class$org$apache$batik$gvt$event$GraphicsNodeKeyListener;

    protected AbstractGraphicsNode() {
    }

    public void setTransform(AffineTransform affineTransform) {
        this.invalidateGeometryCache();
        this.transform = affineTransform;
        if (this.transform.getDeterminant() != 0.0) {
            try {
                this.inverseTransform = this.transform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error();
            }
        } else {
            this.inverseTransform = this.transform;
        }
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public AffineTransform getInverseTransform() {
        return this.inverseTransform;
    }

    public AffineTransform getGlobalTransform() {
        AffineTransform affineTransform = new AffineTransform();
        AbstractGraphicsNode abstractGraphicsNode = this;
        while (abstractGraphicsNode != null) {
            if (abstractGraphicsNode.getTransform() != null) {
                affineTransform.preConcatenate(abstractGraphicsNode.getTransform());
            }
            abstractGraphicsNode = abstractGraphicsNode.getParent();
        }
        return affineTransform;
    }

    public void setComposite(Composite composite) {
        this.invalidateGeometryCache();
        this.composite = composite;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setClip(ClipRable clipRable) {
        this.invalidateGeometryCache();
        this.clip = clipRable;
    }

    public ClipRable getClip() {
        return this.clip;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.hints == null) {
            this.hints = new RenderingHints(key, object);
        } else {
            this.hints.put(key, object);
        }
    }

    public void setRenderingHints(Map map) {
        if (this.hints == null) {
            this.hints = new RenderingHints(map);
        } else {
            this.hints.putAll((Map<?, ?>)map);
        }
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.hints = renderingHints;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setMask(Mask mask) {
        this.invalidateGeometryCache();
        this.mask = mask;
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setFilter(Filter filter) {
        this.invalidateGeometryCache();
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public GraphicsNodeRable getGraphicsNodeRable() {
        GraphicsNodeRable graphicsNodeRable = null;
        if (this.graphicsNodeRable != null && (graphicsNodeRable = (GraphicsNodeRable)this.graphicsNodeRable.get()) != null) {
            return graphicsNodeRable;
        }
        graphicsNodeRable = new GraphicsNodeRable8Bit(this);
        this.graphicsNodeRable = new WeakReference<GraphicsNodeRable>(graphicsNodeRable);
        return graphicsNodeRable;
    }

    public void paint(Graphics2D graphics2D) {
        Cloneable cloneable;
        Object object;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.composite != null && this.composite instanceof AlphaComposite && (double)((AlphaComposite)(object = (AlphaComposite)this.composite)).getAlpha() < 0.001) {
            return;
        }
        object = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        AffineTransform affineTransform = graphics2D.getTransform();
        RenderingHints renderingHints = null;
        if (this.hints != null) {
            renderingHints = graphics2D.getRenderingHints();
            graphics2D.addRenderingHints(this.hints);
        }
        if (this.transform != null) {
            graphics2D.transform(this.transform);
        }
        if (this.composite != null) {
            graphics2D.setComposite(this.composite);
        }
        if (this.clip != null) {
            graphics2D.clip(this.clip.getClipPath());
        }
        Shape shape = graphics2D.getClip();
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_AREA_OF_INTEREST, shape);
        boolean bl = true;
        Rectangle2D rectangle2D = this.getBounds();
        Shape shape2 = graphics2D.getClip();
        if (shape2 != null) {
            cloneable = shape2.getBounds2D();
            if (rectangle2D != null && !rectangle2D.intersects(((RectangularShape)cloneable).getX(), ((RectangularShape)cloneable).getY(), ((RectangularShape)cloneable).getWidth(), ((RectangularShape)cloneable).getHeight())) {
                bl = false;
            }
        }
        if (bl) {
            cloneable = graphics2D.getTransform();
            boolean bl2 = false;
            if (this.clip != null) {
                bl2 = this.isAntialiasedClip(graphics2D.getTransform(), graphics2D.getRenderingHints(), this.clip.getClipPath());
            }
            boolean bl3 = this.isOffscreenBufferNeeded();
            if (!(bl3 |= bl2)) {
                this.primitivePaint(graphics2D);
            } else {
                Filter filter = null;
                filter = this.filter == null ? this.getGraphicsNodeRable() : this.filter;
                if (this.mask != null) {
                    if (this.mask.getSource() != filter) {
                        this.mask.setSource(filter);
                    }
                    filter = this.mask;
                }
                if (this.clip != null && bl2) {
                    if (this.clip.getSource() != filter) {
                        this.clip.setSource(filter);
                    }
                    filter = this.clip;
                }
                if (bl2) {
                    graphics2D.setClip(null);
                }
                Rectangle2D rectangle2D2 = filter.getBounds2D();
                graphics2D.clip(rectangle2D2);
                GraphicsUtil.drawImage(graphics2D, filter);
            }
        }
        if (renderingHints != null) {
            graphics2D.setRenderingHints(renderingHints);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip((Shape)object);
        graphics2D.setComposite(composite);
    }

    private void traceFilter(Filter filter, String string) {
        System.out.println(string + filter.getClass().getName());
        System.out.println(string + filter.getBounds2D());
        Vector<RenderableImage> vector = filter.getSources();
        int n = vector != null ? vector.size() : 0;
        string = string + "\t";
        int n2 = 0;
        while (n2 < n) {
            Filter filter2 = (Filter)vector.elementAt(n2);
            this.traceFilter(filter2, string);
            ++n2;
        }
        System.out.flush();
    }

    protected boolean isOffscreenBufferNeeded() {
        return this.filter != null || this.mask != null || this.composite != null && !AlphaComposite.SrcOver.equals(this.composite);
    }

    protected boolean isAntialiasedClip(AffineTransform affineTransform, RenderingHints renderingHints, Shape shape) {
        boolean bl = false;
        if (!(renderingHints.get(RenderingHints.KEY_ANTIALIASING) != RenderingHints.VALUE_ANTIALIAS_ON && renderingHints.get(RenderingHints.KEY_RENDERING) != RenderingHints.VALUE_RENDER_QUALITY || shape instanceof Rectangle2D && affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0)) {
            bl = true;
        }
        return false;
    }

    public void dispatchEvent(GraphicsNodeEvent graphicsNodeEvent) {
        switch (graphicsNodeEvent.getID()) {
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                this.processMouseEvent((GraphicsNodeMouseEvent)graphicsNodeEvent);
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                this.processKeyEvent((GraphicsNodeKeyEvent)graphicsNodeEvent);
                break;
            }
        }
    }

    public void addGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AbstractGraphicsNode.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, graphicsNodeMouseListener);
    }

    public void removeGraphicsNodeMouseListener(GraphicsNodeMouseListener graphicsNodeMouseListener) {
        if (this.listeners != null) {
            this.listeners.remove(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AbstractGraphicsNode.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener, graphicsNodeMouseListener);
        }
    }

    public void addGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.listeners == null) {
            this.listeners = new EventListenerList();
        }
        this.listeners.add(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AbstractGraphicsNode.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, graphicsNodeKeyListener);
    }

    public void removeGraphicsNodeKeyListener(GraphicsNodeKeyListener graphicsNodeKeyListener) {
        if (this.listeners != null) {
            this.listeners.remove(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AbstractGraphicsNode.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener, graphicsNodeKeyListener);
        }
    }

    public void setGraphicsNodeHitDetector(GraphicsNodeHitDetector graphicsNodeHitDetector) {
        this.hitDetector = graphicsNodeHitDetector;
    }

    public GraphicsNodeHitDetector getGraphicsNodeHitDetector() {
        return this.hitDetector;
    }

    public void processMouseEvent(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
        if (this.listeners != null && this.acceptEvent(graphicsNodeMouseEvent)) {
            GraphicsNodeMouseListener[] graphicsNodeMouseListenerArray = (GraphicsNodeMouseListener[])this.getListeners(class$org$apache$batik$gvt$event$GraphicsNodeMouseListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeMouseListener = AbstractGraphicsNode.class$("org.apache.batik.gvt.event.GraphicsNodeMouseListener")) : class$org$apache$batik$gvt$event$GraphicsNodeMouseListener);
            switch (graphicsNodeMouseEvent.getID()) {
                case 503: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseMoved(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 506: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseDragged(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 504: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseEntered(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 505: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseExited(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 500: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseClicked(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 501: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mousePressed(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                case 502: {
                    int n = 0;
                    while (n < graphicsNodeMouseListenerArray.length) {
                        graphicsNodeMouseListenerArray[n].mouseReleased(graphicsNodeMouseEvent);
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new Error("Unknown Mouse Event type: " + graphicsNodeMouseEvent.getID());
                }
            }
        }
        graphicsNodeMouseEvent.consume();
    }

    public void processKeyEvent(GraphicsNodeKeyEvent graphicsNodeKeyEvent) {
        if (this.listeners != null && this.acceptEvent(graphicsNodeKeyEvent)) {
            GraphicsNodeKeyListener[] graphicsNodeKeyListenerArray = (GraphicsNodeKeyListener[])this.getListeners(class$org$apache$batik$gvt$event$GraphicsNodeKeyListener == null ? (class$org$apache$batik$gvt$event$GraphicsNodeKeyListener = AbstractGraphicsNode.class$("org.apache.batik.gvt.event.GraphicsNodeKeyListener")) : class$org$apache$batik$gvt$event$GraphicsNodeKeyListener);
            switch (graphicsNodeKeyEvent.getID()) {
                case 401: {
                    int n = 0;
                    while (n < graphicsNodeKeyListenerArray.length) {
                        graphicsNodeKeyListenerArray[n].keyPressed(graphicsNodeKeyEvent);
                        ++n;
                    }
                    break;
                }
                case 402: {
                    int n = 0;
                    while (n < graphicsNodeKeyListenerArray.length) {
                        graphicsNodeKeyListenerArray[n].keyReleased(graphicsNodeKeyEvent);
                        ++n;
                    }
                    break;
                }
                case 400: {
                    int n = 0;
                    while (n < graphicsNodeKeyListenerArray.length) {
                        graphicsNodeKeyListenerArray[n].keyTyped(graphicsNodeKeyEvent);
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new Error("Unknown Key Event type: " + graphicsNodeKeyEvent.getID());
                }
            }
        }
        graphicsNodeKeyEvent.consume();
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listeners.getListeners(clazz);
    }

    protected boolean acceptEvent(GraphicsNodeEvent graphicsNodeEvent) {
        return true;
    }

    public CompositeGraphicsNode getParent() {
        return this.parent;
    }

    public RootGraphicsNode getRoot() {
        return this.root;
    }

    protected void setRoot(RootGraphicsNode rootGraphicsNode) {
        this.root = rootGraphicsNode;
    }

    protected void setParent(CompositeGraphicsNode compositeGraphicsNode) {
        this.parent = compositeGraphicsNode;
    }

    protected void invalidateGeometryCache() {
        if (this.parent != null) {
            ((AbstractGraphicsNode)this.parent).invalidateGeometryCache();
        }
        this.bounds = null;
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = this.filter == null ? this.getPrimitiveBounds() : this.filter.getBounds2D();
            if (this.bounds != null) {
                Rectangle2D rectangle2D;
                if (this.clip != null && (rectangle2D = this.clip.getClipPath().getBounds2D()).intersects(this.bounds)) {
                    Rectangle2D.intersect(this.bounds, rectangle2D, this.bounds);
                }
                if (this.mask != null && (rectangle2D = this.mask.getBounds2D()).intersects(this.bounds)) {
                    Rectangle2D.intersect(this.bounds, rectangle2D, this.bounds);
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                this.invalidateGeometryCache();
            }
        }
        return this.bounds;
    }

    public Rectangle2D getTransformedBounds(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        Rectangle2D rectangle2D = null;
        rectangle2D = this.filter == null ? this.getTransformedPrimitiveBounds(affineTransform) : affineTransform2.createTransformedShape(this.filter.getBounds2D()).getBounds2D();
        if (rectangle2D != null) {
            if (this.clip != null) {
                Rectangle2D.intersect(rectangle2D, affineTransform2.createTransformedShape(this.clip.getClipPath()).getBounds2D(), rectangle2D);
            }
            if (this.mask != null) {
                Rectangle2D.intersect(rectangle2D, affineTransform2.createTransformedShape(this.mask.getBounds2D()).getBounds2D(), rectangle2D);
            }
        }
        return rectangle2D;
    }

    public Rectangle2D getTransformedPrimitiveBounds(AffineTransform affineTransform) {
        Rectangle2D rectangle2D = this.getPrimitiveBounds();
        if (rectangle2D == null) {
            return null;
        }
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        return affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
    }

    public Rectangle2D getTransformedGeometryBounds(AffineTransform affineTransform) {
        Rectangle2D rectangle2D = this.getGeometryBounds();
        if (rectangle2D == null) {
            return null;
        }
        AffineTransform affineTransform2 = affineTransform;
        if (this.transform != null) {
            affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.transform);
        }
        return affineTransform2.createTransformedShape(rectangle2D).getBounds2D();
    }

    public boolean contains(Point2D point2D) {
        return this.getBounds().contains(point2D);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.getBounds().intersects(rectangle2D);
    }

    public Shape getTransformedOutline() {
        if (this.transform != null) {
            return this.transform.createTransformedShape(this.getOutline());
        }
        return this.getOutline();
    }

    public GraphicsNode nodeHitAt(Point2D point2D) {
        if (this.hitDetector != null) {
            if (this.hitDetector.isHit(this, point2D)) {
                return this;
            }
            return null;
        }
        return this.contains(point2D) ? this : null;
    }

    public abstract Shape getOutline();

    public abstract Rectangle2D getGeometryBounds();

    public abstract Rectangle2D getPrimitiveBounds();

    public abstract void primitivePaint(Graphics2D var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

