/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Point;
import java.awt.image.Raster;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.apache.batik.ext.awt.image.rendered.LRUCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileLRUMember;
import org.apache.batik.ext.awt.image.rendered.TileStore;

public class TileMap
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private static ReferenceQueue queue = new ReferenceQueue();
    private static HashMap items = new HashMap();
    private HashMap rasters = new HashMap();
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;
    static Thread cleanup;
    static /* synthetic */ Class class$org$apache$batik$ext$awt$image$rendered$TileMap;

    public TileMap(TileGenerator tileGenerator, LRUCache lRUCache) {
        this.cache = lRUCache;
        this.source = tileGenerator;
    }

    public void setTile(int n, int n2, Raster raster) {
        TileMapLRUMember tileMapLRUMember;
        Point point = new Point(n, n2);
        if (raster == null) {
            Object v = this.rasters.remove(point);
            if (v != null) {
                this.cache.remove((TileMapLRUMember)v);
            }
            return;
        }
        Object v = this.rasters.get(point);
        if (v == null) {
            tileMapLRUMember = new TileMapLRUMember(this, point, raster);
            this.rasters.put(point, tileMapLRUMember);
        } else {
            tileMapLRUMember = (TileMapLRUMember)v;
            tileMapLRUMember.setRaster(raster);
        }
        this.cache.add(tileMapLRUMember);
    }

    public Raster getTileNoCompute(int n, int n2) {
        Point point = new Point(n, n2);
        Object v = this.rasters.get(point);
        if (v == null) {
            return null;
        }
        TileMapLRUMember tileMapLRUMember = (TileMapLRUMember)v;
        Raster raster = tileMapLRUMember.retrieveRaster();
        if (raster != null) {
            this.cache.add(tileMapLRUMember);
        }
        return raster;
    }

    public Raster getTile(int n, int n2) {
        Raster raster = null;
        Point point = new Point(n, n2);
        Object v = this.rasters.get(point);
        TileMapLRUMember tileMapLRUMember = null;
        if (v != null) {
            tileMapLRUMember = (TileMapLRUMember)v;
            raster = tileMapLRUMember.retrieveRaster();
        }
        if (raster == null) {
            raster = this.source.genTile(n, n2);
            if (Thread.currentThread().isInterrupted()) {
                return raster;
            }
            if (tileMapLRUMember != null) {
                tileMapLRUMember.setRaster(raster);
            } else {
                tileMapLRUMember = new TileMapLRUMember(this, point, raster);
                this.rasters.put(point, tileMapLRUMember);
            }
        }
        this.cache.add(tileMapLRUMember);
        return raster;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        cleanup = new Thread(){

            public void run() {
                while (true) {
                    Reference reference;
                    try {
                        reference = queue.remove();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    HashMap hashMap = items;
                    synchronized (hashMap) {
                        Object v = items.remove(reference);
                        if (v == null) {
                            continue;
                        }
                        TileMapLRUMember tileMapLRUMember = (TileMapLRUMember)v;
                        TileMap tileMap = (TileMap)tileMapLRUMember.parent.get();
                        if (tileMap != null) {
                            tileMap.rasters.remove(tileMapLRUMember.pt);
                        }
                    }
                }
            }
        };
        cleanup.setDaemon(true);
        cleanup.start();
    }

    static class TileMapLRUMember
    extends TileLRUMember {
        public Point pt;
        public SoftReference parent;

        TileMapLRUMember(TileMap tileMap, Point point, Raster raster) {
            super(raster);
            this.parent = new SoftReference<TileMap>(tileMap);
            this.pt = point;
        }

        public void setRaster(Raster raster) {
            this.hRaster = raster;
            HashMap hashMap = items;
            synchronized (hashMap) {
                if (this.wRaster != null) {
                    items.remove(this.wRaster);
                }
                this.wRaster = new SoftReference<Raster>(raster, queue);
                items.put(this.wRaster, this);
            }
        }
    }
}

