/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.batik.css.CSSDocumentHandler;
import org.apache.batik.css.CSSOMStyleDeclaration;
import org.apache.batik.css.CSSOMStyleSheet;
import org.apache.batik.css.DOMMediaList;
import org.apache.batik.css.svg.SVGValueFactoryMap;
import org.apache.batik.css.svg.SVGViewCSS;
import org.apache.batik.dom.AbstractDOMImplementation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericElement;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.StyleSheetFactory;
import org.apache.batik.dom.events.DocumentEventSupport;
import org.apache.batik.dom.svg.ElementNonCSSPresentationalHintsSupport;
import org.apache.batik.dom.svg.SVGOMAElement;
import org.apache.batik.dom.svg.SVGOMAltGlyphDefElement;
import org.apache.batik.dom.svg.SVGOMAltGlyphElement;
import org.apache.batik.dom.svg.SVGOMAltGlyphItemElement;
import org.apache.batik.dom.svg.SVGOMAnimateColorElement;
import org.apache.batik.dom.svg.SVGOMAnimateElement;
import org.apache.batik.dom.svg.SVGOMAnimateMotionElement;
import org.apache.batik.dom.svg.SVGOMAnimateTransformElement;
import org.apache.batik.dom.svg.SVGOMCircleElement;
import org.apache.batik.dom.svg.SVGOMClipPathElement;
import org.apache.batik.dom.svg.SVGOMColorProfileElement;
import org.apache.batik.dom.svg.SVGOMCursorElement;
import org.apache.batik.dom.svg.SVGOMDefinitionSrcElement;
import org.apache.batik.dom.svg.SVGOMDefsElement;
import org.apache.batik.dom.svg.SVGOMDescElement;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMEllipseElement;
import org.apache.batik.dom.svg.SVGOMEvent;
import org.apache.batik.dom.svg.SVGOMFEBlendElement;
import org.apache.batik.dom.svg.SVGOMFEColorMatrixElement;
import org.apache.batik.dom.svg.SVGOMFEComponentTransferElement;
import org.apache.batik.dom.svg.SVGOMFECompositeElement;
import org.apache.batik.dom.svg.SVGOMFEConvolveMatrixElement;
import org.apache.batik.dom.svg.SVGOMFEDiffuseLightingElement;
import org.apache.batik.dom.svg.SVGOMFEDisplacementMapElement;
import org.apache.batik.dom.svg.SVGOMFEDistantLightElement;
import org.apache.batik.dom.svg.SVGOMFEFloodElement;
import org.apache.batik.dom.svg.SVGOMFEFuncAElement;
import org.apache.batik.dom.svg.SVGOMFEFuncBElement;
import org.apache.batik.dom.svg.SVGOMFEFuncGElement;
import org.apache.batik.dom.svg.SVGOMFEFuncRElement;
import org.apache.batik.dom.svg.SVGOMFEGaussianBlurElement;
import org.apache.batik.dom.svg.SVGOMFEImageElement;
import org.apache.batik.dom.svg.SVGOMFEMergeElement;
import org.apache.batik.dom.svg.SVGOMFEMergeNodeElement;
import org.apache.batik.dom.svg.SVGOMFEMorphologyElement;
import org.apache.batik.dom.svg.SVGOMFEOffsetElement;
import org.apache.batik.dom.svg.SVGOMFEPointLightElement;
import org.apache.batik.dom.svg.SVGOMFESpecularLightingElement;
import org.apache.batik.dom.svg.SVGOMFESpotLightElement;
import org.apache.batik.dom.svg.SVGOMFETileElement;
import org.apache.batik.dom.svg.SVGOMFETurbulenceElement;
import org.apache.batik.dom.svg.SVGOMFilterElement;
import org.apache.batik.dom.svg.SVGOMFontElement;
import org.apache.batik.dom.svg.SVGOMFontFaceElement;
import org.apache.batik.dom.svg.SVGOMFontFaceFormatElement;
import org.apache.batik.dom.svg.SVGOMFontFaceNameElement;
import org.apache.batik.dom.svg.SVGOMFontFaceSrcElement;
import org.apache.batik.dom.svg.SVGOMFontFaceUriElement;
import org.apache.batik.dom.svg.SVGOMForeignObjectElement;
import org.apache.batik.dom.svg.SVGOMGElement;
import org.apache.batik.dom.svg.SVGOMGlyphElement;
import org.apache.batik.dom.svg.SVGOMGlyphRefElement;
import org.apache.batik.dom.svg.SVGOMHKernElement;
import org.apache.batik.dom.svg.SVGOMImageElement;
import org.apache.batik.dom.svg.SVGOMLineElement;
import org.apache.batik.dom.svg.SVGOMLinearGradientElement;
import org.apache.batik.dom.svg.SVGOMMPathElement;
import org.apache.batik.dom.svg.SVGOMMarkerElement;
import org.apache.batik.dom.svg.SVGOMMaskElement;
import org.apache.batik.dom.svg.SVGOMMetadataElement;
import org.apache.batik.dom.svg.SVGOMMissingGlyphElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.svg.SVGOMPatternElement;
import org.apache.batik.dom.svg.SVGOMPolygonElement;
import org.apache.batik.dom.svg.SVGOMPolylineElement;
import org.apache.batik.dom.svg.SVGOMRadialGradientElement;
import org.apache.batik.dom.svg.SVGOMRectElement;
import org.apache.batik.dom.svg.SVGOMSVGElement;
import org.apache.batik.dom.svg.SVGOMScriptElement;
import org.apache.batik.dom.svg.SVGOMSetElement;
import org.apache.batik.dom.svg.SVGOMStopElement;
import org.apache.batik.dom.svg.SVGOMStyleElement;
import org.apache.batik.dom.svg.SVGOMSwitchElement;
import org.apache.batik.dom.svg.SVGOMSymbolElement;
import org.apache.batik.dom.svg.SVGOMTRefElement;
import org.apache.batik.dom.svg.SVGOMTSpanElement;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.dom.svg.SVGOMTextPathElement;
import org.apache.batik.dom.svg.SVGOMTitleElement;
import org.apache.batik.dom.svg.SVGOMUseElement;
import org.apache.batik.dom.svg.SVGOMVKernElement;
import org.apache.batik.dom.svg.SVGOMViewElement;
import org.apache.batik.dom.util.CSSStyleDeclarationFactory;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.i18n.Localizable;
import org.apache.batik.i18n.LocalizableSupport;
import org.apache.batik.util.SVGConstants;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DOMImplementationCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.Event;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.views.DocumentView;

public class SVGDOMImplementation
extends AbstractDOMImplementation
implements Localizable,
DOMImplementationCSS,
CSSStyleDeclarationFactory,
StyleSheetFactory,
SVGConstants {
    public static final String SVG_NAMESPACE_URI = "http://www.w3.org/2000/svg";
    protected static final DOMImplementation DOM_IMPLEMENTATION = new SVGDOMImplementation();
    protected static final String RESOURCES = "org.apache.batik.dom.svg.resources.Messages";
    protected Parser parser = CSSDocumentHandler.createParser();
    protected SVGValueFactoryMap valueFactoryMap = new SVGValueFactoryMap(this.parser);
    protected LocalizableSupport localizableSupport = new LocalizableSupport("org.apache.batik.dom.svg.resources.Messages");
    protected Set presentationAttributeSet = ElementNonCSSPresentationalHintsSupport.createPresentionAttributeSet();
    protected HashTable factories = new HashTable();

    public static DOMImplementation getDOMImplementation() {
        return DOM_IMPLEMENTATION;
    }

    public SVGDOMImplementation() {
        this.factories.put("a", new AElementFactory());
        this.factories.put("altGlyph", new AltGlyphElementFactory());
        this.factories.put("altGlyphDef", new AltGlyphDefElementFactory());
        this.factories.put("altGlyphItem", new AltGlyphItemElementFactory());
        this.factories.put("animate", new AnimateElementFactory());
        this.factories.put("animateColor", new AnimateColorElementFactory());
        this.factories.put("animateMotion", new AnimateMotionElementFactory());
        this.factories.put("animateTransform", new AnimateTransformElementFactory());
        this.factories.put("circle", new CircleElementFactory());
        this.factories.put("clipPath", new ClipPathElementFactory());
        this.factories.put("color-profile", new ColorProfileElementFactory());
        this.factories.put("cursor", new CursorElementFactory());
        this.factories.put("definition-src", new DefinitionSrcElementFactory());
        this.factories.put("defs", new DefsElementFactory());
        this.factories.put("desc", new DescElementFactory());
        this.factories.put("ellipse", new EllipseElementFactory());
        this.factories.put("feBlend", new FeBlendElementFactory());
        this.factories.put("feColorMatrix", new FeColorMatrixElementFactory());
        this.factories.put("feComponentTransfer", new FeComponentTransferElementFactory());
        this.factories.put("feComposite", new FeCompositeElementFactory());
        this.factories.put("feConvolveMatrix", new FeConvolveMatrixElementFactory());
        this.factories.put("feDiffuseLighting", new FeDiffuseLightingElementFactory());
        this.factories.put("feDisplacementMap", new FeDisplacementMapElementFactory());
        this.factories.put("feDistantLight", new FeDistantLightElementFactory());
        this.factories.put("feFlood", new FeFloodElementFactory());
        this.factories.put("feFuncA", new FeFuncAElementFactory());
        this.factories.put("feFuncR", new FeFuncRElementFactory());
        this.factories.put("feFuncG", new FeFuncGElementFactory());
        this.factories.put("feFuncB", new FeFuncBElementFactory());
        this.factories.put("feGaussianBlur", new FeGaussianBlurElementFactory());
        this.factories.put("feImage", new FeImageElementFactory());
        this.factories.put("feMerge", new FeMergeElementFactory());
        this.factories.put("feMergeNode", new FeMergeNodeElementFactory());
        this.factories.put("feMorphology", new FeMorphologyElementFactory());
        this.factories.put("feOffset", new FeOffsetElementFactory());
        this.factories.put("fePointLight", new FePointLightElementFactory());
        this.factories.put("feSpecularLighting", new FeSpecularLightingElementFactory());
        this.factories.put("feSpotLight", new FeSpotLightElementFactory());
        this.factories.put("feTile", new FeTileElementFactory());
        this.factories.put("feTurbulence", new FeTurbulenceElementFactory());
        this.factories.put("filter", new FilterElementFactory());
        this.factories.put("font", new FontElementFactory());
        this.factories.put("font-face", new FontFaceElementFactory());
        this.factories.put("font-face-format", new FontFaceFormatElementFactory());
        this.factories.put("font-face-name", new FontFaceNameElementFactory());
        this.factories.put("font-face-src", new FontFaceSrcElementFactory());
        this.factories.put("font-face-uri", new FontFaceUriElementFactory());
        this.factories.put("foreignObject", new ForeignObjectElementFactory());
        this.factories.put("g", new GElementFactory());
        this.factories.put("glyph", new GlyphElementFactory());
        this.factories.put("glyphRef", new GlyphRefElementFactory());
        this.factories.put("hkern", new HkernElementFactory());
        this.factories.put("image", new ImageElementFactory());
        this.factories.put("line", new LineElementFactory());
        this.factories.put("linearGradient", new LinearGradientElementFactory());
        this.factories.put("marker", new MarkerElementFactory());
        this.factories.put("mask", new MaskElementFactory());
        this.factories.put("metadata", new MetadataElementFactory());
        this.factories.put("missing-glyph", new MissingGlyphElementFactory());
        this.factories.put("mpath", new MpathElementFactory());
        this.factories.put("path", new PathElementFactory());
        this.factories.put("pattern", new PatternElementFactory());
        this.factories.put("polygon", new PolygonElementFactory());
        this.factories.put("polyline", new PolylineElementFactory());
        this.factories.put("radialGradient", new RadialGradientElementFactory());
        this.factories.put("rect", new RectElementFactory());
        this.factories.put("set", new SetElementFactory());
        this.factories.put("script", new ScriptElementFactory());
        this.factories.put("stop", new StopElementFactory());
        this.factories.put("style", new StyleElementFactory());
        this.factories.put("svg", new SvgElementFactory());
        this.factories.put("switch", new SwitchElementFactory());
        this.factories.put("symbol", new SymbolElementFactory());
        this.factories.put("text", new TextElementFactory());
        this.factories.put("textPath", new TextPathElementFactory());
        this.factories.put("title", new TitleElementFactory());
        this.factories.put("tref", new TrefElementFactory());
        this.factories.put("tspan", new TspanElementFactory());
        this.factories.put("use", new UseElementFactory());
        this.factories.put("view", new ViewElementFactory());
        this.factories.put("vkern", new VkernElementFactory());
        this.registerFeature("CSS", "2.0");
        this.registerFeature("StyleSheets", "2.0");
        this.registerFeature("SVG", "1.0");
        this.registerFeature("SVGEvents", "1.0");
    }

    public ViewCSS createViewCSS(SVGOMDocument sVGOMDocument) {
        SVGViewCSS sVGViewCSS = new SVGViewCSS((DocumentView)sVGOMDocument, sVGOMDocument.getSVGContext());
        sVGViewCSS.setUserAgentStyleSheet(this.getUserAgentStyleSheet());
        return sVGViewCSS;
    }

    public Set getPresentionAttributeSet() {
        return this.presentationAttributeSet;
    }

    public DocumentType createDocumentType(String string, String string2, String string3) {
        throw new DOMException(9, this.formatMessage("doctype.not.supported", null));
    }

    public Document createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        SVGOMDocument sVGOMDocument = new SVGOMDocument(documentType, this);
        sVGOMDocument.appendChild(sVGOMDocument.createElementNS(string, string2));
        return sVGOMDocument;
    }

    public CSSStyleSheet createCSSStyleSheet(String string, String string2) {
        try {
            return new CSSOMStyleSheet(null, null, null, string, new DOMMediaList(string2), null, this.valueFactoryMap, CSSDocumentHandler.createParser());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public CSSStyleDeclaration createCSSStyleDeclaration() {
        try {
            CSSOMStyleDeclaration cSSOMStyleDeclaration = new CSSOMStyleDeclaration();
            cSSOMStyleDeclaration.setValueFactoryMap(this.valueFactoryMap);
            return cSSOMStyleDeclaration;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    public StyleSheet createStyleSheet(Node node, HashTable hashTable) {
        String string = (String)hashTable.get("type");
        if ("text/css".equals(string)) {
            try {
                String string2 = (String)hashTable.get("title");
                String string3 = (String)hashTable.get("media");
                String string4 = (String)hashTable.get("href");
                String string5 = (String)hashTable.get("alternate");
                SVGOMDocument sVGOMDocument = (SVGOMDocument)node.getOwnerDocument();
                URL uRL = new URL(sVGOMDocument.getURLObject(), string4);
                CSSOMStyleSheet cSSOMStyleSheet = new CSSOMStyleSheet(node, null, uRL.toString(), string2, new DOMMediaList(string3), null, this.valueFactoryMap, CSSDocumentHandler.createParser());
                CSSDocumentHandler.parseStyleSheet(cSSOMStyleSheet, uRL.toString());
                cSSOMStyleSheet.setDisabled(string2 != null && "yes".equals(string5));
                return cSSOMStyleSheet;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public CSSStyleSheet getUserAgentStyleSheet() {
        CSSStyleSheet cSSStyleSheet = null;
        URL uRL = this.getClass().getResource("resources/UserAgentStyleSheet.css");
        if (uRL != null) {
            String string = uRL.toString();
            cSSStyleSheet = this.createCSSStyleSheet("User Agent Style Sheet", "all");
            try {
                CSSDocumentHandler.parseStyleSheet((CSSOMStyleSheet)cSSStyleSheet, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cSSStyleSheet;
    }

    public Element createElementNS(AbstractDocument abstractDocument, String string, String string2) {
        if (string == null) {
            return new GenericElement(string2.intern(), abstractDocument);
        }
        if (string.equals(SVG_NAMESPACE_URI)) {
            String string3 = DOMUtilities.getLocalName(string2);
            ElementFactory elementFactory = (ElementFactory)this.factories.get(string3);
            if (elementFactory == null) {
                throw abstractDocument.createDOMException((short)8, "invalid.element", new Object[]{string, string2});
            }
            return elementFactory.create(DOMUtilities.getPrefix(string2), abstractDocument);
        }
        return new GenericElementNS(string.intern(), string2.intern(), abstractDocument);
    }

    public DocumentEventSupport createDocumentEventSupport() {
        DocumentEventSupport documentEventSupport = new DocumentEventSupport();
        documentEventSupport.registerEventFactory("SVGEvents", new DocumentEventSupport.EventFactory(){

            public Event createEvent() {
                return new SVGOMEvent();
            }
        });
        return documentEventSupport;
    }

    protected static class VkernElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMVKernElement(string, (AbstractDocument)document);
        }
    }

    protected static class ViewElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMViewElement(string, (AbstractDocument)document);
        }
    }

    protected static class UseElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMUseElement(string, (AbstractDocument)document);
        }
    }

    protected static class TspanElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMTSpanElement(string, (AbstractDocument)document);
        }
    }

    protected static class TrefElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMTRefElement(string, (AbstractDocument)document);
        }
    }

    protected static class TitleElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMTitleElement(string, (AbstractDocument)document);
        }
    }

    protected static class TextPathElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMTextPathElement(string, (AbstractDocument)document);
        }
    }

    protected static class TextElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMTextElement(string, (AbstractDocument)document);
        }
    }

    protected static class SymbolElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMSymbolElement(string, (AbstractDocument)document);
        }
    }

    protected static class SwitchElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMSwitchElement(string, (AbstractDocument)document);
        }
    }

    protected static class SvgElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMSVGElement(string, (AbstractDocument)document);
        }
    }

    protected static class StyleElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMStyleElement(string, (AbstractDocument)document);
        }
    }

    protected static class StopElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMStopElement(string, (AbstractDocument)document);
        }
    }

    protected static class SetElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMSetElement(string, (AbstractDocument)document);
        }
    }

    protected static class ScriptElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMScriptElement(string, (AbstractDocument)document);
        }
    }

    protected static class RectElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMRectElement(string, (AbstractDocument)document);
        }
    }

    protected static class RadialGradientElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMRadialGradientElement(string, (AbstractDocument)document);
        }
    }

    protected static class PolylineElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMPolylineElement(string, (AbstractDocument)document);
        }
    }

    protected static class PolygonElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMPolygonElement(string, (AbstractDocument)document);
        }
    }

    protected static class PatternElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMPatternElement(string, (AbstractDocument)document);
        }
    }

    protected static class PathElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMPathElement(string, (AbstractDocument)document);
        }
    }

    protected static class MpathElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMMPathElement(string, (AbstractDocument)document);
        }
    }

    protected static class MissingGlyphElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMMissingGlyphElement(string, (AbstractDocument)document);
        }
    }

    protected static class MetadataElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMMetadataElement(string, (AbstractDocument)document);
        }
    }

    protected static class MaskElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMMaskElement(string, (AbstractDocument)document);
        }
    }

    protected static class MarkerElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMMarkerElement(string, (AbstractDocument)document);
        }
    }

    protected static class LinearGradientElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMLinearGradientElement(string, (AbstractDocument)document);
        }
    }

    protected static class LineElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMLineElement(string, (AbstractDocument)document);
        }
    }

    protected static class ImageElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMImageElement(string, (AbstractDocument)document);
        }
    }

    protected static class HkernElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMHKernElement(string, (AbstractDocument)document);
        }
    }

    protected static class GlyphRefElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMGlyphRefElement(string, (AbstractDocument)document);
        }
    }

    protected static class GlyphElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMGlyphElement(string, (AbstractDocument)document);
        }
    }

    protected static class GElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMGElement(string, (AbstractDocument)document);
        }
    }

    protected static class ForeignObjectElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMForeignObjectElement(string, (AbstractDocument)document);
        }
    }

    protected static class FontFaceUriElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFontFaceUriElement(string, (AbstractDocument)document);
        }
    }

    protected static class FontFaceSrcElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFontFaceSrcElement(string, (AbstractDocument)document);
        }
    }

    protected static class FontFaceNameElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFontFaceNameElement(string, (AbstractDocument)document);
        }
    }

    protected static class FontFaceFormatElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFontFaceFormatElement(string, (AbstractDocument)document);
        }
    }

    protected static class FontFaceElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFontFaceElement(string, (AbstractDocument)document);
        }
    }

    protected static class FontElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFontElement(string, (AbstractDocument)document);
        }
    }

    protected static class FilterElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFilterElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeTurbulenceElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFETurbulenceElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeTileElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFETileElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeSpotLightElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFESpotLightElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeSpecularLightingElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFESpecularLightingElement(string, (AbstractDocument)document);
        }
    }

    protected static class FePointLightElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEPointLightElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeOffsetElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEOffsetElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeMorphologyElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEMorphologyElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeMergeNodeElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEMergeNodeElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeMergeElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEMergeElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeImageElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEImageElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeGaussianBlurElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEGaussianBlurElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeFuncBElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEFuncBElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeFuncGElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEFuncGElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeFuncRElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEFuncRElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeFuncAElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEFuncAElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeFloodElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEFloodElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeDistantLightElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEDistantLightElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeDisplacementMapElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEDisplacementMapElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeDiffuseLightingElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEDiffuseLightingElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeConvolveMatrixElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEConvolveMatrixElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeCompositeElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFECompositeElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeComponentTransferElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEComponentTransferElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeColorMatrixElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEColorMatrixElement(string, (AbstractDocument)document);
        }
    }

    protected static class FeBlendElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMFEBlendElement(string, (AbstractDocument)document);
        }
    }

    protected static class EllipseElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMEllipseElement(string, (AbstractDocument)document);
        }
    }

    protected static class DescElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMDescElement(string, (AbstractDocument)document);
        }
    }

    protected static class DefsElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMDefsElement(string, (AbstractDocument)document);
        }
    }

    protected static class DefinitionSrcElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMDefinitionSrcElement(string, (AbstractDocument)document);
        }
    }

    protected static class CursorElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMCursorElement(string, (AbstractDocument)document);
        }
    }

    protected static class ColorProfileElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMColorProfileElement(string, (AbstractDocument)document);
        }
    }

    protected static class ClipPathElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMClipPathElement(string, (AbstractDocument)document);
        }
    }

    protected static class CircleElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMCircleElement(string, (AbstractDocument)document);
        }
    }

    protected static class AnimateTransformElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMAnimateTransformElement(string, (AbstractDocument)document);
        }
    }

    protected static class AnimateMotionElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMAnimateMotionElement(string, (AbstractDocument)document);
        }
    }

    protected static class AnimateColorElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMAnimateColorElement(string, (AbstractDocument)document);
        }
    }

    protected static class AnimateElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMAnimateElement(string, (AbstractDocument)document);
        }
    }

    protected static class AltGlyphItemElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMAltGlyphItemElement(string, (AbstractDocument)document);
        }
    }

    protected static class AltGlyphDefElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMAltGlyphDefElement(string, (AbstractDocument)document);
        }
    }

    protected static class AltGlyphElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMAltGlyphElement(string, (AbstractDocument)document);
        }
    }

    protected static class AElementFactory
    implements ElementFactory {
        public Element create(String string, Document document) {
            return new SVGOMAElement(string, (AbstractDocument)document);
        }
    }

    public static interface ElementFactory {
        public Element create(String var1, Document var2);
    }
}

