/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.svg.AlignmentBaselineFactory;
import org.apache.batik.css.svg.BaselineShiftFactory;
import org.apache.batik.css.svg.ClipPathFactory;
import org.apache.batik.css.svg.ClipRuleFactory;
import org.apache.batik.css.svg.ColorInterpolationFactory;
import org.apache.batik.css.svg.ColorProfileFactory;
import org.apache.batik.css.svg.ColorRenderingFactory;
import org.apache.batik.css.svg.DominantBaselineFactory;
import org.apache.batik.css.svg.EnableBackgroundFactory;
import org.apache.batik.css.svg.FillRuleFactory;
import org.apache.batik.css.svg.FilterFactory;
import org.apache.batik.css.svg.GlyphOrientationHorizontalFactory;
import org.apache.batik.css.svg.GlyphOrientationVerticalFactory;
import org.apache.batik.css.svg.ImageRenderingFactory;
import org.apache.batik.css.svg.MarkerFactory;
import org.apache.batik.css.svg.MarkerShorthandFactory;
import org.apache.batik.css.svg.MaskFactory;
import org.apache.batik.css.svg.OpacityFactory;
import org.apache.batik.css.svg.PaintFactory;
import org.apache.batik.css.svg.PointerEventsFactory;
import org.apache.batik.css.svg.SVGColorFactory;
import org.apache.batik.css.svg.SVGFontSizeFactory;
import org.apache.batik.css.svg.SVGValueConstants;
import org.apache.batik.css.svg.ShapeRenderingFactory;
import org.apache.batik.css.svg.SimpleColorFactory;
import org.apache.batik.css.svg.StrokeDasharrayFactory;
import org.apache.batik.css.svg.StrokeDashoffsetFactory;
import org.apache.batik.css.svg.StrokeLinecapFactory;
import org.apache.batik.css.svg.StrokeLinejoinFactory;
import org.apache.batik.css.svg.StrokeMiterlimitFactory;
import org.apache.batik.css.svg.StrokeWidthFactory;
import org.apache.batik.css.svg.TextAnchorFactory;
import org.apache.batik.css.svg.TextRenderingFactory;
import org.apache.batik.css.svg.WritingModeFactory;
import org.apache.batik.css.value.CommonValueFactoryMap;
import org.apache.batik.css.value.DefaultSystemColorResolver;
import org.apache.batik.css.value.SystemColorResolver;
import org.w3c.css.sac.Parser;

public class SVGValueFactoryMap
extends CommonValueFactoryMap
implements SVGValueConstants {
    public SVGValueFactoryMap(Parser parser) {
        this(parser, new DefaultSystemColorResolver());
    }

    public SVGValueFactoryMap(Parser parser, SystemColorResolver systemColorResolver) {
        super(parser, systemColorResolver);
        this.put("alignment-baseline", new AlignmentBaselineFactory(parser));
        this.put("baseline-shift", new BaselineShiftFactory(parser));
        this.put("clip-path", new ClipPathFactory(parser));
        this.put("clip-rule", new ClipRuleFactory(parser));
        this.put("color-profile", new ColorProfileFactory(parser));
        this.put("color", new SVGColorFactory(parser, "color", systemColorResolver));
        this.put("color-interpolation", new ColorInterpolationFactory(parser, "color-interpolation"));
        this.put("color-interpolation-filters", new ColorInterpolationFactory(parser, "color-interpolation-filters"));
        this.put("color-rendering", new ColorRenderingFactory(parser));
        this.put("dominant-baseline", new DominantBaselineFactory(parser));
        this.put("enable-background", new EnableBackgroundFactory(parser));
        this.put("fill", new PaintFactory(parser, "fill", systemColorResolver));
        this.put("fill-opacity", new OpacityFactory(parser, "fill-opacity"));
        this.put("fill-rule", new FillRuleFactory(parser));
        this.put("filter", new FilterFactory(parser));
        this.put("flood-color", new SimpleColorFactory(parser, "flood-color", systemColorResolver));
        this.put("flood-opacity", new OpacityFactory(parser, "flood-opacity"));
        this.put("font-size", new SVGFontSizeFactory(parser));
        this.put("glyph-orientation-horizontal", new GlyphOrientationHorizontalFactory(parser));
        this.put("glyph-orientation-vertical", new GlyphOrientationVerticalFactory(parser));
        this.put("image-rendering", new ImageRenderingFactory(parser));
        this.put("lighting-color", new SimpleColorFactory(parser, "lighting-color", systemColorResolver));
        this.put("marker", new MarkerShorthandFactory(parser));
        this.put("marker-end", new MarkerFactory(parser, "marker-end"));
        this.put("marker-mid", new MarkerFactory(parser, "marker-mid"));
        this.put("marker-start", new MarkerFactory(parser, "marker-start"));
        this.put("mask", new MaskFactory(parser));
        this.put("opacity", new OpacityFactory(parser, "opacity"));
        this.put("pointer-events", new PointerEventsFactory(parser));
        this.put("shape-rendering", new ShapeRenderingFactory(parser));
        this.put("stop-color", new SimpleColorFactory(parser, "stop-color", systemColorResolver));
        this.put("stop-opacity", new OpacityFactory(parser, "stop-opacity"));
        this.put("stroke", new PaintFactory(parser, "stroke", systemColorResolver));
        this.put("stroke-dasharray", new StrokeDasharrayFactory(parser));
        this.put("stroke-dashoffset", new StrokeDashoffsetFactory(parser));
        this.put("stroke-linecap", new StrokeLinecapFactory(parser));
        this.put("stroke-linejoin", new StrokeLinejoinFactory(parser));
        this.put("stroke-miterlimit", new StrokeMiterlimitFactory(parser));
        this.put("stroke-opacity", new OpacityFactory(parser, "stroke-opacity"));
        this.put("stroke-width", new StrokeWidthFactory(parser));
        this.put("text-anchor", new TextAnchorFactory(parser));
        this.put("text-rendering", new TextRenderingFactory(parser));
        this.put("writing-mode", new WritingModeFactory(parser));
    }
}

