/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.gvt.event.GraphicsNodeMouseEvent;
import org.apache.batik.gvt.event.GraphicsNodeMouseListener;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGSVGElement;

class BridgeEventSupport
implements SVGConstants {
    private static final String[] EVENT_ATTRIBUTES_GRAPHICS = new String[]{"onfocusin", "onfocusout", "onactivate", "onclick", "onmousedown", "onmouseup", "onmouseover", "onmouseout", "onmousemove", "onload"};
    private static final int FIRST_SVG_EVENT = 10;
    private static final String[] EVENT_ATTRIBUTES_SVG = new String[]{"onunload", "onabort", "onerror", "onresize", "onscroll", "onzoom"};
    private static final int FIRST_ANIMATION_EVENT = 16;
    private static final String[] EVENT_ATTRIBUTES_ANIMATION = new String[]{"onbegin", "onend", "onrepeat"};
    private static final String[] EVENT_NAMES = new String[]{"focusin", "focusout", "activate", "click", "mousedown", "mouseup", "mouseover", "mouseout", "mousemove", "SVGLoad", "SVGUnload", "SVGAbort", "SVGError", "SVGResize", "SVGScroll", "SVGZoom", "beginEvent", "endEvent", "repeatEvent"};

    private BridgeEventSupport() {
    }

    public static void addDOMListener(BridgeContext bridgeContext, Element element) {
        UserAgent userAgent;
        int n;
        SVGElement sVGElement = null;
        EventTarget eventTarget = null;
        try {
            sVGElement = (SVGElement)element;
            eventTarget = (EventTarget)((Object)sVGElement);
        }
        catch (ClassCastException classCastException) {
            return;
        }
        SVGSVGElement sVGSVGElement = sVGElement.getOwnerSVGElement();
        if (sVGSVGElement == null) {
            if (sVGElement.getLocalName().equals("svg")) {
                sVGSVGElement = (SVGSVGElement)sVGElement;
            } else {
                return;
            }
        }
        String string = sVGSVGElement.getContentScriptType();
        Interpreter interpreter = null;
        String string2 = null;
        if (sVGElement.getLocalName().equals("svg")) {
            n = 0;
            while (n < EVENT_ATTRIBUTES_SVG.length) {
                string2 = sVGElement.getAttribute(EVENT_ATTRIBUTES_SVG[n]);
                if (!string2.equals("")) {
                    if (interpreter == null && (interpreter = bridgeContext.getInterpreterPool().getInterpreter(sVGElement.getOwnerDocument(), string)) == null) {
                        userAgent = bridgeContext.getUserAgent();
                        if (userAgent != null) {
                            userAgent.displayError(new Exception("unknow language: " + string));
                        }
                        break;
                    }
                    BridgeEventSupport.addScriptCaller(eventTarget, EVENT_NAMES[n + 10], new ScriptCaller(bridgeContext.getUserAgent(), string2, interpreter));
                }
                ++n;
            }
        } else if (sVGElement.getLocalName().equals("set") || sVGElement.getLocalName().startsWith("animate")) {
            int n2 = 0;
            while (n2 < EVENT_ATTRIBUTES_ANIMATION.length) {
                string2 = sVGElement.getAttribute(EVENT_ATTRIBUTES_ANIMATION[n2]);
                if (!string2.equals("")) {
                    if (interpreter == null && (interpreter = bridgeContext.getInterpreterPool().getInterpreter(sVGElement.getOwnerDocument(), string)) == null) {
                        UserAgent userAgent2 = bridgeContext.getUserAgent();
                        if (userAgent2 == null) break;
                        userAgent2.displayError(new Exception("unknow language: " + string));
                        break;
                    }
                    BridgeEventSupport.addScriptCaller(eventTarget, EVENT_NAMES[n2 + 16], new ScriptCaller(bridgeContext.getUserAgent(), string2, interpreter));
                }
                ++n2;
            }
            return;
        }
        n = 0;
        while (n < EVENT_ATTRIBUTES_GRAPHICS.length) {
            string2 = sVGElement.getAttribute(EVENT_ATTRIBUTES_GRAPHICS[n]);
            if (!string2.equals("")) {
                if (interpreter == null && (interpreter = bridgeContext.getInterpreterPool().getInterpreter(sVGElement.getOwnerDocument(), string)) == null) {
                    userAgent = bridgeContext.getUserAgent();
                    if (userAgent == null) break;
                    userAgent.displayError(new Exception("unknow language: " + string));
                    break;
                }
                BridgeEventSupport.addScriptCaller(eventTarget, EVENT_NAMES[n], new ScriptCaller(bridgeContext.getUserAgent(), string2, interpreter));
            }
            ++n;
        }
    }

    public static void updateDOMListener(BridgeContext bridgeContext, SVGElement sVGElement) {
    }

    private static void addScriptCaller(EventTarget eventTarget, String string, ScriptCaller scriptCaller) {
        eventTarget.addEventListener(string, scriptCaller, false);
        Element element = ((Element)((Object)eventTarget)).getOwnerDocument().getDocumentElement();
        SVGUnloadListener sVGUnloadListener = null;
        sVGUnloadListener = SVGUnloadListener.getInstance(element);
        if (sVGUnloadListener == null) {
            sVGUnloadListener = new SVGUnloadListener(element);
            ((EventTarget)((Object)element)).addEventListener("SVGUnload", sVGUnloadListener, false);
        }
        sVGUnloadListener.addListener(eventTarget, string, scriptCaller);
    }

    public static void addGVTListener(BridgeContext bridgeContext, Element element) {
        EventDispatcher eventDispatcher;
        UserAgent userAgent = bridgeContext.getUserAgent();
        if (userAgent != null && (eventDispatcher = userAgent.getEventDispatcher()) != null) {
            Listener listener = new Listener(bridgeContext, userAgent);
            eventDispatcher.addGraphicsNodeMouseListener(listener);
            ((EventTarget)((Object)element)).addEventListener("SVGUnload", new GVTUnloadListener(eventDispatcher, listener), false);
        }
    }

    public static void loadScripts(BridgeContext bridgeContext, Element element) {
        Serializable serializable;
        Interpreter interpreter;
        Document document = element.getOwnerDocument();
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/svg", "script");
        UserAgent userAgent = bridgeContext.getUserAgent();
        String string = null;
        Element element2 = null;
        int n = 0;
        while (n < nodeList.getLength()) {
            element2 = (Element)nodeList.item(n);
            string = element2.getAttribute("type");
            interpreter = bridgeContext.getInterpreterPool().getInterpreter(document, string);
            if (interpreter != null) {
                serializable = new StringBuffer();
                Node node = element2.getFirstChild();
                while (node != null) {
                    ((StringBuffer)serializable).append(node.getNodeValue());
                    node = node.getNextSibling();
                }
                try {
                    interpreter.evaluate(new StringReader(((StringBuffer)serializable).toString()));
                }
                catch (IOException iOException) {
                }
                catch (InterpreterException interpreterException) {
                    if (userAgent != null) {
                        userAgent.displayError(new Exception("scripting error: " + interpreterException.getMessage()));
                    }
                }
            } else if (userAgent != null) {
                userAgent.displayError(new Exception("unknown language: " + string));
            }
            ++n;
        }
        interpreter = bridgeContext.getInterpreterPool().getInterpreter(document, string);
        if (interpreter != null) {
            try {
                serializable = new JOptionPane();
                interpreter.bindObject("pane", serializable);
                interpreter.evaluate("function alert(msg) { pane.showMessageDialog(null, msg); }");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class ScriptCaller
    implements EventListener {
        private static String EVENT_NAME = "evt";
        private String script = null;
        private Interpreter interpreter = null;
        private UserAgent ua = null;

        public ScriptCaller(UserAgent userAgent, String string, Interpreter interpreter) {
            this.script = string;
            this.interpreter = interpreter;
            this.ua = userAgent;
        }

        public void handleEvent(Event event) {
            block2: {
                this.interpreter.bindObject(EVENT_NAME, event);
                try {
                    this.interpreter.evaluate(this.script);
                }
                catch (InterpreterException interpreterException) {
                    if (this.ua == null) break block2;
                    this.ua.displayError(new Exception("scripting error: " + interpreterException.getMessage()));
                }
            }
        }
    }

    private static class Listener
    implements GraphicsNodeMouseListener {
        private BridgeContext context;
        private UserAgent ua;
        private GraphicsNode lastTarget;

        public Listener(BridgeContext bridgeContext, UserAgent userAgent) {
            this.context = bridgeContext;
            this.ua = userAgent;
        }

        public void mouseClicked(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("click", graphicsNodeMouseEvent, true);
        }

        public void mousePressed(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mousedown", graphicsNodeMouseEvent, true);
        }

        public void mouseReleased(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mouseup", graphicsNodeMouseEvent, true);
        }

        public void mouseEntered(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mouseover", graphicsNodeMouseEvent, true);
        }

        public void mouseExited(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mouseout", graphicsNodeMouseEvent, true);
        }

        public void mouseDragged(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getRelatedNode();
            GraphicsNodeMouseEvent graphicsNodeMouseEvent2 = null;
            if (this.lastTarget != graphicsNode) {
                if (this.lastTarget != null) {
                    graphicsNodeMouseEvent2 = new GraphicsNodeMouseEvent(this.lastTarget, 505, graphicsNodeMouseEvent.getWhen(), graphicsNodeMouseEvent.getModifiers(), graphicsNodeMouseEvent.getX(), graphicsNodeMouseEvent.getY(), graphicsNodeMouseEvent.getClickCount(), this.lastTarget);
                    this.dispatchMouseEvent("mouseout", graphicsNodeMouseEvent2, true);
                }
                if (graphicsNode != null) {
                    graphicsNodeMouseEvent2 = new GraphicsNodeMouseEvent(graphicsNode, 504, graphicsNodeMouseEvent.getWhen(), graphicsNodeMouseEvent.getModifiers(), graphicsNodeMouseEvent.getX(), graphicsNodeMouseEvent.getY(), graphicsNodeMouseEvent.getClickCount(), this.lastTarget);
                    this.dispatchMouseEvent("mouseover", graphicsNodeMouseEvent2, true);
                }
            }
            try {
                if (graphicsNode != null) {
                    graphicsNodeMouseEvent2 = new GraphicsNodeMouseEvent(graphicsNode, 503, graphicsNodeMouseEvent.getWhen(), graphicsNodeMouseEvent.getModifiers(), graphicsNodeMouseEvent.getX(), graphicsNodeMouseEvent.getY(), graphicsNodeMouseEvent.getClickCount(), null);
                    this.dispatchMouseEvent("mousemove", graphicsNodeMouseEvent2, true);
                }
                Object var5_4 = null;
                this.lastTarget = graphicsNode;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.lastTarget = graphicsNode;
                throw throwable;
            }
        }

        public void mouseMoved(GraphicsNodeMouseEvent graphicsNodeMouseEvent) {
            this.dispatchMouseEvent("mousemove", graphicsNodeMouseEvent, false);
        }

        private void dispatchMouseEvent(String string, GraphicsNodeMouseEvent graphicsNodeMouseEvent, boolean bl) {
            Point2D point2D = graphicsNodeMouseEvent.getPoint2D();
            AffineTransform affineTransform = this.ua.getTransform();
            if (affineTransform != null && !affineTransform.isIdentity()) {
                affineTransform.transform(point2D, point2D);
            }
            Point point = this.ua.getClientAreaLocationOnScreen();
            point.translate((int)Math.floor(point2D.getX()), (int)Math.floor(point2D.getY()));
            GraphicsNode graphicsNode = graphicsNodeMouseEvent.getGraphicsNode();
            Element element = this.context.getElement(graphicsNode);
            if (element == null) {
                return;
            }
            EventTarget eventTarget = (EventTarget)((Object)element);
            short s = 1;
            if ((0x10 & graphicsNodeMouseEvent.getModifiers()) != 0) {
                s = 0;
            } else if ((4 & graphicsNodeMouseEvent.getModifiers()) != 0) {
                s = 2;
            }
            MouseEvent mouseEvent = (MouseEvent)((DocumentEvent)((Object)element.getOwnerDocument())).createEvent("MouseEvents");
            graphicsNode = graphicsNodeMouseEvent.getRelatedNode();
            EventTarget eventTarget2 = (EventTarget)((Object)this.context.getElement(graphicsNode));
            mouseEvent.initMouseEvent(string, true, bl, null, graphicsNodeMouseEvent.getClickCount(), point.x, point.y, (int)Math.floor(point2D.getX()), (int)Math.floor(point2D.getY()), graphicsNodeMouseEvent.isControlDown(), graphicsNodeMouseEvent.isAltDown(), graphicsNodeMouseEvent.isShiftDown(), graphicsNodeMouseEvent.isMetaDown(), s, eventTarget2);
            try {
                eventTarget.dispatchEvent(mouseEvent);
            }
            catch (RuntimeException runtimeException) {
                this.ua.displayError(new Exception("scripting error in event handling: " + runtimeException.getMessage()));
            }
        }
    }

    private static class GVTUnloadListener
    implements EventListener {
        private EventDispatcher dispatcher;
        private Listener listener;

        GVTUnloadListener(EventDispatcher eventDispatcher, Listener listener) {
            this.dispatcher = eventDispatcher;
            this.listener = listener;
        }

        public void handleEvent(Event event) {
            this.dispatcher.removeGraphicsNodeMouseListener(this.listener);
            event.getTarget().removeEventListener("SVGUnload", this, false);
        }
    }

    private static class SVGUnloadListener
    implements EventListener {
        private Element svgRoot = null;
        private List list = new LinkedList();
        private static HashMap map = new HashMap(1);

        SVGUnloadListener(Element element) {
            this.svgRoot = element;
            map.put(element, this);
        }

        public static SVGUnloadListener getInstance(Element element) {
            return (SVGUnloadListener)map.get(element);
        }

        public void addListener(EventTarget eventTarget, String string, EventListener eventListener) {
            this.list.add(new Entry(string, eventListener, eventTarget));
        }

        public void handleEvent(Event event) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                entry.target.removeEventListener(entry.type, entry.caller, false);
            }
            map.remove(this.svgRoot);
            this.svgRoot = null;
            this.list = null;
            event.getTarget().removeEventListener("SVGUnload", this, false);
        }

        private class Entry {
            String type;
            EventListener caller;
            EventTarget target;

            Entry(String string, EventListener eventListener, EventTarget eventTarget) {
                this.type = string;
                this.caller = eventListener;
                this.target = eventTarget;
            }
        }
    }
}

