/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeEventSupport;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public abstract class AbstractGraphicsNodeBridge
extends AbstractSVGBridge
implements GraphicsNodeBridge,
ErrorConstants {
    protected AbstractGraphicsNodeBridge() {
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        if (!SVGUtilities.matchUserAgent(element, bridgeContext.getUserAgent())) {
            return null;
        }
        GraphicsNode graphicsNode = this.instantiateGraphicsNode();
        String string = element.getAttributeNS(null, "transform");
        if (string.length() != 0) {
            graphicsNode.setTransform(SVGUtilities.convertTransform(element, "transform", string));
        }
        graphicsNode.setVisible(CSSUtilities.convertVisibility(element));
        return graphicsNode;
    }

    protected abstract GraphicsNode instantiateGraphicsNode();

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        graphicsNode.setComposite(CSSUtilities.convertOpacity(element));
        graphicsNode.setFilter(CSSUtilities.convertFilter(element, graphicsNode, bridgeContext));
        graphicsNode.setMask(CSSUtilities.convertMask(element, graphicsNode, bridgeContext));
        graphicsNode.setClip(CSSUtilities.convertClipPath(element, graphicsNode, bridgeContext));
        if (bridgeContext.isDynamic()) {
            bridgeContext.bind(element, graphicsNode);
            BridgeEventSupport.addDOMListener(bridgeContext, element);
        }
        SVGUtilities.bridgeChildren(bridgeContext, element);
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
        throw new Error("Not implemented");
    }

    public abstract boolean isComposite();
}

