/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.platformdefinition.Util;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDCPlatform
extends JavaPlatform {
    public static final String PROP_ANT_NAME = "antName";
    public static final String PLATFORM_CDC = "cdc";
    protected static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    public static final String PLATFORM_STRING_PREFIX = "${platform.home}/";
    public static String PROP_EXEC_MAIN = "main";
    public static String PROP_EXEC_XLET = "xlet";
    public static String PROP_EXEC_APPLET = "applet";
    private Properties properties;
    private String displayName;
    private String type;
    private String classVersion;
    private ClassPath sources;
    private List<URL> javadoc;
    private List<URL> installFolders;
    private CDCDevice[] devices;
    private boolean fatJar;
    Reference<ClassPath> bootstrap = new WeakReference<Object>(null);
    Reference<ClassPath> standardLibs = new WeakReference<Object>(null);
    private Specification spec;

    public CDCPlatform(String string, String string2, String string3, String string4, List<URL> list, List<URL> list2, List<URL> list3, CDCDevice[] cDCDeviceArray, boolean bl) {
        assert (string4 != null);
        this.displayName = string;
        this.type = string3;
        this.classVersion = string4;
        this.devices = cDCDeviceArray;
        this.fatJar = bl;
        if (list != null) {
            this.installFolders = list;
        }
        this.sources = CDCPlatform.createClassPath(list2);
        this.javadoc = list3 != null ? Collections.unmodifiableList(list3) : Collections.EMPTY_LIST;
        this.properties = new Properties();
        this.properties.put(PLAT_PROP_ANT_NAME, string2);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
        this.firePropertyChange("displayName", null, null);
    }

    protected final void internalSetDisplayName(String string) {
        this.displayName = string;
    }

    public String getAntName() {
        return (String)this.properties.get(PLAT_PROP_ANT_NAME);
    }

    public void setAntName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.put(PLAT_PROP_ANT_NAME, string);
        this.firePropertyChange(PROP_ANT_NAME, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBootstrapLibraries(List<URL> list) {
        assert (list != null);
        CDCPlatform cDCPlatform = this;
        synchronized (cDCPlatform) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            arrayList.addAll(list);
            ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])this.getAllLibraries());
            List list2 = classPath.entries();
            ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
            for (CDCDevice[] cDCDeviceArray : list2) {
                URL uRL = cDCDeviceArray.getURL();
                if (arrayList.remove(uRL)) continue;
                arrayList2.add(cDCDeviceArray.getRoot());
            }
            boolean bl = false;
            this.bootstrap = new WeakReference<ClassPath>(ClassPathSupport.createClassPath((URL[])list.toArray(new URL[list.size()])));
            for (CDCDevice cDCDevice : this.devices) {
                CDCDevice.CDCProfile[] cDCProfileArray;
                for (CDCDevice.CDCProfile cDCProfile : cDCProfileArray = cDCDevice.getProfiles()) {
                    String string = cDCProfile.getBootClassPath();
                    List<FileObject> list3 = this.resolveRelativePathToFileObjects(string);
                    for (FileObject fileObject : arrayList2) {
                        list3.remove(fileObject);
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    for (URL uRL : list) {
                        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                        String string2 = null;
                        if (fileObject.isRoot()) {
                            try {
                                string2 = fileObject.getFileSystem().getDisplayName();
                            }
                            catch (FileStateInvalidException fileStateInvalidException) {}
                        } else {
                            string2 = fileObject.getPath();
                        }
                        if (arrayList.contains(uRL)) {
                            stringBuffer.append(string2);
                            stringBuffer.append(';');
                        }
                        if (!list3.contains(fileObject)) continue;
                        stringBuffer.append(string2);
                        stringBuffer.append(';');
                    }
                    bl = true;
                    cDCProfile.setBootClassPath(stringBuffer.toString());
                    cDCProfile.setRunClassPath(stringBuffer.toString());
                }
            }
            if (bl) {
                this.firePropertyChange("classpath", null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getBootstrapLibraries() {
        CDCPlatform cDCPlatform = this;
        synchronized (cDCPlatform) {
            ClassPath classPath;
            ClassPath classPath2 = classPath = this.bootstrap == null ? null : this.bootstrap.get();
            if (classPath != null) {
                return classPath;
            }
            classPath = ClassPathSupport.createClassPath((FileObject[])this.getAllLibraries());
            this.bootstrap = new WeakReference<ClassPath>(classPath);
            return classPath;
        }
    }

    public ClassPath getBootstrapLibrariesForProfile(String string, String string2) {
        if (string == null || string2 == null) {
            return this.getBootstrapLibraries();
        }
        CDCDevice[] cDCDeviceArray = this.getDevices();
        CDCDevice.CDCProfile cDCProfile = null;
        block0: for (int i = 0; cDCDeviceArray != null && i < cDCDeviceArray.length; ++i) {
            if (!cDCDeviceArray[i].getName().equals(string)) continue;
            CDCDevice.CDCProfile[] cDCProfileArray = cDCDeviceArray[i].getProfiles();
            for (int j = 0; cDCProfileArray != null && j < cDCProfileArray.length; ++j) {
                if (!cDCProfileArray[j].getName().equals(string2)) continue;
                cDCProfile = cDCProfileArray[j];
                break block0;
            }
            break;
        }
        if (cDCProfile != null) {
            List<FileObject> list = this.resolveRelativePathToFileObjects(cDCProfile.getBootClassPath());
            return ClassPathSupport.createClassPath((FileObject[])list.toArray(new FileObject[list.size()]));
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getClassVersion() {
        return this.classVersion;
    }

    public void setClassVersion(String string) {
        this.classVersion = string;
    }

    public CDCDevice[] getDevices() {
        return this.devices;
    }

    public void setDevices(CDCDevice[] cDCDeviceArray) {
        this.devices = cDCDeviceArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getStandardLibraries() {
        CDCPlatform cDCPlatform = this;
        synchronized (cDCPlatform) {
            ClassPath classPath;
            ClassPath classPath2 = classPath = this.standardLibs == null ? null : this.standardLibs.get();
            if (classPath != null) {
                return classPath;
            }
            classPath = ClassPathSupport.createClassPath(new ArrayList());
            this.standardLibs = new WeakReference<ClassPath>(classPath);
            return classPath;
        }
    }

    public String getHomePath() {
        Iterator<FileObject> iterator = this.getInstallFolders().iterator();
        if (iterator.hasNext()) {
            FileObject fileObject = iterator.next();
            return FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        }
        return null;
    }

    public final Collection<FileObject> getInstallFolders() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (URL uRL : this.installFolders) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public final FileObject findTool(String string) {
        System.out.println("findTool: " + string);
        return null;
    }

    public final FileObject findTool(String string, String string2) {
        return Util.findTool(string, string2, this.getInstallFolders());
    }

    public final ClassPath getSourceFolders() {
        return this.sources;
    }

    public final void setSourceFolders(ClassPath classPath) {
        assert (classPath != null);
        this.sources = classPath;
        this.firePropertyChange("sourceFolders", null, null);
    }

    public final List<URL> getJavadocFolders() {
        return this.javadoc;
    }

    public final void setJavadocFolders(List<URL> list) {
        assert (list != null);
        List<URL> list2 = Collections.unmodifiableList(new ArrayList<URL>(list));
        for (URL uRL : list2) {
            if ("jar".equals(uRL.getProtocol()) || !FileUtil.isArchiveFile((URL)uRL)) continue;
            throw new IllegalArgumentException("JavadocFolder must be a folder.");
        }
        this.javadoc = list2;
        this.firePropertyChange("javadocFolders", null, null);
    }

    public String getVendor() {
        String string = (String)this.getSystemProperties().get("java.vm.vendor");
        return string == null ? "" : string;
    }

    public Specification getSpecification() {
        if (this.spec == null) {
            this.spec = new Specification(PLATFORM_CDC, new SpecificationVersion(this.getClassVersion()));
        }
        return this.spec;
    }

    public Map getProperties() {
        return this.properties;
    }

    public Collection getInstallFolderURLs() {
        return Collections.unmodifiableList(this.installFolders);
    }

    private static ClassPath createClassPath(List<URL> list) {
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        if (list != null) {
            for (URL uRL : list) {
                arrayList.add(ClassPathSupport.createResource((URL)uRL));
            }
        }
        return ClassPathSupport.createClassPath(arrayList);
    }

    private FileObject[] getAllLibraries() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (CDCDevice cDCDevice : this.devices) {
            for (CDCDevice.CDCProfile cDCProfile : cDCDevice.getProfiles()) {
                List<FileObject> list = this.resolveRelativePathToFileObjects(cDCProfile.getBootClassPath());
                int n = -1;
                for (FileObject fileObject : list) {
                    if (!arrayList.contains(fileObject)) {
                        arrayList.add(n + 1, fileObject);
                    }
                    n = arrayList.indexOf(fileObject);
                }
            }
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private List<FileObject> resolveRelativePathToFileObjects(String string) {
        String[] stringArray;
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (string == null) {
            return arrayList;
        }
        for (String string2 : stringArray = PropertyUtils.tokenizePath((String)string)) {
            FileObject fileObject = this.resolveRelativePathToFileObject(string2.trim());
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public FileObject resolveRelativePathToFileObject(String string) {
        File file;
        FileObject fileObject;
        if (string == null || string.length() <= 0) {
            return null;
        }
        if (string.startsWith(PLATFORM_STRING_PREFIX)) {
            fileObject = URLMapper.findFileObject((URL)this.installFolders.iterator().next());
            file = new File(FileUtil.toFile((FileObject)fileObject), string.substring(PLATFORM_STRING_PREFIX.length()));
        } else {
            file = new File(string);
        }
        file = FileUtil.normalizeFile((File)file);
        fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !FileUtil.isArchiveFile((FileObject)fileObject)) {
            return fileObject;
        }
        return FileUtil.getArchiveRoot((FileObject)fileObject);
    }

    public boolean isFatJar() {
        return this.fatJar;
    }
}

